#!/usr/bin/perl -w
#
#  Test that DropAgent works as expected
#
# $Id: drop-agent.t,v 1.4 2006/07/18 14:24:23 steve Exp $
#

use Test::More qw( no_plan );

#
#  Utility functions for adding a test snippet to Apaches configuration tree.
#
require 'tests/apache.utils';


cleanConf();

my $conf = <<EOF;
DropAction status=403
DropAgent sexbot/1.[0-9]
DropAgent "web stripper"

#
# Per rule action
#
DropAgent "skx" "status=500"
EOF

writeConf( $conf );
restart();



#
#  Get a random path, so we can be sure we'll get a 404 code.
#
my $path = join ( '', map {('a'..'z')[rand 26]} 0..7 );

#
#  Now we make some requests.
#
is( makeGETRequest( "/$path" ),
    404, "agent-free request allowed as expected" );

is( makeGETRequest( "/$path", agent => 'sexbat' ),
    404, "Agent sexbat allowed as expected" );

foreach my $i ( 0 ... 9 )
{
    is( makeGETRequest( "/$path", agent => 'sexbot/1.' . $i ),
        403, "Agent sexbot dropped as expected: GET" );
    is( makeHEADRequest( "/$path", agent => 'sexbot/1.' . $i ),
        403, "Agent sexbot dropped as expected: HEAD" );
    is( makePOSTRequest( "/$path", agent => 'sexbot/1.' . $i ),
        403, "Agent sexbot dropped as expected: POST" );
}

is( makeGETRequest( "/$path", agent => 'web' ),
    404, "Agent web allowed as expected" );
is( makeGETRequest( "/$path", agent => 'web stripper' ),
    403, "Agent web stripper dropped as expected" );


is( makeGETRequest( "/$path", agent => 'skx' ),
    500, "Per-rule action worked for GET" );
is( makeHEADRequest( "/$path", agent => 'skx' ),
    500, "Per-rule action worked for HEAD" );
is( makePOSTRequest( "/$path", agent => 'skx' ),
    500, "Per-rule action worked for POST" );

#
#  Cleanup
#
cleanConf();
restart();
