#!/usr/bin/perl -w
#
#  Test that DropBlacklist works as expected
#
# $Id: drop-blacklist.t,v 1.3 2006/07/18 14:24:23 steve Exp $
#

use Test::More qw( no_plan );

#
#  Utility functions for adding a test snippet to Apaches configuration tree.
#
require 'tests/apache.utils';


cleanConf();

my $conf = <<EOF;
DropAction status=403
EOF

writeConf( $conf );
restart();



#
#  Now we make some requests.
#
is( makeGETRequest( "/" ),
    200, "/ allowed as expected - not blacklisted: GET" );

is( makeHEADRequest( "/" ),
    200, "/ allowed as expected - not blacklisted: HEAD" );

is( makePOSTRequest( "/" ),
    200, "/ allowed as expected - not blacklisted: POST" );



$conf .= "\nDropBlacklist 127.0.0.1\n" ;
writeConf( $conf );
restart();


is( makeGETRequest( "/" ),
    403, "/ denied - blacklisted: GET" );

is( makeHEADRequest( "/" ),
    403, "/ denied - blacklisted: HEAD" );

is( makePOSTRequest( "/" ),
    403, "/ denied - blacklisted: POST" );


#
#  Cleanup
#
cleanConf();
restart();
