#!/usr/bin/perl -w
#
#  Test multiple requests to make sure we don't have any buffer corruption, etc.#
# $Id: random-test.t,v 1.4 2006/07/21 17:43:24 steve Exp $
#

use Test::More qw( no_plan );

#
#  Utility functions for adding a test snippet to Apaches configuration tree.
#
require 'tests/apache.utils';



cleanConf();

my $conf = <<EOF;
DropAction status=403
DropParam       foo
DropParamValue  bar baz
DropParamValues sexy

EOF
writeConf( $conf );

restart();

my $count = 0;


#
#  Send 256 requests
#
while( $count <= 255 )
{
    #
    #  Get a random path, agent, and referer.
    #
    my $path    = join ( '', map {('a'..'z')[rand 26]} 0..240 );
    my $agent   = join ( '', map {('a'..'z')[rand 26]} 0..2600 );
    my $referer = join ( '', map {('A'..'Z')[rand 26]} 0..2600 );

    my $name = join ( '', map {('a'..'z')[rand 26]} 0..2600 );
    my $arg  = join ( '', map {('A'..'Z')[rand 26]} 0..2600 );

    #
    #  Now we make some requests.
    #
    is( makeGETRequest( "/$path", referer => $referer, agent=> $agent ),
        404, "Random allowed as expected - GET" );
    is( makeHEADRequest( "/$path", referer => $referer, agent=> $agent ),
        404, "Random allowed as expected - HEAD" );
    is( makePOSTRequest( "/$path", referer => $referer, agent=> $agent ),
        404, "Random allowed as expected - POST" );

    #
    #  And aain with args
    #
    is( makeGETRequest( "/$path?$name=$arg", referer => $referer, agent=> $agent ),
        404, "Random allowed as expected - GET + args" );
    is( makeHEADRequest( "/$path?$name=$arg", referer => $referer, agent=> $agent ),
        404, "Random allowed as expected - HEAD + args" );
    is( makePOSTRequest( "/$path?$name=$arg", referer => $referer, agent=> $agent ),
        404, "Random allowed as expected - POST + args" );


    $count += 1;
}


#
#  Cleanup
#
cleanConf();
restart();
