#include <stdio.h>
#include <stdlib.h>
#include <mod_xmlrpc_c.h>
#include <xmlrpc.h>

int get_integer(void)
{
	return 512;
}

static xmlrpc_value *getstructs(xmlrpc_env *env, xmlrpc_value *param, void *n)
{
	xmlrpc_value *result;
	const char *s = "bar";
	int i;

	result = xmlrpc_build_value(env, "()");
	for (i = 0; i < 10; i++) {
		xmlrpc_value *val = xmlrpc_build_value(env, "{s:i,s:s,s:b}",
				"count", i,
				"foo", s,
				"count_is_odd", i%2);
		xmlrpc_array_append_item(env, result, val);
	}

	return result;
}

static xmlrpc_value *concat(xmlrpc_env *env, xmlrpc_value *param,
		void *separator)
{
	xmlrpc_value *result;
	char *one, *two, *three;
	size_t len;

	xmlrpc_parse_value(env, param, "(ss)", &one, &two);
	len = strlen(one) + strlen(two) + strlen((char *) separator) + 1;
	three = malloc(len);

	strcpy(three, one);
	strcat(three, separator);
	strcat(three, two);
	result = xmlrpc_build_value(env, "s", three);
	free(three);

	return result;
}

#define CONCAT_SEP "::"

struct mod_xmlrpc_func mod_xmlrpc_register[] =
{
	{"stringstuff", "structs", &getstructs, NULL, "A:", "Return an array of structs of... stuff.  Yee-haw."},
	{"stringstuff", "concat", &concat, (void *) CONCAT_SEP, "s:ss",
		"Given two strings, append them together with '" CONCAT_SEP "' in the center."},
	{0}
};

