/***************************************************************************
                         cbase32.cpp  -  description
                             -------------------
    begin                : Sat Apr 24 2004
    copyright            : (C) 2004-2005 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include <dclib/core/cbytearray.h>

#include "cbase32.h"

static int Index_32[] = {
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,26,27,28,29,30,31,-1,-1,-1,-1,-1,-1,-1,-1,
	-1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,
	15,16,17,18,19,20,21,22,23,24,25,-1,-1,-1,-1,-1,
	-1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,
	15,16,17,18,19,20,21,22,23,24,25,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
};

static char B32Chars[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";

#define base32val(c) Index_32[(unsigned int)(c)]
#define base32chars(c) B32Chars[(unsigned int)(c&0x3F)]

/** */
CBase32::CBase32()
{
}

/** */
CBase32::~CBase32()
{
}

#define BAD     -1

/** */
CString CBase32::Encode( CString string )
{
	CString outs;
	CByteArray in,out;

	in.Append(string.Data(),string.Length());

	Encode(&out,&in);

	outs.Set((const char*)out.Data(),out.Size());

	return outs;
}

/* raw bytes to null-terminated base 64 string */
void CBase32::Encode(  CByteArray * dst, CByteArray * src )
{
	unsigned char word;
	size_t index,i,len = src->Size();

	for(i = 0, index = 0; i < len;) {
		/* Is the current word going to span a byte boundary? */
		if (index > 3) {
			word = (src->Data()[i] & (0xFF >> index));
			index = (index + 5) % 8;
			word <<= index;
			if ((i + 1) < len)
				word |= src->Data()[i + 1] >> (8 - index);

			i++;
		} else {
			word = (src->Data()[i] >> (8 - (index + 5))) & 0x1F;
			index = (index + 5) % 8;
			if (index == 0)
				i++;
		}

		dst->Append( &B32Chars[word], 1);
	}
}

/** */
int CBase32::Decode( CByteArray * dst, CString * string )
{
	CByteArray in;

	in.Append(string->Data(),string->Length());

	return Decode(dst,&in);
}

/* Convert '\0'-terminated base 64 string to raw bytes.
 * Returns length of returned buffer, or -1 on error */
int CBase32::Decode( CByteArray * dst, CByteArray * src )
{
	unsigned char c;
	size_t i, index, offset;
	
	if ( (!dst) || (!src) )
		return -1;

	dst->SetSize(0);

	for(i = 0, index = 0, offset = 0, c = 0; i < src->Size(); i++) {
		// Skip what we don't recognise
		char tmp = Index_32[src->Data()[i]];

		if(tmp == -1)
			continue;

		if (index <= 3) {
			index = (index + 5) % 8;
			if (index == 0) {
				if ( dst->Size() <= offset )
				{
					c = 0;
					dst->Append(&c,1);
				}
				dst->Data()[offset] |= tmp;
				offset++;
			} else {
				if ( i < src->Size()-1 )
				{
				if ( dst->Size() <= offset )
				{
					c = 0;
					dst->Append(&c,1);
				}
				dst->Data()[offset] |= tmp << (8 - index);
				}
			}
		} else {
			index = (index + 5) % 8;
			if ( dst->Size() <= offset )
			{
				c = 0;
				dst->Append(&c,1);
			}
			dst->Data()[offset] |= (tmp >> index);
			offset++;
			if ( i < src->Size()-1 )
			{
			if ( dst->Size() <= offset )
			{
				c = 0;
				dst->Append(&c,1);
			}
			dst->Data()[offset] |= tmp << (8 - index);
			}
		}
	}

	return dst->Size();
}
