#include	<sys/types.h>
#include	<sys/stat.h>
//#include	<sys/mman.h>
#ifndef WIN32
#include        <unistd.h>
#include        <sys/time.h>
#endif
#include	<fcntl.h>
#include        <stdio.h>
#include        <stdlib.h>
#include        <errno.h>
//#include        <string.h>

#include        "cstring.h"
#include	"filecopy.h"

/*
 * for filecopy_2
#ifndef	MAP_FILE
#define	MAP_FILE	0
#endif
*/

#ifndef WIN32

// Sun Solaris 8
#ifndef ALLPERMS
#define ALLPERMS (S_ISUID|S_ISGID|S_ISVTX|S_IRWXU|S_IRWXG|S_IRWXO)/* 07777 */
#endif

bool filecopy(CString srcfile, CString destfile)
{
	FILE	*fdin, *fdout;
	char	*buffer;
	int	nb_bytes_r;
	int	nb_bytes_w;

	buffer = new(char[32*1024*1024]);

	if ( (fdin = fopen(srcfile.Data(), "r")) == 0 )
	{
		printf("can't open %s for reading\n", srcfile.Data());
		return (false);
	}
	if ( (fdout = fopen(destfile.Data(), "w")) == 0)
	{
		printf("can't create %s for writing\n", destfile.Data());
		return (false);
	}

	do
	{
		nb_bytes_r = fread(buffer, 1, sizeof(buffer), fdin);
		nb_bytes_w = fwrite(buffer, 1, nb_bytes_r, fdout);
	} while ((nb_bytes_r>0) && (nb_bytes_r==nb_bytes_w));

	if (ferror(fdin) || ferror(fdout))
		return(false);
	if ((fclose(fdin) != 0) || (fclose(fdout) != 0))
		return(false);
	
	return (true);
}

/* -> http://www.mew.org/ml/mew-dist-1.94/msg04074.html
  fastcopy: delived from mv.c (FreeBSD)
*/
bool fastcopy(char* from, char* to)
{
	struct timeval tval[2];
	u_int blen;
	char *bp;
	mode_t oldmode;
	struct stat sb;
	int nread, from_fd, to_fd;

	if (lstat(from, &sb))
	{
		printf("lstat(%s)\n", from);
		return false;
	}
	
	if ((from_fd = open(from, O_RDONLY, 0)) < 0)
	{
		printf("%s\n", from);
		return false;
	}
	
	if ((bp = (char*)malloc(sb.st_blksize)) == NULL)
	{
		printf("malloc failed\n");
		return false;
        }
	
	blen = sb.st_blksize;

	while ((to_fd = open(to, O_CREAT | O_EXCL | O_TRUNC | O_WRONLY, 0)) < 0)
	{
		if (errno == EEXIST && unlink(to) == 0)
			continue;
		printf("%s\n", to);
		(void)close(from_fd);
		free(bp);
		return false;
	}
	
	while ((nread = read(from_fd, bp, blen)) > 0)
	{
        	if (write(to_fd, bp, nread) != nread)
		{
			printf("fastcopy: write failed %s\n", to);
			free(bp);
			goto err;
        	}
	}
	
	free(bp);
	
	if (nread < 0)
	{
		printf("%s\n", from);
err:
		if (unlink(to))
			printf("%s: remove\n", to);
		(void)close(from_fd);
		(void)close(to_fd);
		return false;
    	}
	
    	(void)close(from_fd);

	oldmode = sb.st_mode & ALLPERMS;
	
	if (fchown(to_fd, sb.st_uid, sb.st_gid))
	{
        	printf("%s: set owner/group (was: %lu/%lu)\n", to,
             		(u_long)sb.st_uid, (u_long)sb.st_gid);
			
        	if (oldmode & (S_ISUID | S_ISGID))
		{
            		printf(
                		"%s: owner/group changed; clearing suid/sgid (mode was 0%03o)\n",
                		to, oldmode);
            		sb.st_mode &= ~(S_ISUID | S_ISGID);
        	}
    	}
	
    	if (fchmod(to_fd, sb.st_mode))
        	printf("%s: set mode (was: 0%03o)\n", to, oldmode);
    	/*
     	 * XXX
     	 * NFS doesn't support chflags; ignore errors unless there's reason
     	 * to believe we're losing bits.  (Note, this still won't be right
     	 * if the server supports flags and we were trying to *remove* flags
     	 * on a file that we copied, i.e., that we didn't create.)
     	*/
    	errno = 0;

    	/*
    	if (fchflags(to_fd, sb.st_flags))
        	if (errno != EOPNOTSUPP || sb.st_flags != 0)
            	printf("%s: set flags (was: 0%07o)", to, sb.st_flags);
    	*/

    	tval[0].tv_sec = sb.st_atime;
    	tval[1].tv_sec = sb.st_mtime;
    	tval[0].tv_usec = tval[1].tv_usec = 0;
    	if (utimes(to, tval))
        	printf("%s: set times\n", to);
    	if (close(to_fd))
	{
        	printf("%s\n", to);
        	return false;
    	}

    	return true;
}

/*
bool filecopy_2(CString srcfile, CString destfile)
{
	int		fdin, fdout;
	void		*src, *dst;
	struct stat	statbuf;

	if ( (fdin = open(srcfile.Data(), O_RDONLY)) < 0)
	{
		printf("can't open %s for reading\n", srcfile.Data());
		return (false);
	}
	if ( (fdout = open(destfile.Data(), O_RDWR | O_CREAT | O_TRUNC)) < 0)
	{
		printf("can't creat %s for writing\n", destfile.Data());
		return (false);
	}
	if (fstat(fdin, &statbuf) < 0)
	{
		printf("fstat error\n");
		return (false);
	}
	
	// set size of output file
	if (lseek(fdout, statbuf.st_size - 1, SEEK_SET) == -1)
	{
		printf("lseek error\n");
		return (false);
	}
	if (write(fdout, "", 1) != 1)
	{
		printf("write error\n");
		return (false);
	}
	
	if ( (src = mmap(0, statbuf.st_size, PROT_READ, MAP_FILE | MAP_SHARED, fdin, 0)) == (void *) -1)
	{
		printf("mmap error for input\n");
		return (false);
	}
	
	if ( (dst = mmap(0, statbuf.st_size, PROT_READ | PROT_WRITE, MAP_FILE | MAP_SHARED, fdout, 0)) == (void *) -1)
	{
		printf("mmap error for output\n");
		return (false);
	}

	// the real copy is there
	memcpy(dst, src, statbuf.st_size);

	return (true);
}
*/

#endif
