#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.04';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::Canon::CameraInfo',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorBalance1',
	'Image::ExifTool::Canon::ColorBalance2',
	'Image::ExifTool::Canon::ColorBalance3',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ColorInfoD30',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PictureInfo',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::PreviewImage',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'abspeakaudiofilepath' => { 126 => 'absPeakAudioFilePath' },
	'actionadvised' => { 46 => 0x2a },
	'activearea' => { 40 => 0xc68d },
	'addoriginaldecisiondata' => { 20 => 0x11, 21 => 0x13, 24 => 0x14 },
	'address' => { 59 => 'Address' },
	'adjustmentmode' => { 112 => 0x15 },
	'advancedraw' => { 87 => 0x76a43203 },
	'advisory' => { 124 => 'Advisory' },
	'aebbracketvalue' => { 17 => 0x11 },
	'aebsequence' => { 18 => 0x9, 19 => 0x9, 20 => 0x8, 21 => 0x9, 24 => 0x9, 25 => 0x7 },
	'aelock' => { 93 => 0x201 },
	'aesetting' => { 1 => 0x21 },
	'afareamode' => { 74 => 0x0 },
	'afareas' => { 93 => 0x304 },
	'afassist' => { 18 => 0x5, 25 => 0x5 },
	'afassistbeam' => { 20 => 0x4, 21 => 0x5, 22 => 0x4, 23 => 0x4, 24 => 0x5 },
	'afmode' => { 112 => 0x5 },
	'afpoint' => { 1 => 0x13, 37 => 0x18, 74 => 0x1 },
	'afpointactivationarea' => { 19 => 0x11, 24 => 0x11 },
	'afpointillumination' => { 19 => 0xa },
	'afpointregistration' => { 18 => 0x7 },
	'afpoints' => { 68 => 0x10 },
	'afpointselected' => { 102 => 0xe },
	'afpointselection' => { 19 => 0xb },
	'afpointselectionmethod' => { 20 => 0xc, 21 => 0xd, 24 => 0xd },
	'afpointspotmetering' => { 19 => 0xd },
	'afpointsused' => { 14 => [0x16,0x1a], 74 => 0x2, 102 => 0x3c },
	'afpointsused2' => { 17 => 0xe },
	'afpointsused5d' => { 0 => 0x38 },
	'afresponse' => { 79 => 0xad },
	'afsearch' => { 93 => 0x303 },
	'aiservotrackingsensitivity' => { 19 => 0x14 },
	'album' => { 126 => 'album' },
	'alttapename' => { 126 => 'altTapeName' },
	'alttimecodetimeformat' => { 126 => 'altTimecodeTimeFormat' },
	'alttimecodetimevalue' => { 126 => 'altTimecodeTimeValue' },
	'analogzoom' => { 52 => 0x1e, 55 => 'AnalogZoom' },
	'antialiasstrength' => { 40 => 0xc632 },
	'aperturevalue' => { 40 => 0x9202, 97 => 0x1002, 119 => 'ApertureValue' },
	'applicationrecordversion' => { 46 => 0x0 },
	'armidentifier' => { 47 => 0x78 },
	'armversion' => { 47 => 0x7a },
	'artist' => { 40 => 0x13b, 100 => 'Artist', 123 => 'Artist', 126 => 'artist' },
	'asshotwhitexy' => { 40 => 0xc629 },
	'assistbuttonfunction' => { 18 => 0xd },
	'audio' => { 101 => 0x20 },
	'audiochanneltype' => { 126 => 'audioChannelType' },
	'audiocompression' => { 54 => 'Compression' },
	'audiocompressor' => { 126 => 'audioCompressor' },
	'audioduration' => { 46 => 0x99 },
	'audiomoddate' => { 126 => 'audioModDate' },
	'audiooutcue' => { 46 => 0x9a },
	'audiosamplerate' => { 126 => 'audioSampleRate' },
	'audiosampletype' => { 126 => 'audioSampleType' },
	'audiosamplingrate' => { 46 => 0x97 },
	'audiosamplingresolution' => { 46 => 0x98 },
	'audiotype' => { 46 => 0x96 },
	'author' => { 56 => 'Author', 100 => 'Author', 108 => 'Author', 121 => 'Author' },
	'authorsposition' => { 122 => 'AuthorsPosition' },
	'autoafpoint' => { 102 => 0xf },
	'autobracket' => { 112 => 0x19 },
	'autobracketing' => { 44 => 0x1100 },
	'autobracketrelease' => { 79 => 0x8a },
	'autobrightness' => { 116 => 'AutoBrightness' },
	'autocontrast' => { 116 => 'AutoContrast' },
	'autoexposure' => { 116 => 'AutoExposure' },
	'autoexposurebracketing' => { 17 => 0x10 },
	'autofocus' => { 95 => 0x209 },
	'autoiso' => { 17 => 0x1, 38 => 0x3008 },
	'autorotate' => { 17 => 0x1b },
	'autoshadows' => { 116 => 'AutoShadows' },
	'auxiliarylens' => { 79 => 0x82 },
	'avvalue' => { 28 => 0x2 },
	'baseiso' => { 17 => 0x2, 32 => 0x101c },
	'baselineexposure' => { 40 => 0xc62a },
	'baselinenoise' => { 40 => 0xc62b },
	'baselinesharpness' => { 40 => 0xc62c },
	'baseurl' => { 124 => 'BaseURL' },
	'bayergreensplit' => { 40 => 0xc62d },
	'bayerpattern' => { 71 => 0x17 },
	'beatspliceparamsriseindecibel' => { 126 => 'beatSpliceParamsRiseInDecibel' },
	'beatspliceparamsriseintimeduration' => { 126 => 'beatSpliceParamsRiseInTimeDuration' },
	'beatspliceparamsusefilebeatsmarker' => { 126 => 'beatSpliceParamsUseFileBeatsMarker' },
	'bestqualityscale' => { 40 => 0xc65c },
	'bestshotmode' => { 38 => 0x3007 },
	'bitdepth' => { 60 => 'BitDepth', 71 => 0x11 },
	'bitspercomponent' => { 48 => 0x87 },
	'bitspersample' => { 40 => 0x102, 123 => 'BitsPerSample' },
	'blacklevel' => { 97 => 0x1012 },
	'blackpoint' => { 102 => 0x200 },
	'bluebalance' => { 55 => 'BlueBalance', 97 => 0x1018, 102 => 0x1b },
	'bluecurvelimits' => { 36 => 0x1fe },
	'bluecurvepoints' => { 36 => 0x1d4 },
	'bluehue' => { 116 => 'BlueHue' },
	'bluesaturation' => { 116 => 'BlueSaturation' },
	'blurwarning' => { 44 => 0x1300 },
	'bodyfirmwareversion' => { 94 => 0x104 },
	'bracketmode' => { 8 => 0x3 },
	'bracketsequence' => { 38 => 0x301d },
	'bracketshotnumber' => { 8 => 0x5 },
	'bracketstep' => { 66 => 0xe },
	'bracketvalue' => { 8 => 0x4 },
	'brightness' => { 40 => 0xfe53, 55 => 'Brightness', 66 => 0x2c, 116 => 'Brightness' },
	'brightnessadj' => { 36 => 0x114, 82 => 0x0 },
	'brightnessvalue' => { 40 => 0x9203, 97 => 0x1003, 119 => 'BrightnessValue' },
	'bulbduration' => { 17 => 0x18 },
	'burstmode' => { 50 => 0xa, 101 => 0x2a },
	'burstmode2' => { 50 => 0x18 },
	'bwfilter' => { 66 => 0x2a, 72 => 0x39 },
	'bwmode' => { 97 => 0x203 },
	'by-line' => { 46 => 0x50 },
	'by-linetitle' => { 46 => 0x55 },
	'calibrationilluminant1' => { 40 => 0xc65a },
	'calibrationilluminant2' => { 40 => 0xc65b },
	'cameraid' => { 97 => 0x209, 111 => 0x209 },
	'cameraiso' => { 1 => 0x10 },
	'cameraprofile' => { 116 => 'CameraProfile' },
	'cameraserialnumber' => { 40 => 0xc62f },
	'camerasettingsversion' => { 93 => 0x0 },
	'cameratype' => { 17 => 0x1a, 97 => 0x207 },
	'cameratype2' => { 94 => 0x100 },
	'canonexposuremode' => { 1 => 0x14 },
	'canonfiledescription' => { 32 => 0x805 },
	'canonfilelength' => { 11 => 0xe },
	'canonfirmwareversion' => { 11 => 0x7, 32 => 0x80b },
	'canonflashinfo' => { 32 => 0x1028 },
	'canonflashmode' => { 1 => 0x4 },
	'canonimageheight' => { 14 => 0x3 },
	'canonimageheightasshot' => { 14 => 0x5 },
	'canonimagesize' => { 1 => 0xa },
	'canonimagetype' => { 11 => 0x6, 32 => 0x815 },
	'canonimagewidth' => { 14 => 0x2 },
	'canonimagewidthasshot' => { 14 => 0x4 },
	'canonmodelid' => { 11 => 0x10 },
	'caption-abstract' => { 46 => 0x78 },
	'captionwriter' => { 122 => 'CaptionWriter' },
	'casioimagesize' => { 38 => 0x9 },
	'category' => { 46 => 0xf, 122 => 'Category' },
	'ccdisosensitivity' => { 38 => 0x3014 },
	'ccdscanmode' => { 97 => 0x1039 },
	'ccdsensitivity' => { 37 => 0x14, 81 => 0x6 },
	'celllength' => { 40 => 0x109 },
	'cellwidth' => { 40 => 0x108 },
	'certificate' => { 129 => 'Certificate' },
	'cfapattern' => { 40 => 0xa302 },
	'cfapatterncolumns' => { 119 => 'CFAPatternColumns' },
	'cfapatternrows' => { 119 => 'CFAPatternRows' },
	'cfapatternvalues' => { 119 => 'CFAPatternValues' },
	'channels' => { 54 => 'Channels' },
	'checkmark' => { 36 => 0x26a },
	'chromablurradius' => { 40 => 0xc631 },
	'chromaticaberrationb' => { 116 => 'ChromaticAberrationB' },
	'chromaticaberrationr' => { 116 => 'ChromaticAberrationR' },
	'city' => { 46 => 0x5a, 59 => 'City', 122 => 'City' },
	'classifystate' => { 46 => 0xe1 },
	'codec' => { 65 => 'Codec' },
	'codedcharacterset' => { 47 => 0x5a },
	'coloraberrationcontrol' => { 87 => 0xc89224b },
	'coloradjustment' => { 112 => 0x14 },
	'coloradjustmentmode' => { 111 => 0x210 },
	'colorantsa' => { 130 => 'ColorantsA' },
	'colorantsb' => { 130 => 'ColorantsB' },
	'colorantsblack' => { 130 => 'ColorantsBlack' },
	'colorantsblue' => { 130 => 'ColorantsBlue' },
	'colorantscyan' => { 130 => 'ColorantsCyan' },
	'colorantsgreen' => { 130 => 'ColorantsGreen' },
	'colorantsl' => { 130 => 'ColorantsL' },
	'colorantsmagenta' => { 130 => 'ColorantsMagenta' },
	'colorantsmode' => { 130 => 'ColorantsMode' },
	'colorantsred' => { 130 => 'ColorantsRed' },
	'colorantsswatchname' => { 130 => 'ColorantsSwatchName' },
	'colorantstype' => { 130 => 'ColorantsType' },
	'colorantsyellow' => { 130 => 'ColorantsYellow' },
	'colorbalance1' => { 79 => 0xc },
	'colorbalanceadj' => { 87 => 0x76a43202 },
	'colorbalanceblue' => { 66 => 0x1e },
	'colorbalancegreen' => { 66 => 0x1d },
	'colorbalancered' => { 66 => 0x1c },
	'colorbooster' => { 87 => 0x5f0e7d23 },
	'colorboostlevel' => { 83 => 0x1 },
	'colorboosttype' => { 83 => 0x0 },
	'colorclass' => { 103 => 0xde },
	'colorcontrol' => { 97 => 0x102b },
	'coloreffect' => { 101 => 0x28 },
	'colorfilter' => { 66 => 0x29, 72 => 0x38 },
	'colorhue' => { 6 => 0x2, 79 => 0x8d },
	'colormatrix' => { 7 => 0xa, 96 => 0x200, 97 => 0x1011 },
	'colormode' => { 38 => 0x3015, 44 => 0x1210, 50 => 0x66, 66 => 0x28, 69 => 0x16, 70 => 0x101, 72 => 0x7, 79 => 0x3, 81 => 0x4, 97 => 0x101, 101 => 0x32, 113 => 0xb029 },
	'colormoirereduction' => { 88 => 0x5 },
	'colornoisereduction' => { 116 => 'ColorNoiseReduction' },
	'colorplanes' => { 43 => 0x2 },
	'colorprofile' => { 66 => 0x33 },
	'colorrepresentation' => { 48 => 0x3c },
	'colorsequence' => { 48 => 0x41 },
	'colorspace' => { 6 => 0x3, 11 => 0xb4, 32 => 0x10b4, 40 => 0xa001, 60 => 'ColorSpace', 68 => 0x25, 79 => 0x1e, 93 => 0x507, 102 => 0x37, 112 => 0xb, 119 => 'ColorSpace' },
	'colortempasshot' => { 3 => 0x1d, 4 => 0x1c, 5 => 0x43 },
	'colortempauto' => { 3 => 0x22, 4 => 0x26, 5 => 0x48 },
	'colortempcloudy' => { 3 => 0x31, 4 => 0x35, 5 => 0x5c },
	'colortempcustom' => { 5 => 0x84 },
	'colortempcustom1' => { 3 => 0x45 },
	'colortempcustom2' => { 3 => 0x4a },
	'colortempdaylight' => { 3 => 0x27, 4 => 0x2b, 5 => 0x52 },
	'colortemperature' => { 7 => 0x9, 11 => 0xae, 16 => 0x9, 32 => 0x10ae, 55 => 'ColorTemperature', 67 => [0x6e,0x49], 68 => 0x3f, 69 => 0x5e, 70 => 0x10b, 72 => 0x3c },
	'colortempflash' => { 3 => 0x40, 4 => 0x49, 5 => 0x70 },
	'colortempfluorescent' => { 3 => 0x3b, 4 => 0x3f, 5 => 0x66 },
	'colortempkelvin' => { 4 => 0x44, 5 => 0x6b },
	'colortempmeasured' => { 5 => 0x4d },
	'colortemppc1' => { 4 => 0x94, 5 => 0x75 },
	'colortemppc2' => { 4 => 0x99, 5 => 0x7a },
	'colortemppc3' => { 4 => 0x9e, 5 => 0x7f },
	'colortempshade' => { 3 => 0x2c, 4 => 0x30, 5 => 0x57 },
	'colortemptungsten' => { 3 => 0x36, 4 => 0x3a, 5 => 0x61 },
	'colortempunknown' => { 4 => 0x21 },
	'colortempunknown10' => { 4 => 0x76 },
	'colortempunknown11' => { 4 => 0x7b },
	'colortempunknown12' => { 4 => 0x80 },
	'colortempunknown13' => { 4 => 0x85 },
	'colortempunknown14' => { 4 => 0x8a },
	'colortempunknown15' => { 4 => 0x8f },
	'colortempunknown16' => { 4 => 0xa3 },
	'colortempunknown2' => { 4 => 0x4e },
	'colortempunknown3' => { 4 => 0x53 },
	'colortempunknown4' => { 4 => 0x58 },
	'colortempunknown5' => { 4 => 0x5d },
	'colortempunknown6' => { 4 => 0x62 },
	'colortempunknown7' => { 4 => 0x67 },
	'colortempunknown8' => { 4 => 0x6c },
	'colortempunknown9' => { 4 => 0x71 },
	'colortone' => { 1 => 0x2a },
	'colortoneadj' => { 36 => 0x11e },
	'colortonefaithful' => { 0 => 0x107 },
	'colortonelandscape' => { 0 => 0x105 },
	'colortoneneutral' => { 0 => 0x106 },
	'colortoneportrait' => { 0 => 0x104 },
	'colortonestandard' => { 0 => 0x103 },
	'colortoneuserdef1' => { 0 => 0x109 },
	'colortoneuserdef2' => { 0 => 0x10a },
	'colortoneuserdef3' => { 0 => 0x10b },
	'comment' => { 41 => 'Comment', 56 => 'Comment', 100 => 'Comment' },
	'componentsconfiguration' => { 40 => 0x9101, 60 => 'Components', 119 => 'ComponentsConfiguration' },
	'componentversion' => { 32 => 0x80c },
	'composer' => { 126 => 'composer' },
	'compressedbitsperpixel' => { 40 => 0x9102, 119 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 70 => 0x40, 97 => 0x40 },
	'compression' => { 40 => 0x103, 123 => 'Compression' },
	'compressionfactor' => { 93 => 0x50d },
	'compressionratio' => { 60 => 'Compression', 97 => 0x1034 },
	'constrainedcropheight' => { 36 => 0x266, 103 => 0xd6 },
	'constrainedcropwidth' => { 36 => 0x262, 103 => 0xd5 },
	'contact' => { 46 => 0x76 },
	'contentlocationcode' => { 46 => 0x1a },
	'contentlocationname' => { 46 => 0x1b },
	'continuousdrive' => { 1 => 0x5 },
	'contrast' => { 1 => 0xd, 37 => 0xc, 38 => [0x3012,0x20], 40 => [0xa408,0xfe54], 44 => 0x1004, 55 => 'Contrast', 66 => 0x20, 67 => 0x31, 68 => 0x27, 69 => 0x19, 72 => 0x2, 97 => 0x1029, 101 => 0x2c, 102 => 0x20, 112 => 0xd, 116 => 'Contrast', 119 => 'Contrast' },
	'contrastadj' => { 36 => 0x115 },
	'contrastfaithful' => { 0 => 0xec },
	'contrastlandscape' => { 0 => 0xea },
	'contrastmonochrome' => { 0 => 0xed },
	'contrastneutral' => { 0 => 0xeb },
	'contrastportrait' => { 0 => 0xe9 },
	'contrastsetting' => { 93 => 0x505 },
	'contraststandard' => { 0 => 0xe8 },
	'contrastuserdef1' => { 0 => 0xee },
	'contrastuserdef2' => { 0 => 0xef },
	'contrastuserdef3' => { 0 => 0xf0 },
	'contributedmediaduration' => { 126 => 'contributedMediaDuration' },
	'contributedmediamanaged' => { 126 => 'contributedMediaManaged' },
	'contributedmediapath' => { 126 => 'contributedMediaPath' },
	'contributedmediastarttime' => { 126 => 'contributedMediaStartTime' },
	'contributedmediatrack' => { 126 => 'contributedMediaTrack' },
	'contributedmediawebstatement' => { 126 => 'contributedMediaWebStatement' },
	'contributor' => { 117 => 'contributor' },
	'contributors' => { 56 => 'Contributors' },
	'converter' => { 40 => 0xfe4d, 81 => 0xb },
	'copyright' => { 40 => 0x8298, 56 => 'Copyright', 100 => 'Copyright', 108 => 'Copyright', 123 => 'Copyright', 126 => 'copyright' },
	'copyrightflag' => { 106 => 0x40a },
	'copyrightnotice' => { 46 => 0x74 },
	'coringfilter' => { 97 => 0x102d },
	'country' => { 59 => 'Country', 122 => 'Country' },
	'country-primarylocationcode' => { 46 => 0x64 },
	'country-primarylocationname' => { 46 => 0x65 },
	'countrycode' => { 104 => 'CountryCode', 120 => 'CountryCode' },
	'coverage' => { 117 => 'coverage' },
	'crc32' => { 118 => 'crc32' },
	'createdate' => { 40 => 0x9004, 56 => 'CreateDate', 108 => 'CreationDate', 124 => 'CreateDate' },
	'creationdate' => { 121 => 'CreationDate' },
	'creationtime' => { 100 => 'Creation Time' },
	'creator' => { 108 => 'Creator', 117 => 'creator', 121 => 'Creator' },
	'creatorcontactinfociadrcity' => { 120 => 'CreatorContactInfoCiAdrCity' },
	'creatorcontactinfociadrctry' => { 120 => 'CreatorContactInfoCiAdrCtry' },
	'creatorcontactinfociadrextadr' => { 120 => 'CreatorContactInfoCiAdrExtadr' },
	'creatorcontactinfociadrpcode' => { 120 => 'CreatorContactInfoCiAdrPcode' },
	'creatorcontactinfociadrregion' => { 120 => 'CreatorContactInfoCiAdrRegion' },
	'creatorcontactinfociemailwork' => { 120 => 'CreatorContactInfoCiEmailWork' },
	'creatorcontactinfocitelwork' => { 120 => 'CreatorContactInfoCiTelWork' },
	'creatorcontactinfociurlwork' => { 120 => 'CreatorContactInfoCiUrlWork' },
	'creatortool' => { 124 => 'CreatorTool' },
	'credit' => { 46 => 0x6e, 122 => 'Credit' },
	'creditlinereq' => { 128 => 'CreditLineReq' },
	'cropactive' => { 36 => 0x244 },
	'cropangle' => { 116 => 'CropAngle' },
	'cropaspectratio' => { 36 => 0x260 },
	'cropbottom' => { 43 => 0x9, 84 => 0x36, 103 => 0xdc, 116 => 'CropBottom' },
	'cropheight' => { 36 => 0x24c, 116 => 'CropHeight' },
	'crophispeed' => { 79 => 0x1b },
	'cropleft' => { 36 => 0x246, 43 => 0x6, 84 => 0x1e, 103 => 0xd9, 116 => 'CropLeft' },
	'cropoutputscale' => { 84 => 0xbe },
	'cropright' => { 43 => 0x8, 84 => 0x2e, 103 => 0xdb, 116 => 'CropRight' },
	'croprotation' => { 43 => 0xb },
	'croptop' => { 36 => 0x248, 43 => 0x7, 84 => 0x26, 103 => 0xda, 116 => 'CropTop' },
	'cropunits' => { 116 => 'CropUnits' },
	'cropwidth' => { 36 => 0x24a, 116 => 'CropWidth' },
	'curves' => { 87 => 0x76a43201 },
	'customrendered' => { 40 => 0xa401, 119 => 'CustomRendered' },
	'customsaturation' => { 93 => 0x503 },
	'd-lightinghq' => { 87 => 0x2175eb78 },
	'd-lightinghqselected' => { 87 => 0x6a6e36b6 },
	'd-lightinghs' => { 87 => 0xce5554aa },
	'd-lightinghsadjustment' => { 86 => 0x0 },
	'd-lightinghscolorboost' => { 85 => 0x2, 86 => 0x1 },
	'd-lightinghshighlight' => { 85 => 0x1 },
	'd-lightinghsshadow' => { 85 => 0x0 },
	'datacompressionmethod' => { 48 => 0x6e },
	'dataimprint' => { 66 => 0x34 },
	'date' => { 102 => 0x6, 117 => 'date' },
	'datecreated' => { 46 => 0x37, 122 => 'DateCreated' },
	'datesent' => { 47 => 0x46 },
	'datetime' => { 123 => 'DateTime' },
	'datetimedigitized' => { 119 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 35 => 0x0, 40 => 0x9003, 56 => 'OriginalDate', 119 => 'DateTimeOriginal' },
	'datetimestamp' => { 50 => 0x64 },
	'decposition' => { 66 => 0x32 },
	'defaultcroporigin' => { 40 => 0xc61f },
	'defaultcropsize' => { 40 => 0xc620 },
	'defaultscale' => { 40 => 0xc61e },
	'deletedimagecount' => { 79 => 0xa6 },
	'derivedfromdocumentid' => { 127 => 'DerivedFromDocumentID' },
	'derivedfrominstanceid' => { 127 => 'DerivedFromInstanceID' },
	'derivedfrommanager' => { 127 => 'DerivedFromManager' },
	'derivedfrommanagervariant' => { 127 => 'DerivedFromManagerVariant' },
	'derivedfrommanageto' => { 127 => 'DerivedFromManageTo' },
	'derivedfrommanageui' => { 127 => 'DerivedFromManageUI' },
	'derivedfromrenditionclass' => { 127 => 'DerivedFromRenditionClass' },
	'derivedfromrenditionparams' => { 127 => 'DerivedFromRenditionParams' },
	'derivedfromversionid' => { 127 => 'DerivedFromVersionID' },
	'description' => { 100 => 'Description', 117 => 'description' },
	'destination' => { 47 => 0x5 },
	'destinationcity' => { 102 => 0x24 },
	'destinationcitycode' => { 102 => 0x1001 },
	'destinationdst' => { 102 => 0x26 },
	'developmentdynamicrange' => { 44 => 0x1403 },
	'devicesettingdescriptioncolumns' => { 119 => 'DeviceSettingDescriptionColumns' },
	'devicesettingdescriptionrows' => { 119 => 'DeviceSettingDescriptionRows' },
	'devicesettingdescriptionsettings' => { 119 => 'DeviceSettingDescriptionSettings' },
	'digitalcreationdate' => { 46 => 0x3e },
	'digitalcreationtime' => { 46 => 0x3f },
	'digitalgain' => { 16 => 0xb },
	'digitalzoom' => { 1 => 0xc, 37 => 0xa, 50 => 0x68, 55 => 'DigitalZoom', 66 => 0xc, 79 => 0x86, 81 => 0xa, 97 => 0x204, 102 => 0x1e, 111 => 0x204 },
	'digitalzoomon' => { 111 => 0x21b },
	'digitalzoomratio' => { 40 => 0xa404, 119 => 'DigitalZoomRatio' },
	'directory' => { 41 => 'Directory' },
	'disclaimer' => { 100 => 'Disclaimer' },
	'displayaperture' => { 1 => 0x23 },
	'displayedunitsx' => { 107 => 0x2 },
	'displayedunitsy' => { 107 => 0x6 },
	'distance1' => { 50 => 0x28 },
	'distance2' => { 50 => 0x2c },
	'distance3' => { 50 => 0x30 },
	'distance4' => { 50 => 0x34 },
	'distortioncorrection' => { 93 => 0x50b },
	'distortioncorrection2' => { 96 => 0x1011 },
	'dngbackwardversion' => { 40 => 0xc613 },
	'dnglensinfo' => { 40 => 0xc630 },
	'dngversion' => { 40 => 0xc612 },
	'document' => { 100 => 'Document' },
	'documenthistory' => { 46 => 0xe7 },
	'documentid' => { 127 => 'DocumentID' },
	'documentname' => { 40 => 0x10d },
	'documentnotes' => { 46 => 0xe6 },
	'dotrange' => { 40 => 0x150 },
	'drivemode' => { 66 => 0x6, 69 => 0x1e, 102 => 0x34, 112 => 0x3 },
	'duration' => { 54 => 'Duration', 65 => 'Duration', 126 => 'duration' },
	'dynamicrange' => { 44 => 0x1400 },
	'dynamicrangemax' => { 36 => 0x7c },
	'dynamicrangemin' => { 36 => 0x7a },
	'dynamicrangesetting' => { 44 => 0x1402 },
	'easymode' => { 1 => 0xb },
	'edgenoisereduction' => { 88 => 0x4 },
	'editorialupdate' => { 46 => 0x8 },
	'editstatus' => { 46 => 0x7, 104 => 'EditStatus' },
	'elevation' => { 59 => 'Elevation' },
	'engineer' => { 126 => 'engineer' },
	'enhancedarktones' => { 82 => 0x8 },
	'enhancement' => { 37 => 0x16, 38 => 0x3016 },
	'envelopenumber' => { 47 => 0x28 },
	'envelopepriority' => { 47 => 0x3c },
	'enveloperecordversion' => { 47 => 0x0 },
	'epsonimageheight' => { 97 => 0x20c },
	'epsonimagewidth' => { 97 => 0x20b },
	'epsonsoftware' => { 97 => 0x20d },
	'equipmentversion' => { 94 => 0x0 },
	'ettlii' => { 20 => 0xd, 21 => 0xe, 22 => 0x7, 23 => 0x7, 24 => 0xe },
	'excursiontolerance' => { 48 => 0x82 },
	'exifcamerainfo' => { 46 => 0xe8 },
	'exifimagelength' => { 40 => 0xa003, 119 => 'PixelYDimension' },
	'exifimagewidth' => { 40 => 0xa002, 119 => 'PixelXDimension' },
	'exifversion' => { 40 => 0x9000, 119 => 'ExifVersion' },
	'expirationdate' => { 46 => 0x25 },
	'expirationtime' => { 46 => 0x26 },
	'exposure' => { 40 => 0xfe51, 116 => 'Exposure' },
	'exposurebracketstep' => { 102 => 0x18 },
	'exposurebracketvalue' => { 79 => 0x19 },
	'exposurecompensation' => { 17 => 0x6, 28 => 0x0, 40 => 0x9204, 50 => 0x24, 55 => 'ExposureComp', 66 => 0xd, 67 => 0x53, 68 => 0x1e, 69 => 0x1, 97 => 0x1006, 102 => 0x16, 112 => 0xc, 119 => 'ExposureBiasValue' },
	'exposuredifference' => { 79 => 0xe },
	'exposureindex' => { 40 => 0xa215, 119 => 'ExposureIndex' },
	'exposurelevelincrements' => { 18 => 0x6, 19 => 0x6, 20 => 0x5, 21 => 0x6, 22 => 0x5, 23 => 0x5, 24 => 0x6, 25 => 0x4 },
	'exposuremode' => { 40 => 0xa402, 55 => 'ExposureMode', 66 => 0x1, 67 => 0xa, 68 => 0x0, 69 => 0x0, 93 => 0x200, 112 => 0x8, 119 => 'ExposureMode' },
	'exposureprogram' => { 40 => 0x8822, 119 => 'ExposureProgram' },
	'exposuretime' => { 0 => 0x4, 17 => 0x16, 40 => 0x829a, 50 => 0x20, 52 => 0x38, 55 => 'ExposureTime', 66 => 0x9, 67 => 0x35, 68 => 0x48, 102 => 0x12, 119 => 'ExposureTime' },
	'exposurewarning' => { 44 => 0x1302 },
	'extender' => { 94 => 0x301 },
	'extenderfirmwareversion' => { 94 => 0x304 },
	'extendermake' => { 57 => 'Make' },
	'extendermodel' => { 57 => 'Model', 94 => 0x303 },
	'extenderserialnumber' => { 57 => 'SerialNumber', 94 => 0x302 },
	'externalflash' => { 95 => 0x1201 },
	'externalflashbounce' => { 97 => 0x1026 },
	'externalflashmode' => { 97 => 0x1028 },
	'externalflashzoom' => { 97 => 0x1027 },
	'ffid' => { 118 => 'ffid' },
	'filedatarate' => { 126 => 'fileDataRate' },
	'fileformat' => { 30 => 0x0, 47 => 0x14 },
	'filemodifydate' => { 41 => 'FileModifyDate' },
	'filename' => { 41 => 'FileName' },
	'filenumber' => { 8 => 0x1, 11 => 0x8, 32 => 0x1817 },
	'filenumbermemory' => { 66 => 0x1a },
	'filesource' => { 40 => 0xa300, 44 => 0x8000, 119 => 'FileSource' },
	'fileversion' => { 47 => 0x16 },
	'fillflashautoreduction' => { 18 => 0xe, 19 => 0xe, 25 => 0xa },
	'fillorder' => { 40 => 0x10a },
	'filmmode' => { 44 => 0x1401 },
	'filter' => { 37 => 0x17, 38 => 0x3017 },
	'filtereffect' => { 8 => 0xe },
	'filtereffectmonochrome' => { 0 => 0xff },
	'finderdisplayduringexposure' => { 19 => 0x1 },
	'firmware' => { 112 => 0x17, 114 => 'Firmware' },
	'firmwaredate' => { 38 => 0x2001 },
	'firmwareid' => { 71 => 0x0 },
	'firmwarerevision' => { 0 => 0xa4 },
	'firmwareversion' => { 55 => 'FirmwareVersion', 79 => 0x1, 101 => 0x2 },
	'fixtureidentifier' => { 46 => 0x16 },
	'flash' => { 40 => 0x9209, 67 => 0x1f, 68 => 0x15 },
	'flashactivity' => { 1 => 0x1c },
	'flashbias' => { 101 => 0x24 },
	'flashbits' => { 1 => 0x1d },
	'flashchargelevel' => { 97 => 0x1010 },
	'flashcompensation' => { 114 => 'FlashCompensation' },
	'flashdevice' => { 97 => 0x1005 },
	'flashdistance' => { 38 => 0x2034 },
	'flashenergy' => { 40 => 0xa20b, 119 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 79 => 0x18 },
	'flashexposurecomp' => { 17 => 0xf, 58 => 'ExposureComp', 66 => 0x23, 70 => 0x104, 79 => 0x12, 97 => 0x1023 },
	'flashexposurecompensation' => { 93 => 0x401 },
	'flashfired' => { 50 => 0x5d, 58 => 'Fired', 66 => 0x14, 119 => 'FlashFired' },
	'flashfiring' => { 20 => 0x6, 21 => 0x7, 24 => 0x7 },
	'flashfirmwareversion' => { 94 => 0x1002 },
	'flashfunction' => { 119 => 'FlashFunction' },
	'flashguidenumber' => { 17 => 0xd, 29 => 0x0, 58 => 'GuideNumber' },
	'flashintensity' => { 37 => [0x19,0x5] },
	'flashmake' => { 58 => 'Make' },
	'flashmetering' => { 66 => 0x3f },
	'flashmode' => { 37 => 0x4, 50 => 0x5c, 58 => 'Mode', 66 => 0x2, 79 => 0x87, 93 => 0x400, 97 => 0x1004, 102 => 0xc, 109 => 0x20, 111 => 0x225, 119 => 'FlashMode' },
	'flashmodel' => { 58 => 'Model', 94 => 0x1001 },
	'flashpixversion' => { 40 => 0xa000, 119 => 'FlashpixVersion' },
	'flashredeyemode' => { 119 => 'FlashRedEyeMode' },
	'flashreturn' => { 119 => 'FlashReturn' },
	'flashserialnumber' => { 58 => 'SerialNumber', 94 => 0x1003 },
	'flashsetting' => { 79 => 0x8 },
	'flashstrength' => { 44 => 0x1011 },
	'flashsyncspeedav' => { 18 => 0x3, 20 => 0x2, 21 => 0x3, 22 => 0x2, 23 => 0x2, 24 => 0x3, 25 => 0x6 },
	'flashthreshold' => { 29 => 0x1 },
	'flashtype' => { 58 => 'Type', 79 => 0x9, 94 => 0x1000 },
	'flickerreduce' => { 111 => 0x218 },
	'fliphorizontal' => { 87 => 0x76a43206 },
	'fnumber' => { 17 => 0x15, 40 => 0x829d, 50 => 0x1e, 52 => 0x3c, 55 => 'FNumber', 66 => 0xa, 67 => 0x36, 68 => 0x47, 102 => 0x13, 119 => 'FNumber' },
	'focallength' => { 0 => 0xa, 10 => 0x1, 38 => 0x1d, 40 => 0x920a, 55 => 'FocalLength', 66 => 0x12, 102 => 0x1d, 119 => 'FocalLength' },
	'focallengthin35mmformat' => { 40 => 0xa405, 119 => 'FocalLengthIn35mmFilm' },
	'focalplanediagonal' => { 94 => 0x103, 97 => 0x205 },
	'focalplaneresolutionunit' => { 40 => 0xa210, 119 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 40 => 0xa20e, 119 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 10 => 0x2 },
	'focalplaneyresolution' => { 40 => 0xa20f, 119 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 10 => 0x3 },
	'focaltype' => { 0 => 0x2d, 10 => 0x0 },
	'focalunits' => { 1 => 0x19 },
	'focus' => { 81 => 0x8 },
	'focusarea' => { 66 => 0x31 },
	'focuscontinuous' => { 1 => 0x20 },
	'focusdistance' => { 55 => 'FocusDistance', 66 => 0x13, 95 => 0x305 },
	'focusdistancelower' => { 17 => 0x14 },
	'focusdistanceupper' => { 17 => 0x13 },
	'focusinfoversion' => { 95 => 0x0 },
	'focusingscreen' => { 19 => 0x0, 24 => 0x0 },
	'focusmode' => { 1 => 0x7, 37 => 0x3, 38 => [0x3003,0xd], 44 => 0x1021, 50 => 0x38, 55 => 'FocusMode', 66 => 0x30, 68 => 0xe, 79 => 0x7, 93 => 0x301, 97 => 0x100b, 101 => 0x7, 102 => 0xd },
	'focuspixel' => { 44 => 0x1023 },
	'focusposition' => { 102 => 0x10 },
	'focusprocess' => { 93 => 0x302 },
	'focusrange' => { 1 => 0x12 },
	'focussetting' => { 112 => 0x6 },
	'focusstepcount' => { 97 => 0x100e },
	'focuswarning' => { 44 => 0x1301 },
	'foldername' => { 66 => 0x27 },
	'fontschildfontfiles' => { 130 => 'FontsChildFontFiles' },
	'fontscomposite' => { 130 => 'FontsComposite' },
	'fontsfontface' => { 130 => 'FontsFontFace' },
	'fontsfontfamily' => { 130 => 'FontsFontFamily' },
	'fontsfontfilename' => { 130 => 'FontsFontFileName' },
	'fontsfontname' => { 130 => 'FontsFontName' },
	'fontsfonttype' => { 130 => 'FontsFontType' },
	'fontsversionstring' => { 130 => 'FontsVersionString' },
	'for' => { 108 => 'For' },
	'format' => { 117 => 'format' },
	'framenum' => { 103 => 0xd7 },
	'framenumber' => { 44 => 0x8003, 102 => 0x29 },
	'freebytes' => { 32 => 0x1 },
	'freememorycardimages' => { 67 => [0x37,0x54], 68 => [0x2d,0x4a] },
	'fujiflashmode' => { 44 => 0x1010 },
	'fullsizeimage' => { 60 => 'data' },
	'fullsizeimagename' => { 60 => '1Name' },
	'fullsizeimagetype' => { 60 => '0Type' },
	'gaincontrol' => { 40 => 0xa407, 119 => 'GainControl' },
	'gamma' => { 40 => 0xa500 },
	'gammacompensatedvalue' => { 48 => 0x91 },
	'genre' => { 126 => 'genre' },
	'globalaltitude' => { 106 => 0x419 },
	'globalangle' => { 106 => 0x40d },
	'gpsaltitude' => { 45 => 0x6, 119 => 'GPSAltitude' },
	'gpsaltituderef' => { 45 => 0x5, 119 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 45 => 0x1c, 119 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 45 => 0x1d },
	'gpsdestbearing' => { 45 => 0x18, 119 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 45 => 0x17, 119 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 45 => 0x1a, 119 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 45 => 0x19, 119 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 45 => 0x14, 119 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 45 => 0x13 },
	'gpsdestlongitude' => { 45 => 0x16, 119 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 45 => 0x15 },
	'gpsdifferential' => { 45 => 0x1e, 119 => 'GPSDifferential' },
	'gpsdop' => { 45 => 0xb, 119 => 'GPSDOP' },
	'gpsimgdirection' => { 45 => 0x11, 119 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 45 => 0x10, 119 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 45 => 0x2, 119 => 'GPSLatitude' },
	'gpslatituderef' => { 45 => 0x1 },
	'gpslongitude' => { 45 => 0x4, 119 => 'GPSLongitude' },
	'gpslongituderef' => { 45 => 0x3 },
	'gpsmapdatum' => { 45 => 0x12, 119 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 45 => 0xa, 119 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 45 => 0x1b, 119 => 'GPSProcessingMethod' },
	'gpssatellites' => { 45 => 0x8, 119 => 'GPSSatellites' },
	'gpsspeed' => { 45 => 0xd, 119 => 'GPSSpeed' },
	'gpsspeedref' => { 45 => 0xc, 119 => 'GPSSpeedRef' },
	'gpsstatus' => { 45 => 0x9, 119 => 'GPSStatus' },
	'gpstimestamp' => { 45 => 0x7, 119 => 'GPSTimeStamp' },
	'gpstrack' => { 45 => 0xf, 119 => 'GPSTrack' },
	'gpstrackref' => { 45 => 0xe, 119 => 'GPSTrackRef' },
	'gpsversionid' => { 45 => 0x0, 119 => 'GPSVersionID' },
	'gradation' => { 93 => 0x50f },
	'grayresponseunit' => { 40 => 0x122 },
	'greencurvelimits' => { 36 => 0x1c4 },
	'greencurvepoints' => { 36 => 0x19a },
	'greenhue' => { 116 => 'GreenHue' },
	'greensaturation' => { 116 => 'GreenSaturation' },
	'halftonehints' => { 40 => 0x141 },
	'hascrop' => { 116 => 'HasCrop' },
	'hassettings' => { 116 => 'HasSettings' },
	'headline' => { 46 => 0x69, 122 => 'Headline' },
	'highisonoisereduction' => { 79 => 0xb1 },
	'highlight' => { 112 => 0xf },
	'historyaction' => { 127 => 'HistoryAction' },
	'historyinstanceid' => { 127 => 'HistoryInstanceID' },
	'historyparameters' => { 127 => 'HistoryParameters' },
	'historysoftwareagent' => { 127 => 'HistorySoftwareAgent' },
	'historywhen' => { 127 => 'HistoryWhen' },
	'hometowncity' => { 102 => 0x23 },
	'hometowncitycode' => { 102 => 0x1000 },
	'hometowndst' => { 102 => 0x25 },
	'hostcomputer' => { 40 => 0x13c },
	'hue' => { 72 => 0x3b },
	'hueadjustment' => { 79 => 0x92 },
	'icc_profile' => { 41 => 'ICC_Profile' },
	'identifier' => { 117 => 'identifier', 124 => 'Identifier' },
	'imageadjustment' => { 79 => 0x80, 81 => 0x5 },
	'imageboundary' => { 79 => 0x16 },
	'imagecount' => { 79 => 0xa5 },
	'imagedatasize' => { 79 => 0xa2 },
	'imagedescription' => { 40 => 0x10e, 123 => 'ImageDescription' },
	'imagedustoff' => { 87 => 0xfe443a45 },
	'imageheight' => { 40 => 0x101, 71 => 0xc, 123 => 'ImageLength' },
	'imagehistory' => { 40 => 0x9213 },
	'imagenumber' => { 0 => 0xd0, 40 => 0x9211, 55 => 'ImageNumber', 67 => 0xae, 68 => 0x5e, 114 => 'ImageNumber' },
	'imagenumber2' => { 68 => 0x62 },
	'imageoptimization' => { 79 => 0xa9 },
	'imageorientation' => { 46 => 0x83 },
	'imageprocessing' => { 79 => 0x1a },
	'imageprocessingversion' => { 96 => 0x0 },
	'imagequality' => { 55 => 'ImageQuality', 101 => 0x1 },
	'imagequality2' => { 93 => 0x603 },
	'imagesize' => { 60 => 'ImageSize' },
	'imagestabilization' => { 1 => 0x22, 38 => 0x3020, 55 => 'ImageStabilization', 67 => 0xbd, 68 => 0x71, 69 => 0x87, 70 => [0x18,0x107,0x113], 79 => 0xac },
	'imagestabilizer' => { 101 => 0x1a },
	'imagetype' => { 46 => 0x82 },
	'imageuniqueid' => { 40 => 0xa420, 119 => 'ImageUniqueID' },
	'imagewidth' => { 40 => 0x100, 71 => 0xe, 123 => 'ImageWidth' },
	'infinitylensstep' => { 97 => 0x103b },
	'inkset' => { 40 => 0x14c },
	'instructions' => { 122 => 'Instructions' },
	'instrument' => { 126 => 'instrument' },
	'intellectualgenre' => { 120 => 'IntellectualGenre' },
	'interchangecolorspace' => { 48 => 0x40 },
	'internalflash' => { 66 => 0x2b, 95 => 0x1208 },
	'internalserialnumber' => { 11 => 0x96, 44 => 0x10, 94 => 0x102, 101 => 0x25 },
	'interopindex' => { 40 => 0x1 },
	'interopversion' => { 40 => 0x2 },
	'intervallength' => { 66 => 0x10 },
	'intervalmode' => { 66 => 0x26 },
	'intervalnumber' => { 66 => 0x11 },
	'introtime' => { 126 => 'introTime' },
	'iptc-naa' => { 40 => 0x83bb },
	'iptcbitspersample' => { 48 => 0x56 },
	'iptcimageheight' => { 48 => 0x1e },
	'iptcimagerotation' => { 48 => 0x66 },
	'iptcimagewidth' => { 48 => 0x14 },
	'iptcpicturenumber' => { 48 => 0xa },
	'iptcpixelheight' => { 48 => 0x32 },
	'iptcpixelwidth' => { 48 => 0x28 },
	'iso' => { 38 => 0x14, 40 => 0x8827, 50 => 0x60, 52 => 0x4e, 55 => 'ISO', 66 => 0x8, 79 => 0x2, 102 => 0x14, 119 => 'ISOSpeedRatings' },
	'isoexpansion' => { 20 => 0x7, 21 => 0x8, 24 => 0x8 },
	'isoselection' => { 79 => 0xf },
	'isosetting' => { 50 => 0x5e, 55 => 'ISOSetting', 66 => 0x24, 67 => 0x26, 68 => 0x1c, 72 => 0x6, 79 => 0x13, 109 => 0x27 },
	'isospeedexpansion' => { 19 => 0x3 },
	'isovalue' => { 97 => 0x1001 },
	'jobid' => { 46 => 0xb8 },
	'jobrefid' => { 125 => 'JobRefId' },
	'jobrefname' => { 125 => 'JobRefName' },
	'jobrefurl' => { 125 => 'JobRefUrl' },
	'jpgfromraw' => { 32 => 0x2007, 39 => 'JpgFromRaw' },
	'jpgfromrawlength' => { 40 => [0x117,0x202] },
	'jpgfromrawstart' => { 40 => [0x111,0x201] },
	'key' => { 126 => 'key' },
	'keywords' => { 46 => 0x19, 56 => 'Keywords', 108 => 'Keywords', 121 => 'Keywords' },
	'kodakimageheight' => { 50 => 0xe, 51 => 0x70 },
	'kodakimagewidth' => { 50 => 0xc, 51 => 0x6c },
	'kodakmaker' => { 51 => 0x8 },
	'kodakmodel' => { 50 => 0x0, 51 => 0x28 },
	'label' => { 100 => 'Label', 124 => 'Label' },
	'language' => { 117 => 'language' },
	'languageidentifier' => { 46 => 0x87 },
	'lastfilenumber' => { 66 => 0x1b },
	'lasturl' => { 127 => 'LastURL' },
	'latitude' => { 59 => 'Latitude' },
	'lcddisplayatpoweron' => { 23 => 0xa },
	'lcddisplayreturntoshoot' => { 24 => 0x12 },
	'lcdpanels' => { 19 => 0x8 },
	'lcheditor' => { 87 => 0x8ae85e },
	'lens' => { 40 => 0xfdea, 79 => 0x84, 112 => 0xa, 114 => 'Lens' },
	'lensafstopbutton' => { 18 => 0x11, 19 => 0x13, 20 => 0x10, 21 => 0x12, 24 => 0x13, 25 => 0x9 },
	'lensdataversion' => { 78 => 0x0 },
	'lensdistortionparams' => { 97 => 0x206 },
	'lensfirmwareversion' => { 94 => 0x204 },
	'lensfstops' => { 78 => 0x7, 79 => 0x8b },
	'lensid' => { 70 => 0x10c },
	'lensidnumber' => { 78 => 0x6 },
	'lensinfo' => { 114 => 'LensInfo' },
	'lensmake' => { 61 => 'Make' },
	'lensmodel' => { 61 => 'Model' },
	'lensserialnumber' => { 61 => 'SerialNumber', 94 => 0x202 },
	'lenstemperature' => { 97 => 0x1008 },
	'lenstype' => { 0 => 0xd, 1 => 0x16, 11 => 0x95, 79 => 0x83, 94 => 0x201, 102 => 0x3f },
	'license' => { 115 => 'license' },
	'licensetype' => { 118 => 'licensetype' },
	'lightsource' => { 40 => 0x9208, 79 => 0x90, 119 => 'LightSource' },
	'lightsourcespecial' => { 111 => 0x21d },
	'linearresponselimit' => { 40 => 0xc62e },
	'localcaption' => { 46 => 0x79 },
	'localizedcameramodel' => { 40 => 0xc615 },
	'location' => { 120 => 'Location' },
	'logcomment' => { 126 => 'logComment' },
	'longexposurenoisereduction' => { 20 => 0x1, 21 => 0x2, 22 => 0x1, 23 => 0x1, 24 => 0x2, 25 => 0x1 },
	'longfocal' => { 0 => 0x14, 1 => 0x17 },
	'longitude' => { 59 => 'Longitude' },
	'loop' => { 126 => 'loop' },
	'luminancesmoothing' => { 116 => 'LuminanceSmoothing' },
	'macro' => { 44 => 0x1020, 97 => 0x202, 109 => 0x21, 111 => 0x202 },
	'macromode' => { 1 => 0x1, 66 => 0xb, 93 => 0x300, 101 => 0x1c },
	'magnification' => { 57 => 'Magnification' },
	'magnifiedview' => { 21 => 0x11, 23 => 0x9 },
	'make' => { 33 => 0x0, 40 => 0x10f, 55 => 'Make', 100 => 'Make', 123 => 'Make' },
	'makernote' => { 119 => 'MakerNote' },
	'makernotecanon' => { 40 => 0x927c },
	'makernotecasio' => { 40 => 0x927c },
	'makernotecasio2' => { 40 => 0x927c },
	'makernotefujifilm' => { 40 => 0x927c },
	'makernotejvc' => { 40 => 0x927c },
	'makernotejvctext' => { 40 => 0x927c },
	'makernotekodak1a' => { 40 => 0x927c },
	'makernotekodak1b' => { 40 => 0x927c },
	'makernotekodak2' => { 40 => 0x927c },
	'makernotekodak3' => { 40 => 0x927c },
	'makernotekodak4' => { 40 => 0x927c },
	'makernotekodak5' => { 40 => 0x927c },
	'makernotekodak6a' => { 40 => 0x927c },
	'makernotekodak6b' => { 40 => 0x927c },
	'makernotekodakunknown' => { 40 => 0x927c },
	'makernotekyocera' => { 40 => 0x927c },
	'makernoteleica' => { 40 => 0x927c },
	'makernoteminolta' => { 40 => 0x927c },
	'makernoteminolta2' => { 40 => 0x927c },
	'makernoteminolta3' => { 40 => 0x927c },
	'makernoteminolta4' => { 40 => 0x927c },
	'makernotenikon' => { 40 => 0x927c },
	'makernotenikon2' => { 40 => 0x927c },
	'makernotenikon3' => { 40 => 0x927c },
	'makernoteoffset' => { 111 => 0xff },
	'makernoteolympus' => { 40 => 0x927c },
	'makernotepanasonic' => { 40 => 0x927c },
	'makernotepanasonic2' => { 40 => 0x927c },
	'makernotepentax' => { 40 => 0x927c },
	'makernotericoh' => { 40 => 0x927c },
	'makernotericohtext' => { 40 => 0x927c },
	'makernotesafety' => { 40 => 0xc635 },
	'makernotesanyo' => { 40 => 0x927c },
	'makernotesanyoc4' => { 40 => 0x927c },
	'makernotesigma' => { 40 => 0x927c },
	'makernotesony' => { 40 => 0x927c },
	'makernotesonysr2' => { 40 => 0x927c },
	'makernotesonysrf' => { 40 => 0x927c },
	'makernotetype' => { 110 => 0x1 },
	'makernoteunknown' => { 40 => 0x927c },
	'makernoteversion' => { 70 => 0x0, 97 => 0x0, 110 => 0x2 },
	'managedfromdocumentid' => { 127 => 'ManagedFromDocumentID' },
	'managedfrominstanceid' => { 127 => 'ManagedFromInstanceID' },
	'managedfrommanager' => { 127 => 'ManagedFromManager' },
	'managedfrommanagervariant' => { 127 => 'ManagedFromManagerVariant' },
	'managedfrommanageto' => { 127 => 'ManagedFromManageTo' },
	'managedfrommanageui' => { 127 => 'ManagedFromManageUI' },
	'managedfromrenditionclass' => { 127 => 'ManagedFromRenditionClass' },
	'managedfromrenditionparams' => { 127 => 'ManagedFromRenditionParams' },
	'managedfromversionid' => { 127 => 'ManagedFromVersionID' },
	'manager' => { 127 => 'Manager' },
	'managervariant' => { 127 => 'ManagerVariant' },
	'manageto' => { 127 => 'ManageTo' },
	'manageui' => { 127 => 'ManageUI' },
	'manualflash' => { 95 => 0x1209 },
	'manualfocusdistance' => { 79 => 0x85, 97 => 0x100c, 111 => 0x223 },
	'manualtv' => { 19 => 0x5 },
	'marked' => { 129 => 'Marked' },
	'markerscomment' => { 126 => 'markersComment' },
	'markersduration' => { 126 => 'markersDuration' },
	'markerslocation' => { 126 => 'markersLocation' },
	'markersname' => { 126 => 'markersName' },
	'markersstarttime' => { 126 => 'markersStartTime' },
	'markerstarget' => { 126 => 'markersTarget' },
	'markerstype' => { 126 => 'markersType' },
	'maskedareas' => { 40 => 0xc68e },
	'masterdocumentid' => { 46 => 0xb9 },
	'maxaperture' => { 1 => 0x1a, 55 => 'MaxAperture', 66 => 0x17 },
	'maxapertureatcurrentfocal' => { 94 => 0x20a },
	'maxapertureatmaxfocal' => { 44 => 0x1407, 55 => 'MaxApertureAtMaxFocal', 78 => 0xb, 94 => 0x206 },
	'maxapertureatminfocal' => { 44 => 0x1406, 78 => 0xa },
	'maxaperturevalue' => { 40 => 0x9205, 119 => 'MaxApertureValue' },
	'maxfocallength' => { 44 => 0x1405, 55 => 'MaxFocalLength', 78 => 0x9, 94 => 0x208 },
	'maximumdensityrange' => { 48 => 0x8c },
	'maxpagesizeh' => { 130 => 'MaxPageSizeH' },
	'maxpagesizeunit' => { 130 => 'MaxPageSizeUnit' },
	'maxpagesizew' => { 130 => 'MaxPageSizeW' },
	'maxsamplevalue' => { 40 => 0x119 },
	'mcuversion' => { 78 => 0xc },
	'measuredev' => { 17 => 0x3, 32 => 0x1814, 55 => 'MeasuredEV' },
	'menubuttondisplayposition' => { 18 => 0xb, 20 => 0xa, 21 => 0xb, 24 => 0xb },
	'menubuttonreturn' => { 25 => 0xb },
	'metadatadate' => { 124 => 'MetadataDate' },
	'metadatamoddate' => { 126 => 'metadataModDate' },
	'meteringmode' => { 1 => 0x11, 40 => 0x9207, 50 => 0x1c, 66 => 0x7, 67 => 0x25, 93 => 0x202, 102 => 0x17, 112 => 0x9, 119 => 'MeteringMode' },
	'minaperture' => { 1 => 0x1b, 55 => 'MinAperture' },
	'minfocallength' => { 44 => 0x1404, 55 => 'MinFocalLength', 78 => 0x8, 94 => 0x207 },
	'minoltadate' => { 66 => 0x15 },
	'minoltaimagesize' => { 66 => 0x4, 67 => 0xc, 68 => 0x2, 70 => 0x103 },
	'minoltamodelid' => { 66 => 0x25 },
	'minoltaquality' => { 66 => 0x5, 67 => 0xd, 68 => 0x3, 70 => [0x102,0x103], 97 => [0x102,0x103] },
	'minoltatime' => { 66 => 0x16 },
	'minsamplevalue' => { 40 => 0x118 },
	'mirrorlockup' => { 18 => 0xc, 19 => 0xc, 20 => 0xb, 21 => 0xc, 22 => 0x6, 23 => 0x6, 24 => 0xc, 25 => 0x3 },
	'moddate' => { 121 => 'ModDate' },
	'model' => { 33 => 0x6, 40 => 0x110, 55 => 'Model', 100 => 'Model', 123 => 'Model' },
	'modifiedcolortemp' => { 12 => 0x9 },
	'modifieddigitalgain' => { 12 => 0xb },
	'modifiedparamflag' => { 9 => 0x1 },
	'modifiedpicturestyle' => { 12 => 0xa },
	'modifiedsaturation' => { 93 => 0x504 },
	'modifiedsensorbluelevel' => { 12 => 0x5 },
	'modifiedsensorredlevel' => { 12 => 0x4 },
	'modifiedsharpness' => { 12 => 0x2 },
	'modifiedsharpnessfreq' => { 12 => 0x3 },
	'modifiedtonecurve' => { 12 => 0x1 },
	'modifiedwhitebalance' => { 12 => 0x8 },
	'modifiedwhitebalanceblue' => { 12 => 0x7 },
	'modifiedwhitebalancered' => { 12 => 0x6 },
	'modifydate' => { 40 => 0x132, 56 => 'ModifyDate', 99 => 'tIME', 108 => 'ModDate', 124 => 'ModifyDate' },
	'moirefilter' => { 40 => 0xfe58 },
	'monochromecontrast' => { 36 => 0x2ee },
	'monochromefiltereffect' => { 36 => 0x2ea },
	'monochromelinear' => { 36 => 0x2f0 },
	'monochromesharpness' => { 36 => 0x2f2 },
	'monochrometoningeffect' => { 36 => 0x2ec },
	'monthdaycreated' => { 50 => 0x12, 52 => 0xe },
	'ndfilter' => { 17 => 0x1c },
	'nearlensstep' => { 97 => 0x103c },
	'newsphotoversion' => { 48 => 0x0 },
	'nickname' => { 124 => 'Nickname' },
	'nikoncaptureversion' => { 79 => 0xe09 },
	'noisereduction' => { 8 => 0x8, 67 => 0xb0, 68 => 0x60, 69 => 0x3f, 79 => 0x95, 87 => 0x753dcbc0, 93 => 0x50a, 97 => 0x103a, 101 => 0x2d, 102 => 0x49 },
	'noisereduction2' => { 96 => 0x1010 },
	'noisereductionintensity' => { 88 => 0x9 },
	'noisereductionmethod' => { 88 => 0x11 },
	'noisereductionsharpness' => { 88 => 0xd },
	'npages' => { 130 => 'NPages' },
	'nullrecord' => { 32 => 0x0 },
	'numafpoints' => { 14 => 0x1 },
	'numberofbeats' => { 126 => 'numberOfBeats' },
	'numindexentries' => { 48 => 0x54 },
	'objectattributereference' => { 46 => 0x4 },
	'objectcycle' => { 46 => 0x4b },
	'objectdistance' => { 37 => 0x6, 38 => 0x2022 },
	'objectname' => { 46 => 0x5 },
	'objectpreviewdata' => { 46 => 0xca },
	'objectpreviewfileformat' => { 46 => 0xc8 },
	'objectpreviewfileversion' => { 46 => 0xc9 },
	'objecttypereference' => { 46 => 0x3 },
	'oecfcolumns' => { 119 => 'OECFColumns' },
	'oecfnames' => { 119 => 'OECFNames' },
	'oecfrows' => { 119 => 'OECFRows' },
	'oecfvalues' => { 119 => 'OECFValues' },
	'oldsubfiletype' => { 40 => 0xff },
	'olympusimageheight' => { 97 => 0x102f },
	'olympusimageheight2' => { 96 => 0x615 },
	'olympusimagewidth' => { 97 => 0x102e },
	'olympusimagewidth2' => { 96 => 0x614 },
	'onetouchwb' => { 97 => 0x302 },
	'opticalzoomon' => { 111 => 0x219 },
	'ordernumber' => { 44 => 0x8002 },
	'orientation' => { 40 => 0x112, 55 => 'Orientation', 123 => 'Orientation' },
	'originaldecisiondata' => { 11 => 0x83 },
	'originalfilename' => { 32 => 0x816, 53 => 0x20 },
	'originalimageheight' => { 43 => 0x1 },
	'originalimagewidth' => { 43 => 0x0 },
	'originalrawfiledata' => { 40 => 0xc68c },
	'originalrawfilename' => { 40 => 0xc68b },
	'originaltransmissionreference' => { 46 => 0x67 },
	'originatingprogram' => { 46 => 0x41 },
	'os' => { 118 => 'os' },
	'outcue' => { 126 => 'outCue' },
	'outputheight' => { 84 => 0xce },
	'outputheightinches' => { 84 => 0x96 },
	'outputpixels' => { 84 => 0xd6 },
	'outputresolution' => { 84 => 0xb6 },
	'outputwidth' => { 84 => 0xc6 },
	'outputwidthinches' => { 84 => 0x8e },
	'owner' => { 129 => 'Owner' },
	'ownerid' => { 46 => 0xbc },
	'ownername' => { 11 => 0x9, 32 => 0x810, 40 => 0xfde8, 55 => 'OwnerName', 114 => 'OwnerName' },
	'pagename' => { 40 => 0x11d },
	'pagenumber' => { 40 => 0x129 },
	'panoramadirection' => { 13 => 0x5 },
	'panoramaframe' => { 13 => 0x2 },
	'panoramamode' => { 50 => 0x3c, 93 => 0x601 },
	'pdfversion' => { 121 => 'PDFVersion' },
	'pentaximagesize' => { 102 => 0x9 },
	'pentaxmode' => { 102 => 0x1 },
	'pentaxmodelid' => { 102 => 0x5 },
	'pf0customfuncregistration' => { 27 => 0x1 },
	'pf10retainprogramshift' => { 27 => 0xb },
	'pf13drivepriority' => { 27 => 0xe },
	'pf14disablefocussearch' => { 27 => 0xf },
	'pf15disableafassistbeam' => { 27 => 0x10 },
	'pf16autofocuspointshoot' => { 27 => 0x11 },
	'pf17disableafpointsel' => { 27 => 0x12 },
	'pf18enableautoafpointsel' => { 27 => 0x13 },
	'pf19continuousshootspeed' => { 27 => 0x14 },
	'pf19shootingspeedhigh' => { 26 => 0xa },
	'pf19shootingspeedlow' => { 26 => 0x9 },
	'pf1disableshootingmodes' => { 27 => 0x2 },
	'pf1value' => { 26 => 0x1 },
	'pf20limitcontinousshots' => { 27 => 0x15 },
	'pf20maxcontinousshots' => { 26 => 0xb },
	'pf21enablequietoperation' => { 27 => 0x16 },
	'pf23felocktime' => { 26 => 0xd },
	'pf23postreleasetime' => { 26 => 0xe },
	'pf23settimerlengths' => { 27 => 0x18 },
	'pf23shutterbuttontime' => { 26 => 0xc },
	'pf24lightlcdduringbulb' => { 27 => 0x19 },
	'pf25aemode' => { 26 => 0xf },
	'pf25afmode' => { 26 => 0x12 },
	'pf25afpointsel' => { 26 => 0x13 },
	'pf25colormatrix' => { 26 => 0x17 },
	'pf25defaultclearsettings' => { 27 => 0x1a },
	'pf25drivemode' => { 26 => 0x11 },
	'pf25imagesize' => { 26 => 0x14 },
	'pf25meteringmode' => { 26 => 0x10 },
	'pf25parameters' => { 26 => 0x16 },
	'pf25wbmode' => { 26 => 0x15 },
	'pf26shortenreleaselag' => { 27 => 0x1b },
	'pf27reversedialrotation' => { 27 => 0x1c },
	'pf27value' => { 26 => 0x18 },
	'pf28noquickdialexpcomp' => { 27 => 0x1d },
	'pf29quickdialswitchoff' => { 27 => 0x1e },
	'pf2disablemeteringmodes' => { 27 => 0x3 },
	'pf2value' => { 26 => 0x2 },
	'pf30enlargementmode' => { 27 => 0x1f },
	'pf31originaldecisiondata' => { 27 => 0x20 },
	'pf3manualexposuremetering' => { 27 => 0x4 },
	'pf3value' => { 26 => 0x3 },
	'pf4exposuretimelimits' => { 27 => 0x5 },
	'pf4exposuretimemax' => { 26 => 0x5 },
	'pf4exposuretimemin' => { 26 => 0x4 },
	'pf5aperturelimits' => { 27 => 0x6 },
	'pf5aperturemax' => { 26 => 0x7 },
	'pf5aperturemin' => { 26 => 0x6 },
	'pf6presetshootingmodes' => { 27 => 0x7 },
	'pf7bracketcontinuousshoot' => { 27 => 0x8 },
	'pf8bracketshots' => { 26 => 0x8 },
	'pf8setbracketshots' => { 27 => 0x9 },
	'pf9changebracketsequence' => { 27 => 0xa },
	'photoeffect' => { 1 => 0x28 },
	'photoeffects' => { 87 => 0xab5eca5e },
	'photoeffectsblue' => { 89 => 0x8 },
	'photoeffectsgreen' => { 89 => 0x6 },
	'photoeffectsred' => { 89 => 0x4 },
	'photoeffectstype' => { 89 => 0x0 },
	'photometricinterpretation' => { 40 => 0x106, 123 => 'PhotometricInterpretation' },
	'photoshopquality' => { 105 => 0x0 },
	'pictinfo' => { 111 => 0x208 },
	'picturemode' => { 44 => 0x1031, 93 => 0x520, 102 => [0xb,0x33] },
	'picturemodebwfilter' => { 93 => 0x525 },
	'picturemodecontrast' => { 93 => 0x523 },
	'picturemodehue' => { 93 => 0x522 },
	'picturemodesaturation' => { 93 => 0x521 },
	'picturemodesharpness' => { 93 => 0x524 },
	'picturemodetone' => { 93 => 0x526 },
	'picturestyle' => { 0 => 0x6c, 16 => 0xa, 36 => 0x27a },
	'planarconfiguration' => { 40 => 0x11c, 123 => 'PlanarConfiguration' },
	'platenames' => { 130 => 'PlateNames' },
	'pngwarning' => { 100 => 'Warning' },
	'precaptureframes' => { 97 => 0x300 },
	'predictor' => { 40 => 0x13d },
	'prefs' => { 104 => 'Prefs' },
	'preservedfilename' => { 127 => 'PreservedFileName' },
	'previewfocalplanexresolution' => { 15 => 0x6 },
	'previewfocalplaneyresolution' => { 15 => 0x8 },
	'previewimage' => { 38 => 0x2000, 39 => 'PreviewImage', 40 => 0x927c, 42 => 0x4, 63 => 'data', 70 => 0x81, 97 => 0x280 },
	'previewimagedata' => { 102 => 0x2000 },
	'previewimageheight' => { 15 => 0x4 },
	'previewimagelength' => { 15 => 0x2, 38 => 0x3, 40 => [0x117,0x202], 70 => 0x89, 80 => 0x202, 93 => 0x102, 97 => 0x1037, 102 => 0x3, 109 => 0x1e },
	'previewimagename' => { 63 => '1Name' },
	'previewimagesize' => { 38 => 0x2, 63 => 'ImageSize', 102 => 0x2 },
	'previewimagestart' => { 15 => 0x5, 38 => 0x4, 40 => [0x111,0x201], 70 => 0x88, 80 => 0x201, 93 => 0x101, 97 => 0x1036, 102 => 0x4, 109 => 0x1c },
	'previewimagetype' => { 63 => '0Type' },
	'previewimagevalid' => { 93 => 0x100, 97 => 0x1035 },
	'previewimagewidth' => { 15 => 0x3 },
	'previewquality' => { 15 => 0x1 },
	'primarychromaticities' => { 40 => 0x13f, 123 => 'PrimaryChromaticities' },
	'printim' => { 40 => 0xc4a5 },
	'processingsoftware' => { 40 => 0xb },
	'producer' => { 121 => 'Producer' },
	'productid' => { 47 => 0x32 },
	'programmode' => { 72 => 0x5 },
	'programshift' => { 79 => 0xd },
	'programversion' => { 46 => 0x46 },
	'projectrefpath' => { 126 => 'projectRefPath' },
	'projectreftype' => { 126 => 'projectRefType' },
	'province-state' => { 46 => 0x5f },
	'publisher' => { 117 => 'publisher' },
	'pulldown' => { 126 => 'pullDown' },
	'quality' => { 1 => 0x3, 37 => 0x2, 38 => 0x3002, 44 => 0x1000, 50 => 0x9, 79 => 0x4, 81 => 0x3, 97 => 0x201, 102 => 0x8, 112 => 0x16 },
	'qualitymode' => { 38 => 0x8 },
	'quantizationmethod' => { 48 => 0x78 },
	'quickshot' => { 111 => 0x213 },
	'rasterizedcaption' => { 46 => 0x7d },
	'rating' => { 103 => 0xdf, 118 => 'rating', 124 => 'Rating' },
	'rawandjpgrecording' => { 18 => 0x8 },
	'rawbrightnessadj' => { 36 => 0x38 },
	'rawcoloradj' => { 36 => 0x2e },
	'rawcolortoneadj' => { 36 => 0x290 },
	'rawcontrastadj' => { 36 => 0x294 },
	'rawcropbottom' => { 103 => 0xd4 },
	'rawcropleft' => { 103 => 0xd1 },
	'rawcropright' => { 103 => 0xd3 },
	'rawcroptop' => { 103 => 0xd2 },
	'rawcustomsaturation' => { 36 => 0x30 },
	'rawcustomtone' => { 36 => 0x34 },
	'rawdatauniqueid' => { 40 => 0xc65d },
	'rawdepth' => { 71 => 0x10 },
	'rawdevcolorspace' => { 98 => 0x108 },
	'rawdevcontrastvalue' => { 98 => 0x106 },
	'rawdeveditstatus' => { 98 => 0x10b },
	'rawdevengine' => { 98 => 0x109 },
	'rawdevexposurebiasvalue' => { 98 => 0x100 },
	'rawdevgraypoint' => { 98 => 0x103 },
	'rawdevmemorycoloremphasis' => { 98 => 0x105 },
	'rawdevnoisereduction' => { 98 => 0x10a },
	'rawdevsaturationemphasis' => { 98 => 0x104 },
	'rawdevsettings' => { 98 => 0x10c },
	'rawdevsharpnessvalue' => { 98 => 0x107 },
	'rawdevversion' => { 98 => 0x0 },
	'rawdevwbfineadjustment' => { 98 => 0x102 },
	'rawdevwhitebalancevalue' => { 98 => 0x101 },
	'rawfile' => { 40 => 0xfe4c },
	'rawfilename' => { 116 => 'RawFileName' },
	'rawhighlightpoint' => { 36 => 0x29a },
	'rawimagecenter' => { 79 => 0x99 },
	'rawimagesize' => { 102 => 0x39 },
	'rawjpgheight' => { 34 => 0x4 },
	'rawjpgquality' => { 8 => 0x6, 34 => 0x1 },
	'rawjpgsize' => { 8 => 0x7, 34 => 0x2 },
	'rawjpgwidth' => { 34 => 0x3 },
	'rawlinear' => { 36 => 0x296 },
	'rawsaturationadj' => { 36 => 0x292 },
	'rawshadowpoint' => { 36 => 0x29c },
	'rawsharpnessadj' => { 36 => 0x298 },
	'recordid' => { 32 => 0x1804 },
	'recordingmode' => { 37 => 0x1 },
	'recordmode' => { 38 => 0x3000 },
	'recordshutterrelease' => { 111 => 0x217 },
	'redbalance' => { 55 => 'RedBalance', 97 => 0x1017, 102 => 0x1c },
	'redcurvelimits' => { 36 => 0x18a },
	'redcurvepoints' => { 36 => 0x160 },
	'redeyecorrection' => { 90 => 0x0 },
	'redhue' => { 116 => 'RedHue' },
	'redsaturation' => { 116 => 'RedSaturation' },
	'referenceblackwhite' => { 40 => 0x214, 123 => 'ReferenceBlackWhite' },
	'referencedate' => { 46 => 0x2f },
	'referencenumber' => { 46 => 0x32 },
	'references' => { 56 => 'References' },
	'referenceservice' => { 46 => 0x2d },
	'relatedaudiofile' => { 54 => 'data' },
	'relatedaudiofilename' => { 54 => '1Name' },
	'relatedaudiofiletype' => { 54 => '0Type' },
	'relatedimagefileformat' => { 40 => 0x1000 },
	'relatedimagelength' => { 40 => 0x1002 },
	'relatedimagewidth' => { 40 => 0x1001 },
	'relatedsoundfile' => { 40 => 0xa004, 119 => 'RelatedSoundFile' },
	'relatedvideofile' => { 65 => 'data' },
	'relatedvideofilename' => { 65 => '1Name' },
	'relatedvideofiletype' => { 65 => '0Type' },
	'relation' => { 117 => 'relation' },
	'relativepeakaudiofilepath' => { 126 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 126 => 'relativeTimestamp' },
	'releasedate' => { 46 => 0x1e, 126 => 'releaseDate' },
	'releasesetting' => { 32 => 0x1016 },
	'releasetime' => { 46 => 0x23 },
	'renditionclass' => { 127 => 'RenditionClass' },
	'renditionofdocumentid' => { 127 => 'RenditionOfDocumentID' },
	'renditionofinstanceid' => { 127 => 'RenditionOfInstanceID' },
	'renditionofmanager' => { 127 => 'RenditionOfManager' },
	'renditionofmanagervariant' => { 127 => 'RenditionOfManagerVariant' },
	'renditionofmanageto' => { 127 => 'RenditionOfManageTo' },
	'renditionofmanageui' => { 127 => 'RenditionOfManageUI' },
	'renditionofrenditionclass' => { 127 => 'RenditionOfRenditionClass' },
	'renditionofrenditionparams' => { 127 => 'RenditionOfRenditionParams' },
	'renditionofversionid' => { 127 => 'RenditionOfVersionID' },
	'renditionparams' => { 127 => 'RenditionParams' },
	'resampleparamsquality' => { 126 => 'resampleParamsQuality' },
	'resaved' => { 111 => 0x21e },
	'resolution' => { 60 => 'Resolution' },
	'resolutionmode' => { 112 => 0x4 },
	'resolutionunit' => { 40 => 0x128, 49 => 0x2, 123 => 'ResolutionUnit' },
	'resolutionunits' => { 60 => 'ResolutionUnits' },
	'reuseallowed' => { 128 => 'ReuseAllowed' },
	'revision' => { 118 => 'revision' },
	'rgbcurvelimits' => { 36 => 0x238 },
	'rgbcurvepoints' => { 36 => 0x20e },
	'ricohdate' => { 109 => 0x6 },
	'ricohimageheight' => { 109 => 0x2 },
	'ricohimagewidth' => { 109 => 0x0 },
	'rights' => { 117 => 'rights' },
	'romoperationmode' => { 32 => 0x80d },
	'rotation' => { 31 => 0x3, 36 => 0x26e, 43 => 0x4, 67 => 0x50, 68 => 0x46, 69 => 0x5a, 87 => 0x76a43207, 101 => 0x30, 103 => 0xd8 },
	'routing' => { 108 => 'Routing' },
	'rowsperstrip' => { 40 => 0x116 },
	'safetyshiftinavortv' => { 18 => 0x10, 19 => 0x10, 20 => 0xf, 21 => 0x10, 24 => 0x10 },
	'samplebits' => { 54 => 'SampleBits' },
	'samplerate' => { 54 => 'SampleRate' },
	'samplesperpixel' => { 40 => 0x115, 123 => 'SamplesPerPixel' },
	'samplestructure' => { 48 => 0x5a },
	'sanyoquality' => { 111 => 0x201 },
	'sanyothumbnail' => { 111 => 0x100 },
	'saturation' => { 1 => 0xe, 6 => 0x1, 37 => 0xd, 38 => [0x3013,0x1f], 40 => [0xa409,0xfe55], 44 => 0x1003, 55 => 'Saturation', 66 => 0x1f, 67 => 0x32, 68 => 0x28, 69 => 0x1a, 72 => 0x1, 79 => [0x94,0xaa], 102 => 0x1f, 109 => 0x28, 112 => 0x10, 116 => 'Saturation', 119 => 'Saturation' },
	'saturationadj' => { 36 => 0x116 },
	'saturationfaithful' => { 0 => 0xfe },
	'saturationlandscape' => { 0 => 0xfc },
	'saturationneutral' => { 0 => 0xfd },
	'saturationportrait' => { 0 => 0xfb },
	'saturationstandard' => { 0 => 0xfa },
	'saturationuserdef1' => { 0 => 0x100 },
	'saturationuserdef2' => { 0 => 0x101 },
	'saturationuserdef3' => { 0 => 0x102 },
	'saveid' => { 127 => 'SaveID' },
	'scaledfocallength' => { 10 => 0x1 },
	'scaledresolution' => { 84 => 0x9e },
	'scaletype' => { 126 => 'scaleType' },
	'scanningdirection' => { 48 => 0x64 },
	'scene' => { 120 => 'Scene', 126 => 'scene' },
	'scenecapturetype' => { 40 => 0xa406, 119 => 'SceneCaptureType' },
	'scenemode' => { 70 => 0x100, 79 => 0x8f, 93 => 0x509 },
	'sceneselect' => { 111 => 0x21f },
	'scenetype' => { 40 => 0xa301, 119 => 'SceneType' },
	'securityclassification' => { 40 => 0x9212 },
	'self-timer' => { 1 => 0x2 },
	'self-timer2' => { 17 => 0x1d },
	'selftimer' => { 38 => 0x3001, 101 => 0x2e, 111 => 0x214 },
	'selftimermode' => { 40 => 0x882b },
	'selftimertime' => { 32 => 0x1806 },
	'seminfo' => { 40 => 0x8546 },
	'sensingmethod' => { 40 => 0xa217, 119 => 'SensingMethod' },
	'sensorbluelevel' => { 16 => 0x5 },
	'sensorcleaning' => { 25 => 0xd },
	'sensorheight' => { 71 => 0x8 },
	'sensorpixelsize' => { 79 => 0x9a },
	'sensorredlevel' => { 16 => 0x4 },
	'sensorsize' => { 55 => 'SensorSize' },
	'sensortemperature' => { 95 => 0x1500, 97 => 0x1007 },
	'sensorwidth' => { 71 => 0xa },
	'sequence' => { 93 => 0x600 },
	'sequencenumber' => { 17 => 0x9, 38 => 0x301c, 44 => 0x1101, 50 => 0x1d, 101 => 0x2b },
	'sequenceshotinterval' => { 111 => 0x224 },
	'sequentialshot' => { 111 => 0x20e },
	'serialnumber' => { 11 => 0xc, 32 => 0x180b, 40 => 0xfde9, 55 => 'SerialNumber', 79 => 0xa0, 94 => 0x101, 97 => [0x404,0x101a], 112 => 0x2, 114 => 'SerialNumber' },
	'serialnumberformat' => { 11 => 0x15, 32 => 0x183b },
	'serviceidentifier' => { 47 => 0x1e },
	'setbuttoncrosskeysfunc' => { 22 => 0x0, 23 => 0x0 },
	'setbuttonfunction' => { 18 => 0x1, 25 => 0xc },
	'setfunctionwhenshooting' => { 20 => 0x0, 21 => 0x1, 24 => 0x1 },
	'shadingcompensation' => { 93 => 0x50c },
	'shadingcompensation2' => { 96 => 0x1012 },
	'shadow' => { 112 => 0xe },
	'shadows' => { 40 => 0xfe52, 116 => 'Shadows' },
	'shadowscale' => { 40 => 0xc633 },
	'shadowtint' => { 116 => 'ShadowTint' },
	'sharpness' => { 1 => 0xf, 16 => 0x2, 37 => 0xb, 38 => [0x3011,0x21], 40 => [0xa40a,0xfe56], 44 => 0x1001, 50 => 0x6b, 52 => 0x37, 55 => 'Sharpness', 66 => 0x21, 67 => 0x30, 68 => 0x26, 69 => 0x18, 72 => 0x3, 79 => 0x6, 97 => 0x100f, 102 => 0x21, 109 => 0x22, 110 => 0x1003, 112 => 0x11, 116 => 'Sharpness', 119 => 'Sharpness' },
	'sharpnessfactor' => { 97 => 0x102a },
	'sharpnessfaithful' => { 0 => 0xf5 },
	'sharpnessfrequency' => { 16 => 0x3 },
	'sharpnesslandscape' => { 0 => 0xf3 },
	'sharpnessmonochrome' => { 0 => 0xf6 },
	'sharpnessneutral' => { 0 => 0xf4 },
	'sharpnessportrait' => { 0 => 0xf2 },
	'sharpnesssetting' => { 93 => 0x506 },
	'sharpnessstandard' => { 0 => 0xf1 },
	'sharpnessuserdef1' => { 0 => 0xf7 },
	'sharpnessuserdef2' => { 0 => 0xf8 },
	'sharpnessuserdef3' => { 0 => 0xf9 },
	'shootingmode' => { 55 => 'ShootingMode', 79 => 0x89, 101 => 0x1f },
	'shortdescription' => { 118 => 'shortdescription' },
	'shortdocumentid' => { 46 => 0xba },
	'shortfocal' => { 0 => 0x12, 1 => 0x18 },
	'shortownername' => { 0 => 0xac },
	'shotdate' => { 126 => 'shotDate' },
	'shotlocation' => { 126 => 'shotLocation' },
	'shotname' => { 126 => 'shotName' },
	'shutter-aelock' => { 18 => 0x4, 20 => 0x3, 21 => 0x4, 22 => 0x3, 23 => 0x3, 24 => 0x4, 25 => 0x2 },
	'shutteraelbutton' => { 19 => 0x4 },
	'shuttercount' => { 8 => 0x1 },
	'shuttercurtainsync' => { 18 => 0xf, 19 => 0xf, 20 => 0xe, 21 => 0xf, 22 => 0x8, 23 => 0x8, 24 => 0xf, 25 => 0x8 },
	'shuttermode' => { 50 => 0x1b },
	'shutterreleasemethod' => { 32 => 0x1010 },
	'shutterreleasenocfcard' => { 18 => 0x2, 19 => 0x2, 25 => 0xf },
	'shutterreleasetiming' => { 32 => 0x1011 },
	'shutterspeedvalue' => { 40 => 0x9201, 97 => 0x1000, 119 => 'ShutterSpeedValue' },
	'similarityindex' => { 46 => 0xe4 },
	'slowshutter' => { 17 => 0x8 },
	'slowsync' => { 44 => 0x1030 },
	'smoothingparameter1' => { 96 => 0x300 },
	'smoothingparameter2' => { 96 => 0x310 },
	'smoothingthreshold2' => { 96 => 0x610 },
	'smoothingthresholds' => { 96 => 0x600 },
	'smoothness' => { 40 => 0xfe57 },
	'software' => { 40 => 0x131, 56 => 'Software', 100 => 'Software', 112 => 0x18, 123 => 'Software' },
	'softwareversion' => { 111 => 0x207 },
	'source' => { 46 => 0x73, 100 => 'Source', 117 => 'source', 118 => 'source', 122 => 'Source' },
	'sourceresolution' => { 84 => 0xae },
	'spatialfrequencyresponsecolumns' => { 119 => 'SpatialFrequencyResponseColumns' },
	'spatialfrequencyresponsenames' => { 119 => 'SpatialFrequencyResponseNames' },
	'spatialfrequencyresponserows' => { 119 => 'SpatialFrequencyResponseRows' },
	'spatialfrequencyresponsevalues' => { 119 => 'SpatialFrequencyResponseValues' },
	'speakerplacement' => { 126 => 'speakerPlacement' },
	'specialinstructions' => { 46 => 0x28 },
	'specialmode' => { 97 => 0x200, 111 => 0x200 },
	'spectralsensitivity' => { 40 => 0x8824, 119 => 'SpectralSensitivity' },
	'spotfocuspointx' => { 66 => 0x2d },
	'spotfocuspointy' => { 66 => 0x2e },
	'spotmode' => { 101 => 0xf },
	'starttimecodetimeformat' => { 126 => 'startTimecodeTimeFormat' },
	'starttimecodetimevalue' => { 126 => 'startTimecodeTimeValue' },
	'state' => { 59 => 'State', 122 => 'State' },
	'storagemethod' => { 71 => 0x12 },
	'straightenangle' => { 87 => 0x2fc08431 },
	'stretchmode' => { 126 => 'stretchMode' },
	'sub-location' => { 46 => 0x5c },
	'subfile' => { 62 => 'data' },
	'subfiledirectory' => { 62 => '1Directory' },
	'subfilemimetype' => { 62 => '2MIME' },
	'subfilename' => { 62 => '1Name' },
	'subfileresource' => { 62 => 'resource' },
	'subfiletype' => { 40 => 0xfe, 62 => '0Type' },
	'subject' => { 108 => 'Subject', 117 => 'subject', 121 => 'Subject' },
	'subjectarea' => { 119 => 'SubjectArea' },
	'subjectcode' => { 120 => 'SubjectCode' },
	'subjectdistance' => { 40 => 0x9206, 50 => 0x3e, 119 => 'SubjectDistance' },
	'subjectdistancerange' => { 40 => 0xa40c, 119 => 'SubjectDistanceRange' },
	'subjectlocation' => { 40 => [0x9214,0xa214], 119 => 'SubjectLocation' },
	'subjectprogram' => { 66 => 0x22 },
	'subjectreference' => { 46 => 0xc },
	'subsectime' => { 40 => 0x9290 },
	'subsectimedigitized' => { 40 => 0x9292 },
	'subsectimeoriginal' => { 40 => 0x9291 },
	'superimposeddisplay' => { 18 => 0xa, 20 => 0x9, 21 => 0xa, 24 => 0xa, 25 => 0xe },
	'supplementalcategories' => { 46 => 0x14, 122 => 'SupplementalCategories' },
	'supplementaltype' => { 48 => 0x37 },
	'switchtoregisteredafpoint' => { 19 => 0x12 },
	'tagged' => { 103 => 0xdd },
	'tapename' => { 126 => 'tapeName' },
	'targetaperture' => { 17 => 0x4 },
	'targetcompressionratio' => { 30 => 0x1 },
	'targetdistancesetting' => { 32 => 0x1807 },
	'targetexposuretime' => { 17 => 0x5 },
	'targetimagetype' => { 32 => 0x100a },
	'temperature' => { 116 => 'Temperature' },
	'tempo' => { 126 => 'tempo' },
	'thresholding' => { 40 => 0x107 },
	'thumbnailfilename' => { 32 => 0x817 },
	'thumbnailimage' => { 32 => 0x2008, 39 => 'ThumbnailImage', 42 => 0x3, 64 => 'data', 97 => 0x100 },
	'thumbnailimagename' => { 64 => '1Name' },
	'thumbnailimagesize' => { 64 => 'ImageSize' },
	'thumbnailimagetype' => { 64 => '0Type' },
	'thumbnaillength' => { 40 => 0x202 },
	'thumbnailoffset' => { 40 => 0x201 },
	'thumbnailsformat' => { 124 => 'ThumbnailsFormat' },
	'thumbnailsheight' => { 124 => 'ThumbnailsHeight' },
	'thumbnailsimage' => { 124 => 'ThumbnailsImage' },
	'thumbnailswidth' => { 124 => 'ThumbnailsWidth' },
	'tilelength' => { 40 => 0x143 },
	'tilewidth' => { 40 => 0x142 },
	'time' => { 102 => 0x7 },
	'timecreated' => { 46 => 0x3c, 50 => 0x14, 52 => 0x10, 104 => 'TimeCreated' },
	'timescaleparamsframeoverlappingpercentage' => { 126 => 'timeScaleParamsFrameOverlappingPercentage' },
	'timescaleparamsframesize' => { 126 => 'timeScaleParamsFrameSize' },
	'timescaleparamsquality' => { 126 => 'timeScaleParamsQuality' },
	'timesent' => { 47 => 0x50 },
	'timesignature' => { 126 => 'timeSignature' },
	'timestamp' => { 0 => 0x11c, 100 => 'TimeStamp' },
	'timezone' => { 38 => 0x3006 },
	'timezonecode' => { 35 => 0x1 },
	'timezoneinfo' => { 35 => 0x2 },
	'timezoneoffset' => { 40 => 0x882a },
	'tint' => { 116 => 'Tint' },
	'title' => { 56 => 'Title', 100 => 'Title', 108 => 'Title', 117 => 'title', 121 => 'Title' },
	'tonecomp' => { 79 => 0x81 },
	'tonecurve' => { 16 => 0x1, 102 => 0x402, 116 => 'ToneCurve' },
	'tonecurveactive' => { 36 => 0x110 },
	'tonecurvename' => { 116 => 'ToneCurveName' },
	'tonecurveproperty' => { 36 => 0x3c },
	'tonecurves' => { 102 => 0x403 },
	'toningeffect' => { 8 => 0xf },
	'toningeffectmonochrome' => { 0 => 0x108 },
	'totalzoom' => { 50 => 0x62 },
	'tracknumber' => { 126 => 'trackNumber' },
	'trailersignature' => { 62 => 'zmie' },
	'transferfunction' => { 123 => 'TransferFunction' },
	'transmissionreference' => { 122 => 'TransmissionReference' },
	'travelday' => { 101 => 0x36 },
	'tvvalue' => { 28 => 0x1 },
	'type' => { 117 => 'type' },
	'uniquecameramodel' => { 40 => 0xc614 },
	'uniquedocumentid' => { 46 => 0xbb },
	'uniqueobjectname' => { 47 => 0x64 },
	'unsharp1color' => { 91 => 0x13 },
	'unsharp1halowidth' => { 91 => 0x19 },
	'unsharp1intensity' => { 91 => 0x17 },
	'unsharp1threshold' => { 91 => 0x1b },
	'unsharp2color' => { 91 => 0x2e },
	'unsharp2halowidth' => { 91 => 0x34 },
	'unsharp2intensity' => { 91 => 0x32 },
	'unsharp2threshold' => { 91 => 0x36 },
	'unsharp3color' => { 91 => 0x49 },
	'unsharp3halowidth' => { 91 => 0x4f },
	'unsharp3intensity' => { 91 => 0x4d },
	'unsharp3threshold' => { 91 => 0x51 },
	'unsharp4color' => { 91 => 0x64 },
	'unsharp4halowidth' => { 91 => 0x6a },
	'unsharp4intensity' => { 91 => 0x68 },
	'unsharp4threshold' => { 91 => 0x6c },
	'unsharpcount' => { 91 => 0x0 },
	'unsharpmask' => { 87 => 0x76a43200 },
	'urgency' => { 46 => 0xa, 122 => 'Urgency' },
	'url' => { 56 => 'URL', 100 => 'URL', 106 => 0x40b },
	'usageterms' => { 129 => 'UsageTerms' },
	'usercomment' => { 32 => 0x805, 40 => 0x9286, 119 => 'UserComment' },
	'userdef1picturestyle' => { 0 => 0x10c },
	'userdef2picturestyle' => { 0 => 0x10e },
	'userdef3picturestyle' => { 0 => 0x110 },
	'usmlenselectronicmf' => { 19 => 0x7 },
	'validbits' => { 96 => 0x611, 97 => 0x102c },
	'variousmodes' => { 50 => 0x26 },
	'variousmodes2' => { 50 => 0x3a },
	'variprogram' => { 79 => 0xab },
	'version' => { 44 => 0x0, 108 => 'Version', 116 => 'Version' },
	'versionid' => { 127 => 'VersionID' },
	'versionscomments' => { 127 => 'VersionsComments' },
	'versionseventaction' => { 127 => 'VersionsEventAction' },
	'versionseventinstanceid' => { 127 => 'VersionsEventInstanceID' },
	'versionseventparameters' => { 127 => 'VersionsEventParameters' },
	'versionseventsoftwareagent' => { 127 => 'VersionsEventSoftwareAgent' },
	'versionseventwhen' => { 127 => 'VersionsEventWhen' },
	'versionsmodifier' => { 127 => 'VersionsModifier' },
	'versionsmodifydate' => { 127 => 'VersionsModifyDate' },
	'versionsversion' => { 127 => 'VersionsVersion' },
	'videoalphamode' => { 126 => 'videoAlphaMode' },
	'videoalphapremultiplecolora' => { 126 => 'videoAlphaPremultipleColorA' },
	'videoalphapremultiplecolorb' => { 126 => 'videoAlphaPremultipleColorB' },
	'videoalphapremultiplecolorblack' => { 126 => 'videoAlphaPremultipleColorBlack' },
	'videoalphapremultiplecolorblue' => { 126 => 'videoAlphaPremultipleColorBlue' },
	'videoalphapremultiplecolorcyan' => { 126 => 'videoAlphaPremultipleColorCyan' },
	'videoalphapremultiplecolorgreen' => { 126 => 'videoAlphaPremultipleColorGreen' },
	'videoalphapremultiplecolorl' => { 126 => 'videoAlphaPremultipleColorL' },
	'videoalphapremultiplecolormagenta' => { 126 => 'videoAlphaPremultipleColorMagenta' },
	'videoalphapremultiplecolormode' => { 126 => 'videoAlphaPremultipleColorMode' },
	'videoalphapremultiplecolorred' => { 126 => 'videoAlphaPremultipleColorRed' },
	'videoalphapremultiplecolorswatchname' => { 126 => 'videoAlphaPremultipleColorSwatchName' },
	'videoalphapremultiplecolortype' => { 126 => 'videoAlphaPremultipleColorType' },
	'videoalphapremultiplecoloryellow' => { 126 => 'videoAlphaPremultipleColorYellow' },
	'videoalphaunityistransparent' => { 126 => 'videoAlphaUnityIsTransparent' },
	'videocolorspace' => { 126 => 'videoColorSpace' },
	'videocompressor' => { 126 => 'videoCompressor' },
	'videofieldorder' => { 126 => 'videoFieldOrder' },
	'videoframerate' => { 126 => 'videoFrameRate' },
	'videoframesizeh' => { 126 => 'videoFrameSizeH' },
	'videoframesizeunit' => { 126 => 'videoFrameSizeUnit' },
	'videoframesizew' => { 126 => 'videoFrameSizeW' },
	'videomoddate' => { 126 => 'videoModDate' },
	'videopixelaspectratio' => { 126 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 126 => 'videoPixelDepth' },
	'vignetteamount' => { 116 => 'VignetteAmount' },
	'vignettecontrol' => { 87 => 0x76a43205 },
	'vignettecontrolintensity' => { 87 => 0xac6bd5c0 },
	'vignettemidpoint' => { 116 => 'VignetteMidpoint' },
	'voicememo' => { 111 => 0x216 },
	'wb_rbgglevels' => { 75 => 0x0 },
	'wb_rblevels' => { 96 => 0x100 },
	'wb_rgbglevels' => { 77 => 0x0 },
	'wb_rggblevels' => { 76 => 0x0 },
	'wb_rggblevelsasshot' => { 3 => 0x19, 4 => 0x18, 5 => 0x3f },
	'wb_rggblevelsauto' => { 2 => 0x0, 3 => 0x1e, 4 => 0x22, 5 => 0x44 },
	'wb_rggblevelscloudy' => { 2 => 0xc, 3 => 0x2d, 4 => 0x31, 5 => 0x58 },
	'wb_rggblevelscustom' => { 2 => 0x1c, 5 => 0x80 },
	'wb_rggblevelscustom1' => { 3 => 0x41 },
	'wb_rggblevelscustom2' => { 3 => 0x46 },
	'wb_rggblevelsdaylight' => { 2 => 0x4, 3 => 0x23, 4 => 0x27, 5 => 0x4e },
	'wb_rggblevelsflash' => { 2 => 0x18, 3 => 0x3c, 4 => 0x45, 5 => 0x6c },
	'wb_rggblevelsfluorescent' => { 2 => 0x14, 3 => 0x37, 4 => 0x3b, 5 => 0x62 },
	'wb_rggblevelskelvin' => { 2 => 0x20, 4 => 0x40, 5 => 0x67 },
	'wb_rggblevelsmeasured' => { 5 => 0x49 },
	'wb_rggblevelspc1' => { 4 => 0x90, 5 => 0x71 },
	'wb_rggblevelspc2' => { 4 => 0x95, 5 => 0x76 },
	'wb_rggblevelspc3' => { 4 => 0x9a, 5 => 0x7b },
	'wb_rggblevelsshade' => { 2 => 0x8, 3 => 0x28, 4 => 0x2c, 5 => 0x53 },
	'wb_rggblevelstungsten' => { 2 => 0x10, 3 => 0x32, 4 => 0x36, 5 => 0x5d },
	'wb_rggblevelsunknown' => { 4 => 0x1d },
	'wb_rggblevelsunknown10' => { 4 => 0x72 },
	'wb_rggblevelsunknown11' => { 4 => 0x77 },
	'wb_rggblevelsunknown12' => { 4 => 0x7c },
	'wb_rggblevelsunknown13' => { 4 => 0x81 },
	'wb_rggblevelsunknown14' => { 4 => 0x86 },
	'wb_rggblevelsunknown15' => { 4 => 0x8b },
	'wb_rggblevelsunknown16' => { 4 => 0x9f },
	'wb_rggblevelsunknown2' => { 4 => 0x4a },
	'wb_rggblevelsunknown3' => { 4 => 0x4f },
	'wb_rggblevelsunknown4' => { 4 => 0x54 },
	'wb_rggblevelsunknown5' => { 4 => 0x59 },
	'wb_rggblevelsunknown6' => { 4 => 0x5e },
	'wb_rggblevelsunknown7' => { 4 => 0x63 },
	'wb_rggblevelsunknown8' => { 4 => 0x68 },
	'wb_rggblevelsunknown9' => { 4 => 0x6d },
	'wbadjbluebalance' => { 92 => 0x8 },
	'wbadjcolortemp' => { 36 => 0x1a },
	'wbadjlighting' => { 92 => 0x15 },
	'wbadjmode' => { 92 => 0x10 },
	'wbadjredbalance' => { 92 => 0x0 },
	'wbadjrgblevels' => { 36 => 0x8 },
	'wbadjtemperature' => { 92 => 0x18 },
	'wbbracketmode' => { 8 => 0x9 },
	'wbbracketvalueab' => { 8 => 0xc },
	'wbbracketvaluegm' => { 8 => 0xd },
	'wbfinetuneactive' => { 36 => 0x24 },
	'wbfinetunesaturation' => { 36 => 0x28 },
	'wbfinetunetone' => { 36 => 0x2c },
	'wblevels' => { 73 => 0x4 },
	'wbmode' => { 72 => 0x4, 97 => 0x1015 },
	'wbscale' => { 73 => 0x0 },
	'wbshiftab' => { 16 => 0xc },
	'wbshiftgm' => { 16 => 0xd },
	'webstatement' => { 129 => 'WebStatement' },
	'whitebalance' => { 16 => 0x8, 17 => 0x7, 37 => 0x7, 38 => [0x19,0x2012], 40 => [0xa403,0xfe4e], 44 => 0x1002, 50 => 0x40, 66 => 0x3, 67 => 0xe, 68 => 0x4, 69 => 0xb, 79 => 0x5, 81 => 0x7, 101 => 0x3, 102 => 0x19, 109 => 0x26, 112 => 0x7, 116 => 'WhiteBalance', 119 => 'WhiteBalance' },
	'whitebalance2' => { 93 => 0x500 },
	'whitebalanceadj' => { 36 => 0x18, 87 => 0x76a43204 },
	'whitebalancebias' => { 38 => 0x2011, 101 => 0x23 },
	'whitebalanceblue' => { 16 => 0x7 },
	'whitebalancebracket' => { 93 => 0x502 },
	'whitebalancefinetune' => { 79 => 0xb },
	'whitebalancemode' => { 102 => 0x1a },
	'whitebalancered' => { 16 => 0x6 },
	'whitebalancetemperature' => { 93 => 0x501 },
	'whitepoint' => { 40 => 0x13e, 102 => 0x201, 123 => 'WhitePoint' },
	'widefocuszone' => { 66 => 0x2f },
	'widerange' => { 111 => 0x20f },
	'workcolorspace' => { 36 => 0x270 },
	'worldtimelocation' => { 102 => 0x22 },
	'writer-editor' => { 46 => 0x7a },
	'x3filllight' => { 112 => 0x12 },
	'xmp' => { 41 => 'XMP' },
	'xpauthor' => { 40 => 0x9c9d },
	'xpcomment' => { 40 => 0x9c9c },
	'xpkeywords' => { 40 => 0x9c9e },
	'xposition' => { 40 => 0x11e },
	'xpsubject' => { 40 => 0x9c9f },
	'xptitle' => { 40 => 0x9c9b },
	'xresolution' => { 40 => 0x11a, 49 => 0x3, 107 => 0x0, 123 => 'XResolution' },
	'xyresolution' => { 43 => 0x3 },
	'ycbcrcoefficients' => { 40 => 0x211, 123 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 40 => 0x213, 123 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 40 => 0x212, 123 => 'YCbCrSubSampling' },
	'yearcreated' => { 50 => 0x10, 52 => 0xc },
	'yposition' => { 40 => 0x11f },
	'yresolution' => { 40 => 0x11b, 49 => 0x5, 107 => 0x4, 123 => 'YResolution' },
	'zonematching' => { 70 => 0x10a, 72 => 0x3a },
	'zonematchingon' => { 68 => 0x75 },
	'zoomsourcewidth' => { 1 => 0x24 },
	'zoomstepcount' => { 95 => 0x300, 97 => 0x100d },
	'zoomtargetwidth' => { 1 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'adobe' => 1,
	'adobephotoshop' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'afaperture' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afinfo' => 1,
	'afpointsused1d' => 1,
	'albumartist' => 1,
	'albumcoverurl' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'aliaslayermetadata' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphasample' => 1,
	'analogbalance' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'applestoreid' => 1,
	'applicationnotes' => 1,
	'archivallocation' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'aspectratio' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'asshoticcprofile' => 1,
	'asshotneutral' => 1,
	'asshotpreprofilematrix' => 1,
	'association' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'audiences' => 1,
	'audiobitrate' => 1,
	'audiobytes' => 1,
	'audiochannels' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecname' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audioinfo' => 1,
	'audiolayer' => 1,
	'audiomode' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorurl' => 1,
	'aux' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'azimuth' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'badfaxlines' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'basisobject' => 1,
	'batterylevel' => 1,
	'beatsperminute' => 1,
	'binaryfilter' => 1,
	'bitrate' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperrunlength' => 1,
	'blacklevel2' => 1,
	'blackleveldeltah' => 1,
	'blackleveldeltav' => 1,
	'blacklevelrepeatdim' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blocksperframe' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'bufferaverage' => 1,
	'burstshot' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bytesperminute' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calibrationdatetime' => 1,
	'camera' => 1,
	'camerabacktype' => 1,
	'cameracalibration1' => 1,
	'cameracalibration2' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraowner' => 1,
	'cameraprofileversion' => 1,
	'camerasettings' => 1,
	'camerasetup' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canoncamerainfo' => 1,
	'canoncamerasettings' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonpanorama' => 1,
	'canonpictureinfo' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonvrd' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'casio' => 1,
	'cc' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfapattern2' => 1,
	'cfaplanecolor' => 1,
	'cfarepeatpatterndim' => 1,
	'channelmode' => 1,
	'charcount' => 1,
	'chartarget' => 1,
	'chromaticadaptation' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'ciff' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'cleanfaxdata' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'cmcontrast' => 1,
	'cmexposurecompensation' => 1,
	'cmhue' => 1,
	'cmmflags' => 1,
	'cmsaturation' => 1,
	'cmsharpness' => 1,
	'cmwhitebalance' => 1,
	'cmwhitebalancecomp' => 1,
	'cmwhitebalancegraypoint' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codingmethods' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloraverages' => 1,
	'colorbalance' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance2' => 1,
	'colorbalance3' => 1,
	'colorbalanceunknown' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcomponents' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorinfo' => 1,
	'colorinfod30' => 1,
	'colormap' => 1,
	'colormatrix1' => 1,
	'colormatrix2' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'compatibility' => 1,
	'compilation' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compressed' => 1,
	'compressedtext' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressor' => 1,
	'compressorid' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'cont' => 1,
	'containerformat' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdistributor' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentrating' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringvalues' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'cpuversions' => 1,
	'crdinfo' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'cropdata' => 1,
	'cropped' => 1,
	'cross-reference' => 1,
	'crs' => 1,
	'currentbitrate' => 1,
	'currenticcprofile' => 1,
	'currentpreprofilematrix' => 1,
	'currenttime' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'data' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datareference' => 1,
	'datatype' => 1,
	'datetimecreated' => 1,
	'dc' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodertable' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defineobject' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'depth' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicesettingdescription' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dictionary' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'dinf' => 1,
	'director' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'dngmakernotes' => 1,
	'dngprivatedata' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'ducky' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustremovaldata' => 1,
	'dvdid' => 1,
	'dynamicrangeoptimizer' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'edittagarray' => 1,
	'effectivebw' => 1,
	'effectivemaxaperture' => 1,
	'effectsvisible' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encryption' => 1,
	'endpoints' => 1,
	'eppim' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'events' => 1,
	'exif' => 1,
	'exif_profile' => 1,
	'exifinfo' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'exportimage' => 1,
	'exposureadjust' => 1,
	'exposureinfo' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedstreamprops' => 1,
	'extenderstatus' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extrasamples' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fileid' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileowner' => 1,
	'fileproperties' => 1,
	'filerul' => 1,
	'filesize' => 1,
	'filetype' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filtering' => 1,
	'finalframeblocks' => 1,
	'finalimageheight' => 1,
	'finalimagewidth' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'flags' => 1,
	'flashinfo' => 1,
	'flashon' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashversion' => 1,
	'focallength35efl' => 1,
	'focusinfo' => 1,
	'focuspos' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'fotostation' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framecount' => 1,
	'framepriority' => 1,
	'framerate' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'frametype' => 1,
	'free' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'fujifilm' => 1,
	'gain' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geotiffasciiparams' => 1,
	'geotiffdirectory' => 1,
	'geotiffdoubleparams' => 1,
	'geotiffversion' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'gpsdatetime' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'graphicconverter' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasaudio' => 1,
	'hasfiletransferstream' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hcusage' => 1,
	'hdrl' => 1,
	'header' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'heightresolution' => 1,
	'highlightendpoints' => 1,
	'huesetting' => 1,
	'hyperfocaldistance' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'id' => 1,
	'id3' => 1,
	'id3v1' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'identification' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'image' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedepth' => 1,
	'imagefields' => 1,
	'imageformat' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imageoffset' => 1,
	'imageprintstatus' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotationstatus' => 1,
	'imagesourcedata' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'index' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'infolist' => 1,
	'information' => 1,
	'initialkey' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputprofile' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'iptc' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isospeed' => 1,
	'isrc' => 1,
	'isrcnumber' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jumptoxpep' => 1,
	'kids' => 1,
	'kodak' => 1,
	'kodakbordersifd' => 1,
	'kodakeffectsifd' => 1,
	'konicaminolta' => 1,
	'languagelist' => 1,
	'lastmodifier' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'layersgroupinfo' => 1,
	'layerstateinfo' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensaperturerange' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdataunknown' => 1,
	'lensfocalrange' => 1,
	'lensspec' => 1,
	'lightness' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationtable' => 1,
	'lit' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics' => 1,
	'lyrics_synchronised' => 1,
	'macintoshprintinfo' => 1,
	'magnifyobject' => 1,
	'makeandmodel' => 1,
	'makernotebyteorder' => 1,
	'makernotelength' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'marker' => 1,
	'markerid' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxsubfilesize' => 1,
	'maxval' => 1,
	'mcdi' => 1,
	'mdat' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mdlabname' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementobserver' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaindex' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'mimetype' => 1,
	'minf' => 1,
	'minimumbitrate' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsa100' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'mngheader' => 1,
	'modeextension' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modenumber' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'montage' => 1,
	'mood' => 1,
	'mosaicpattern' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'movieheader' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'msstereo' => 1,
	'multiquality' => 1,
	'musiciancredits' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'namelength' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'nefcurve1' => 1,
	'nefcurve2' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'nexttrackid' => 1,
	'nikon' => 1,
	'nikoncapturedata' => 1,
	'nikoncaptureoffsets' => 1,
	'nikonpreview' => 1,
	'nikontags' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofinks' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'offsetorigin' => 1,
	'offsetxy' => 1,
	'olympus' => 1,
	'opacity' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'opticalzoom' => 1,
	'optimalbitrate' => 1,
	'opto-electricconvfactor' => 1,
	'orderingrestrictions' => 1,
	'organization' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmakernoteoffset' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'otherimage' => 1,
	'otherimagelength' => 1,
	'otherimagestart' => 1,
	'outputdataobjectlist' => 1,
	'outputprofile' => 1,
	'outputresponse' => 1,
	'packets' => 1,
	'padding' => 1,
	'page' => 1,
	'pagecount' => 1,
	'pages' => 1,
	'palette' => 1,
	'palettehistogram' => 1,
	'panasonic' => 1,
	'panasonicrawversion' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'partialpalette' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'patternangle' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'peakbitrate' => 1,
	'peakvalue' => 1,
	'pentax' => 1,
	'pentaxtags' => 1,
	'people' => 1,
	'performer' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'period' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'photoeffectsdata' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshopbgrthumbnail' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopsettings' => 1,
	'photoshopthumbnail' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'picture' => 1,
	'pictureinfo' => 1,
	'pieceinfo' => 1,
	'pixelaspectratio' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixelsperunitx' => 1,
	'pixelsperunity' => 1,
	'pixelunits' => 1,
	'places' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playselection' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'preferredrate' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewdate' => 1,
	'previewdescription' => 1,
	'previewduration' => 1,
	'previewifd_offset' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewmimetype' => 1,
	'previewpict' => 1,
	'previewtime' => 1,
	'previewtype' => 1,
	'previewversion' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printquality' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'private' => 1,
	'proccessinginfo' => 1,
	'producednotice' => 1,
	'product' => 1,
	'profile' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecopyright' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profilesequencedesc' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'ps2crdvmsize' => 1,
	'ps2renteringintent' => 1,
	'pstringcaption' => 1,
	'publisherurl' => 1,
	'quickmaskinfo' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rasterpadding' => 1,
	'rawdata' => 1,
	'rawdatarotation' => 1,
	'rawdevelopment' => 1,
	'rawimagemode' => 1,
	'rawinfo' => 1,
	'rawjpginfo' => 1,
	'readerrequirements' => 1,
	'reconstructiontype' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redeyedata' => 1,
	'redeyereduction' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'reductionmatrix1' => 1,
	'reductionmatrix2' => 1,
	'redx' => 1,
	'redy' => 1,
	'relatedimagefile' => 1,
	'renderingintent' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'requirements' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resultaspectratio' => 1,
	'revisionnumber' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohdatetime1' => 1,
	'ricohdatetime2' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'sampleformat' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'saturationsetting' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scale' => 1,
	'scalefactor35efl' => 1,
	'scandate' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerserialnumber' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'scriptcommand' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'sensorbottomborder' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'serviceorganizationname' => 1,
	'setsubtitle' => 1,
	'shadowendpoints' => 1,
	'shareduserrating' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'significantbits' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slices' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'softedit' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimagevolumename' => 1,
	'sourceurl' => 1,
	'spatialfrequencyresponse' => 1,
	'spatialorientation' => 1,
	'specialeffectsopticalfilter' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srf2_key' => 1,
	'srgbrendering' => 1,
	'stbl' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitrateprops' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamstarttime' => 1,
	'streamtype' => 1,
	'streamtypeinfo' => 1,
	'stridable' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'subifd' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimageheader' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsecdatetimeoriginal' => 1,
	'subtitle' => 1,
	'subtitledescription' => 1,
	'suggestedpalette' => 1,
	'summaryinfo' => 1,
	't4options' => 1,
	't6options' => 1,
	'taggingtime' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetprinter' => 1,
	'targetxy' => 1,
	'technician' => 1,
	'technology' => 1,
	'template' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textinfo' => 1,
	'textualdata' => 1,
	'things' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeoffset' => 1,
	'timescale' => 1,
	'titlelen' => 1,
	'titlesortorder' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totaledittime' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'track' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackcreatedate' => 1,
	'trackduration' => 1,
	'trackheader' => 1,
	'trackid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackmodifydate' => 1,
	'trackversion' => 1,
	'trackvolume' => 1,
	'transferrange' => 1,
	'transfomation' => 1,
	'transform' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapped' => 1,
	'typeoforiginal' => 1,
	'ucrbg' => 1,
	'uncompressed' => 1,
	'unicodealphanames' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknownblock1' => 1,
	'unknownblock2' => 1,
	'unknowntags' => 1,
	'unsharpdata' => 1,
	'unused' => 1,
	'url_list' => 1,
	'usedextensionnumbers' => 1,
	'useradjsba_rgbshifts' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'userselectgrouptitle' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'uuid-geojp2' => 1,
	'uuid-unknown' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validpixeldepth' => 1,
	'vbrpeak' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'version2' => 1,
	'versioninfo' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecname' => 1,
	'videoformat' => 1,
	'videoheight' => 1,
	'videomode' => 1,
	'videoquality' => 1,
	'videowidth' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'visibleoutputs' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vrdversion' => 1,
	'wangannotation' => 1,
	'warning' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'wb_bluelevel' => 1,
	'wb_grbglevels' => 1,
	'wb_greenlevel' => 1,
	'wb_rblevelsauto' => 1,
	'wb_rblevelscloudy' => 1,
	'wb_rblevelscoolwhitefluor' => 1,
	'wb_rblevelsdaylightfluor' => 1,
	'wb_rblevelsdaywhitefluor' => 1,
	'wb_rblevelseveningsunlight' => 1,
	'wb_rblevelsfineweather' => 1,
	'wb_rblevelsshade' => 1,
	'wb_rblevelstungsten' => 1,
	'wb_rblevelsused' => 1,
	'wb_rblevelswhitefluorescent' => 1,
	'wb_redlevel' => 1,
	'wbadjdata' => 1,
	'whitebalancecomp' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whitelevel' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'wide' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wordcount' => 1,
	'workflowurl' => 1,
	'workingpath' => 1,
	'writer' => 1,
	'xclippathunits' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xml' => 1,
	'xmldata' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'ytarget' => 1,
	'zoom' => 1,
	'zoompos' => 1,
);

#++++ End automatically generated code ++++

# insert any user-defined tags into our tag lookup
if (defined %Image::ExifTool::UserDefined) {
    my ($table, %tableNum, $tagID);
    my $tnum = 0; # make hash lookup to get table numbers
    foreach $table (@tableList) {
        $tableNum{$table} = $tnum++;
    }
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        $tnum = $tableNum{$table};
        unless ($tnum) {
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $userTable = $Image::ExifTool::UserDefined{$table};
        foreach $tagID (Image::ExifTool::TagTableKeys($userTable)) {
            my $newInfo = $$userTable{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = ucfirst($tagID);
            } else {
                $newInfo = $$userTable{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc($$newInfo{Name});
            # add to lookup even though we don't know it is writable
            # (to save speed by not having to load the module)
            my $lookup = $tagLookup{$lcTag};
            $lookup or $lookup = $tagLookup{$lcTag} = { };
            if ($$lookup{$tnum}) {
                my $le = $$lookup{$tnum};
                my @ids = (ref $le eq 'ARRAY') ? @{$le} : ( $le );
                # only add new tag ID if it didn't already exist
                next if grep /^$tagID$/, @ids;
                push @ids, $tagID;
                $$lookup{$tnum} = \@ids;
            } else {
                $$lookup{$tnum} = $tagID;
            }
            # add any new subdirectory tables
            next unless $$newInfo{SubDirectory};
            my $subTable = $newInfo->{SubDirectory}->{TagTable};
            next unless $subTable and not defined $tableNum{$subTable};
            next if $Image::ExifTool::UserDefined{$subTable};
            no strict 'refs';
            next unless defined %$subTable;
            $Image::ExifTool::UserDefined{$subTable} = \%$subTable;
            push @userTables, $subTable;
            # save parent table name so we can load it when necessary
            $$subTable{PARENT} = $table;
        }
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $tagID = $$lookup{$tableNum};
            my @tagIDs;
            if (ref $tagID eq 'ARRAY') {
                @tagIDs = @$tagID;
            } else {
                push @tagIDs, $tagID;
            }
            foreach $tagID (@tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        &$writeProc();
                        @infoList = GetTagInfoList($table,$tagID);
                    }
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2006, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
