#!perl -w
use strict;
use blib;
use lib '../t';
use Imager;
use Test::More tests => 3;

BEGIN { use_ok('Imager::Filter::Flines') }

my $im = Imager->new(xsize=>150, ysize=>150);

$im->box(filled=>1, xmin => 70, ymin=>25, xmax =>130, ymax => 125, 
         color=>'00FF00');
$im->box(filled=>1, xmin=>20, ymin=>25, xmax=>80, ymax=>125,
         color => '0000FF');
$im->arc(x =>75, y=>75, r=>30, color => 'FF0000');
$im->filter(type=>"conv", coef => [0.1, 0.2, 0.4, 0.2, 0.1]);

ok($im->filter(type=>'flines'),
   "try filter")
  or print "# ", $im->errstr, "\n";
ok($im->write(file => '../testout/t00flines.ppm'),
   "save result");
