/*
** algo.hh
** Login : <dax@happycoders.org>
** Started on  Thu Jul 17 02:56:28 2003 David Rousselie
** $Id: algo.hh,v 1.6 2003/07/29 19:38:28 speedblue Exp $
** 
** Copyright (C) 2003 David Rousselie
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU Lesser General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU Lesser General Public License for more details.
** 
** You should have received a copy of the GNU Lesser General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef   	ALGO_HH_
# define   	ALGO_HH_

# include "Matrix.hh"

template <class TypeName>
class PCAAlgo
{
public:
  PCAAlgo(Matrix<TypeName>& x, double epsilon = 0.01) :
    _x(x.transpose()),
    _epsilon(epsilon)
  {
  }
  
  ~PCAAlgo() {}
  
  // GHA iterative method
  float gha(Matrix<float>& W, int i);
  // GHA with matrix computations
  Matrix<float> gha2();
  // ALA
  float ala(Matrix<float>& W, int i);

  // random init new matrix
  Matrix<TypeName> random_init(unsigned int nb_lines, unsigned int nb_cols);
  Matrix<TypeName> random_init2(unsigned int nb_lines, unsigned int nb_cols);

private:
  // make matrix lower triangular
  Matrix<TypeName> lt(Matrix<TypeName> m);
  Matrix<TypeName> _x;
  double _epsilon;
};

# include "algo.hxx"

#endif	    /* !ALGO_HH_ */
