# Web::Persistent::Lock::Null
# Copyright(c) 2002 MoonWolf <moonwolf@moonwolf.com>
module Web
  class Persistent
    module Lock
      class Null
        def initialize(persistent_id, options={})
          @persistent_id = persistent_id
        end

        def lock
          @locked =true
          if block_given?
            yield
            unlock
          end
        end

        def unlock
          @locked = false
        end

        def delete
          nil
        end
      end
    end # Lock
  end # Persistent
end # Web
