/*
  File autogenerated by gengetopt version 2.10
  generated with the following command:
  gengetopt --unamed-opts 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "getopt.h"

#include "cmdline.h"

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n"
  "Purpose:\n"
  "  ofxdump prints to stdout, in human readable form, everything the library \n"
  "   understands about a particular file or response, and sends errors to \n"
  "   stderr.  To know exactly what the library understands about of a particular\n"
  "   ofx response file, just call ofxdump on that file.\n"
  "\n"
  "Usage: %s [OPTIONS]... [FILES]...\n", CMDLINE_PARSER_PACKAGE);
  printf("   -h         --help                  Print help and exit\n");
  printf("   -V         --version               Print version and exit\n");
  printf("   -fSTRING   --import-format=STRING  Force the file format of the file(s) specified (default='AUTODETECT')\n");
  printf("              --list-import-formats   List available import file formats 'import-format' command\n");
  printf("              --msg_parser            Output file parsing messages (default=off)\n");
  printf("              --msg_debug             Output messages meant for debuging (default=off)\n");
  printf("              --msg_warning           Output warning messages about abnormal conditions and unknown constructs (default=on)\n");
  printf("              --msg_error             Output error messages (default=on)\n");
  printf("              --msg_info              Output informational messages about the progress of the library (default=on)\n");
  printf("              --msg_status            Output status messages (default=on)\n");
}


static char *gengetopt_strdup (const char *s);

/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  int c;	/* Character of the parsed option.  */
  int missing_required_options = 0;

  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->import_format_given = 0 ;
  args_info->list_import_formats_given = 0 ;
  args_info->msg_parser_given = 0 ;
  args_info->msg_debug_given = 0 ;
  args_info->msg_warning_given = 0 ;
  args_info->msg_error_given = 0 ;
  args_info->msg_info_given = 0 ;
  args_info->msg_status_given = 0 ;
#define clear_args() { \
  args_info->import_format_arg = gengetopt_strdup("AUTODETECT") ;\
  args_info->msg_parser_flag = 0;\
  args_info->msg_debug_flag = 0;\
  args_info->msg_warning_flag = 1;\
  args_info->msg_error_flag = 1;\
  args_info->msg_info_flag = 1;\
  args_info->msg_status_flag = 1;\
}

  clear_args();

  args_info->inputs = NULL;
  args_info->inputs_num = 0;

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "import-format",	1, NULL, 'f' },
        { "list-import-formats",	0, NULL, 0 },
        { "msg_parser",	0, NULL, 0 },
        { "msg_debug",	0, NULL, 0 },
        { "msg_warning",	0, NULL, 0 },
        { "msg_error",	0, NULL, 0 },
        { "msg_info",	0, NULL, 0 },
        { "msg_status",	0, NULL, 0 },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVf:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          clear_args ();
          cmdline_parser_print_help ();
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          clear_args ();
          cmdline_parser_print_version ();
          exit (EXIT_SUCCESS);

        case 'f':	/* Force the file format of the file(s) specified.  */
          if (args_info->import_format_given)
            {
              fprintf (stderr, "%s: `--import-format' (`-f') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->import_format_given = 1;
          args_info->import_format_arg = gengetopt_strdup (optarg);
          break;


        case 0:	/* Long option with no short option */
          /* List available import file formats 'import-format' command.  */
          if (strcmp (long_options[option_index].name, "list-import-formats") == 0)
          {
            if (args_info->list_import_formats_given)
              {
                fprintf (stderr, "%s: `--list-import-formats' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->list_import_formats_given = 1;
            break;
          }
          
          /* Output file parsing messages.  */
          else if (strcmp (long_options[option_index].name, "msg_parser") == 0)
          {
            if (args_info->msg_parser_given)
              {
                fprintf (stderr, "%s: `--msg_parser' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->msg_parser_given = 1;
            args_info->msg_parser_flag = !(args_info->msg_parser_flag);
            break;
          }
          
          /* Output messages meant for debuging.  */
          else if (strcmp (long_options[option_index].name, "msg_debug") == 0)
          {
            if (args_info->msg_debug_given)
              {
                fprintf (stderr, "%s: `--msg_debug' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->msg_debug_given = 1;
            args_info->msg_debug_flag = !(args_info->msg_debug_flag);
            break;
          }
          
          /* Output warning messages about abnormal conditions and unknown constructs.  */
          else if (strcmp (long_options[option_index].name, "msg_warning") == 0)
          {
            if (args_info->msg_warning_given)
              {
                fprintf (stderr, "%s: `--msg_warning' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->msg_warning_given = 1;
            args_info->msg_warning_flag = !(args_info->msg_warning_flag);
            break;
          }
          
          /* Output error messages.  */
          else if (strcmp (long_options[option_index].name, "msg_error") == 0)
          {
            if (args_info->msg_error_given)
              {
                fprintf (stderr, "%s: `--msg_error' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->msg_error_given = 1;
            args_info->msg_error_flag = !(args_info->msg_error_flag);
            break;
          }
          
          /* Output informational messages about the progress of the library.  */
          else if (strcmp (long_options[option_index].name, "msg_info") == 0)
          {
            if (args_info->msg_info_given)
              {
                fprintf (stderr, "%s: `--msg_info' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->msg_info_given = 1;
            args_info->msg_info_flag = !(args_info->msg_info_flag);
            break;
          }
          
          /* Output status messages.  */
          else if (strcmp (long_options[option_index].name, "msg_status") == 0)
          {
            if (args_info->msg_status_given)
              {
                fprintf (stderr, "%s: `--msg_status' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->msg_status_given = 1;
            args_info->msg_status_flag = !(args_info->msg_status_flag);
            break;
          }
          

        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          exit (EXIT_FAILURE);

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c\n", CMDLINE_PARSER_PACKAGE, c);
          abort ();
        } /* switch */
    } /* while */


  if ( missing_required_options )
    exit (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;
  
      args_info->inputs_num = argc - optind ;
      args_info->inputs = 
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind++]) ; 
    }
  
  return 0;
}
