
MODULE StringTest;

IMPORT D   := VO:Base:Display,

       V   := VO:Model:Value,

              VO:Prefs:All,  (* Include preferences for all objects *)

       S   := VO:String,
       P   := VO:Panel,
       G   := VO:Object,
       W   := VO:Window,

              Err,
       L   := Locales;

VAR
  w        : W.Window;
  string,
  c,
  r        : S.String;
  sm       : V.StringModel;
  msg2Exit : D.Msg2Exit;
  panel    : P.Panel;

  old      : ARRAY 32 OF CHAR;


BEGIN
  D.display.SetAppName("StringTest");
  IF ~D.display.Open() THEN
    Err.String("Cannot open to display!"); Err.Ln;
    HALT(1);
  END;

  L.Set(L.ALL,"",old);  (* use env variables *)

  NEW(w);
  w.Init;

  NEW(panel);
  panel.Init();

  NEW(sm);
  sm.Init();
  sm.SetString("It's cool, hu hu huh!");

  NEW(string);
  string.Init();
  string.SetFlags({G.horizontalFlex});
  string.SetStringWidth(120, 80);
  string.SetStringAlignment(S.leftAligned);
  string.SetModel(sm);
  w.AddFocusObject(string);
  panel.Add(string);

  NEW(c);
  c.Init();
  c.SetFlags({G.horizontalFlex});
  c.SetStringWidth(120, 80);
  c.SetStringAlignment(S.centerAligned);
  c.SetModel(sm);
  c.SetMode(S.password);
  w.AddFocusObject(c);
  panel.Add(c);

  NEW(r);
  r.Init();
  r.SetFlags({G.horizontalFlex});
  r.SetStringWidth(120, 80);
  r.SetStringAlignment(S.rightAligned);
  r.SetModel(sm);
  w.AddFocusObject(r);
  panel.Add(r);

  w.SetTop(panel);
  w.SetTitle("StringTest");
  NEW(msg2Exit);
  msg2Exit.destination:=D.display;
  w.AddHandler(msg2Exit,W.closeMsg);
  w.Open;

  D.display.EventLoop;

  D.display.Close;
END StringTest.