(**
    Demo for VisualOberon. Demonstrates the image object.
**)

MODULE VisualShow;

(*
    Demo for VisualOberon. Demonstrates the image object.
    Copyright (C) 1998  Tim Teulings (rael@edge.ping.de)

    This file is part of VisualOberon.

    VisualOberon is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    VisualOberon is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with VisualOberon. If not, write to the Free Software
    Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT D   := VO:Base:Display,

              VO:Prefs:All,  (* Include preferences for all objects *)

       G   := VO:Object,
       I   := VO:Image,
       P   := VO:Panel,
       T   := VO:Text,
       W   := VO:Window,

              Err,
       A   := ProgramArgs,
       TR  := TextRider;


VAR
  w        : W.Window;

  panel    : P.Panel;
  image    : I.Image;
  text     : T.Text;

  msg2Exit : D.Msg2Exit;

  reader   : TR.Reader;
  file     : ARRAY 256 OF CHAR;

BEGIN
  D.display.SetAppName("VisualShow");
  IF ~D.display.Open() THEN
    Err.String("Cannot open to display!"); Err.Ln;
    HALT(1);
  END;

  reader:=TR.ConnectReader(A.args);
  IF reader#NIL THEN
    reader.ReadLine(file);
    IF A.args.ArgNumber()=1 THEN
      reader.ReadLine(file);
    ELSE
      Err.String("VisualShow <image>"); Err.Ln;
      HALT(1);
    END;
  ELSE
    HALT(1);
  END;

  NEW(panel);
  panel.Init;
  panel.Set(P.vertical);
  panel.SetFlags({G.horizontalFlex,G.verticalFlex});

    NEW(image);
    image.Init;
    image.SetFilename(file);
  panel.Add(image);

    NEW(text);
    text.Init;
    text.SetFlags({G.horizontalFlex});
    text.SetText(file);
  panel.Add(text);

  NEW(w);
  w.Init;
  w.SetTop(panel);
  w.SetTitle("VisualShow");
  NEW(msg2Exit);
  msg2Exit.destination:=D.display;
  w.AddHandler(msg2Exit,W.closeMsg);
  w.Open;

  D.display.EventLoop;

  D.display.Close;
END VisualShow.