MODULE VOListPrefs;

(*
    Copyright (C) 1999  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT B   := VOButton,
       F   := VO:Base:Frame,
       FG  := VOFrameGroup,
       FSD := VO:Dlg:FrmSel,
       G   := VOGUIObject,
       GP  := VOGUIObjectPrefs,
       L   := VOLabel,
       LI  := VOList,
       PG  := VOPrefsGUI,
       PP  := VOPrefsParser,
       T   := VOText,
       TA  := VOTab;

TYPE
  Item*     = POINTER TO ItemDesc;
  ItemDesc* = RECORD (GP.PrefsItemDesc)
                rFrmSelDlg : FSD.FrmSelDlg;
                wFrmSelDlg : FSD.FrmSelDlg;
                rFrame     : FG.FrameGroup;
                wFrame     : FG.FrameGroup;
              END;

VAR
  prefs : Item;

  PROCEDURE (d : Item) Init*;

  BEGIN
    d.Init^;
    d.name:="List";

    d.SetPrefs(LI.prefs);

    NEW(d.rFrmSelDlg);
    d.rFrmSelDlg.Init;

    NEW(d.wFrmSelDlg);
    d.wFrmSelDlg.Init;
  END Init;

  PROCEDURE (d : Item) GetObject*():G.Object;

  VAR
    button : B.Button;
    frame  : FG.FrameGroup;
    label  : L.Label;
    object : G.Object;
    tab    : TA.Tab;

  BEGIN
    d.rFrmSelDlg.SetDisplay(d.display);
    d.wFrmSelDlg.SetDisplay(d.display);

    object:=d.GetObject^();
    tab:=object(TA.Tab);

    frame:=FG.CreateFrameGroup();
    frame.SetTextLabel("Frames");

      label:=L.CreateLabel();

        button:=PG.CreateFrameButton(d.rFrame,d.display,d.rFrmSelDlg,
                                     d.window.keyHandler,"Select readonly frame");
      label.AddTextLabel("Readonly",button);

      button:=PG.CreateFrameButton(d.wFrame,d.display,d.wFrmSelDlg,
                                   d.window.keyHandler,"Select read/write frame");
      label.AddTextLabel("Read/write",button);
    frame.Add(label);

    tab.AddTab(T.MakeCenterText(d.name),frame);

    RETURN tab;
  END GetObject;

  PROCEDURE (d : Item) Refresh*;

  BEGIN
    d.Refresh^;

    d.rFrame.SetFrame(LI.prefs.rFrame);
    d.wFrame.SetFrame(LI.prefs.wFrame);
    d.rFrmSelDlg.SetFrame(LI.prefs.rFrame);
    d.wFrmSelDlg.SetFrame(LI.prefs.wFrame);
  END Refresh;

  PROCEDURE (p : Item) Apply*;

  BEGIN
    p.Apply^;

    LI.prefs.rFrame:=p.rFrame.GetFrame();
    LI.prefs.wFrame:=p.wFrame.GetFrame();
  END Apply;

  PROCEDURE (p : Item) LoadPrefs*(top : PP.Item);

  BEGIN
    p.LoadPrefs^(top);

    F.LoadFrame("readonlyFrame",top,LI.prefs.rFrame);
  END LoadPrefs;

  PROCEDURE (p : Item) SavePrefs*(block : PP.BlockItem);

  BEGIN
    p.SavePrefs^(block);

    block.AddItemValue("readonlyFrame",F.internalFrames[LI.prefs.rFrame]);
  END SavePrefs;

BEGIN
  NEW(prefs);
  prefs.Init;
END VOListPrefs.