/*
 * Copyright (C) 2001-2002 Hewlett-Packard Co
 * Contributed by Stephane Eranian <eranian@hpl.hp.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy 
 * of this software and associated documentation files (the "Software"), to deal 
 * in the Software without restriction, including without limitation the rights 
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies 
 * of the Software, and to permit persons to whom the Software is furnished to do so, 
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all 
 * copies or substantial portions of the Software.  
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT 
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF 
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * This file is part of libpfm, a performance monitoring support library for
 * applications on Linux/ia64.
 */

/*
 * This file is generated automatically
 * !! DO NOT CHANGE !!
 */

/*
 * Events table for the Itanium PMU family
 */
static pme_ita_entry_t itanium_pe []={
#define PME_ITA_ALAT_INST_CHKA_LDC_ALL 0
{ "ALAT_INST_CHKA_LDC_ALL", {0x30036} , 0xf0, 2, {0xffff0003}, NULL},
#define PME_ITA_ALAT_INST_CHKA_LDC_FP 1
{ "ALAT_INST_CHKA_LDC_FP", {0x10036} , 0xf0, 2, {0xffff0003}, NULL},
#define PME_ITA_ALAT_INST_CHKA_LDC_INT 2
{ "ALAT_INST_CHKA_LDC_INT", {0x20036} , 0xf0, 2, {0xffff0003}, NULL},
#define PME_ITA_ALAT_INST_FAILED_CHKA_LDC_ALL 3
{ "ALAT_INST_FAILED_CHKA_LDC_ALL", {0x30037} , 0xf0, 2, {0xffff0003}, NULL},
#define PME_ITA_ALAT_INST_FAILED_CHKA_LDC_FP 4
{ "ALAT_INST_FAILED_CHKA_LDC_FP", {0x10037} , 0xf0, 2, {0xffff0003}, NULL},
#define PME_ITA_ALAT_INST_FAILED_CHKA_LDC_INT 5
{ "ALAT_INST_FAILED_CHKA_LDC_INT", {0x20037} , 0xf0, 2, {0xffff0003}, NULL},
#define PME_ITA_ALAT_REPLACEMENT_ALL 6
{ "ALAT_REPLACEMENT_ALL", {0x30038} , 0xf0, 2, {0xffff0007}, NULL},
#define PME_ITA_ALAT_REPLACEMENT_FP 7
{ "ALAT_REPLACEMENT_FP", {0x10038} , 0xf0, 2, {0xffff0007}, NULL},
#define PME_ITA_ALAT_REPLACEMENT_INT 8
{ "ALAT_REPLACEMENT_INT", {0x20038} , 0xf0, 2, {0xffff0007}, NULL},
#define PME_ITA_ALL_STOPS_DISPERSED 9
{ "ALL_STOPS_DISPERSED", {0x2f} , 0xf0, 1, {0xffff0001}, NULL},
#define PME_ITA_BRANCH_EVENT 10
{ "BRANCH_EVENT", {0x811} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_MULTIWAY_ALL_PATHS_ALL_PREDICTIONS 11
{ "BRANCH_MULTIWAY_ALL_PATHS_ALL_PREDICTIONS", {0xe} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_MULTIWAY_ALL_PATHS_CORRECT_PREDICTIONS 12
{ "BRANCH_MULTIWAY_ALL_PATHS_CORRECT_PREDICTIONS", {0x1000e} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_MULTIWAY_ALL_PATHS_WRONG_PATH 13
{ "BRANCH_MULTIWAY_ALL_PATHS_WRONG_PATH", {0x2000e} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_MULTIWAY_ALL_PATHS_WRONG_TARGET 14
{ "BRANCH_MULTIWAY_ALL_PATHS_WRONG_TARGET", {0x3000e} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_MULTIWAY_NOT_TAKEN_ALL_PREDICTIONS 15
{ "BRANCH_MULTIWAY_NOT_TAKEN_ALL_PREDICTIONS", {0x8000e} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_MULTIWAY_NOT_TAKEN_CORRECT_PREDICTIONS 16
{ "BRANCH_MULTIWAY_NOT_TAKEN_CORRECT_PREDICTIONS", {0x9000e} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_MULTIWAY_NOT_TAKEN_WRONG_PATH 17
{ "BRANCH_MULTIWAY_NOT_TAKEN_WRONG_PATH", {0xa000e} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_MULTIWAY_NOT_TAKEN_WRONG_TARGET 18
{ "BRANCH_MULTIWAY_NOT_TAKEN_WRONG_TARGET", {0xb000e} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_MULTIWAY_TAKEN_ALL_PREDICTIONS 19
{ "BRANCH_MULTIWAY_TAKEN_ALL_PREDICTIONS", {0xc000e} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_MULTIWAY_TAKEN_CORRECT_PREDICTIONS 20
{ "BRANCH_MULTIWAY_TAKEN_CORRECT_PREDICTIONS", {0xd000e} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_MULTIWAY_TAKEN_WRONG_PATH 21
{ "BRANCH_MULTIWAY_TAKEN_WRONG_PATH", {0xe000e} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_MULTIWAY_TAKEN_WRONG_TARGET 22
{ "BRANCH_MULTIWAY_TAKEN_WRONG_TARGET", {0xf000e} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_NOT_TAKEN 23
{ "BRANCH_NOT_TAKEN", {0x8000d} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_PATH_1ST_STAGE_NT_OUTCOMES_CORRECTLY_PREDICTED 24
{ "BRANCH_PATH_1ST_STAGE_NT_OUTCOMES_CORRECTLY_PREDICTED", {0x6000f} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_PATH_1ST_STAGE_NT_OUTCOMES_INCORRECTLY_PREDICTED 25
{ "BRANCH_PATH_1ST_STAGE_NT_OUTCOMES_INCORRECTLY_PREDICTED", {0x4000f} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_PATH_1ST_STAGE_TK_OUTCOMES_CORRECTLY_PREDICTED 26
{ "BRANCH_PATH_1ST_STAGE_TK_OUTCOMES_CORRECTLY_PREDICTED", {0x7000f} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_PATH_1ST_STAGE_TK_OUTCOMES_INCORRECTLY_PREDICTED 27
{ "BRANCH_PATH_1ST_STAGE_TK_OUTCOMES_INCORRECTLY_PREDICTED", {0x5000f} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_PATH_2ND_STAGE_NT_OUTCOMES_CORRECTLY_PREDICTED 28
{ "BRANCH_PATH_2ND_STAGE_NT_OUTCOMES_CORRECTLY_PREDICTED", {0xa000f} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_PATH_2ND_STAGE_NT_OUTCOMES_INCORRECTLY_PREDICTED 29
{ "BRANCH_PATH_2ND_STAGE_NT_OUTCOMES_INCORRECTLY_PREDICTED", {0x8000f} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_PATH_2ND_STAGE_TK_OUTCOMES_CORRECTLY_PREDICTED 30
{ "BRANCH_PATH_2ND_STAGE_TK_OUTCOMES_CORRECTLY_PREDICTED", {0xb000f} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_PATH_2ND_STAGE_TK_OUTCOMES_INCORRECTLY_PREDICTED 31
{ "BRANCH_PATH_2ND_STAGE_TK_OUTCOMES_INCORRECTLY_PREDICTED", {0x9000f} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_PATH_3RD_STAGE_NT_OUTCOMES_CORRECTLY_PREDICTED 32
{ "BRANCH_PATH_3RD_STAGE_NT_OUTCOMES_CORRECTLY_PREDICTED", {0xe000f} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_PATH_3RD_STAGE_NT_OUTCOMES_INCORRECTLY_PREDICTED 33
{ "BRANCH_PATH_3RD_STAGE_NT_OUTCOMES_INCORRECTLY_PREDICTED", {0xc000f} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_PATH_3RD_STAGE_TK_OUTCOMES_CORRECTLY_PREDICTED 34
{ "BRANCH_PATH_3RD_STAGE_TK_OUTCOMES_CORRECTLY_PREDICTED", {0xf000f} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_PATH_3RD_STAGE_TK_OUTCOMES_INCORRECTLY_PREDICTED 35
{ "BRANCH_PATH_3RD_STAGE_TK_OUTCOMES_INCORRECTLY_PREDICTED", {0xd000f} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_PATH_ALL_NT_OUTCOMES_CORRECTLY_PREDICTED 36
{ "BRANCH_PATH_ALL_NT_OUTCOMES_CORRECTLY_PREDICTED", {0x2000f} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_PATH_ALL_NT_OUTCOMES_INCORRECTLY_PREDICTED 37
{ "BRANCH_PATH_ALL_NT_OUTCOMES_INCORRECTLY_PREDICTED", {0xf} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_PATH_ALL_TK_OUTCOMES_CORRECTLY_PREDICTED 38
{ "BRANCH_PATH_ALL_TK_OUTCOMES_CORRECTLY_PREDICTED", {0x3000f} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_PATH_ALL_TK_OUTCOMES_INCORRECTLY_PREDICTED 39
{ "BRANCH_PATH_ALL_TK_OUTCOMES_INCORRECTLY_PREDICTED", {0x1000f} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_PREDICTOR_1ST_STAGE_ALL_PREDICTIONS 40
{ "BRANCH_PREDICTOR_1ST_STAGE_ALL_PREDICTIONS", {0x40010} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_PREDICTOR_1ST_STAGE_CORRECT_PREDICTIONS 41
{ "BRANCH_PREDICTOR_1ST_STAGE_CORRECT_PREDICTIONS", {0x50010} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_PREDICTOR_1ST_STAGE_WRONG_PATH 42
{ "BRANCH_PREDICTOR_1ST_STAGE_WRONG_PATH", {0x60010} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_PREDICTOR_1ST_STAGE_WRONG_TARGET 43
{ "BRANCH_PREDICTOR_1ST_STAGE_WRONG_TARGET", {0x70010} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_PREDICTOR_2ND_STAGE_ALL_PREDICTIONS 44
{ "BRANCH_PREDICTOR_2ND_STAGE_ALL_PREDICTIONS", {0x80010} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_PREDICTOR_2ND_STAGE_CORRECT_PREDICTIONS 45
{ "BRANCH_PREDICTOR_2ND_STAGE_CORRECT_PREDICTIONS", {0x90010} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_PREDICTOR_2ND_STAGE_WRONG_PATH 46
{ "BRANCH_PREDICTOR_2ND_STAGE_WRONG_PATH", {0xa0010} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_PREDICTOR_2ND_STAGE_WRONG_TARGET 47
{ "BRANCH_PREDICTOR_2ND_STAGE_WRONG_TARGET", {0xb0010} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_PREDICTOR_3RD_STAGE_ALL_PREDICTIONS 48
{ "BRANCH_PREDICTOR_3RD_STAGE_ALL_PREDICTIONS", {0xc0010} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_PREDICTOR_3RD_STAGE_CORRECT_PREDICTIONS 49
{ "BRANCH_PREDICTOR_3RD_STAGE_CORRECT_PREDICTIONS", {0xd0010} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_PREDICTOR_3RD_STAGE_WRONG_PATH 50
{ "BRANCH_PREDICTOR_3RD_STAGE_WRONG_PATH", {0xe0010} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_PREDICTOR_3RD_STAGE_WRONG_TARGET 51
{ "BRANCH_PREDICTOR_3RD_STAGE_WRONG_TARGET", {0xf0010} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_PREDICTOR_ALL_ALL_PREDICTIONS 52
{ "BRANCH_PREDICTOR_ALL_ALL_PREDICTIONS", {0x10} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_PREDICTOR_ALL_CORRECT_PREDICTIONS 53
{ "BRANCH_PREDICTOR_ALL_CORRECT_PREDICTIONS", {0x10010} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_PREDICTOR_ALL_WRONG_PATH 54
{ "BRANCH_PREDICTOR_ALL_WRONG_PATH", {0x20010} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_PREDICTOR_ALL_WRONG_TARGET 55
{ "BRANCH_PREDICTOR_ALL_WRONG_TARGET", {0x30010} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_TAKEN_SLOT_0 56
{ "BRANCH_TAKEN_SLOT_0", {0x1000d} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_TAKEN_SLOT_1 57
{ "BRANCH_TAKEN_SLOT_1", {0x2000d} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BRANCH_TAKEN_SLOT_2 58
{ "BRANCH_TAKEN_SLOT_2", {0x4000d} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_BUS_ALL_ANY 59
{ "BUS_ALL_ANY", {0x10047} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_ALL_IO 60
{ "BUS_ALL_IO", {0x40047} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_ALL_SELF 61
{ "BUS_ALL_SELF", {0x20047} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_BRQ_LIVE_REQ_HI 62
{ "BUS_BRQ_LIVE_REQ_HI", {0x5c} , 0xf0, 2, {0xffff0000}, NULL},
#define PME_ITA_BUS_BRQ_LIVE_REQ_LO 63
{ "BUS_BRQ_LIVE_REQ_LO", {0x5b} , 0xf0, 2, {0xffff0000}, NULL},
#define PME_ITA_BUS_BRQ_REQ_INSERTED 64
{ "BUS_BRQ_REQ_INSERTED", {0x5d} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_BURST_ANY 65
{ "BUS_BURST_ANY", {0x10049} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_BURST_IO 66
{ "BUS_BURST_IO", {0x40049} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_BURST_SELF 67
{ "BUS_BURST_SELF", {0x20049} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_HITM 68
{ "BUS_HITM", {0x44} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_IO_ANY 69
{ "BUS_IO_ANY", {0x10050} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_IOQ_LIVE_REQ_HI 70
{ "BUS_IOQ_LIVE_REQ_HI", {0x58} , 0xf0, 3, {0xffff0000}, NULL},
#define PME_ITA_BUS_IOQ_LIVE_REQ_LO 71
{ "BUS_IOQ_LIVE_REQ_LO", {0x57} , 0xf0, 3, {0xffff0000}, NULL},
#define PME_ITA_BUS_IO_SELF 72
{ "BUS_IO_SELF", {0x20050} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_LOCK_ANY 73
{ "BUS_LOCK_ANY", {0x10053} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_LOCK_CYCLES_ANY 74
{ "BUS_LOCK_CYCLES_ANY", {0x10054} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_LOCK_CYCLES_SELF 75
{ "BUS_LOCK_CYCLES_SELF", {0x20054} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_LOCK_SELF 76
{ "BUS_LOCK_SELF", {0x20053} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_MEMORY_ANY 77
{ "BUS_MEMORY_ANY", {0x1004a} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_MEMORY_IO 78
{ "BUS_MEMORY_IO", {0x4004a} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_MEMORY_SELF 79
{ "BUS_MEMORY_SELF", {0x2004a} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_PARTIAL_ANY 80
{ "BUS_PARTIAL_ANY", {0x10048} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_PARTIAL_IO 81
{ "BUS_PARTIAL_IO", {0x40048} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_PARTIAL_SELF 82
{ "BUS_PARTIAL_SELF", {0x20048} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_RD_ALL_ANY 83
{ "BUS_RD_ALL_ANY", {0x1004b} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_RD_ALL_IO 84
{ "BUS_RD_ALL_IO", {0x4004b} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_RD_ALL_SELF 85
{ "BUS_RD_ALL_SELF", {0x2004b} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_RD_DATA_ANY 86
{ "BUS_RD_DATA_ANY", {0x1004c} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_RD_DATA_IO 87
{ "BUS_RD_DATA_IO", {0x4004c} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_RD_DATA_SELF 88
{ "BUS_RD_DATA_SELF", {0x2004c} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_RD_HIT 89
{ "BUS_RD_HIT", {0x40} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_RD_HITM 90
{ "BUS_RD_HITM", {0x41} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_RD_INVAL_ANY 91
{ "BUS_RD_INVAL_ANY", {0x1004e} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_RD_INVAL_BST_ANY 92
{ "BUS_RD_INVAL_BST_ANY", {0x1004f} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_RD_INVAL_BST_HITM 93
{ "BUS_RD_INVAL_BST_HITM", {0x43} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_RD_INVAL_BST_IO 94
{ "BUS_RD_INVAL_BST_IO", {0x4004f} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_RD_INVAL_BST_SELF 95
{ "BUS_RD_INVAL_BST_SELF", {0x2004f} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_RD_INVAL_HITM 96
{ "BUS_RD_INVAL_HITM", {0x42} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_RD_INVAL_IO 97
{ "BUS_RD_INVAL_IO", {0x4004e} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_RD_INVAL_SELF 98
{ "BUS_RD_INVAL_SELF", {0x2004e} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_RD_IO_ANY 99
{ "BUS_RD_IO_ANY", {0x10051} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_RD_IO_SELF 100
{ "BUS_RD_IO_SELF", {0x20051} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_RD_PRTL_ANY 101
{ "BUS_RD_PRTL_ANY", {0x1004d} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_RD_PRTL_IO 102
{ "BUS_RD_PRTL_IO", {0x4004d} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_RD_PRTL_SELF 103
{ "BUS_RD_PRTL_SELF", {0x2004d} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_SNOOPQ_REQ 104
{ "BUS_SNOOPQ_REQ", {0x56} , 0x30, 3, {0xffff0000}, NULL},
#define PME_ITA_BUS_SNOOPS_ANY 105
{ "BUS_SNOOPS_ANY", {0x10046} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_SNOOPS_HITM_ANY 106
{ "BUS_SNOOPS_HITM_ANY", {0x10045} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_SNOOP_STALL_CYCLES_ANY 107
{ "BUS_SNOOP_STALL_CYCLES_ANY", {0x10055} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_SNOOP_STALL_CYCLES_SELF 108
{ "BUS_SNOOP_STALL_CYCLES_SELF", {0x20055} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_WR_WB_ANY 109
{ "BUS_WR_WB_ANY", {0x10052} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_WR_WB_IO 110
{ "BUS_WR_WB_IO", {0x40052} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_BUS_WR_WB_SELF 111
{ "BUS_WR_WB_SELF", {0x20052} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_CPU_CPL_CHANGES 112
{ "CPU_CPL_CHANGES", {0x34} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_CPU_CYCLES 113
{ "CPU_CYCLES", {0x12} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_DATA_ACCESS_CYCLE 114
{ "DATA_ACCESS_CYCLE", {0x3} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_DATA_EAR_CACHE_LAT1024 115
{ "DATA_EAR_CACHE_LAT1024", {0x90367} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_DATA_EAR_CACHE_LAT128 116
{ "DATA_EAR_CACHE_LAT128", {0x50367} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_DATA_EAR_CACHE_LAT16 117
{ "DATA_EAR_CACHE_LAT16", {0x20367} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_DATA_EAR_CACHE_LAT2048 118
{ "DATA_EAR_CACHE_LAT2048", {0xa0367} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_DATA_EAR_CACHE_LAT256 119
{ "DATA_EAR_CACHE_LAT256", {0x60367} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_DATA_EAR_CACHE_LAT32 120
{ "DATA_EAR_CACHE_LAT32", {0x30367} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_DATA_EAR_CACHE_LAT4 121
{ "DATA_EAR_CACHE_LAT4", {0x367} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_DATA_EAR_CACHE_LAT512 122
{ "DATA_EAR_CACHE_LAT512", {0x80367} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_DATA_EAR_CACHE_LAT64 123
{ "DATA_EAR_CACHE_LAT64", {0x40367} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_DATA_EAR_CACHE_LAT8 124
{ "DATA_EAR_CACHE_LAT8", {0x10367} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_DATA_EAR_CACHE_LAT_NONE 125
{ "DATA_EAR_CACHE_LAT_NONE", {0xf0367} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_DATA_EAR_EVENTS 126
{ "DATA_EAR_EVENTS", {0x67} , 0xf0, 1, {0xffff0007}, NULL},
#define PME_ITA_DATA_EAR_TLB_L2 127
{ "DATA_EAR_TLB_L2", {0x20767} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_DATA_EAR_TLB_SW 128
{ "DATA_EAR_TLB_SW", {0x80767} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_DATA_EAR_TLB_VHPT 129
{ "DATA_EAR_TLB_VHPT", {0x40767} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_DATA_REFERENCES_RETIRED 130
{ "DATA_REFERENCES_RETIRED", {0x63} , 0xf0, 2, {0xffff0007}, NULL},
#define PME_ITA_DEPENDENCY_ALL_CYCLE 131
{ "DEPENDENCY_ALL_CYCLE", {0x6} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_DEPENDENCY_SCOREBOARD_CYCLE 132
{ "DEPENDENCY_SCOREBOARD_CYCLE", {0x2} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_DTC_MISSES 133
{ "DTC_MISSES", {0x60} , 0xf0, 1, {0xffff0007}, NULL},
#define PME_ITA_DTLB_INSERTS_HPW 134
{ "DTLB_INSERTS_HPW", {0x62} , 0xf0, 1, {0xffff0007}, NULL},
#define PME_ITA_DTLB_MISSES 135
{ "DTLB_MISSES", {0x61} , 0xf0, 1, {0xffff0007}, NULL},
#define PME_ITA_EXPL_STOPBITS 136
{ "EXPL_STOPBITS", {0x2e} , 0xf0, 1, {0xffff0001}, NULL},
#define PME_ITA_FP_FLUSH_TO_ZERO 137
{ "FP_FLUSH_TO_ZERO", {0xb} , 0xf0, 2, {0xffff0003}, NULL},
#define PME_ITA_FP_OPS_RETIRED_HI 138
{ "FP_OPS_RETIRED_HI", {0xa} , 0xf0, 3, {0xffff0003}, NULL},
#define PME_ITA_FP_OPS_RETIRED_LO 139
{ "FP_OPS_RETIRED_LO", {0x9} , 0xf0, 3, {0xffff0003}, NULL},
#define PME_ITA_FP_SIR_FLUSH 140
{ "FP_SIR_FLUSH", {0xc} , 0xf0, 2, {0xffff0003}, NULL},
#define PME_ITA_IA32_INST_RETIRED 141
{ "IA32_INST_RETIRED", {0x15} , 0xf0, 2, {0xffff0000}, NULL},
#define PME_ITA_IA64_INST_RETIRED 142
{ "IA64_INST_RETIRED", {0x8} , 0x30, 6, {0xffff0003}, NULL},
#define PME_ITA_IA64_TAGGED_INST_RETIRED_PMC8 143
{ "IA64_TAGGED_INST_RETIRED_PMC8", {0x30008} , 0x30, 6, {0xffff0003}, NULL},
#define PME_ITA_IA64_TAGGED_INST_RETIRED_PMC9 144
{ "IA64_TAGGED_INST_RETIRED_PMC9", {0x20008} , 0x30, 6, {0xffff0003}, NULL},
#define PME_ITA_INST_ACCESS_CYCLE 145
{ "INST_ACCESS_CYCLE", {0x1} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_INST_DISPERSED 146
{ "INST_DISPERSED", {0x2d} , 0x30, 6, {0xffff0001}, NULL},
#define PME_ITA_INST_FAILED_CHKS_RETIRED_ALL 147
{ "INST_FAILED_CHKS_RETIRED_ALL", {0x30035} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_INST_FAILED_CHKS_RETIRED_FP 148
{ "INST_FAILED_CHKS_RETIRED_FP", {0x20035} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_INST_FAILED_CHKS_RETIRED_INT 149
{ "INST_FAILED_CHKS_RETIRED_INT", {0x10035} , 0xf0, 1, {0xffff0003}, NULL},
#define PME_ITA_INSTRUCTION_EAR_CACHE_LAT1024 150
{ "INSTRUCTION_EAR_CACHE_LAT1024", {0x80123} , 0xf0, 1, {0xffff0001}, NULL},
#define PME_ITA_INSTRUCTION_EAR_CACHE_LAT128 151
{ "INSTRUCTION_EAR_CACHE_LAT128", {0x50123} , 0xf0, 1, {0xffff0001}, NULL},
#define PME_ITA_INSTRUCTION_EAR_CACHE_LAT16 152
{ "INSTRUCTION_EAR_CACHE_LAT16", {0x20123} , 0xf0, 1, {0xffff0001}, NULL},
#define PME_ITA_INSTRUCTION_EAR_CACHE_LAT2048 153
{ "INSTRUCTION_EAR_CACHE_LAT2048", {0x90123} , 0xf0, 1, {0xffff0001}, NULL},
#define PME_ITA_INSTRUCTION_EAR_CACHE_LAT256 154
{ "INSTRUCTION_EAR_CACHE_LAT256", {0x60123} , 0xf0, 1, {0xffff0001}, NULL},
#define PME_ITA_INSTRUCTION_EAR_CACHE_LAT32 155
{ "INSTRUCTION_EAR_CACHE_LAT32", {0x30123} , 0xf0, 1, {0xffff0001}, NULL},
#define PME_ITA_INSTRUCTION_EAR_CACHE_LAT4096 156
{ "INSTRUCTION_EAR_CACHE_LAT4096", {0xa0123} , 0xf0, 1, {0xffff0001}, NULL},
#define PME_ITA_INSTRUCTION_EAR_CACHE_LAT4 157
{ "INSTRUCTION_EAR_CACHE_LAT4", {0x123} , 0xf0, 1, {0xffff0001}, NULL},
#define PME_ITA_INSTRUCTION_EAR_CACHE_LAT512 158
{ "INSTRUCTION_EAR_CACHE_LAT512", {0x70123} , 0xf0, 1, {0xffff0001}, NULL},
#define PME_ITA_INSTRUCTION_EAR_CACHE_LAT64 159
{ "INSTRUCTION_EAR_CACHE_LAT64", {0x40123} , 0xf0, 1, {0xffff0001}, NULL},
#define PME_ITA_INSTRUCTION_EAR_CACHE_LAT8 160
{ "INSTRUCTION_EAR_CACHE_LAT8", {0x10123} , 0xf0, 1, {0xffff0001}, NULL},
#define PME_ITA_INSTRUCTION_EAR_CACHE_LAT_NONE 161
{ "INSTRUCTION_EAR_CACHE_LAT_NONE", {0xf0123} , 0xf0, 1, {0xffff0001}, NULL},
#define PME_ITA_INSTRUCTION_EAR_EVENTS 162
{ "INSTRUCTION_EAR_EVENTS", {0x23} , 0xf0, 1, {0xffff0001}, NULL},
#define PME_ITA_INSTRUCTION_EAR_TLB_SW 163
{ "INSTRUCTION_EAR_TLB_SW", {0x80523} , 0xf0, 1, {0xffff0001}, NULL},
#define PME_ITA_INSTRUCTION_EAR_TLB_VHPT 164
{ "INSTRUCTION_EAR_TLB_VHPT", {0x40523} , 0xf0, 1, {0xffff0001}, NULL},
#define PME_ITA_ISA_TRANSITIONS 165
{ "ISA_TRANSITIONS", {0x14} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_ISB_LINES_IN 166
{ "ISB_LINES_IN", {0x26} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_ITLB_INSERTS_HPW 167
{ "ITLB_INSERTS_HPW", {0x28} , 0xf0, 1, {0xffff0001}, NULL},
#define PME_ITA_ITLB_MISSES_FETCH 168
{ "ITLB_MISSES_FETCH", {0x27} , 0xf0, 1, {0xffff0001}, NULL},
#define PME_ITA_L1D_READ_FORCED_MISSES_RETIRED 169
{ "L1D_READ_FORCED_MISSES_RETIRED", {0x6b} , 0xf0, 2, {0xffff0007}, NULL},
#define PME_ITA_L1D_READ_MISSES_RETIRED 170
{ "L1D_READ_MISSES_RETIRED", {0x66} , 0xf0, 2, {0xffff0007}, NULL},
#define PME_ITA_L1D_READS_RETIRED 171
{ "L1D_READS_RETIRED", {0x64} , 0xf0, 2, {0xffff0007}, NULL},
#define PME_ITA_L1I_DEMAND_READS 172
{ "L1I_DEMAND_READS", {0x20} , 0xf0, 1, {0xffff0001}, NULL},
#define PME_ITA_L1I_FILLS 173
{ "L1I_FILLS", {0x21} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_L1I_PREFETCH_READS 174
{ "L1I_PREFETCH_READS", {0x24} , 0xf0, 1, {0xffff0001}, NULL},
#define PME_ITA_L1_OUTSTANDING_REQ_HI 175
{ "L1_OUTSTANDING_REQ_HI", {0x79} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_L1_OUTSTANDING_REQ_LO 176
{ "L1_OUTSTANDING_REQ_LO", {0x78} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_L2_DATA_REFERENCES_ALL 177
{ "L2_DATA_REFERENCES_ALL", {0x30069} , 0xf0, 2, {0xffff0007}, NULL},
#define PME_ITA_L2_DATA_REFERENCES_READS 178
{ "L2_DATA_REFERENCES_READS", {0x10069} , 0xf0, 2, {0xffff0007}, NULL},
#define PME_ITA_L2_DATA_REFERENCES_WRITES 179
{ "L2_DATA_REFERENCES_WRITES", {0x20069} , 0xf0, 2, {0xffff0007}, NULL},
#define PME_ITA_L2_FLUSH_DETAILS_ADDR_CONFLICT 180
{ "L2_FLUSH_DETAILS_ADDR_CONFLICT", {0x20077} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_L2_FLUSH_DETAILS_ALL 181
{ "L2_FLUSH_DETAILS_ALL", {0xf0077} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_L2_FLUSH_DETAILS_BUS_REJECT 182
{ "L2_FLUSH_DETAILS_BUS_REJECT", {0x40077} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_L2_FLUSH_DETAILS_FULL_FLUSH 183
{ "L2_FLUSH_DETAILS_FULL_FLUSH", {0x80077} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_L2_FLUSH_DETAILS_ST_BUFFER 184
{ "L2_FLUSH_DETAILS_ST_BUFFER", {0x10077} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_L2_FLUSHES 185
{ "L2_FLUSHES", {0x76} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_L2_INST_DEMAND_READS 186
{ "L2_INST_DEMAND_READS", {0x22} , 0xf0, 1, {0xffff0001}, NULL},
#define PME_ITA_L2_INST_PREFETCH_READS 187
{ "L2_INST_PREFETCH_READS", {0x25} , 0xf0, 1, {0xffff0001}, NULL},
#define PME_ITA_L2_MISSES 188
{ "L2_MISSES", {0x6a} , 0xf0, 2, {0xffff0007}, NULL},
#define PME_ITA_L2_REFERENCES 189
{ "L2_REFERENCES", {0x68} , 0xf0, 3, {0xffff0007}, NULL},
#define PME_ITA_L3_LINES_REPLACED 190
{ "L3_LINES_REPLACED", {0x7f} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_L3_MISSES 191
{ "L3_MISSES", {0x7c} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_L3_READS_ALL_READS_ALL 192
{ "L3_READS_ALL_READS_ALL", {0xf007d} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_L3_READS_ALL_READS_HIT 193
{ "L3_READS_ALL_READS_HIT", {0xd007d} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_L3_READS_ALL_READS_MISS 194
{ "L3_READS_ALL_READS_MISS", {0xe007d} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_L3_READS_DATA_READS_ALL 195
{ "L3_READS_DATA_READS_ALL", {0xb007d} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_L3_READS_DATA_READS_HIT 196
{ "L3_READS_DATA_READS_HIT", {0x9007d} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_L3_READS_DATA_READS_MISS 197
{ "L3_READS_DATA_READS_MISS", {0xa007d} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_L3_READS_INST_READS_ALL 198
{ "L3_READS_INST_READS_ALL", {0x7007d} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_L3_READS_INST_READS_HIT 199
{ "L3_READS_INST_READS_HIT", {0x5007d} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_L3_READS_INST_READS_MISS 200
{ "L3_READS_INST_READS_MISS", {0x6007d} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_L3_REFERENCES 201
{ "L3_REFERENCES", {0x7b} , 0xf0, 1, {0xffff0007}, NULL},
#define PME_ITA_L3_WRITES_ALL_WRITES_ALL 202
{ "L3_WRITES_ALL_WRITES_ALL", {0xf007e} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_L3_WRITES_ALL_WRITES_HIT 203
{ "L3_WRITES_ALL_WRITES_HIT", {0xd007e} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_L3_WRITES_ALL_WRITES_MISS 204
{ "L3_WRITES_ALL_WRITES_MISS", {0xe007e} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_L3_WRITES_DATA_WRITES_ALL 205
{ "L3_WRITES_DATA_WRITES_ALL", {0x7007e} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_L3_WRITES_DATA_WRITES_HIT 206
{ "L3_WRITES_DATA_WRITES_HIT", {0x5007e} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_L3_WRITES_DATA_WRITES_MISS 207
{ "L3_WRITES_DATA_WRITES_MISS", {0x6007e} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_L3_WRITES_L2_WRITEBACK_ALL 208
{ "L3_WRITES_L2_WRITEBACK_ALL", {0xb007e} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_L3_WRITES_L2_WRITEBACK_HIT 209
{ "L3_WRITES_L2_WRITEBACK_HIT", {0x9007e} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_L3_WRITES_L2_WRITEBACK_MISS 210
{ "L3_WRITES_L2_WRITEBACK_MISS", {0xa007e} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_LOADS_RETIRED 211
{ "LOADS_RETIRED", {0x6c} , 0xf0, 2, {0xffff0007}, NULL},
#define PME_ITA_MEMORY_CYCLE 212
{ "MEMORY_CYCLE", {0x7} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_MISALIGNED_LOADS_RETIRED 213
{ "MISALIGNED_LOADS_RETIRED", {0x70} , 0xf0, 2, {0xffff0007}, NULL},
#define PME_ITA_MISALIGNED_STORES_RETIRED 214
{ "MISALIGNED_STORES_RETIRED", {0x71} , 0xf0, 2, {0xffff0007}, NULL},
#define PME_ITA_NOPS_RETIRED 215
{ "NOPS_RETIRED", {0x30} , 0x30, 6, {0xffff0003}, NULL},
#define PME_ITA_PIPELINE_ALL_FLUSH_CYCLE 216
{ "PIPELINE_ALL_FLUSH_CYCLE", {0x4} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_PIPELINE_BACKEND_FLUSH_CYCLE 217
{ "PIPELINE_BACKEND_FLUSH_CYCLE", {0x0} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_PIPELINE_FLUSH_ALL 218
{ "PIPELINE_FLUSH_ALL", {0xf0033} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_PIPELINE_FLUSH_DTC_FLUSH 219
{ "PIPELINE_FLUSH_DTC_FLUSH", {0x40033} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_PIPELINE_FLUSH_IEU_FLUSH 220
{ "PIPELINE_FLUSH_IEU_FLUSH", {0x80033} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_PIPELINE_FLUSH_L1D_WAYMP_FLUSH 221
{ "PIPELINE_FLUSH_L1D_WAYMP_FLUSH", {0x20033} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_PIPELINE_FLUSH_OTHER_FLUSH 222
{ "PIPELINE_FLUSH_OTHER_FLUSH", {0x10033} , 0xf0, 1, {0xffff0000}, NULL},
#define PME_ITA_PREDICATE_SQUASHED_RETIRED 223
{ "PREDICATE_SQUASHED_RETIRED", {0x31} , 0x30, 6, {0xffff0003}, NULL},
#define PME_ITA_RSE_LOADS_RETIRED 224
{ "RSE_LOADS_RETIRED", {0x72} , 0xf0, 2, {0xffff0007}, NULL},
#define PME_ITA_RSE_REFERENCES_RETIRED 225
{ "RSE_REFERENCES_RETIRED", {0x65} , 0xf0, 2, {0xffff0007}, NULL},
#define PME_ITA_STORES_RETIRED 226
{ "STORES_RETIRED", {0x6d} , 0xf0, 2, {0xffff0007}, NULL},
#define PME_ITA_UC_LOADS_RETIRED 227
{ "UC_LOADS_RETIRED", {0x6e} , 0xf0, 2, {0xffff0007}, NULL},
#define PME_ITA_UC_STORES_RETIRED 228
{ "UC_STORES_RETIRED", {0x6f} , 0xf0, 2, {0xffff0007}, NULL},
#define PME_ITA_UNSTALLED_BACKEND_CYCLE 229
{ "UNSTALLED_BACKEND_CYCLE", {0x5} , 0xf0, 1, {0xffff0000}, NULL}};
#define PME_ITA_EVENT_COUNT 230
