#ifndef __INCLUDED_PHIDGETS_LED64_H__
#define __INCLUDED_PHIDGETS_LED64_H__

#include <phidgets/phidgets.h>


typedef struct PhidgetLED64_t {
	Phidget *phidget;

	/* Timestamp and last tag */
	time_t   time;

        unsigned int leds;
        unsigned int led_level[PHIDGETS_LED64_NUMLEDS];

} PhidgetLED64;

#ifdef __cplusplus
extern "C" {
#endif

PhidgetLED64* phidget_new_PhidgetLED64();
void phidget_delete_PhidgetLED64(PhidgetLED64** const qsc);
void phidget_reset_PhidgetLED64(PhidgetLED64* const qsc);
phidget_return phidget_led64_open(PhidgetLED64* const qsc,
	 unsigned int serial, unsigned short retries);
phidget_return phidget_led64_close(PhidgetLED64* const qsc);
bool phidget_led64_is_opened(PhidgetLED64 const* const qsc);

unsigned int phidget_led64_get_level(PhidgetLED64* const qsc,
				       unsigned int led_index);
phidget_return phidget_led64_set_level(PhidgetLED64* const qsc,
				       unsigned int led_index, unsigned int led_level);
		  
		  
#ifdef __cplusplus
}
#endif
		  
#endif /* __INCLUDED_PHIDGETS_LED64_H__ */
