/*
    Copyright (C) 1997-1999  Daniel W. Crompton <redhat@rphh.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

string cvs_version= "$Id: explaindir.pike,v 0.93 1999/10/07 04:11:45 redhat Exp $";

inherit "roxenlib";
inherit "http";
inherit "module";
#include <module.h>
#include <stdio.h>

array register_module()

{
//*** RETURN TAGS TYPE
return ({ MODULE_PARSER|MODULE_LOCATION, "Explain Directory v0.93",
              "This module returns a directory listing from a mountpoint, using a file with and explination of content."
#include "ad.h"
	      });
}

void create()
{
  defvar("dir",
         "NONE/",
         "Directory",
          TYPE_DIR,
         ".");
  defvar("mnt",
         "/download/",
         "Mountpoint",
          TYPE_LOCATION,
         ".");
  defvar("file",
         "filename.txt",
         "Filename",
          TYPE_FILE,
         ".");
  defvar("body",
         "<title> Something $mnt</title>\n<body>\n$result",
         "Body HTML",
          TYPE_TEXT_FIELD,
         "(<I>$mnt = mountpoint & $result = results from Content</I>).");
  defvar("cont",
         "<A HREF=$file>$title</A> $discript<BR>",
         "Content",
          TYPE_TEXT_FIELD,
         "How do you wish to return content???\n<BR>(<I>$file = filename & $discript = discription & $title = title</I>)");
}

string query_location()
{
  return QUERY(mnt);
}

string query_name()
{
  return sprintf("Explain <i>%s</i> in <i>%s</i>",query("dir"),query("mnt"));
}

int hits;

string status()
{
  return
    (
     sprintf("<P>Page Views: <B>%d</B>\n",hits)
    );
}

string directory(string t)
{
  string line;
  string filename = "";
  string _filename;
  string Result = "";
  array dirres = get_dir(combine_path(query("dir"),t));
  string discript;
  string title;
  string filecontent = Stdio.read_bytes(combine_path(query("dir"),query("file")));
  
  foreach(filecontent/"\n",line)
  {
    _filename = filename;
    sscanf(line,"%s:%s:%s",filename, title, discript);

    if(search(dirres,filename)>=0)
    {
      if(filename==_filename) continue;
      Result += replace(query("cont"),({"$file","$discript","$title"}),
                                      ({filename,discript, title})) +"\n";
    }
  }

//  return Result;

  return parse_html(Result - "\r", ([]),
                    ([ "pike" : lambda(string s, mapping a, string c) { return c; } ])
		   );
}

mixed find_file(string t, object id)
{
    hits++;
    if(t!="")
    {
      string content;
      string err = catch( content = Stdio.read_bytes(combine_path(query("dir"),t)) );

      if(!err) return http_string_answer(content);
    }
    return http_string_answer(replace(query("body"),({"$mnt","$result"}),
                                                    ({query("mnt"),directory(t)})
                                     )
			     );
}

string tag_list(string t, mapping m, mixed id)
{
}

string tag_short(string t, mapping m, mixed id)
{
}

mapping query_tag_callers()
{
  return ([ "explain_list":tag_list,
	    "short_list":tag_short,
	  ]);
}
