/*
  imho_german.pike v0.1 for IMHO v0.96.1
  
  Copyright  
  Michael Stenitzer <stenitzer@eva.wsr.ac.at> 1999
  
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  See the file "LICENSE" for details.
  
*/

// Messages
//
//login
#define M_LOGIN 1
#define M_PASSWORD 2
#define M_NOLOGIN 3
#define M_IMAPERROR 10
#define M_SMTPERROR 11
#define M_SAVEDUSERINTERFACE 12
#define M_USERINTERFACE 13
#define M_LOGIN_OK 14
// page header
#define M_NEWMAIL 50
#define M_MAILBOX 51
#define M_MAILBOXES 52
#define M_FILES 53
#define M_PREFS 54
#define M_LOGOUT 55
#define M_CURRMAILBOX 56
#define M_CHECKACTIVEMAILBOXES 57
// compose
#define M_SEND 100
#define M_CANCELSEND 101
#define M_SENDMOREFILES 102
#define M_COMPOSEMAIL 103
#define M_SPELLCHECK 104
#define M_DONTSAVEMAIL 105
#define M_ADDFILEASATTACHMENT 106
#define M_NOATTACHMENTS 107
#define M_ADDATTACHMENT 108
#define M_REMOVEMARKEDATTACHMENTS 109
#define M_UPLOADATTACHMENT 110
#define M_ADDMARKEDTOATTACHMENTS 111
#define M_UPLOADTOATTACHMENTS 112
#define M_BACKTOCOMPOSE 113
#define M_NOATTACHFILES 114
#define M_ATTACHMENTSHEADER 115
#define M_SENDSAVEFAILED 116
#define M_SENDNORECV 117
// mailindex
#define M_DELETEMARKED 200
#define M_MOVEMARKED 201
#define M_SELECTMBOX 202
#define M_CHECKNEWMAIL 203
#define M_MAILSHOWN 204
#define M_BACKN 205
#define M_FORWARDN 206
#define M_NUMBER 207
#define M_DELETEMARKEDP 208
#define M_DELETEMARKEDNONE 209
#define M_CHANGESORTORDER 210
#define M_MOVETOTRASH 211
#define M_DELETEALLTRASH 212
#define M_NOMAILS 213
// mailboxlist
#define M_MBOXNAME 300
#define M_DELETEMARKEDMBOX 301
#define M_CREATEMBOX 302
#define M_NEWMBOXNAME 303
#define M_MBOXREMOVEP 350
#define M_MBOXMARKONE 351
#define M_NEWMBOXNONAME 352
#define M_CREATEMBOXERROR 353
#define M_INBOX 354
#define M_PREVIOUS_LEVEL 355
#define M_FOLDER_PATH 356
// files
#define M_FILENAME 400
#define M_SIZE 401
#define M_MIMETYPE 402
#define M_DELETEMARKEDFILES 403
#define M_UPLOAD 404
#define M_AVAILSPACE 405
#define M_WINDOWSBUG 406
#define M_NOFILES 407
// preferences
#define M_PNAME 500
#define M_PMAILADDRESS 501
#define M_PMAILPATH 502
#define M_PINCLUDEMAIL 503
#define M_PQUOTEPREFIX 504
#define M_PSIGNATURE 505
#define M_PINACTIVELOGOUT 506
#define M_PSAVEANDUSE 550
#define M_PVISIBLEMESSAGES 507
#define M_PSORTORDER 508
#define M_PSORTORDERS 509
#define M_PTRASHFOLDER 510
#define M_PSENTFOLDER 511
#define M_PDEFAULTBCC 512
#define M_PSAVEATTACHMENTS 513
#define M_PLANGUAGE 514
#define M_PUSERINTERFACE 515
#define M_PINBOXES 516
#define M_PCOMMASEPARATED 517
// logout
#define M_LOGOUTMSG 600
#define M_LOGGEDOUT 601
// dialog
#define M_QUESTION 700
#define M_INFO 701
// readmail
#define M_REPLY 800
#define M_READPREV 801
#define M_READNEXT 802
#define M_ATTACHMENTLINK 803
#define M_MAILMISSING 804
#define M_MAILMISSINGBACK 805
#define M_DELETE 806
#define M_FORWARD 807
#define M_MAIL 808
#define M_SHOWFULLHEADERS 809
#define M_HIDEFULLHEADERS 810
#define M_MAILTOOBIG 811
//spellcheck
#define M_SPELLDONE 900
#define M_SPELLPREV 901
#define M_SPELLNEXT 902
#define M_SPELLCHANGETO 903
#define M_SPELLSUGGESTIONS 904
// mailheaders
#define M_FROM 1000
#define M_TO 1001
#define M_CC 1002
#define M_BCC 1003
#define M_SUBJECT 1004
#define M_ATTACHMENTS 1005
#define M_TIME 1006
#define M_DATE 1007
// table heads
#define M_MARKFLAG 1100
#define M_NEWFLAG 1101
#define M_ANSWEREDFLAG 1102
// address book
#define M_ADDRESSBOOKTITLE 1200
#define M_ADDRESSBOOK 1201
#define M_INDEXNAMERECIPIENT 1202
#define M_INDEXNAMEEDIT 1203
#define M_ADDRESS 1204
#define M_NOADDRESSES 1205
#define M_NEWADDRESS 1206
#define M_EDITADDRESS 1207
#define M_ADDADDRESS 1208
#define M_INDEXNAME 1209
#define M_ADDRESSFORMAT 1210
#define M_SAVEADDRESS 1211
#define M_DELETEADDRESS 1212
#define M_CANCELADDRESS 1213
#define M_CANNOTIMPORT 1214
#define M_IMPORTADDRESSBOOKTITLE 1215
#define M_UPLOADADDRESSBOOK 1216
#define M_PINELOCATION 1217
#define M_UPLOADANDIMPORT 1218
#define M_IMPORTADDRESSBOOK 1219
// general
#define M_YES 2000
#define M_NO 2001
#define M_DIALOGOK 2002
#define M_DIALOGCANCEL 2003

string imho_lang() {
  return "deutsch";
}

string imho_lang_short() {
  return "de";
}

string msg(object sessobj,int m,array arg) {
  switch(m) {
    
// Login page
    
  case M_LOGIN:
    //return "Login:";
    return "Benutzerkennung:";
  case M_PASSWORD:
    //return "Password:";
    return "Passwort:";
  case M_NOLOGIN:
    //return "<b>Could not log in:</b> Wrong login or password. Try again. ";
    return "<b>Sie konnten nicht angemeldet werden:</b> Benutzerkennung oder Passwort sind falsch. Versuchen Sie es nochmals. ";
  case M_IMAPERROR:
    //return "There was a problem talking to the mail (IMAP) server. Please contact the administrator.";
    return "Die Verbindung mit dem Mail-/IMAP-Server konnte nicht hergestellt werden. Kontaktieren Sie Ihre SystemadministratorIn.";
  case M_SMTPERROR:
    //return "There was a problem talking to the outgoing mail (SMTP) server. The recipient of the mail might not exist.";
    return "Beim Versenden der Nachricht gab es ein Problem bei der Verbindung zum (SMTP) Mailserver. Die Empf&auml;ngerIn dieser Nachricht exisitiert unter Umst&auml;nden nicht.";
   case M_SAVEDUSERINTERFACE:
    //return "From preferences";
    //???
    return "Von Einstellungen";
  case M_USERINTERFACE:
    //return "User interface:";
    return "Benutzer-Interface:";
  case M_LOGIN_OK:
    //return "OK";
    return "OK";
   
  case M_NEWMAIL:
    //return "New mail";
    return "Neue Nachricht";
  case M_MAILBOX:
    //return sprintf("Mailbox: %s",@arg);
    return sprintf("Ordner: %s",@arg);
  case M_MAILBOXES:
    //return "Mailboxes";
    return "Ordner";
  case M_FILES:
    //return "Files";
    return "Dateien";
  case M_PREFS:
    //return "Preferences";
    return "Einstellungen";
  case M_LOGOUT:
    //return "Logout";
    // return "Abmelden";
    return "Logout";
  case M_CURRMAILBOX:
    // return "Current Mailbox";
    return "Aktueller Ordner";
  case M_CHECKACTIVEMAILBOXES:
    // return "Check active mailboxes";
    return "Ueberpruefe aktuellen Ordner";


  case M_FROM:
    //return "From";
    return "Von";
  case M_TO:
    //return "To";
    return "An";
  case M_CC:
    //return "Cc";
    return "Cc";
  case M_BCC:
    //return "Bcc";
    return "Bcc";
  case M_SUBJECT:
    //return "Subject";
    return "Betreff";
  case M_ATTACHMENTS:
    //return "Attachments";
    return "Attachments";
  case M_TIME:
    //return "Time";
    return "Zeit";
  case M_DATE:
    //return "Date";
    return "Datum";
    
  case  M_MARKFLAG:
    //return "M";
    return "M";
  case M_NEWFLAG:
    //return "N";
    return "N";
  case M_ANSWEREDFLAG:
    //return "A";
    return "A";
    
    
  case M_SEND:
    //return "Send";
    return "Senden";
  case M_CANCELSEND:
    //return "Cancel";
    return "Abbrechen";
  case M_SENDMOREFILES:
    //return "Select files to send. Press 'Ctrl' to toggle-select multiple files.";
    return "W&auml;hlen Sie eine Datei zum versenden. Dr&uuml;cken Sie 'Ctrl'/'Strg' f&uuml;r mehrere Dateien.";
  case M_COMPOSEMAIL:
    //return "Compose mail";
    return "Nachricht verfassen";
  case M_SPELLCHECK:
    return "Rechtschreibung pr&uuml;fen";
  case M_DONTSAVEMAIL:
    //return "Do not save this mail.";
    return "Diese Nachricht nicht speichern.";
  case M_ADDFILEASATTACHMENT:
    //return "Add file as attachment";
    return "Eine Datei als Attachment beif&uuml;gen";
  case M_NOATTACHMENTS:
    //return "No attachments";
    return "Keine Attachments";
  case M_ADDATTACHMENT:
    //return "Add attachment...";
    return "Ein Attachment beif&uuml;gen...";
  case M_REMOVEMARKEDATTACHMENTS:
    //return "Remove marked attachments";
    return "Markierte Attachments l&ouml;schen";
  case M_UPLOADATTACHMENT:
    //return "Upload attachment";
    return "Attachment laden";
  case M_ADDMARKEDTOATTACHMENTS:
    //return "Add marked to attachments";
    return "Markierte Dateien als Attachment hinzuf&uuml;gen";
  case M_UPLOADTOATTACHMENTS:
    //return "Upload to attachments";
    return "Zu den Attachments laden";
  case M_BACKTOCOMPOSE:
    //return "Back to compose";
    return "Zur&uuml;ck zum Verfassen einer Nachricht";
  case M_NOATTACHFILES:
    //return "No files";
    return "Keine Dateien";
  case  M_ATTACHMENTSHEADER:
    return "Attachments";
  case M_SENDSAVEFAILED:
    //return "Mail was sent successfully, but save in folder failed.";
    return "E-Mail erfolgreich versendet, speichern in Postausgang fehlgeschlagen.";
  case M_SENDNORECV:
    //return "You must specify a recipient of the mail.";
    return "Sie muessen eine EmpfaengerIn fuer die Nachricht angegeben.";
    
  case M_DELETEMARKED:
    //return "Delete marked";
    return "Markierte l&ouml;schen";
  case M_MOVEMARKED:
    //return "Move marked to";
    return "Markierte Nachrichten in folgenden Ordner verschieben";
  case M_SELECTMBOX:
    //return "(Select a mailbox)";
    return "[Ordner ausw&auml;hlen]";
  case M_CHECKNEWMAIL:
    //return "Check for new mail";
    return "Neue Nachrichten?";
  case M_MAILSHOWN:
    // return sprintf("Mail <b>%d-%d of %d</b>", @arg);
    return sprintf("E-Mail <b>%d-%d von %d</b>", @arg);
  case M_BACKN:
    //return sprintf("[<< Prev %d]", @arg);
    return sprintf("[<< Vorherige %d]", @arg);
  case M_FORWARDN:
    // return sprintf("[Next %d >>]", @arg);
    return sprintf("[N&auml;chste %d >>]", @arg);
  case M_NUMBER:
    return "#";
  case M_DELETEMARKEDP:
    //sprintf("Are you sure you want to delete the %d marked message(s)?", 
    return 
      sprintf("Sind Sie sicher, dass Sie die %d markierten Nachrichten l&ouml;schen m&ouml;chten?", 
	      @arg);
  case M_DELETEMARKEDNONE:
    //return "Please mark some messages first.";
    return "Bitte markieren Sie zuerst die entsprechenden Nachrichten.";
  case M_CHANGESORTORDER:
    //return "Change sort order";
    return "Reihenfolge &auml;ndern";
  case M_MOVETOTRASH:
    //return "Move marked to trash";
    return "Markierte Nachrichten in den 'Papierkorb' verschieben";
  case M_DELETEALLTRASH:
    //return "Delete ALL trash";
    return "'Papierkorb' entleeren";
  case M_NOMAILS:
    // return "[No mails]";
    return "[Keine Nachrichten]";

  case M_MBOXNAME:
    //return "Mailbox";
    return "Ordner";
  case M_DELETEMARKEDMBOX:
    //return "Delete marked";
    return "Markierte l&ouml;schen";
  case M_CREATEMBOX:
    //return "Create a new mailbox";
    return "Neuen Ordner erstellen";
  case M_NEWMBOXNAME:
    //return "(Name)";
    return "[Name]";
  case M_MBOXREMOVEP:
    //return "Are you sure you want to delete the following mailboxes?";
    return "Sind Sie sicher, dass Sie die folgenden Ordner l&ouml;schen m&ouml;chten?";
  case M_MBOXMARKONE:
    //return "Mark at least one mailbox.";
    return "Markieren Sie zumindest einen Ordner.";    
  case M_NEWMBOXNONAME:
    // return "Type in a name first.";
    return "Geben Sie zuerst einen Namen an.";
  case M_CREATEMBOXERROR:
    //return "Failed to create mailbox. The name may be illegal or the mailbox may exist.";
    return "Ordner konnte nicht angelegt werden. Der Name k&ouml;nnte ung&uuml;ltig sein oder bereits existieren.";
  case M_INBOX:
    //return "Inbox";
    return "Posteingang";
  case M_PREVIOUS_LEVEL:
    //return "[Previuos level]";
    return "[Vorige Ebene]";
  case M_FOLDER_PATH:
    //return "Path:";
    return "Pfad:";
	
  case M_FILENAME:
    //return "Filename";
    return "Dateiname";
  case M_SIZE:
    //return "Size";
    return "Gr&ouml;&szlig;e";
  case M_MIMETYPE:
    //return "Type";
    return "Typ";
  case M_DELETEMARKEDFILES:
    //return "Delete marked";
    return "Zum L&ouml;schen markiert";
  case M_UPLOAD:
    //return "Upload";
    return "Laden";
  case M_AVAILSPACE:
    //return sprintf("You have %d Kb available for upload.",@arg);
    return sprintf("Sie haben %d Kb Speicherplatz f&uuml;r Ihre Dateien.",@arg);
  case M_WINDOWSBUG :
    //return "Windowsusers: Due to a bug in some browsers, filenames can be crippled. Avoid this by replacing the last \\ with \\\\ before pressing 'Upload'.";
    return "ACHTUNG WINDOWS-ANWENDER! Wegen eines Fehlers in manchen Browsern, k&ouml;nnen Dateinamen verst&uuml;mmelt werden. Um das zu vermeiden ersetzen Sie den LETZTEN '\\' durch '\\\\' bevor Sie 'Laden' dr&uuml;cken.";
  case M_NOFILES:
    //return "You have no uploades files.";
    return "Sie haben keine Dateien ausgew&auml;hlt.";

  case M_PNAME:
    //return "Name";
    return "Name";
  case M_PMAILADDRESS:
    //return "Mail address";
    return "E-Mail Adresse";
  case M_PMAILPATH:
    //return "Mail searchpath";
    return "Mailpfad (kann leer sein)";
  case M_PINCLUDEMAIL:
    //return "Include mail when replying";
    return "Beim Antworten Original-Nachricht beif&uuml;gen";
  case M_PQUOTEPREFIX :
    //return "Prefix";
    return "Prefix";
  case M_PSIGNATURE:
    //return "Signature";
    return "Signatur";
  case M_PINACTIVELOGOUT:
    //return "Inactive logout (minutes)";
    return "Logout nach Unt&auml;tigkeit (Minuten)";
  case M_PSAVEANDUSE:
    //return "Save and use";
    return "Speichern";
  case M_PVISIBLEMESSAGES:
    //return "Messages shown in mailbox";
    return "Anzahl der angezeigten Nachrichten";
  case M_PSORTORDER:
    //return "Mail sort order";
    return "Reihenfolge";
  case M_PSORTORDERS:
    //return ([ "forward": "forward", "backward":"backward"])[arg[0]];
    return (["backward":"aktuellste zuerst", "forward": "chronologisch"])[arg[0]];
  case M_PTRASHFOLDER:
    //return "Trash folder";
    return "Papierkorb";
  case M_PSENTFOLDER:
    //return "Sent mail folder";
    return "Pfad f&uuml;r gesendete Nachrichten";
  case M_PDEFAULTBCC:
    //return "Default Bcc address";
    return "Standard Bcc-Adresse";
  case M_PSAVEATTACHMENTS:
    //return "Save attachments";
    return "Attachments speichern";
  case M_PLANGUAGE:
    //return "Language";
    return "Sprache";
  case M_PUSERINTERFACE:
    //return "User interface";
    return "Benutzer-Interface";
  case M_PINBOXES:
    //return "Inboxes";
    return "Posteingangsordner";
  case M_PCOMMASEPARATED: 
    //return "(Comma separated list of mailboxes)";
    return "(Liste der Ordner; durch Komma getrennt)";

  case M_SPELLDONE:
    //return "Done";
    return "Erledigt";
  case M_SPELLPREV:
    //return "Previous";
    return "Vorherige";
  case M_SPELLNEXT:
    //return "Next";
    return "Weiter";
  case  M_SPELLCHANGETO:
    //return "Change to";
    return "ndern in";
  case M_SPELLSUGGESTIONS:
    //return "Suggestions";
    return "Vorschlag";

  case M_LOGOUTMSG:
    //return "You are logged out. Close this browser window to make sure no one can read your mails.<br><br>Reload this page to login.";
    return "Sie sind abgemeldet. Damit niemand Ihre E-Mails missbr&auml;uchlich lesen kann, schlie&szlig;en Sie das Browser-Fenster.";
  case M_LOGGEDOUT:
    //return "Logged out";
    return "Abgemeldet";

  case M_QUESTION:
    //return "Question"; 
    return "Frage";

  case M_INFO:
    //return "Info"; 
    return "Info";

  case M_REPLY:
    //return "Reply";
    return "Antworten";
  case M_READPREV:
    //return "Read previous";
    return "Vorherige lesen";
  case M_READNEXT:
    //return "Read next";
    return "N&auml;chste lesen";
  case M_ATTACHMENTLINK:
    //return sprintf("%sattachment of type %s",@arg);
    return sprintf("%sAttachment vom Typ %s",@arg);
  case M_MAILMISSING:
    //return "<b>Error:</b> Failed to fetch mail. Try again. <br>";
    return "<b>Fehler:</b> Nachricht konnte nicht ge&ouml;ffnet werden. Versuchen Sie es nochmals.<br>";
  case M_MAILMISSINGBACK:
    //return "Back";
    return "Zur&uuml;ck";
  case M_DELETE:
    //return "Delete";
    return "L&ouml;schen";
  case M_FORWARD:
    //return "Forward";
    return "Weiterleiten";
  case M_MAIL:
    // return "Mail";
    return "E-Mail";
  case M_SHOWFULLHEADERS:
    //return "Show full headers";
    return "E-Mail Header anzeigen";
  case M_HIDEFULLHEADERS:
    //return "Hide full headers";
    return "E-Mail Header ausblenden";
  case M_MAILTOOBIG:
    // return "Mail is too big to be shown. Click here to download it.";
    return "E-Mail ist zu gro&szlig; um angezeigt zu werden. Sie koennen die E-Mail hier herunterladen.";

  case M_ADDRESSBOOKTITLE:
    //return("Address Book");         
    return("Adressbuch");
  case M_ADDRESSBOOK:
    //return("Address book...");
    return("Adressbuch...");
  case M_INDEXNAMERECIPIENT:
    //return("Intex name (click to add as recipient)");
    return("Name (klicken, um als Empfaenger hinzuzufuegen)");
  case M_INDEXNAMEEDIT:
    //return("Index name (click to edit)");
    return("Name (klicken zum Aendern)");
  case M_ADDRESS:
    //return("Address");
    return("Adresse");
  case M_NOADDRESSES:
    //return("No addresses");
    return("Keine Adresse");
  case M_NEWADDRESS:
    //return("New address...");
    return("Neue Adresse...");
  case M_EDITADDRESS:
    //return("Edit address");
    return("Adresse aendern");
  case M_ADDADDRESS:
    //return("Add to address book");
    return("Zum Adressbuch hinzufuegen");
  case M_INDEXNAME:
    //return("Index name");
    return("Name");
  case M_ADDRESSFORMAT:
    //return("Address(es), comma separated");
    return("E-Mail-Adresse/n (mehrere durch Komma trennen)");
  case M_SAVEADDRESS:
    //return("Save and use");
    return("Speichern und verwenden");
  case M_DELETEADDRESS:
    //return("Delete address");
    return("Adresse loeschen");
  case M_CANCELADDRESS:
    //return("Cancel");
    return("Abbrechen");
  case M_CANNOTIMPORT:
    //return("Cannot import this addressbook, since its\nformat is not recognized.");
    return("Kann dieses Adressbuch nicht importieren,\nda das Format unbekannt ist.");
  case M_IMPORTADDRESSBOOKTITLE:
    //return("Import address book");
    return("Adressbuch importieren");
  case M_UPLOADADDRESSBOOK:
    //return("Upload a Pine or exported Netscape (.ldif) address book");
    return("Ein \"Pine\"- oder ein \"exportiertes Netscape\"-Adressbuch (.ldif) importieren");
  case M_PINELOCATION:
    //return("The Pine address book is often in ~/.addressbook");
    return("(Das \"Pine\"-Adressbuch liegt meistens unter \"~/.addressbook\")");
  case M_UPLOADANDIMPORT:
    //return("Upload and import");
    return("Importieren");
  case M_IMPORTADDRESSBOOK:
    // return("Import address book...");
    return("Adressbuch importieren...");

case M_YES:
    //return "Yes";
    return "Ja";
  case M_NO:
    //return "No";
    return "Nein";
  case M_DIALOGOK:
    // return "OK";
    return "OK";
  case M_DIALOGCANCEL:
    // return "Cancel";
    return "Abbrechen";
   
  }
  return 0;
}




