/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbc;

import com.sap.dbtech.util.StructuredBytes;

/**
 *
 */
public class NameHandling
{
    /**
     * private for statics only class
     */
    private
    NameHandling ()
    {
    }
    
    static private String stripPassword(String pwd) {
        if (pwd.length() > 0) {
            /* don`t upper passwords enclosed by '"' */
            char firstChar = pwd.charAt(0);
            char lastChar = pwd.charAt(pwd.length() - 1);
            if (!((firstChar == '"') && (lastChar == '"'))) {
                pwd = pwd.toUpperCase();
            } else {
                pwd = pwd.substring(1, pwd.length() - 1);
            }
        }
        return pwd;
    }
    static byte[] preprocessPassword(String pwd, boolean isUnicode){
      pwd = stripPassword(pwd);  
      
      if (isUnicode) {
         StructuredBytes pwdBytes = new StructuredBytes(pwd.length()*2);
         pwdBytes.putBigUnicode(pwd.toCharArray(),0,pwd.length()*2);
         return pwdBytes.getBytes(0,pwdBytes.size());
      }
      else {
        return pwd.getBytes();
      }
    }
    /**
     * 
     * @return byte[]
     * @param pwd
     *            java.lang.String
     */
    static byte [] mangle (
        String pwd,
        boolean isUnicode)
    {
        final int vp1 = 2;
        final int vp2 = 521;
        final int vp3 = 133379;
        final int maxPwdLen_C = 18;
        StructuredBytes pwdBytes = new StructuredBytes(maxPwdLen_C);
        String upperpwd = stripPassword(pwd);
        
        if (isUnicode) {
           pwdBytes.putBigUnicode(upperpwd.toCharArray(),0,maxPwdLen_C);
        }
        else {
          pwdBytes.putString(upperpwd,0,maxPwdLen_C);
        }
        int [] clearname = pwdBytes.getIntArray(0,pwdBytes.size());
        int crypt[] = new int[6];
        int left, right;
        StructuredBytes result;

        for (int i = 1; i <= 6; ++i) {
            crypt[i-1] = clearname[3*i-3] * vp3 +
                clearname[3*i-2] * vp2 +
                clearname[3*i-1] * vp1;
        }

        for (int i = 1; i <= 6; ++i) {
            if (i > 1) {
                left = crypt[i-2];
            }
            else {
                left = vp3;
            }
            crypt[i-1] += left % 61 * (vp3 * 126 - 1);
        }

        for (int i = 6; i >= 1; --i) {
            if (i < 5) {
                right = crypt[i];
            }
            else {
                right = vp2;
            }
            crypt[i-1] += right % 61 * (vp3 * 128 - 1);
        }

        for (int i = 0; i < 6; ++i) {
            if ((crypt[i] & 1) != 0) {
                crypt[i] = -crypt[i];
            }
        }
        result = new StructuredBytes (6 * 4);
        for (int i = 0; i < 6; ++i) {
            result.putInt4 (crypt [i], i * 4);
        }
        return result.bytes ();
    }
}
