/*

    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.translators.DBTechTranslator;

/**
 * An object that can be used to get information about the types
 * and properties of the parameters in a <code>PreparedStatement</code> object.
 * @since 1.4 JDBC 3.0
 *
 */
public class ParameterMetaDataSapDB extends ParameterInfo implements java.sql.ParameterMetaData {

  /**
   * Creates a new ParameterMetaData object.
   */
  public ParameterMetaDataSapDB(DBTechTranslator [] paramInfos) {
    super(paramInfos);
  }

  /**
   * Retrieves the designated parameter's mode.
   * @param index the first parameter is 1, the second is 2, ...
   * @return mode of the parameter; one of
   *         <code>ParameterMetaData.parameterModeIn</code>,
   *         <code>ParameterMetaData.parameterModeOut</code>, or
   *         <code>ParameterMetaData.parameterModeInOut</code>
   *         <code>ParameterMetaData.parameterModeUnknown</code>.
   * @throws java.sql.SQLException if a database access error occurs
   * @since 1.4 JDBC 3.0
   *
   */
  public int getParameterMode(int index) throws java.sql.SQLException {
    return this.findParamInfo(index).getParameterMode();
  }
  /*wrapper to suppress class not found exceptions if this driver is
    used with jdk versions < 1.4*/
  public static java.sql.ParameterMetaData createParameterMetaDataSapDB (DBTechTranslator [] paramInfos ) {
     ParameterMetaDataSapDB pmd = new ParameterMetaDataSapDB (paramInfos);
     return (java.sql.ParameterMetaData)pmd;
  }
}