/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/
package com.sap.dbtech.util;

import java.util.Vector;

public class GarbageParseid extends GarbageCan {
  private Vector garbage;
  private boolean supportsMultipleDropParseIDs;

  public GarbageParseid(boolean asupportsMultipleDropParseIDs) {
    super();
    this.supportsMultipleDropParseIDs = asupportsMultipleDropParseIDs;
    this.garbage = new Vector(this.canTresholdC);
  }

  public void throwIntoGarbageCan (Object obj){
    this.garbage.addElement(obj);
  }

  protected int getGarbageSize(){
      return this.garbage.size();
  }

  public synchronized boolean emptyCan(com.sap.dbtech.jdbc.packet.RequestPacket requestPacket)
  {
        if(currentEmptyRun2)
            return false;
        currentEmptyRun2=true;

        boolean packetActionFailed=false;
        int sz=getGarbageSize();

        if (! this.supportsMultipleDropParseIDs){
          while(sz>0 &&
                !packetActionFailed) {
              Object o=this.garbage.remove(sz-1);
              packetActionFailed = ! requestPacket.dropPid((byte[])o, false);
              if(packetActionFailed) {
                  this.garbage.addElement(o);
              }
              --sz;
          }
        }else {
          if (sz>0){
            Object o=this.garbage.remove(sz-1);
            packetActionFailed = ! requestPacket.dropPid((byte[])o, false);
            if(packetActionFailed) {
                this.garbage.addElement(o);
            } else {
              --sz;
              while(sz>0 &&
                    !packetActionFailed) {
                  o=this.garbage.remove(sz-1);
                  packetActionFailed = ! requestPacket.dropPidAddtoParsidPart((byte[])o);
                  if(packetActionFailed) {
                      this.garbage.addElement(o);
                  }
                  --sz;
              }
            }
          }
        }

        currentEmptyRun2=false;
        return !packetActionFailed;
  }
  public void emptyCan () {
    this.garbage.removeAllElements();
  }

}
