# vim:noexpandtab:autoindent:tabstop=8:shiftwidth=8:filetype=make:
#-----------------------------------------------------------------------------
#push
sp 				:= $(sp).x
dirstack_$(sp)	:= $(d)
d				:= $(dir)
#-----------------------------------------------------------------------------


testStandalone_LIBS := $(d)/../main.o
testStandalone_LIBS += $(d)/testStandalone.o 
testStandalone_LDFLAGS += $(call get_ldflags,smbios) 
testStandalone_LDFLAGS += $(call get_ldflags,smbiosxml) 
testStandalone_LDFLAGS += $(XMLLIBFLAG)

-include $(patsubst %.o, %.d, $(testStandalone_LIBS))

testStandalone_LDFLAGS += -Lcppunit/ -lcppunit  -ldl
cppunit/testStandalone: $(testStandalone_LIBS) $(BASE_LIBS) $(EXT_LIBS)
	@[ "$(SIL)" == "" ] || echo "COMPILING UNIT TEST"
	$(SIL)$(CXX) $($(shell basename $(@:%=%_LIBS))) $($(shell basename $(@:%=%_LIBS_NOD))) $(LDFLAGS) $($(shell basename $(@:%=%_LDFLAGS))) -o $@

cppunit/testStandalone-debug: $(testStandalone_LIBS:%.o=%.do) $(BASE_STATIC_DEBUG_LIBS) $(EXT_STATIC_DEBUG_LIBS)
	@[ "$(SIL)" == "" ] || echo "COMPILING DEBUG UNIT TEST"
	$(SIL)$(CXX) $(debug_flags) $(testStandalone_LIBS:%.o=%.do) $(LDFLAGS) -Lcppunit/ -lcppunit -ldl $(XMLLIBFLAG) $(BASE_STATIC_DEBUG_LIBS) $(EXT_STATIC_DEBUG_LIBS) $(XMLLIBFLAG) -o $@

CLEAN_LIST += cppunit/testStandalone cppunit/testStandalone-debug


# Pop dir stack back to what it was
d		:= $(dirstack_$(sp))
sp		:= $(basename $(sp))
