/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; version 
 * 2.1 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */
 
#ifndef _SML_COMMAND_H_
#define _SML_COMMAND_H_

SmlStatus *smlStatusNew(SmlErrorType data, unsigned int cmdref, unsigned int msgref, SmlLocation *sourceref, SmlLocation *targeref, SmlCommandType type, SmlError **error);
void smlStatusRef(SmlStatus *status);
void smlStatusUnref(SmlStatus *status);
SmlErrorType smlStatusGetCode(SmlStatus *status);
SmlErrorClass smlStatusGetClass(SmlStatus *status);
SmlCommand *smlStatusGetResult(SmlStatus *status);
SmlBool smlStatusIsResult(SmlStatus *status);

SmlCommand *smlCommandNew(SmlCommandType type, SmlError **error);
SmlStatus *smlCommandNewReply(SmlCommand *cmd, SmlErrorType code, SmlError **error);
void smlCommandRef(SmlCommand *cmd);
void smlCommandUnref(SmlCommand *cmd);

SmlCommand *smlCommandNewAlert(SmlAlertType type, SmlLocation *target, SmlLocation *source, const char *next, const char *last, const char *contenttype, SmlError **error);
SmlCommand *smlCommandNewSync(SmlLocation *target, SmlLocation *source, unsigned int num_changes, SmlError **error);
SmlCommand *smlCommandNewChange(SmlChangeType type, const char *uid, const char *data, unsigned int size, const char *contenttype, SmlError **error);
SmlCommand *smlCommandNewPartialChange(SmlChangeType type, const char *uid, const char *data, unsigned int complete_size, unsigned int partial_size, const char *contenttype, SmlError **error);
SmlCommand *smlCommandNewResult(SmlCommand *cmd, SmlLocation *source, char *data, unsigned int size, const char *contenttype, SmlError **error);
SmlCommand *smlCommandNewPut(SmlLocation *target, SmlLocation *source, const char *data, unsigned int size, const char *contenttype, SmlError **error);
SmlCommand *smlCommandNewGet(SmlLocation *target, const char *contenttype, SmlError **error);

SmlCommand *smlCommandNewMap(SmlLocation *target, SmlLocation *source, SmlError **error);
SmlBool smlCommandAddMapItem(SmlCommand *map, SmlMapItem *item, SmlError **error);

#endif //_SML_COMMAND_H_
