#include <TePDIUtils.hpp>

//#include <TeRaster.h>
//#include <TeDataTypes.h>
//#include <TeDecoderTIFF.h>
#include <TeInitRasterDecoders.h>

#include <TePDIAgnostic.hpp>

#include <string>

void TeGenerateHistogram_test()
{
  TePDITypes::TePDIRasterPtrType inRaster( new TeRaster(
    std::string( "../resources/cbers_b2_crop.tif" ), 'r' ) );

  PDIAGN_TRUE_OR_THROW( inRaster->init(), "Unable to init inRaster" );

  TePDITypes::TePDIHistogramType out_hist;

  PDIAGN_TRUE_OR_THROW(
    TePDIUtils::TeGenerateHistogram(inRaster, 0, 0, out_hist, true ),
    "Histogram generation error" );

  PDIAGN_CHECK_EQUAL( out_hist.size(), 256,
    "Invalid Generated histogram" );

  int pixels = 0;

  TePDITypes::TePDIHistogramType::iterator hist_it = out_hist.begin();
  TePDITypes::TePDIHistogramType::iterator hist_it_end = out_hist.end();

  while( hist_it != hist_it_end ) {
    pixels += hist_it->second;

    ++hist_it;
  }

  PDIAGN_CHECK_EQUAL( pixels, inRaster->params().nlines_ *
    inRaster->params().ncols_, "Invalid Generated historgram" );

}

void TeRaster2Geotiff_test()
{
  TePDITypes::TePDIRasterPtrType inRaster( new TeRaster(
    std::string( "../resources/cbers_b2_crop.tif" ), 'r' ) );

  PDIAGN_TRUE_OR_THROW( inRaster->init(), "Unable to init inRaster" );

  PDIAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( inRaster,
    "TeRaster2Geotiff_test.tif" ), "GeoTIF generation error" );
}

void TeAllocRAMRaster_test()
{
  TePDITypes::TePDIRasterPtrType inRaster( new TeRaster(
    std::string( "../resources/cbers_b2_crop.tif" ), 'r' ) );

  PDIAGN_TRUE_OR_THROW( inRaster->init(), "Unable to init inRaster" );

  TePDITypes::TePDIRasterPtrType RAMRaster;

  PDIAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( inRaster, RAMRaster ),
    "RAM Raster Allocation error" );

  PDIAGN_TRUE_OR_THROW( TePDIUtils::TeCopyRasterPixels( inRaster, RAMRaster ),
    "Raster pixel copy error" );

  PDIAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( RAMRaster,
    "TeAllocRAMRaster_test.tif" ), "GeoTIF generation error" );
}

void TeResetRaster_test()
{
  TePDITypes::TePDIRasterPtrType inRaster( new TeRaster(
    std::string( "../resources/cbers_b2_crop.tif" ), 'r' ) );

  PDIAGN_TRUE_OR_THROW( inRaster->init(), "Unable to init inRaster" );

  TePDITypes::TePDIRasterPtrType outRaster(
    new TeRaster( inRaster->params().ncols_, inRaster->params().nlines_,
    inRaster->nBands(), TeUNSIGNEDCHAR ) );
  PDIAGN_TRUE_OR_THROW( outRaster->init(), "Unable to init outRaster" );

  PDIAGN_TRUE_OR_THROW( TePDIUtils::TeResetRaster( outRaster,
    inRaster->nBands(), inRaster->params().nlines_,
    inRaster->params().ncols_ ), "Raster reset error" );

  PDIAGN_TRUE_OR_THROW(
    TePDIUtils::TeCopyRasterPixels( inRaster, outRaster ),
    "Raster pixel copy error" );

  PDIAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( outRaster,
    "TeResetRaster_test.tif" ), "GeoTIF generation error" );
}

int main()
{
  PDIAGN_LOGMSG( "Test started." );

  PDIAGN_DEBUG_MODE_CHECK;

  try{
    TeInitRasterDecoders();

    TeGenerateHistogram_test();
    TeRaster2Geotiff_test();
    TeAllocRAMRaster_test();
    TeResetRaster_test();
  }
  catch(...){
    PDIAGN_LOGERR( "Test Failed.");
    return EXIT_FAILURE;
  }

  PDIAGN_LOGMSG( "Test OK." );
  return EXIT_SUCCESS;
}
