/************************************************************************************
TerraView - visualization and exploration of geographical databases
using TerraLib.
Copyright  2001-2004 INPE and Tecgraf/PUC-Rio.
This file is part of TerraView. TerraView is free software; you can redistribute it 
and/or modify it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

You should have received a copy of the GNU General Public License
along with TerraView.
The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular purpose.
The software provided hereunder is on an "as is" basis, and the authors have no
obligation to provide maintenance, support, updates, enhancements, or modifications.
In no event shall INPE and Tecgraf / PUC-Rio be held liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use of
this program and its documentation.
*************************************************************************************/

#include "TeApplicationUtils.h"
#include "TeSlice.h"
#include "TeDatabase.h"
#include "TeDatabaseUtils.h"
#include "TeColorUtils.h"

template<class iterator> extern void
TeGroupByEqualStep(iterator, iterator, int , vector<TeSlice>& , int);

extern void TeGroupByUniqueValue(vector<string>& vec, TeAttrDataType tipo, vector<TeSlice>& result, int precision);

bool generateCountLegends(TeThemeApplication* theme, string table, string field)
{
	if(theme == 0)
		return false;

	theme->groupObjects(TeAll);
	TeAttributeRep rep;
	rep.name_ = table + "." + field;
	rep.type_ = TeINT;
	
	TeGrouping* group = new TeGrouping();
	group->groupAttribute_ = rep;
	group->groupNormAttribute_ = "";
	group->groupMode_ = TeUniqueValue;
	group->groupPrecision_ = 0;
	theme->grouping(group);
	
	string	scor = "Cy-G-Y-Or-R";
	theme->groupColor(scor);
	theme->countObj(true);
	theme->mixColor(true);
	theme->groupColorDir(TeColorAscSatEnd);
	
	string	fieldId = theme->collectionTable() + ".c_object_id";
	TeLayer* layer = theme->layer();
	TeDatabase* db = layer->database();
    vector<TeSlice> result;
	vector<string> valVec;
	vector<string> idVec;

	string sel = "SELECT " + fieldId + ", " + field + theme->sqlFrom() + " ORDER BY " + field;

	TeDatabasePortal* portal = db->getPortal();
	if(portal->query(sel) == false)
	{
		delete portal;
		return false;
	}

	while(portal->fetchRow())
	{
		string objectId = portal->getData(0);
		string val = portal->getData(1);
		if (val.empty() == false)
		{
			valVec.push_back(val);
			idVec.push_back(objectId);
		}
	}
	delete portal;

	if(valVec.size()==0)
		return false;

	TeGroupByUniqueValue(valVec, TeINT, result, 0);
	theme->grouping()->groupNumSlices_ = result.size();

	vector<string> colorRamps;
	colorRamps.push_back("CYAN");
	colorRamps.push_back("GREEN");
	colorRamps.push_back("YELLOW");
	colorRamps.push_back("ORANGE");
	colorRamps.push_back("RED");
	vector<TeColor> colorVec;
	getColors(colorRamps,10, colorVec);

	TeVisual visual;
	if((layer->geomRep() & TePOLYGONS) || (layer->geomRep() & TeCELLS))
		visual = theme->defaultLegend().visual(TePOLYGONS);
	else if((layer->geomRep() & TeLINES))
		visual = theme->defaultLegend().visual(TeLINES);
	else if((layer->geomRep() & TePOINTS))
		visual = theme->defaultLegend().visual(TePOINTS);

	TeLegendEntryVector legVec;
	unsigned int i, j = 0;
	for(i = 0; i < result.size(); i++)
	{
		TeColor cor = colorVec[i];
		visual.color(cor);

		TeLegendEntry leg;
		leg.from(result[i].from_);
		leg.to(result[i].to_);
		if((layer->geomRep() & TePOLYGONS) || (layer->geomRep() & TeCELLS))
			leg.setVisual(visual, TePOLYGONS);
		else if((layer->geomRep() & TeLINES))
			leg.setVisual(visual, TeLINES);
		else if((layer->geomRep() & TePOINTS))
			leg.setVisual(visual, TePOINTS);

		int count = 0;
		while(j < valVec.size())
		{
			if(valVec[j] == leg.from())
			{
				count++;
				j++;
			}
			else
				break;
		}
		leg.count(count);
		leg.group(i);
		leg.theme(theme->id());
		string label = leg.from();
		leg.label(label);
		legVec.push_back(leg);
	}

	colorRamps.clear();
	colorVec.clear();

	db->deleteLegend(theme->id());
	map<int, vector<string> > legMap;
	for(i=j=0; i<legVec.size(); i++)
	{
		theme->legend().push_back(legVec[i]);
		if (db->insertLegend(&(theme->legend()[i])) == false)
			return false;

		vector<string> ids;
		TeLegendEntry& leg = theme->legend()[i];
		while(j < valVec.size())
		{
			if(valVec[j] == leg.from())
			{
				ids.push_back(idVec[j]);
				j++;
			}
			else
				break;
		}
		legMap[leg.id()] = ids;
	}

	map<int, vector<string> > :: iterator it = legMap.begin();
	while(it != legMap.end())
	{
		vector<string>::iterator itB = it->second.begin();
		vector<string>::iterator itE = it->second.end();
		vector<string> svec = generateInClauses(itB,itE,db);				

		for(i=0; i<svec.size(); i++)
		{
			string up = "UPDATE " + theme->collectionTable() + " SET c_legend_id = " + Te2String(it->first);
			up += " WHERE c_object_id IN " + svec[i];

			if(db->execute(up) == false)
				return false;
		}
		it++;
	}

	if(theme->legend().size())
		theme->visibleRep(theme->visibleRep() | 0x40000000);
	else
		theme->visibleRep(theme->visibleRep() & 0xbfffffff);

	if((db->updateGrouping (theme->id(), theme->grouping())) == false)
		return false;

	return(updateThemeApplication(db, theme));
}

void changeObjectStatus(ObjectInfo& info, string& uniqueId, string mode, int pointed)
{
	if(uniqueId.empty())
	{
		if(mode == "pointing")
			info.status_ ^= 0x1; // toggle least significant bit
		else if(mode == "shiftAndPointing")
		{
			if(pointed == 1)
				info.status_ |= 0x1; // set least significant bit
			else
				info.status_ &= 0x2; // reset least significant bit
		}
		return;
	}

	int& gs = info.uniqueMap_[uniqueId];
	int	os;

	if(mode == "pointing")
	{
		gs ^= 0x1; // toggle least significant bit

		set<int> statusSet;
		map<string, int>::iterator it = info.uniqueMap_.begin();
		while(it != info.uniqueMap_.end())
		{
			statusSet.insert(it->second);
			it++;
		}
		if(statusSet.find(3) != statusSet.end())
			os = 3;
		else if(statusSet.find(2) != statusSet.end() && statusSet.find(1) != statusSet.end())
			os = 3;
		else if(statusSet.find(2) != statusSet.end() && statusSet.find(1) == statusSet.end())
			os = 2;
		else if(statusSet.find(2) == statusSet.end() && statusSet.find(1) != statusSet.end())
			os = 1;
		else
			os = 0;
	}
	else if(mode == "shiftAndPointing")
	{
		if(pointed == 1)
			gs |= 0x1; // set least significant bit
		else
			gs &= 0x2; // reset least significant bit

		set<int> statusSet;
		map<string, int>::iterator it = info.uniqueMap_.begin();
		while(it != info.uniqueMap_.end())
		{
			statusSet.insert(it->second);
			it++;
		}
		if(statusSet.find(3) != statusSet.end())
			os = 3;
		else if(statusSet.find(2) != statusSet.end() && statusSet.find(1) != statusSet.end())
			os = 3;
		else if(statusSet.find(2) != statusSet.end() && statusSet.find(1) == statusSet.end())
			os = 2;
		else if(statusSet.find(2) == statusSet.end() && statusSet.find(1) != statusSet.end())
			os = 1;
		else
			os = 0;
	}

	info.status_ = os;
}

bool saveObjectStatus(TeThemeApplication *theme, set<string>& objectSet, map<string, ObjectInfo>& objectMap)
{
	unsigned int i;
    int os, gs;
	string	q, oid, uid;
	TeDatabase *db = theme->layer()->database();
	map<int, vector<string> > sameObjectStMap;
	map<int, vector<string> > sameGridStMap;

	set<string>::iterator setIt = objectSet.begin();
	while(setIt != objectSet.end())
	{
		oid = *setIt;
		ObjectInfo& info = objectMap[oid];
		os = info.status_;
		sameObjectStMap[os].push_back(oid);

		map<string, int>& gridMap = info.uniqueMap_;
		map<string, int>::iterator gridIt = gridMap.begin();
		while(gridIt != gridMap.end())
		{
			uid = gridIt->first;
			gs = gridIt->second;
			sameGridStMap[gs].push_back(uid);
			gridIt++;
		}
		setIt++;
	}

	string qUpdate = "UPDATE " + theme->collectionTable();
	map<int, vector<string> >::iterator it;
	for (it = sameObjectStMap.begin(); it != sameObjectStMap.end(); ++it)
	{
		vector<string>::iterator itB = it->second.begin();
		vector<string>::iterator itE = it->second.end();
		vector<string> inClauseVector = generateInClauses(itB,itE,db);				
		for (i = 0; i < inClauseVector.size(); ++i)
		{
			q = qUpdate + " SET c_object_status = " + Te2String(it->first);
			q += " WHERE c_object_id IN " + inClauseVector[i];

			if (db->execute(q) == false)
				return false;
		}
	}


	qUpdate = "UPDATE " + theme->collectionAuxTable();
	for (it = sameGridStMap.begin(); it != sameGridStMap.end(); ++it)
	{
		vector<string>::iterator itB = it->second.begin();
		vector<string>::iterator itE = it->second.end();
		vector<string> inClauseVector = generateInClauses(itB,itE,db);				
		for (i = 0; i < inClauseVector.size(); ++i)
		{
			q = qUpdate + " SET grid_status = " + Te2String(it->first);
			q += " WHERE unique_id IN " + inClauseVector[i];

			if (db->execute(q) == false)
				return false;
		}
	}
	return true;
}

string getStringFromStatistic(TeStatisticType sType)
{
	string ss;

	if(sType == TeSUM)
		ss = "SUM";
	else if(sType == TeMAXVALUE)
		ss = "MAXVALUE";
	else if(sType == TeMINVALUE)
		ss = "MINVALUE";
	else if(sType == TeCOUNT)
		ss = "COUNT";
	else if(sType == TeVALIDCOUNT)
		ss = "VALIDCOUNT";
	else if(sType == TeSTANDARDDEVIATION)
		ss = "STANDARDDEVIATION";
	else if(sType == TeKERNEL)
		ss = "KERNEL";
	else if(sType == TeMEAN)
		ss = "MEAN";
	else if(sType == TeVARIANCE)
		ss = "VARIANCE";
	else if(sType == TeSKEWNESS)
		ss = "SKEWNESS";
	else if(sType == TeKURTOSIS)
		ss = "KURTOSIS";
	else if(sType == TeAMPLITUDE)
		ss = "AMPLITUDE";
	else if(sType == TeMEDIAN)
		ss = "MEDIAN";
	else if(sType == TeVARCOEFF)
		ss = "VARCOEFF";
	else if(sType == TeMODE)
		ss = "MODE";

	return ss;
}

TeStatisticType getStatisticFromString(const string& s)
{
	TeStatisticType sType;

	if(s == "TeSUM")
		sType = TeSUM;
	else if(s == "TeMAXVALUE")
		sType = TeMAXVALUE;
	else if(s == "TeMINVALUE")
		sType = TeMINVALUE;
	else if(s == "TeCOUNT")
		sType = TeCOUNT;
	else if(s == "TeVALIDCOUNT")
		sType = TeVALIDCOUNT;
	else if(s == "TeSTANDARDDEVIATION")
		sType = TeSTANDARDDEVIATION;
	else if(s == "TeKERNEL")
		sType = TeKERNEL;
	else if(s == "TeMEAN")
		sType = TeMEAN;
	else if(s == "TeVARIANCE")
		sType = TeVARIANCE;
	else if(s == "TeSKEWNESS")
		sType = TeSKEWNESS;
	else if(s == "TeKURTOSIS")
		sType = TeKURTOSIS;
	else if(s == "TeAMPLITUDE")
		sType = TeAMPLITUDE;
	else if(s == "TeMEDIAN")
		sType = TeMEDIAN;
	else if(s == "TeVARCOEFF")
		sType = TeVARCOEFF;
	else if(s == "TeMODE")
		sType = TeMODE;

	return sType;
}
	
	
