/************************************************************************************
TerraLib - a library for developing GIS applications.
Copyright  2001-2004 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular purpose.
The library provided hereunder is on an "as is" basis, and the authors have no
obligation to provide maintenance, support, updates, enhancements, or modifications.
In no event shall INPE and Tecgraf / PUC-Rio be held liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use
of this library and its documentation.
*************************************************************************************/
/*! \file TeDefines.h
    Provides a set of general definitions used by Terralib
*/
#ifndef  __TERRALIB_INTERNAL_DEFINES_H
#define  __TERRALIB_INTERNAL_DEFINES_H

const int		TeNAME_LENGTH = 400;				//<! A default name lenght
const double	TeMAXFLOAT =	3.4E37;				//<! Maximum float value
const double	TeMINFLOAT =	3.4E-37;			//<! Minimum float value
const double	TePI  =	3.14159265358979323846;		//<! The ratio of the circumference to the diameter of a circle
const double	TeCDR =	0.01745329251994329576;		//<! Conversion factor: degrees to radians
const double	TeCRD = 57.29577951308232087679;	//<!Conversion factor: radians to degrees


// General position definitions
#define	TeUNKNOWNPOSITION  0
#define	TeINSIDE		   1
#define	TeOUTSIDE		   2
#define	TeBOUNDARY		   4


// Intersection type
#define TeINTERIORINTERIOR 8
#define TeINTERIORBOUNDARY 16
#define TeINTERIOREXTERIOR 32
#define TeBOUNDARYINTERIOR 64
#define TeBOUNDARYBOUNDARY 128
#define TeBOUNDARYEXTERIOR 256
#define TeEXTERIORINTERIOR 512
#define TeEXTERIORBOUNDARY 1024
#define TeEXTERIOREXTERIOR 2048

// Segment intersection
#define TeDONT_INTERSECT 0
#define TeDO_INTERSECT   1
//#define TeCOLLINEAR      2
#define TeAT_ENDPOINT    4

#ifndef MAX
#define MAX(a,b) a>b?a:b
#endif

#ifndef MIN
#define MIN(a,b) a<b?a:b
#endif

#ifndef ABS
#define ABS(x) 	( ((x) >= 0) ? (x) : -(x) )
#endif

// Orientation
#define TeNOTURN			 0
#define TeCOLLINEAR			 0
#define TeCLOCKWISE   		-1
#define TeCOUNTERCLOCKWISE	 1

// Operation
#define TeDIFFERENCE   1
#define TeUNION        2
#define TeINTERSECTION 4

#endif

