/************************************************************************************
TerraLib - a library for developing GIS applications.
Copyright  2001-2004 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular purpose.
The library provided hereunder is on an "as is" basis, and the authors have no
obligation to provide maintenance, support, updates, enhancements, or modifications.
In no event shall INPE and Tecgraf / PUC-Rio be held liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use
of this library and its documentation.
*************************************************************************************/

/*! \file TeOverlay.h
    This file contains structures and definitions for set operation on objects.
 */

/**
  *@author Gilberto Ribeiro de Queiroz
  */

#ifndef  __TERRALIB_INTERNAL_OVERLAY_H
#define  __TERRALIB_INTERNAL_OVERLAY_H

#include "TeMultiGeometry.h"


namespace TeOVERLAY
{	

bool TeOverlay(const TePolygonSet& redPols, const TePolygonSet& bluePols, TePolygonSet& polsOut, const short& operation);

inline bool TeUnion(TePolygonSet& redPols, TePolygonSet& bluePols, TePolygonSet& polsOut)
{
	return TeOverlay(redPols, bluePols, polsOut, TeUNION);
}

inline bool TeIntersection(TePolygonSet& redPols, TePolygonSet& bluePols, TePolygonSet& polsOut)
{
	return TeOverlay(redPols, bluePols, polsOut, TeINTERSECTION);
}

inline bool TeDifference(TePolygonSet& redPols, TePolygonSet& bluePols, TePolygonSet& polsOut)
{
	return TeOverlay(redPols, bluePols, polsOut, TeDIFFERENCE);
}

TeMultiGeometry TeOverlay(const TeLineSet& redLines, const TePolygonSet& bluePols, const short& operation);

inline TeMultiGeometry TeUnion(TeLineSet& redLines, TePolygonSet& bluePols)
{
	return TeOverlay(redLines, bluePols, TeUNION);
}

inline TeMultiGeometry TeIntersection(TeLineSet& redLines, TePolygonSet& bluePols)
{
	return TeOverlay(redLines, bluePols, TeINTERSECTION);
}

inline TeMultiGeometry TeDifference(TeLineSet& redLines, TePolygonSet& bluePols)
{
	return TeOverlay(redLines, bluePols, TeDIFFERENCE);
}

}	// end namespace TeOVERLAY

#endif //__TERRALIB_INTERNAL_OVERLAY_H

