/************************************************************************************
TerraLib - a library for developing GIS applications.
Copyright  2001-2004 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular purpose.
The library provided hereunder is on an "as is" basis, and the authors have no
obligation to provide maintenance, support, updates, enhancements, or modifications.
In no event shall INPE and Tecgraf / PUC-Rio be held liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use
of this library and its documentation.
*************************************************************************************/

#ifndef  __TERRALIB_INTERNAL_QUERIER_H
#define  __TERRALIB_INTERNAL_QUERIER_H

#include "TeSTInstance.h"
#include "TeTemporalSeries.h"

class TeQuerierParams;
class TeQuerierImpl; 

//! A class to build spatial temporal instances (STInstance) from different sources 
class TeQuerier
{
	
	protected:
		TeQuerierImpl*		Impl_;  //! handle/bory pattern
		
	public:
		
		//! Empty constructor
		TeQuerier():
			Impl_(0)
			{} 
			
		//! Constructor
		TeQuerier(TeQuerierParams& params);
				
		//! Destructor
		~TeQuerier(); 
		
		//! Returns the theme
		TeTheme* theme();
		
	 	//! Loads the STInstances. If frame>-1, loads only the instances of the frame-simo frame 
		bool loadInstances(int frame=-1);  
		
		//! Returns each spatial temporal instance 
		bool fetchInstance(TeSTInstance&  sto);

		//! Return the number of time frames generated by the chronon	
		int getNumTimeFrames(); 

		//! Gets each temporal serie entry, for each time frame
		bool getTSEntry(TeTSEntry& tsEntry, int frame);
		
		//! Gets the full temporal serie
		bool getTS(TeTemporalSeries& ts); 
		
		//! Returns the temporal serie params
		TeTSParams& getTSParams();
		
		//! Gets the attribute list from querier
		TeAttributeList getAttrList();

		//! Returns the number of instances to each time frame
		int numElemInstances(); 

		//! Returns the querier parameters
		TeQuerierParams& params(); 

		//! Empties querier instances
		void clear(); 

		//! Refresh the querier based in new querier params
		void refresh(TeQuerierParams& params); 
};


#endif 



