/************************************************************************************
TerraLib - a library for developing GIS applications.
Copyright  2001-2004 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular purpose.
The library provided hereunder is on an "as is" basis, and the authors have no
obligation to provide maintenance, support, updates, enhancements, or modifications.
In no event shall INPE and Tecgraf / PUC-Rio be held liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use
of this library and its documentation.
*************************************************************************************/

/*! \file TeTreeMinimum.h
    This file contains functions related to the Tree Minimum clustering algorithm
*/
#ifndef  __TERRALIB_INTERNAL_TREEMINIMUM_H
#define  __TERRALIB_INTERNAL_TREEMINIMUM_H

#include <vector>
#include <map>
#include <string>

#include "TeSelectedObject.h"
#include "TeSpatialStatistics.h"
#include "TeLayer.h"

using namespace std;

class graph_link
{
public:
	string GeoId1_;
	string GeoId2_;
	double Dissimilarity_;

	~graph_link()
	{}


	graph_link() :
		GeoId1_(""),
		GeoId2_("")
	{}

	graph_link(const string& GeoId1, const string& GeoId2):
		GeoId1_(GeoId1),
		GeoId2_(GeoId2)
	{}

	graph_link(const string& GeoId1, const string& GeoId2, const double Dissimilarity)  :
		GeoId1_(GeoId1),
		GeoId2_(GeoId2),
		Dissimilarity_(Dissimilarity)
	{}

 
	void set_Dissimilatiry (const double Dissimilarity)
	{	Dissimilarity_ = Dissimilarity;	}

	bool compare_dissimilarity(const graph_link &graph_link1, const graph_link &graph_link2);
//	bool graph_link::operator<(const graph_link &graph_link1, const graph_link &graph_link2);
};



typedef vector<graph_link> graph;

typedef map<string,graph> matrix;

void TeCreateDissMatrix (TeSelectedObjectMap& Objects, TeProxMatrix& proxMatrix,
					   matrix& mat_diss, double& Diss_max);

void TeCreateMinimumTree ( TeSelectedObjectMap& Objects, matrix& DissMatrix, graph& Min_Tree, double Diss_max);

void TeCreateSubTrees( TeSelectedObjectMap& Objects, graph& Min_Tree,
					  TeSelectedObjectMap& result, int num_regioes);

#endif