#include <stdio.h>
#include <assert.h>
#include "common.h"
#include "string.h"

int main( int argc, char **argv ) {
  c_string s;
  float f;
  int i,j;
  a_rect r, r2;
  int b;
  str255list_list sl = str255list_null;
  str255 s255;
  str255list_a_list_index li;

  printf( "Starting Ada run-time...\n" );
  adainit();
  printf( "Success\n\n" );

  startup_common( "test suite", "test" );

  // Startup and Related Global Variables

  printf( "Startup tests...\n" );
  strncpy( s, program_name.chars, program_name.length );
  s[ program_name.length ] = '\0';
  assert( strcmp( s, "test suite" ) == 0 );
  strncpy( s, short_program_name.chars, short_program_name.length );
  s[ short_program_name.length ] = '\0';
  assert( strcmp( s, "test" ) == 0 );
  printf( "Success\n\n" );

  // Math Function Tests

  printf( "Math function tests...\n" );

  f = CSin( 0.0 );
  assert( f == 0.0 );
  f = CCos( 0.0 );
  assert( f == 1.0 );
  i = Crnd( 5 );
  assert( i > 0 && i < 6 );
  i = Cnormalrnd( 5 );
  assert( i > 0 && i < 6 );
  i = COdds( 50 );
  assert( i == 0 || i == 1 );
  Csetrndseed( 1 );
  i = Crnd( 5 );
  Csetrndseed( 1 );
  j = Crnd( 5 );
  assert( i == j );
  printf( "Success\n\n" );

  // Rectangle Tests

  printf( "Rectangle tests...\n" );

  set_rect( &r, 1, 2, 3, 4 );
  assert( r.left   == 1 );
  assert( r.top    == 2 );
  assert( r.right  == 3 );
  assert( r.bottom == 4 );

  r2 = offset_rect( &r, 1, 2 );
  assert( r2.left   == 2 );
  assert( r2.top    == 4 );
  assert( r2.right  == 4 );
  assert( r2.bottom == 6 );

  r = inset_rect( &r2, -1, -2 );
  assert( r.left   == 1 );
  assert( r.top    == 2 );
  assert( r.right  == 5 );
  assert( r.bottom == 8 );

  set_rect( &r, 10, 10, 20, 20 );
  set_rect( &r2, 12, 12, 18, 18 );
  b = inside_rect( &r2, &r );
  assert( b == 1 );
  b = inside_rect( &r, &r2 );
  assert( b == 0 );

  set_rect( &r, 10, 10, 20, 20 );
  b = in_rect( 15, 15, &r );
  assert( b == 1 );
  b = in_rect( 1, 1, &r );
  assert( b == 0 );

  assert( null_rect.left == 0 );
  assert( null_rect.top  == 0 );
  assert( null_rect.right == -1 );
  assert( null_rect.bottom == -1 );

  // There's a problem with is_empty_rect.
  // b = is_empty_rect( &null_rect );
  // printf( "left   = %d\n", null_rect.left );
  // printf( "top    = %d\n", null_rect.top );
  // printf( "right  = %d\n", null_rect.right );
  // printf( "bottom = %d\n", null_rect.bottom );
  // printf( "result = %d\n", b );
  // printf( "A\n" );
  // assert( b == 1 );
  // set_rect( &r, 10, 10, 20, 20 );
  // b = is_empty_rect( &r );
  // assert( b == 0 );
  printf( "Success\n\n" );

  // Error handling

  printf( "Error handling tests...\n" );
  i = TT_not_yet_written;
  i = TT_ok;
  i = TT_memory_leak;
  i = TT_low_memory;

  last_error = TT_low_memory;
  assert( last_error == TT_low_memory );

  // no_error();
  // assert( last_error == TT_ok );

  // error( TT_not_yet_written );
  // assert( last_error == TT_not_yet_written );

  printf( "Success\n\n" );

  printf( "String list tests...\n" );
  b = str255list_is_empty( &sl );
  printf( "is_empty is %d\n", b );
  li = str255list_length( &sl );
  printf( "length is %d\n", li );
  assert( b == 1 );
  li = str255list_length( &sl );
  assert( li == 0 );

  printf( "Success\n\n" );

  shutdown_common();
  adafinal();

  return 0;

}

