/*
 * Ostatnia aktualizacja:
 *
 * - $Id: message.c,v 1.20 2003/10/15 16:32:29 mati Exp $
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include "libtlen.h"

/*
 * tlen_sendmsg()
 *
 * Wysya wiadomo
 *
 * - sesja - nasza sesja
 * - destination - osoba, do ktrej wysyamy wiadomo
 * - message - tre wiadomoci
 * - type - typ wiadomoci, TLEN_CHAT lub TLEN_MESSAGE
 *
 * Trzeba okreli w parametrze type rodzaj wysyanej wiadomoci 
 *
 */

int tlen_sendmsg(struct tlen_session *sesja, const char *destination, const char *message, int type)
{
	char *query;
	char *urlencoded;
	char *msgtype;

	urlencoded = tlen_encode(message);
	
	switch (type)
	{
	    case TLEN_MESSAGE:
		{
		    msgtype = "normal";
		    break;
		}
	    case TLEN_CHAT:
		{
		    msgtype = "chat";
		    break;
		}
	    default:
		{
		    msgtype = "chat";
		    break;
		}
	}
	
	tlen_debug ("To: %s\nMessage: %s\nTyp: %s\n", destination, message, msgtype);
	if (!(query = (char *) malloc (strlen ("<message to='' type=''><body></body></message>") + strlen (destination) + strlen (urlencoded) + strlen(msgtype)+1)))
	{
		perror ("malloc");
		sesja->error = TLEN_ERROR_MALLOC;
	}
	sprintf (query, "<message to='%s' type='%s'><body>%s</body></message>", destination, msgtype, urlencoded);
	tlen_socket_write_string (sesja, query);

	free (query);
	free (urlencoded);
	return 1;
}

/*
 * tlen_sendnotify()
 *
 * Wysya powiadomienie
 *
 * - sesja - nasza sesja
 * - destination - osoba, do ktrej wysyamy wiadomo
 * - type - typ powiadomienia, TLEN_NOTIFY_TYPING, TLEN_NOTIFY_NOTTYPING lub TLEN_NOTIFY_SOUNDALERT
 *
 * Trzeba okreli w parametrze type rodzaj wysyanego powiadomienia
 *
 */

int tlen_sendnotify(struct tlen_session *sesja, const char *destination, int type)
{
	char *query;
	char *notifytype;

	switch (type)
	{
	    case TLEN_NOTIFY_TYPING:
		{
		    notifytype = "t";
		    break;
		}
	    case TLEN_NOTIFY_NOTTYPING:
		{
		    notifytype = "u";
		    break;
		}
	    case TLEN_NOTIFY_SOUNDALERT:
		{
		    notifytype = "a";
		    break;
		}    
	    default:
		{
		    notifytype = "t"; // domyslnie TYPING
		    break;
		}
	}
	
	tlen_debug ("To: %s\nType: %s\n", destination, notifytype);
	if (!(query = (char *) malloc (strlen ("<m to='' tp=''/>") + strlen (destination) + strlen(notifytype)+1)))
	{
		perror ("malloc");
		sesja->error = TLEN_ERROR_MALLOC;
	}
	sprintf (query, "<m to='%s' tp='%s'/>", destination, notifytype);
	tlen_socket_write_string (sesja, query);

	free (query);
	return 1;
}
