static GtkWidget *count_label;
static gboolean count_cancelled;
static GtkWidget *countW = NULL;
static int counttimer, countT, smallcount;
static long long sizeT;
static gchar child_file[_POSIX_PATH_MAX];
static widgets_t *count_widgets_p;


static 
int recursive_count_files (char *path)
{
    DIR *directory;
    struct dirent *dir;
    char fullpath[_POSIX_PATH_MAX];
    struct stat st;

    directory = opendir(path);
    if(!directory)
    {
	return -1;
    }
	/*fprintf(stderr,"dbg:%s file=%d size=%ld\n",path,countT,sizeT);*/
    while((dir = readdir(directory)) != NULL && !count_cancelled)
    {
	if(strcmp(dir->d_name, ".") == 0 || strcmp(dir->d_name, "..") == 0)
	    continue;
	if(strlen(path) + strlen(dir->d_name) + 2 > _POSIX_PATH_MAX)
	{
	    printf("TRACE:%s/%s\n", path, dir->d_name);
	    assert_not_reached();
	}
	sprintf(fullpath, "%s/%s", path, dir->d_name);
	countT++;
	if (lstat(fullpath, &st) != -1) {
	  smallcount++;
	  sizeT += st.st_size;
	}
	if(S_ISDIR(st.st_mode))
	    recursive_count_files(fullpath);
	else if(smallcount & 0x100)
	{
	    gchar *g=g_strdup_printf(dngettext(GETTEXT_PACKAGE,"%d file","%d files",countT), countT);
	    smallcount = 0;
	    gtk_label_set_text((GtkLabel *) count_label, g);
	    g_free(g);
    	    process_pending_gtk();
	}
    }
    closedir(directory);
    return (1);
}

static gint ParentCount(gpointer data)
{
    FILE *tfile;
    char *line, *source;
    int type;
    struct stat st;

    g_source_remove(counttimer);
    counttimer = 0;
    smallcount = 0;
    countT = 0;
    sizeT = 0;
    line = (char *)malloc(MAX_LINE_SIZE);
    if(!line)
	assert_not_reached();
    tfile = fopen(child_file, "r");
    if(!tfile)
	assert_not_reached();
    TRACE("TRACE: opened %s\n",child_file);
    while(fgets(line, MAX_LINE_SIZE - 1, tfile) && !feof(tfile) && !count_cancelled)
    {
	type = atoi(strtok(line, "\t"));
	source = strtok(NULL, "\t");
	recursive_count_files(source);
	countT++;
	if (lstat(source, &st) != -1) {
	  sizeT += st.st_size;
	}
	/*fprintf(stderr,"dbg:%s file=%d size=%ld\n",line,countT,sizeT);*/
	sprintf(line, "%s", sizetag((off_t)sizeT, countT));
	print_status(count_widgets_p,"xffm/info", line, NULL);
    }
    fclose(tfile);
    g_free(line);
    line=NULL;
    gtk_main_quit();
    return FALSE;
}


static void cb_count_destroy(GtkWidget * widget, gpointer data)
{
    count_cancelled = TRUE;	/* for user destruction */
    countW = NULL;
}
static void cb_count_cancel(GtkWidget * widget, gpointer data)
{
    count_cancelled = TRUE;	/* for user destruction */
    gtk_widget_destroy(countW);
    countW = NULL;
}


