#ifndef MENU_H__
#define MENU_H__
#define MENU_PIXMAP 	0
#define BIGGER_MENU_PIXMAP 	10
#define BUTTON_PIXMAP	1
#define BIGGER_BUTTON_PIXMAP	11
#define OTHER_PIXMAP	2

typedef struct autotype_t{
	char *extension;
	char *command;
	char *label;
	char *querypath;
	gboolean queued;
}autotype_t;

typedef struct keybind_t {
    guint key;
    guint mask;
    gpointer callback;
} keybind_t;

void gui_autostuff(	widgets_t *widgets_p, 
			gpointer gui_data, 
			GtkWidget *popup,
			record_entry_t *en, 
			gpointer callback,
			gpointer on_mount,
			gpointer on_unmount);
void 
gui_add_autotype_C_widgets(	widgets_t *widgets_p,
			gpointer gui_data,
			GtkWidget *popup,
			gpointer callback, 
			gpointer on_mount,
			gpointer on_unmount);

gboolean 
gui_common_mask_key(GdkEventKey *event, void *data);

void 
gui_add_to_keylist(guint key, guint mask, gpointer callback);
int 
gui_keybind_exec(guint key, guint mask, void *data);

GtkWidget * 
gui_add_menu_separator(	GtkWidget *parent);

void 
gui_mk_module_popup_menu (	widgets_t *widgets_p, 
				const gchar *module_name,
				gpointer gui_data,
				record_entry_t *en);

GtkWidget *
gui_mk_pixmap_menu(	widgets_t *widgets_p, 
			const gchar *file,
			GtkWidget *parent,
			int caso) ;


GtkWidget *
gui_mk_input_box(	widgets_t *widgets_p,
			GtkWidget *parent,
			gpointer user_data);

GtkWidget *
gui_mk_menu(		widgets_t *widgets_p,
			const gchar * label,
			const gchar *name, 
			GtkWidget *parent, 
			gpointer callback, 
			const gchar *iconfile);

GtkWidget *
gui_mk_radio_button(	widgets_t *widgets_p,
			const gchar *label, 
			const gchar *name,
			GtkWidget *parent,
			GSList **radiogroup);

const gchar *
gui_get_response(		widgets_t *widgets_p, 
				const gchar *title_txt, 
				const gchar *label_txt);
const gchar *
gui_get_response_history(	widgets_t *widgets_p, 
				const gchar *title_txt, 
				const gchar *label_txt,
				gchar *history_file,
				const gchar *path,
				const gchar *entry_text);

void
gui_add_menu_item(	widgets_t *widgets_p,
			GtkWidget *parent,
			const gchar *label,
			const gchar *icon_id,
			const gchar *name,
			gpointer callback,
			gpointer callback_data,
			GtkAccelGroup *accel_group,
			guint accel_key,
			guint accel_mask
			);

void
gui_autofunction  (		widgets_t *widgets_p, 
			record_entry_t *en,
			const gchar **arguments,
			gboolean queued);


void
gui_on_close_activate  (GtkMenuItem     *menuitem,
                                        gpointer         user_data);


#endif
