# -*- ruby -*-
#
# Using '*' and '**' in data ID.
#

require 'xtemplate'

text = <<EOF
<?xml version="1.0"?>
<data>
<members>
  <member id="/*[name and age]">
     <name id="name"></name>
     <age id="age"></age>
  </member>
</members>
<members>
  <member id="/**[name and age]">
     <name id="name"></name>
     <age id="age"></age>
  </member>
</members>
</data>
EOF

data = {
  "members" => [
    {"name" => "name1", "age" => 21},
    {"name" => "name2", "age" => 22},
    {"name" => "name3"},
  ],
  "staff" => {
    "staff1" => [
       {"name" => "name4", "age" => 24},
       {"name" => "name5", "age" => 27},
    ],
    "staff2" => [
       {"name" => "name6", "age" => 28},
       {"name" => "name7"},
    ],
  }
}

print XTemplate::XMLTemplate.new(text).expand(data)
