# -*- ruby -*-
#
# Using an internal stack.
#

require 'xtemplate'
require 'xtemplate/xml'

doc = XTemplate::XMLDocument.new(<<EOF)
<?xml version="1.0"?>
<members xmlns:xt="#{XTemplate::BIND_URI}">
  <member><uid xt:type="int">1</uid><name>name1&apos;</name><email>&lt;name1@com&gt;</email></member>
  <member><uid xt:type="int">2</uid><name>name2&apos;</name><email>&lt;name2@com&gt;</email></member>
  <member><uid xt:type="int">3</uid><name>name3&apos;</name><email>&lt;name3@com&gt;</email></member>
</members>
EOF

data = {
  'members' => [
    {'member' => {'name' => 'name1\'', 'uid' => 1, 'email' => '<name1@com>'}},
    {'member' => {'name' => 'name2\'', 'uid' => 2, 'email' => '<name2@com>'}},
    {'member' => {'name' => 'name3\'', 'uid' => 3, 'email' => '<name3@com>'}},
  ]
}

text = <<EOF
<?xml version="1.0" encoding="UTF-8"?>
<members xmlns:xt="#{XTemplate::BIND_URI}">
   <xt:select id="/members/member">
     <xt:element name="@{name}">
        <xt:attribute name="uid" id="uid"></xt:attribute>
        <xt:attribute name="email" id="email"></xt:attribute>
        <xt:value-of id="name" />
        <xt:value-of id="email" />
     </xt:element>
   </xt:select>
</members>
EOF

t = XTemplate::XMLTemplate.new(text)
print(t.expand(doc))
print("\n")
print(t.expand(data))
