# -*- ruby -*-
# Select nodes with '[condition]'.
#

require 'xtemplate'

data = {
  'members' => [
    {'name' => 'name1', 'age' => 21, '@uid' => 1},
    {'name' => 'name2', 'age' => 22, '@uid' => 2},
    {'name' => 'name3', 'age' => 23, '@uid' => 3},
  ],
}

text = <<EOF
<?xml version="1.0" encoding="UTF-8"?>
<members>
  <!-- The following members are older than 21. -->
  <member id="members[age &gt; 21]">
     <name id="name" />
     <age id="age" />
  </member>
</members>
EOF

t = XTemplate::XMLTemplate.new(text)
print(t.expand(data))
