/*
    Copyright (c) 1999-2001 the KMime authors.
    See file AUTHORS for details

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef __KMIME_BOOLFLAGS_H__
#define __KMIME_BOOLFLAGS_H__

/** This class stores boolean values in single bytes.
    It provides a similar functionality as QBitArray
    but requires much less memory.
    We use it to store the flags of an article
    @internal
*/
class BoolFlags {

public:
  BoolFlags()       { clear(); }
  ~BoolFlags()      {}

  void set(unsigned int i, bool b=true);
  bool get(unsigned int i);
  void clear()            { bits[0]=0; bits[1]=0; }
  unsigned char *data()   { return bits; }

protected:
  unsigned char bits[2];  //space for 16 flags
};

#endif // __KMIME_BOOLFLAGS_H__
