/* This file is part of the KDE project
   Copyright (C) 2005 Bram Schoenmakers <bramschoenmakers@kde.nl>
   Copyright (C) 2006 Tom Albers <tomalbers@kde.nl>
   Copyright (C) 2006-2007 KovoKs <info@kovoks.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef TOOLTIP_H
#define TOOLTIP_H

#include <qdatetime.h>
#include <qimage.h>

#include <kpassivepopup.h>

namespace Mailody {

/**
 * @class ToolTip
 * This frame is shown as a tooltip, when there is new mail
 * @author Bram Schoenmakers <bramschoenmakers@kde.nl>
 */
class ToolTip : public KPassivePopup
{
    Q_OBJECT
    public:
        /**
         * Constructor
         */
        ToolTip( QWidget *parent = 0, const char *name = 0 );

        /**
         * Destruction
         */
        ~ToolTip();

        /**
         * Adds this mb to the blocklist. It will not popup for 10 seconds.
         */
        void addToBlockList(const QString& mb);

    public slots:
        /**
         * Sets the tooltip to display @p text text
         * But not when @p mb is on the block list
         */
        void setText( const QString &mb, const QString &text);

        /**
         * Just display @p text at @p point
         */
        void setText(const QPoint& point, const QString &text);

    private:
        QLabel                  *mText;
        QTimer*                  m_clearTimer;
        QMap<QString, bool>      m_blockList;

    protected:
        void mouseReleaseEvent( QMouseEvent * e );
        void contextMenuEvent( QContextMenuEvent * e );

    private slots:
        void clearBlockList();

    signals:
        void leftClicked(const QString&);
        void rightClicked(const QString&);
};

}

#endif
