/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.21
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */


#if defined(__GNUC__)
    typedef long long __int64; /*For gcc on Windows */
#endif
#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" } };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  (*jenv)->ExceptionClear(jenv);
  excep = (*jenv)->FindClass(jenv, except_ptr->java_exception);
  if (excep)
    (*jenv)->ThrowNew(jenv, excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else


#include "../../map.h"
#include "../../maptemplate.h"
#include "../../mapogcsld.h"
#include "../../mapows.h"
#include "../../cgiutil.h"
#include "../../mapcopy.h"
#include "../../maperror.h"
#include "../../mapprimitive.h"
#include "../../mapshape.h"

#ifdef SWIGPYTHON
#include "pygdioctx/pygdioctx.h"
#endif



#define  SWIG_MemoryError    1
#define  SWIG_IOError        2
#define  SWIG_RuntimeError   3
#define  SWIG_IndexError     4
#define  SWIG_TypeError      5
#define  SWIG_DivisionByZero 6
#define  SWIG_OverflowError  7
#define  SWIG_SyntaxError    8
#define  SWIG_ValueError     9
#define  SWIG_SystemError   10
#define  SWIG_UnknownError  99


static void SWIG_JavaException(JNIEnv *jenv, int code, const char *msg) {
  SWIG_JavaExceptionCodes exception_code = SWIG_JavaUnknownError;
  switch(code) {
  case SWIG_MemoryError:
    exception_code = SWIG_JavaOutOfMemoryError;
    break;
  case SWIG_IOError:
    exception_code = SWIG_JavaIOException;
    break;
  case SWIG_SystemError:
  case SWIG_RuntimeError:
    exception_code = SWIG_JavaRuntimeException;
    break;
  case SWIG_OverflowError:
  case SWIG_IndexError:
    exception_code = SWIG_JavaIndexOutOfBoundsException;
    break;
  case SWIG_DivisionByZero:
    exception_code = SWIG_JavaArithmeticException;
    break;
  case SWIG_SyntaxError:
  case SWIG_ValueError:
  case SWIG_TypeError:
    exception_code = SWIG_JavaIllegalArgumentException;
    break;
  case SWIG_UnknownError:
  default:
    exception_code = SWIG_JavaUnknownError;
    break;
  }
  SWIG_JavaThrowException(jenv, exception_code, msg);
}
#define SWIG_exception(code, msg) { SWIG_JavaException(jenv, code, msg); }


typedef int intarray;

intarray *new_intarray(int nelements){
  return (int *) calloc(nelements,sizeof(int));
}
void delete_intarray(intarray *self){
  free(self);
}
int intarray_getitem(intarray *self,int index){
  return self[index];
}
void intarray_setitem(intarray *self,int index,int value){
  self[index] = value;
}
int *intarray_cast(intarray *self){
  return self;
}
intarray *intarray_frompointer(int *t){
  return (intarray *) t;
}

#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
    unsigned char *data;
    int size;
    int owns_data;
} gdBuffer;

#ifdef __cplusplus
}
#endif


#if defined(SWIG_NOINCLUDE) || defined(SWIG_NOARRAYS)


int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input);
void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input);
jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz);


int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input);
void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input);
jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz);


int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input);
void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input);
jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz);


int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input);
void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input);
jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz);


int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input);
void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input);
jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz);


int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input);
void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input);
jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz);


int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input);
void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input);
jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz);


int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input);
void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input);
jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz);


int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input);
void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input);
jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz);


int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input);
void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input);
jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz);


int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input);
void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input);
jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz);


#else


/* signed char[] support */
int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = (*jenv)->GetArrayLength(jenv, input);
  *jarr = (*jenv)->GetByteArrayElements(jenv, input, 0);
  if (!*jarr)
    return 0; 
  *carr = (signed char*) calloc(sz, sizeof(signed char)); 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (signed char)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input) {
  int i;
  jsize sz = (*jenv)->GetArrayLength(jenv, input);
  for (i=0; i<sz; i++)
    jarr[i] = (jbyte)carr[i];
  (*jenv)->ReleaseByteArrayElements(jenv, input, jarr, 0);
}

jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz) {
  jbyte *arr;
  int i;
  jbyteArray jresult = (*jenv)->NewByteArray(jenv, sz);
  if (!jresult)
    return NULL;
  arr = (*jenv)->GetByteArrayElements(jenv, jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jbyte)result[i];
  (*jenv)->ReleaseByteArrayElements(jenv, jresult, arr, 0);
  return jresult;
}


/* unsigned char[] support */
int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = (*jenv)->GetArrayLength(jenv, input);
  *jarr = (*jenv)->GetShortArrayElements(jenv, input, 0);
  if (!*jarr)
    return 0; 
  *carr = (unsigned char*) calloc(sz, sizeof(unsigned char)); 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned char)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input) {
  int i;
  jsize sz = (*jenv)->GetArrayLength(jenv, input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  (*jenv)->ReleaseShortArrayElements(jenv, input, jarr, 0);
}

jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = (*jenv)->NewShortArray(jenv, sz);
  if (!jresult)
    return NULL;
  arr = (*jenv)->GetShortArrayElements(jenv, jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  (*jenv)->ReleaseShortArrayElements(jenv, jresult, arr, 0);
  return jresult;
}


/* short[] support */
int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = (*jenv)->GetArrayLength(jenv, input);
  *jarr = (*jenv)->GetShortArrayElements(jenv, input, 0);
  if (!*jarr)
    return 0; 
  *carr = (short*) calloc(sz, sizeof(short)); 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (short)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input) {
  int i;
  jsize sz = (*jenv)->GetArrayLength(jenv, input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  (*jenv)->ReleaseShortArrayElements(jenv, input, jarr, 0);
}

jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = (*jenv)->NewShortArray(jenv, sz);
  if (!jresult)
    return NULL;
  arr = (*jenv)->GetShortArrayElements(jenv, jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  (*jenv)->ReleaseShortArrayElements(jenv, jresult, arr, 0);
  return jresult;
}


/* unsigned short[] support */
int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = (*jenv)->GetArrayLength(jenv, input);
  *jarr = (*jenv)->GetIntArrayElements(jenv, input, 0);
  if (!*jarr)
    return 0; 
  *carr = (unsigned short*) calloc(sz, sizeof(unsigned short)); 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned short)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input) {
  int i;
  jsize sz = (*jenv)->GetArrayLength(jenv, input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  (*jenv)->ReleaseIntArrayElements(jenv, input, jarr, 0);
}

jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = (*jenv)->NewIntArray(jenv, sz);
  if (!jresult)
    return NULL;
  arr = (*jenv)->GetIntArrayElements(jenv, jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  (*jenv)->ReleaseIntArrayElements(jenv, jresult, arr, 0);
  return jresult;
}


/* int[] support */
int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = (*jenv)->GetArrayLength(jenv, input);
  *jarr = (*jenv)->GetIntArrayElements(jenv, input, 0);
  if (!*jarr)
    return 0; 
  *carr = (int*) calloc(sz, sizeof(int)); 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (int)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input) {
  int i;
  jsize sz = (*jenv)->GetArrayLength(jenv, input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  (*jenv)->ReleaseIntArrayElements(jenv, input, jarr, 0);
}

jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = (*jenv)->NewIntArray(jenv, sz);
  if (!jresult)
    return NULL;
  arr = (*jenv)->GetIntArrayElements(jenv, jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  (*jenv)->ReleaseIntArrayElements(jenv, jresult, arr, 0);
  return jresult;
}


/* unsigned int[] support */
int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = (*jenv)->GetArrayLength(jenv, input);
  *jarr = (*jenv)->GetLongArrayElements(jenv, input, 0);
  if (!*jarr)
    return 0; 
  *carr = (unsigned int*) calloc(sz, sizeof(unsigned int)); 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned int)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input) {
  int i;
  jsize sz = (*jenv)->GetArrayLength(jenv, input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  (*jenv)->ReleaseLongArrayElements(jenv, input, jarr, 0);
}

jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = (*jenv)->NewLongArray(jenv, sz);
  if (!jresult)
    return NULL;
  arr = (*jenv)->GetLongArrayElements(jenv, jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  (*jenv)->ReleaseLongArrayElements(jenv, jresult, arr, 0);
  return jresult;
}


/* long[] support */
int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = (*jenv)->GetArrayLength(jenv, input);
  *jarr = (*jenv)->GetIntArrayElements(jenv, input, 0);
  if (!*jarr)
    return 0; 
  *carr = (long*) calloc(sz, sizeof(long)); 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (long)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input) {
  int i;
  jsize sz = (*jenv)->GetArrayLength(jenv, input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  (*jenv)->ReleaseIntArrayElements(jenv, input, jarr, 0);
}

jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = (*jenv)->NewIntArray(jenv, sz);
  if (!jresult)
    return NULL;
  arr = (*jenv)->GetIntArrayElements(jenv, jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  (*jenv)->ReleaseIntArrayElements(jenv, jresult, arr, 0);
  return jresult;
}


/* unsigned long[] support */
int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = (*jenv)->GetArrayLength(jenv, input);
  *jarr = (*jenv)->GetLongArrayElements(jenv, input, 0);
  if (!*jarr)
    return 0; 
  *carr = (unsigned long*) calloc(sz, sizeof(unsigned long)); 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned long)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input) {
  int i;
  jsize sz = (*jenv)->GetArrayLength(jenv, input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  (*jenv)->ReleaseLongArrayElements(jenv, input, jarr, 0);
}

jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = (*jenv)->NewLongArray(jenv, sz);
  if (!jresult)
    return NULL;
  arr = (*jenv)->GetLongArrayElements(jenv, jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  (*jenv)->ReleaseLongArrayElements(jenv, jresult, arr, 0);
  return jresult;
}


/* jlong[] support */
int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = (*jenv)->GetArrayLength(jenv, input);
  *jarr = (*jenv)->GetLongArrayElements(jenv, input, 0);
  if (!*jarr)
    return 0; 
  *carr = (jlong*) calloc(sz, sizeof(jlong)); 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (jlong)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input) {
  int i;
  jsize sz = (*jenv)->GetArrayLength(jenv, input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  (*jenv)->ReleaseLongArrayElements(jenv, input, jarr, 0);
}

jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = (*jenv)->NewLongArray(jenv, sz);
  if (!jresult)
    return NULL;
  arr = (*jenv)->GetLongArrayElements(jenv, jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  (*jenv)->ReleaseLongArrayElements(jenv, jresult, arr, 0);
  return jresult;
}


/* float[] support */
int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = (*jenv)->GetArrayLength(jenv, input);
  *jarr = (*jenv)->GetFloatArrayElements(jenv, input, 0);
  if (!*jarr)
    return 0; 
  *carr = (float*) calloc(sz, sizeof(float)); 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (float)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input) {
  int i;
  jsize sz = (*jenv)->GetArrayLength(jenv, input);
  for (i=0; i<sz; i++)
    jarr[i] = (jfloat)carr[i];
  (*jenv)->ReleaseFloatArrayElements(jenv, input, jarr, 0);
}

jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz) {
  jfloat *arr;
  int i;
  jfloatArray jresult = (*jenv)->NewFloatArray(jenv, sz);
  if (!jresult)
    return NULL;
  arr = (*jenv)->GetFloatArrayElements(jenv, jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jfloat)result[i];
  (*jenv)->ReleaseFloatArrayElements(jenv, jresult, arr, 0);
  return jresult;
}


/* double[] support */
int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = (*jenv)->GetArrayLength(jenv, input);
  *jarr = (*jenv)->GetDoubleArrayElements(jenv, input, 0);
  if (!*jarr)
    return 0; 
  *carr = (double*) calloc(sz, sizeof(double)); 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (double)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input) {
  int i;
  jsize sz = (*jenv)->GetArrayLength(jenv, input);
  for (i=0; i<sz; i++)
    jarr[i] = (jdouble)carr[i];
  (*jenv)->ReleaseDoubleArrayElements(jenv, input, jarr, 0);
}

jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz) {
  jdouble *arr;
  int i;
  jdoubleArray jresult = (*jenv)->NewDoubleArray(jenv, sz);
  if (!jresult)
    return NULL;
  arr = (*jenv)->GetDoubleArrayElements(jenv, jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jdouble)result[i];
  (*jenv)->ReleaseDoubleArrayElements(jenv, jresult, arr, 0);
  return jresult;
}


#endif


/*
	These functions taken from: http://java.sun.com/docs/books/jni/html/other.html#26018
	Umberto Nicoletti, umberto.nicoletti@gmail.com

	Fix bug: http://mapserver.gis.umn.edu/bugs/show_bug.cgi?id=1753
*/	


void JNU_ThrowByName(JNIEnv *env, const char *name, const char *msg)
{
	jclass cls = (*env)->FindClass(env, name);
	/* if cls is NULL, an exception has already been thrown */
	if (cls != NULL) {
		(*env)->ThrowNew(env, cls, msg);
	}
	/* free the local ref */
	(*env)->DeleteLocalRef(env, cls);
}

char *JNU_GetStringNativeChars(JNIEnv *env, jstring jstr) {
	jbyteArray bytes = 0;
	jthrowable exc;
	char *result = 0;
	jclass jcls_str;
	jmethodID MID_String_getBytes;

	if (jstr == NULL) {
		return NULL;
	}

	if ((*env)->EnsureLocalCapacity(env, 2) < 0) {
		return 0; /* out of memory error */
	}

  	jcls_str = (*env)->FindClass(env, "java/lang/String"); 
    	MID_String_getBytes = (*env)->GetMethodID(env, jcls_str, "getBytes", "()[B"); 
     
	bytes = (*env)->CallObjectMethod(env, jstr,
                                      MID_String_getBytes);
	exc = (*env)->ExceptionOccurred(env);
	if (!exc) {
    		jint len = (*env)->GetArrayLength(env, bytes);
    		result = (char *)malloc(len + 1);
    		if (result == 0) {
        		JNU_ThrowByName(env, "java/lang/OutOfMemoryError",0);
        		(*env)->DeleteLocalRef(env, bytes);
        		return 0;
    		}
    		(*env)->GetByteArrayRegion(env, bytes, 0, len,
                               (jbyte *)result);
	    	result[len] = 0; /* NULL-terminate */
	} else {
    		(*env)->DeleteLocalRef(env, exc);
	}
	(*env)->DeleteLocalRef(env, bytes);
	return result;
}

jstring JNU_NewStringNative(JNIEnv *env, const char *str) {
	jstring result;
	jbyteArray bytes = 0;
	int len;
	jclass jcls_str;
	jmethodID MID_String_init;

	if (str == NULL) {
		return NULL;
	}

	if ((*env)->EnsureLocalCapacity(env, 2) < 0) {
	    return NULL; /* out of memory error */
	}
	jcls_str = (*env)->FindClass(env, "java/lang/String"); 
	MID_String_init = (*env)->GetMethodID(env, jcls_str, "<init>", "([B)V"); 

	len = strlen(str);
	bytes = (*env)->NewByteArray(env, len);
	if (bytes != NULL) {
	    (*env)->SetByteArrayRegion(env, bytes, 0, len,
	                            (jbyte *)str);
	    result = (*env)->NewObject(env, jcls_str,
	                            MID_String_init, bytes);
	    (*env)->DeleteLocalRef(env, bytes);
	    return result;
	} /* else fall through */
	return NULL;
}
 

outputFormatObj *new_outputFormatObj(char const *driver,char *name){
        outputFormatObj *format;

        format = msCreateDefaultOutputFormat(NULL, driver);

        /* in the case of unsupported formats, msCreateDefaultOutputFormat
           should return NULL */
        if (!format)
        {
            msSetError(12, "Unsupported format driver: %s",
                       "outputFormatObj()", driver);
            return NULL;
        }
        
        /* Else, continue */
        format->refcount++;
	format->inmapfile = 1;

        if (name != NULL)
        {
            free(format->name);
            format->name = strdup(name);
        }
        return format;
    }
void delete_outputFormatObj(outputFormatObj *self){
        if ( --self->refcount < 1 )
            msFreeOutputFormat( self );
    }
void outputFormatObj_setOption(outputFormatObj *self,char const *key,char const *value){
        msSetOutputFormatOption( self, key, value );
    }
int outputFormatObj_validate(outputFormatObj *self){
       	return msOutputFormatValidate( self );
    }
char *outputFormatObj_getOption(outputFormatObj *self,char const *key,char const *value){
        const char *retval;
        retval = msGetOutputFormatOption(self, key, value);
        return strdup(retval);
    }
webObj *new_webObj(){
        webObj *web;
        web = (webObj *) malloc(sizeof(webObj));
        initWeb(web);
        return web;
    }
void delete_webObj(webObj *self){
        if (!self) return;
	freeWeb(self);
        free(self);
    }
styleObj *new_styleObj(classObj *parent_class){
    
        styleObj *style;
        int result;
        
        if (!parent_class) 
        { 
            style = (styleObj *) malloc(sizeof(styleObj));
            if (!style) return NULL;
            result = initStyle(style);
            if (result == MS_SUCCESS) 
            {
                style->isachild = 0;
                return style;
            }
            else 
            {
                msSetError(12, "Failed to initialize styleObj",
                                       "styleObj()");
                return NULL;
            }
        }
        else 
        {
            if (parent_class->numstyles == 5) 
            {
                msSetError(31, "Exceeded max number of styles: %d",
                           "styleObj()", 5);
                return NULL;
            }
            parent_class->numstyles++;
            return &(parent_class->styles[parent_class->numstyles-1]);
        }
    }
void delete_styleObj(styleObj *self){
        if (self->isachild == 0) 
            free(self);
    }
styleObj *styleObj_cloneStyle(styleObj *self){
        styleObj *style;

        style = (styleObj *) malloc(sizeof(styleObj));
        if (!style)
        {
            msSetError(2,
                "Could not allocate memory for new styleObj instance",
                "clone()");
            return NULL;
        }
        if (initStyle(style) == -1)
        {
            msSetError(2, "Failed to initialize Style",
                                  "clone()");
            return NULL;
        }

        if (msCopyStyle(style, self) != MS_SUCCESS)
        {
            free(style);
            return NULL;
        }
        
        style->isachild = 0;
        return style;
    }
int styleObj_setSymbolByName(styleObj *self,mapObj *map,char *symbolname){
        self->symbol = msGetSymbolIndex(&map->symbolset, symbolname, 1);
        if (self->symbolname) free((char*)self->symbolname);
        if (symbolname) self->symbolname = strdup(symbolname);
        else self->symbolname = 0;
        return self->symbol;
	}
classObj *new_classObj(layerObj *layer){
        classObj *new_class=NULL;
        
        if (!layer)
        {
            new_class = (classObj *) malloc(sizeof(classObj));
            if (!new_class)
            {
                msSetError(2,
                    "Could not allocate memory for new classObj instance",
                    "classObj()");
                return NULL;
            }
            if (initClass(new_class) == -1) return NULL;
            new_class->layer = NULL;
            return new_class;
        }
        else
        {
            if (layer->numclasses == 250)
            {
                msSetError(31, "Max number of classes reached",
                           "classObj()");
                return NULL;
            }
            if (initClass(&(layer->class[layer->numclasses])) == -1)
                return NULL;
            layer->class[layer->numclasses].type = layer->type;
            layer->class[layer->numclasses].layer = layer;
            layer->numclasses++;
            return &(layer->class[layer->numclasses-1]);
        }

        return NULL;
    }
void delete_classObj(classObj *self){
        if (!self->layer)
        {
            freeClass(self);
            free(self);
        }
    }
classObj *classObj_cloneClass(classObj *self){
        classObj *new_class;

        new_class = (classObj *) malloc(sizeof(classObj));
        if (!new_class)
        {
            msSetError(2,
                "Could not allocate memory for new classObj instance",
                "clone()");
            return NULL;
        }
        if (initClass(new_class) == -1)
        {
            msSetError(2, "Failed to initialize Class",
                                  "clone()");
            return NULL;
        }
        new_class->layer = NULL;

        if (msCopyClass(new_class, self, self->layer) != MS_SUCCESS) {
            freeClass(new_class);
            free(new_class);
            new_class = NULL;
        }
        
        return new_class;
    }
int classObj_setExpression(classObj *self,char *expression){
    if (!expression || strlen(expression) == 0) {
       freeExpression(&self->expression);
       return MS_SUCCESS;
    }
    else return msLoadExpressionString(&self->expression, expression);
  }
char *classObj_getExpressionString(classObj *self){
    return msGetExpressionString(&(self->expression));
  }
int classObj_setText(classObj *self,char *text){
    if (!text || strlen(text) == 0) {
      freeExpression(&self->text);
      return MS_SUCCESS;
    }	
    else return msLoadExpressionString(&self->text, text);
  }
char *classObj_getTextString(classObj *self){
    return msGetExpressionString(&(self->text));
  }
char *classObj_getMetaData(classObj *self,char *name){
    char *value = NULL;
    if (!name) {
      msSetError(16, "NULL key", "getMetaData");
    }
     
    value = (char *) msLookupHashTable(&(self->metadata), name);
    if (!value) {
      msSetError(16, "Key %s does not exist", "getMetaData", name);
      return NULL;
    }
    return value;
  }
int classObj_setMetaData(classObj *self,char *name,char *value){
    if (msInsertHashTable(&(self->metadata), name, value) == NULL)
        return MS_FAILURE;
    return MS_SUCCESS;
  }
char *classObj_getFirstMetaDataKey(classObj *self){
    return (char *) msFirstKeyFromHashTable(&(self->metadata));
  }
char *classObj_getNextMetaDataKey(classObj *self,char *lastkey){
    return (char *) msNextKeyFromHashTable(&(self->metadata), lastkey);
  }
int classObj_drawLegendIcon(classObj *self,mapObj *map,layerObj *layer,int width,int height,imageObj *dstImage,int dstX,int dstY){
    return msDrawLegendIcon(map, layer, self, width, height, dstImage->img.gd, dstX, dstY);
  }
imageObj *classObj_createLegendIcon(classObj *self,mapObj *map,layerObj *layer,int width,int height){
    return msCreateLegendIcon(map, layer, self, width, height);
  }
styleObj *classObj_getStyle(classObj *self,int i){
        if (i >= 0 && i < self->numstyles)	
            return &(self->styles[i]);
        else {
            msSetError(31, "Invalid index: %d", "getStyle()", i);
            return NULL;
        }
    }
int classObj_insertStyle(classObj *self,styleObj *style,int index){
        return msInsertStyle(self, style, index);
    }
styleObj *classObj_removeStyle(classObj *self,int index){
        return (styleObj *) msRemoveStyle(self, index);
    }
int classObj_moveStyleUp(classObj *self,int index){
        return msMoveStyleUp(self, index);
    }
int classObj_moveStyleDown(classObj *self,int index){
       return msMoveStyleDown(self, index);
    }
void labelCacheObj_freeCache(labelCacheObj *self){
        msFreeLabelCache(self);    
    }
resultCacheMemberObj *resultCacheObj_getResult(resultCacheObj *self,int i){
        if (i >= 0 && i < self->numresults) {
            return &self->results[i];
        }
        return NULL;
    }
symbolSetObj *new_symbolSetObj(char const *symbolfile){
        symbolSetObj *symbolset;
        mapObj *temp_map=NULL;
        symbolset = (symbolSetObj *) malloc(sizeof(symbolSetObj));
        msInitSymbolSet(symbolset);
        if (symbolfile) {
            symbolset->filename = strdup(symbolfile);
            temp_map = msNewMapObj();
            msLoadSymbolSet(symbolset, temp_map);
            symbolset->map = NULL;
            msFreeMap(temp_map);
        }
        return symbolset;
    }
void delete_symbolSetObj(symbolSetObj *self){
        msFreeSymbolSet(self);
        if (self->filename) free(self->filename);
        free(self);
    }
symbolObj *symbolSetObj_getSymbol(symbolSetObj *self,int i){
        if (i >= 0 && i < self->numsymbols)	
            return (symbolObj *) &(self->symbol[i]);
        else
            return NULL;
    }
symbolObj *symbolSetObj_getSymbolByName(symbolSetObj *self,char *symbolname){
        int i;

        if (!symbolname) return NULL;

        i = msGetSymbolIndex(self, symbolname, 1);
        if (i == -1)
            return NULL;
        else
            return (symbolObj *) &(self->symbol[i]);
    }
int symbolSetObj_index(symbolSetObj *self,char *symbolname){
        return msGetSymbolIndex(self, symbolname, 1);
    }
int symbolSetObj_appendSymbol(symbolSetObj *self,symbolObj *symbol){
        return msAppendSymbol(self, symbol);
    }
symbolObj *symbolSetObj_removeSymbol(symbolSetObj *self,int index){
        return (symbolObj *) msRemoveSymbol(self, index);
    }
int symbolSetObj_save(symbolSetObj *self,char const *filename){
        return msSaveSymbolSet(self, filename);
    }
layerObj *new_layerObj(mapObj *map){
        layerObj *layer;
        int result;
        
        if (!map) {
            layer = (layerObj *) malloc(sizeof(layerObj));
            if (!layer) {
                msSetError(2, "Failed to initialize Layer",
                                       "layerObj()");
                return NULL;
            } 
            result = initLayer(layer, NULL);
            if (result == MS_SUCCESS) {
                layer->index = -1;
                return layer;
            }
            else {
                msSetError(2, "Failed to initialize Layer",
                                       "layerObj()");
                return NULL;
            }
        }
        else {
            if (map->numlayers == 200) {
                msSetError(31, "Max number of layers exceeded",
                                        "layerObj()");
                return(NULL);
            }

            if (initLayer(&(map->layers[map->numlayers]), map) == -1)
                return(NULL);

            map->layers[map->numlayers].index = map->numlayers;
            map->layerorder[map->numlayers] = map->numlayers;
            map->numlayers++;

            return &(map->layers[map->numlayers-1]);
        }
    }
void delete_layerObj(layerObj *self){
        if (!self->map) {
            freeLayer(self);
            free(self);
        }
    }
layerObj *layerObj_cloneLayer(layerObj *self){
        layerObj *layer;
        int result;

        layer = (layerObj *) malloc(sizeof(layerObj));
        if (!layer) {
            msSetError(2, "Failed to initialize Layer",
                                  "layerObj()");
            return NULL;
        } 
        result = initLayer(layer, NULL);
        if (result != MS_SUCCESS) {
            msSetError(2, "Failed to initialize Layer",
                                  "layerObj()");
            return NULL;
        }

        if (msCopyLayer(layer, self) != MS_SUCCESS) {
            freeLayer(layer);
            free(layer);
            layer = NULL;
        }
        layer->map = NULL;
        layer->index = -1;
        
        return layer;
    }
int layerObj_insertClass(layerObj *self,classObj *classobj,int index){
        return msInsertClass(self, classobj, index);
    }
classObj *layerObj_removeClass(layerObj *self,int index){
        return msRemoveClass(self, index);
    }
int layerObj_open(layerObj *self){
        int status;
        status =  msLayerOpen(self);
        if (status == MS_SUCCESS) {
            return msLayerGetItems(self);
        }
        return status;
    }
int layerObj_whichShapes(layerObj *self,rectObj rect){
        /* 
        ** We assume folks use this like a simple query so retrieve all items with each shape.
        */
        msLayerGetItems(self);
        return msLayerWhichShapes(self, rect);
    }
shapeObj *layerObj_nextShape(layerObj *self){
       int status;
       shapeObj *shape;

       shape = (shapeObj *)malloc(sizeof(shapeObj));
       if (!shape) return NULL;
       msInitShape(shape);

       status = msLayerNextShape(self, shape);
       if(status != MS_SUCCESS) {
         msFreeShape(shape);
	 free(shape);
	 return NULL;
       } else
         return shape;
    }
void layerObj_close(layerObj *self){
        msLayerClose(self);
    }
shapeObj *layerObj_getFeature(layerObj *self,int shapeindex,int tileindex){
    /* This version properly returns shapeObj and also has its
     * arguments properly ordered so that users can ignore the
     * tileindex if they are not accessing a tileindexed layer.
     * See bug 586:
     * http://mapserver.gis.umn.edu/bugs/show_bug.cgi?id=586 */
        int retval;
        shapeObj *shape;
        shape = (shapeObj *)malloc(sizeof(shapeObj));
        if (!shape)
            return NULL;
        msInitShape(shape);
        shape->type = self->type;
        retval = msLayerGetShape(self, shape, tileindex, shapeindex);
        return shape;
    }
int layerObj_getShape(layerObj *self,shapeObj *shape,int tileindex,int shapeindex){
        return msLayerGetShape(self, shape, tileindex, shapeindex);
    }
int layerObj_getNumResults(layerObj *self){
        if (!self->resultcache) return 0;
        return self->resultcache->numresults;
    }
resultCacheMemberObj *layerObj_getResult(layerObj *self,int i){
        if (!self->resultcache) return NULL;
        if (i >= 0 && i < self->resultcache->numresults)
            return &self->resultcache->results[i]; 
        else
            return NULL;
    }
classObj *layerObj_getClass(layerObj *self,int i){

        if (i >= 0 && i < self->numclasses)
            return &(self->class[i]); 
        else
            return NULL;
    }
char *layerObj_getItem(layerObj *self,int i){
  
        if (i >= 0 && i < self->numitems)
            return (char *) (self->items[i]);
        else
            return NULL;
    }
int layerObj_draw(layerObj *self,mapObj *map,imageObj *image){
        return msDrawLayer(map, self, image);    
    }
int layerObj_drawQuery(layerObj *self,mapObj *map,imageObj *image){
        return msDrawQueryLayer(map, self, image);    
    }
int layerObj_queryByAttributes(layerObj *self,mapObj *map,char *qitem,char *qstring,int mode){
        int status;
        int retval;
        
        status = self->status;
        self->status = 1;
        retval = msQueryByAttributes(map, self->index, qitem, qstring, mode);
        self->status = status;
        return retval;
    }
int layerObj_queryByPoint(layerObj *self,mapObj *map,pointObj *point,int mode,double buffer){
        int status;
        int retval;
        
        status = self->status;
        self->status = 1;
        retval = msQueryByPoint(map, self->index, mode, *point, buffer);
        self->status = status;
        return retval;
    }
int layerObj_queryByRect(layerObj *self,mapObj *map,rectObj rect){
        int status;
        int retval;
        
        status = self->status;
        self->status = 1;
        retval = msQueryByRect(map, self->index, rect);
        self->status = status;
        return retval;
    }
int layerObj_queryByFeatures(layerObj *self,mapObj *map,int slayer){
        int status;
        int retval;
        
        status = self->status;
        self->status = 1;
        retval = msQueryByFeatures(map, self->index, slayer);
        self->status = status;
        return retval;
    }
int layerObj_queryByShape(layerObj *self,mapObj *map,shapeObj *shape){
        int status;
        int retval;
        
        status = self->status;
        self->status = 1;
        retval = msQueryByShape(map, self->index, shape);
        self->status = status;
        return retval;
    }
int layerObj_queryByIndex(layerObj *self,mapObj *map,int tileindex,int shapeindex,int bAddToQuery){
        int status;
        int retval;
        
        status = self->status;
        self->status = 1;
        if (bAddToQuery == 0)
            retval = msQueryByIndex(map, self->index, tileindex, shapeindex);
        else
            retval = msQueryByIndexAdd(map, self->index, tileindex, shapeindex);
        self->status = status;
        return retval;
    }
resultCacheObj *layerObj_getResults(layerObj *self){
        return self->resultcache;
    }
int layerObj_setFilter(layerObj *self,char *filter){
        if (!filter || strlen(filter) == 0) {
            freeExpression(&self->filter);
            return MS_SUCCESS;
        }
        else return msLoadExpressionString(&self->filter, filter);
    }
char *layerObj_getFilterString(layerObj *self){
        return msGetExpressionString(&(self->filter));
    }
int layerObj_setWKTProjection(layerObj *self,char *wkt){
        self->project = 1;
        return msOGCWKT2ProjectionObj(wkt, &(self->projection), self->debug);
    }
char *layerObj_getProjection(layerObj *self){    
        return (char *) msGetProjectionString(&(self->projection));
    }
int layerObj_setProjection(layerObj *self,char *proj4){
        self->project = 1;
        return msLoadProjectionString(&(self->projection), proj4);
    }
int layerObj_addFeature(layerObj *self,shapeObj *shape){    
        self->connectiontype = MS_INLINE;
        if (insertFeatureList(&(self->features), shape) == NULL) 
        return MS_FAILURE;
        return MS_SUCCESS;
    }
int layerObj_getNumFeatures(layerObj *self){
        return msLayerGetNumFeatures(self);
    }
rectObj *layerObj_getExtent(layerObj *self){
        rectObj *extent;
        extent = (rectObj *) malloc(sizeof(rectObj));
        msLayerGetExtent(self, extent);
        return extent;
    }
int layerObj_setExtent(layerObj *self,double minx,double miny,double maxx,double maxy){
        if (minx > maxx || miny > maxy) {
            msSetError(34,
                "{ 'minx': %f , 'miny': %f , 'maxx': %f , 'maxy': %f }",
                "layerObj::setExtent()", minx, miny, maxx, maxy);
            return MS_FAILURE;
        }

        return msLayerSetExtent(self, minx, miny, maxx, maxy);
    }
char *layerObj_getMetaData(layerObj *self,char *name){
        char *value = NULL;
        if (!name) {
            msSetError(16, "NULL key", "getMetaData");
        }
     
        value = (char *) msLookupHashTable(&(self->metadata), name);
	/*
	Umberto, 05/17/2006
	Exceptions should be reserved for situations when a serious error occurred
	and normal program flow must be interrupted.
	In this case returning null should be more that enough.
	*/






        return value;
    }
int layerObj_setMetaData(layerObj *self,char *name,char *value){
        if (msInsertHashTable(&(self->metadata), name, value) == NULL)
        return MS_FAILURE;
        return MS_SUCCESS;
    }
int layerObj_removeMetaData(layerObj *self,char *name){
        return(msRemoveHashTable(&(self->metadata), name));
    }
char *layerObj_getFirstMetaDataKey(layerObj *self){
        return (char *) msFirstKeyFromHashTable(&(self->metadata));
    }
char *layerObj_getNextMetaDataKey(layerObj *self,char *lastkey){
        return (char *) msNextKeyFromHashTable(&(self->metadata), lastkey);
    }
char *layerObj_getWMSFeatureInfoURL(layerObj *self,mapObj *map,int click_x,int click_y,int feature_count,char *info_format){
        return (char *) msWMSGetFeatureInfoURL(map, self, click_x, click_y,
               feature_count, info_format);
    }
char *layerObj_executeWFSGetFeature(layerObj *self,layerObj *layer){
        return (char *) msWFSExecuteGetFeature(layer);
    }
int layerObj_applySLD(layerObj *self,char *sld,char *stylelayer){
        return msSLDApplySLD(self->map, sld, self->index, stylelayer);
    }
int layerObj_applySLDURL(layerObj *self,char *sld,char *stylelayer){
        return msSLDApplySLDURL(self->map, sld, self->index, stylelayer);
    }
char *layerObj_generateSLD(layerObj *self){
        return (char *) msSLDGenerateSLD(self->map, self->index);
    }
int layerObj_isVisible(layerObj *self){
        if (!self->map)
        {
            msSetError(12,
                "visibility has no meaning outside of a map context",
                "isVisible()");
            return MS_FAILURE;
        }
        return msLayerIsVisible(self->map, self);
    }
int layerObj_moveClassUp(layerObj *self,int index){
        return msMoveClassUp(self, index);
    }
int layerObj_moveClassDown(layerObj *self,int index){
        return msMoveClassDown(self, index);
    }
void layerObj_setProcessingKey(layerObj *self,char const *key,char const *value){
	   msLayerSetProcessingKey( self, key, value );
    }
void layerObj_setProcessing(layerObj *self,char const *directive){
        msLayerAddProcessing( self, directive );
    }
void layerObj_addProcessing(layerObj *self,char const *directive){
        msLayerAddProcessing( self, directive );
    }
char *layerObj_getProcessing(layerObj *self,int index){
        return (char *) msLayerGetProcessing(self, index);
    }
int layerObj_clearProcessing(layerObj *self){
        return msLayerClearProcessing(self);
    }
mapObj *new_mapObj(char *filename){
        if (filename && strlen(filename))
            return msLoadMap(filename, NULL);
        else { /* create an empty map, no layers etc... */
            return msNewMapObj();
        }      
    }
void delete_mapObj(mapObj *self){
        msFreeMap(self);
    }
mapObj *mapObj_cloneMap(mapObj *self){
        mapObj *dstMap;
        dstMap = msNewMapObj();
        if (msCopyMap(dstMap, self) != MS_SUCCESS) {
            msFreeMap(dstMap);
            dstMap = NULL;
        }
        return dstMap;
    }
int mapObj_insertLayer(mapObj *self,layerObj *layer,int index){
        return msInsertLayer(self, layer, index);  
    }
layerObj *mapObj_removeLayer(mapObj *self,int index){
        return msRemoveLayer(self, index);
    }
int mapObj_setExtent(mapObj *self,double minx,double miny,double maxx,double maxy){	
	return msMapSetExtent( self, minx, miny, maxx, maxy );
    }
int mapObj_setSize(mapObj *self,int width,int height){
        return msMapSetSize(self, width, height);
    }
int mapObj_setRotation(mapObj *self,double rotation_angle){
        return msMapSetRotation( self, rotation_angle );
    }
layerObj *mapObj_getLayer(mapObj *self,int i){
    if(i >= 0 && i < self->numlayers)	
      return &(self->layers[i]); /* returns an EXISTING layer */
    else
      return NULL;
  }
layerObj *mapObj_getLayerByName(mapObj *self,char *name){
    int i;

    i = msGetLayerIndex(self, name);

    if(i != -1)
      return &(self->layers[i]); /* returns an EXISTING layer */
    else
      return NULL;
  }
int mapObj_getSymbolByName(mapObj *self,char *name){
    return msGetSymbolIndex(&self->symbolset, name, 1);
  }
void mapObj_prepareQuery(mapObj *self){
    int status;

    status = msCalculateScale(self->extent, self->units, self->width, self->height, self->resolution, &self->scale);
    if(status != MS_SUCCESS) self->scale = -1;
  }
imageObj *mapObj_prepareImage(mapObj *self){
    return msPrepareImage(self, 0);
  }
void mapObj_setImageType(mapObj *self,char *imagetype){
      outputFormatObj *format;

      format = msSelectOutputFormat( self, imagetype );
      if( format == NULL )
	  msSetError(12, "Unable to find IMAGETYPE '%s'.", 
		     "setImageType()", imagetype );
      else
      {  
          msFree( self->imagetype );
          self->imagetype = strdup(imagetype);
          msApplyOutputFormat( &(self->outputformat), format, -1111, 
                               -1111, -1111 );
      }
  }
void mapObj_selectOutputFormat(mapObj *self,char *imagetype){
        outputFormatObj *format;

        format = msSelectOutputFormat( self, imagetype );
        if ( format == NULL )
	        msSetError(12, "Unable to find IMAGETYPE '%s'.", 
		               "setImageType()", imagetype );
        else
        {   
            msFree( self->imagetype );
            self->imagetype = strdup(imagetype);
            msApplyOutputFormat( &(self->outputformat), format, -1111, 
                                 -1111, -1111 );
        }
    }
void mapObj_setOutputFormat(mapObj *self,outputFormatObj *format){
      msApplyOutputFormat( &(self->outputformat), format, -1111, 
                           -1111, -1111 );
  }
imageObj *mapObj_draw(mapObj *self){
    return msDrawMap(self);
  }
imageObj *mapObj_drawQuery(mapObj *self){
    return msDrawQueryMap(self);
  }
imageObj *mapObj_drawLegend(mapObj *self){
    return msDrawLegend(self, 0);
  }
imageObj *mapObj_drawScalebar(mapObj *self){
    return msDrawScalebar(self);
  }
imageObj *mapObj_drawReferenceMap(mapObj *self){
    return msDrawReferenceMap(self);
  }
int mapObj_embedScalebar(mapObj *self,imageObj *image){	
    return msEmbedScalebar(self, image->img.gd);
  }
int mapObj_embedLegend(mapObj *self,imageObj *image){	
    return msEmbedLegend(self, image->img.gd);
  }
int mapObj_drawLabelCache(mapObj *self,imageObj *image){
    return msDrawLabelCache(image, self);
  }
labelCacheMemberObj *mapObj_getLabel(mapObj *self,int i){
    if(i >= 0 && i < self->labelcache.numlabels)	
      return &(self->labelcache.labels[i]);
    else
      return NULL;
  }
labelCacheMemberObj *mapObj_nextLabel(mapObj *self){
    static int i=0;

    if(i<self->labelcache.numlabels)
      return &(self->labelcache.labels[i++]);
    else
      return NULL;	
  }
int mapObj_queryByPoint(mapObj *self,pointObj *point,int mode,double buffer){
    return msQueryByPoint(self, -1, mode, *point, buffer);
  }
int mapObj_queryByRect(mapObj *self,rectObj rect){
    return msQueryByRect(self, -1, rect);
  }
int mapObj_queryByFeatures(mapObj *self,int slayer){
    return msQueryByFeatures(self, -1, slayer);
  }
int mapObj_queryByShape(mapObj *self,shapeObj *shape){
    return msQueryByShape(self, -1, shape);
  }
int mapObj_setWKTProjection(mapObj *self,char *wkt){
    return msOGCWKT2ProjectionObj(wkt, &(self->projection), self->debug);
  }
char *mapObj_getProjection(mapObj *self){
    return msGetProjectionString(&(self->projection));
  }
int mapObj_setProjection(mapObj *self,char *proj4){
    return msLoadProjectionString(&(self->projection), proj4);
  }
int mapObj_save(mapObj *self,char *filename){
    return msSaveMap(self, filename);
  }
int mapObj_saveQuery(mapObj *self,char *filename){
        return msSaveQuery(self, filename);
    }
int mapObj_loadQuery(mapObj *self,char *filename){
        return msLoadQuery(self, filename);
    }
void mapObj_freeQuery(mapObj *self,int qlayer){
        msQueryFree(self, qlayer);
    }
int mapObj_saveQueryAsGML(mapObj *self,char *filename,char const *ns){
    return msGMLWriteQuery(self, filename, ns);
  }
char *mapObj_getMetaData(mapObj *self,char *name){
    char *value = NULL;
    if (!name) {
      msSetError(16, "NULL key", "getMetaData");
    }
     
    value = (char *) msLookupHashTable(&(self->web.metadata), name);
    if (!value) {
      msSetError(16, "Key %s does not exist", "getMetaData", name);
      return NULL;
    }
    return value;
  }
int mapObj_setMetaData(mapObj *self,char *name,char *value){
    if (msInsertHashTable(&(self->web.metadata), name, value) == NULL)
	return MS_FAILURE;
    return MS_SUCCESS;
  }
int mapObj_removeMetaData(mapObj *self,char *name){
    return(msRemoveHashTable(&(self->web.metadata), name));
  }
char *mapObj_getFirstMetaDataKey(mapObj *self){
    return (char *) msFirstKeyFromHashTable(&(self->web.metadata));
  }
char *mapObj_getNextMetaDataKey(mapObj *self,char *lastkey){
    return (char *) msNextKeyFromHashTable(&(self->web.metadata), lastkey);
  }
int mapObj_setSymbolSet(mapObj *self,char *szFileName){
    msFreeSymbolSet(&self->symbolset);
    msInitSymbolSet(&self->symbolset);
   
    self->symbolset.filename = strdup(szFileName);

    /* Symbolset shares same fontset as main mapfile */
    self->symbolset.fontset = &(self->fontset);

    return msLoadSymbolSet(&self->symbolset, self);
  }
int mapObj_getNumSymbols(mapObj *self){
    return self->symbolset.numsymbols;
  }
int mapObj_setFontSet(mapObj *self,char *filename){
    msFreeFontSet(&(self->fontset));
    msInitFontSet(&(self->fontset));
   
    self->fontset.filename = strdup(filename);

    return msLoadFontSet(&(self->fontset), self);
  }
int mapObj_saveMapContext(mapObj *self,char *szFileName){
    return msSaveMapContext(self, szFileName);
  }
int mapObj_loadMapContext(mapObj *self,char *szFileName,int useUniqueNames){
    return msLoadMapContext(self, szFileName, useUniqueNames);
  }
int mapObj_moveLayerUp(mapObj *self,int layerindex){
    return msMoveLayerUp(self, layerindex);
  }
int mapObj_moveLayerDown(mapObj *self,int layerindex){
    return msMoveLayerDown(self, layerindex);
  }
intarray *mapObj_getLayersDrawingOrder(mapObj *self){
    int i;
    intarray *order;
    order = new_intarray(self->numlayers);
    for (i=0; i<self->numlayers; i++)
        


        intarray_setitem(order, i, self->layerorder[i]);
        
    return order;
  }
int mapObj_setLayersDrawingOrder(mapObj *self,int *panIndexes){
    return  msSetLayersdrawingOrder(self, panIndexes); 
  }
void mapObj_setConfigOption(mapObj *self,char *key,char *value){
    msSetConfigOption(self,key,value);
  }
char *mapObj_getConfigOption(mapObj *self,char *key){
    return (char *) msGetConfigOption(self,key);
  }
void mapObj_applyConfigOptions(mapObj *self){
    msApplyMapConfigOptions( self );
  }
int mapObj_applySLD(mapObj *self,char *sld){
        return msSLDApplySLD(self, sld, -1, NULL);
    }
int mapObj_applySLDURL(mapObj *self,char *sld){
        return msSLDApplySLDURL(self, sld, -1, NULL);
    }
char *mapObj_generateSLD(mapObj *self){
        return (char *) msSLDGenerateSLD(self, -1);
    }
char *mapObj_processTemplate(mapObj *self,int bGenerateImages,char **names,char **values,int numentries){
        return msProcessTemplate(self, bGenerateImages, names, values,
                                 numentries);
    }
char *mapObj_processLegendTemplate(mapObj *self,char **names,char **values,int numentries){
        return msProcessLegendTemplate(self, names, values, numentries);
    }
char *mapObj_processQueryTemplate(mapObj *self,char **names,char **values,int numentries){
        return msProcessQueryTemplate(self, 1, names, values, numentries);
    }
outputFormatObj *mapObj_getOutputFormatByName(mapObj *self,char *name){
        return msSelectOutputFormat(self, name); 
    }
int mapObj_appendOutputFormat(mapObj *self,outputFormatObj *format){
        return msAppendOutputFormat(self, format);
    }
int mapObj_removeOutputFormat(mapObj *self,char *name){
        return msRemoveOutputFormat(self, name);
    }
int mapObj_loadOWSParameters(mapObj *self,cgiRequestObj *request,char *wmtver_string){
        return msMapLoadOWSParameters(self, request, wmtver_string);
    }
int mapObj_OWSDispatch(mapObj *self,cgiRequestObj *req){
	return msOWSDispatch( self, req );
    }
int mapObj_zoomPoint(mapObj *self,int zoomfactor,pointObj *poPixPos,int width,int height,rectObj *poGeorefExt,rectObj *poMaxGeorefExt){
        double      dfGeoPosX, dfGeoPosY;
        double      dfDeltaX, dfDeltaY;
        rectObj     oNewGeorefExt;    
        double      dfNewScale;
        int         bMaxExtSet;
        double      dfDeltaExt;
        double dX, dY;
        
        dfNewScale = 0.0;
        bMaxExtSet = 0;
        dfDeltaExt = -1.0;

        if (poMaxGeorefExt != NULL) { bMaxExtSet = 1; }

        /* ----------------------------------------------------------- */
        /*      check the validity of the parameters.                  */
        /* ----------------------------------------------------------- */
        if (zoomfactor == 0 || 
            width <= 0 ||
            height <= 0 ||
            poGeorefExt == NULL ||
            poPixPos == NULL )
        {
            msSetError(12, "Incorrect arguments", 
                       "mapscript::mapObj::zoomPoint()");
            return MS_FAILURE;
        }

        /* ----------------------------------------------------------- */
        /*      check if the values passed are consistent min > max.   */
        /* ----------------------------------------------------------- */
        if (poGeorefExt->minx >= poGeorefExt->maxx)
        {
            msSetError(12, "Georeferenced coordinates minx >= maxx",
                       "mapscript::mapObj::zoomPoint()");
            return MS_FAILURE;
        }
        if (poGeorefExt->miny >= poGeorefExt->maxy)
        {
            msSetError(12, "Georeferenced coordinates miny >= maxy",
                       "mapscript::mapObj::zoomPoint()");
            return MS_FAILURE;
        }
        if (bMaxExtSet == 1)
        {
            if (poMaxGeorefExt->minx >= poMaxGeorefExt->maxx)
            {
                msSetError(12, 
                           "Max Georeferenced coordinates minx >= maxx",
                           "mapscript::mapObj::zoomPoint()");
                return MS_FAILURE;
            }
            if (poMaxGeorefExt->miny >= poMaxGeorefExt->maxy)
            {
                msSetError(12, 
                           "Max Georeferenced coordinates miny >= maxy",
                           "mapscript::mapObj::zoomPoint()");
            }
        }
   
        dfDeltaX = poGeorefExt->maxx - poGeorefExt->minx;
        dfDeltaY = poGeorefExt->maxy - poGeorefExt->miny;
        dX = dfDeltaX/(double)width;
        dY = dfDeltaY/(double)height;
        dfGeoPosX = poGeorefExt->minx + dX * (double)poPixPos->x;
        dfGeoPosY = poGeorefExt->maxy - dY * (double)poPixPos->y;
        
        /* --- -------------------------------------------------------- */
        /*      zoom in                                                 */
        /* ------------------------------------------------------------ */
        if (zoomfactor > 1)
        {
            oNewGeorefExt.minx = dfGeoPosX - (dfDeltaX/(2*zoomfactor));        
            oNewGeorefExt.miny = dfGeoPosY - (dfDeltaY/(2*zoomfactor));        
            oNewGeorefExt.maxx = dfGeoPosX + (dfDeltaX/(2*zoomfactor));        
            oNewGeorefExt.maxy = dfGeoPosY + (dfDeltaY/(2*zoomfactor));
        }

        if (zoomfactor < 0)
        {
            oNewGeorefExt.minx = dfGeoPosX - (dfDeltaX/2)*(abs(zoomfactor));    
            oNewGeorefExt.miny = dfGeoPosY - (dfDeltaY/2)*(abs(zoomfactor));    
            oNewGeorefExt.maxx = dfGeoPosX + (dfDeltaX/2)*(abs(zoomfactor));    
            oNewGeorefExt.maxy = dfGeoPosY + (dfDeltaY/2)*(abs(zoomfactor));
        }
        if (zoomfactor == 1)
        {
            oNewGeorefExt.minx = dfGeoPosX - (dfDeltaX/2);
            oNewGeorefExt.miny = dfGeoPosY - (dfDeltaY/2);
            oNewGeorefExt.maxx = dfGeoPosX + (dfDeltaX/2);
            oNewGeorefExt.maxy = dfGeoPosY + (dfDeltaY/2);
        }

        /* ------------------------------------------------------------ */
        /*   if the min and max scale are set in the map file, we will  */
        /*   use them to test before zooming.                           */
        /* ------------------------------------------------------------ */
        msAdjustExtent(&oNewGeorefExt, self->width, self->height);
        msCalculateScale(oNewGeorefExt, self->units, 
                             self->width, self->height, 
                             self->resolution, &dfNewScale);
    
        if (self->web.maxscale > 0)
        {
            if (zoomfactor < 0 && dfNewScale > self->web.maxscale)
            {
                return MS_FAILURE;
            }
        }

        /* ============================================================ */
        /*  we do a spcial case for zoom in : we try to zoom as much as */
        /*  possible using the mincale set in the .map.                 */
        /* ============================================================ */
        if (self->web.minscale > 0 &&
            dfNewScale < self->web.minscale &&
            zoomfactor > 1)
        {
            dfDeltaExt = (self->web.minscale * self->width)
                       /(self->resolution * msInchesPerUnit(self->units,0));
            /*dfDeltaExt = 
                GetDeltaExtentsUsingScale(self->web.minscale, self->units,
                                          dfGeoPosY, self->width, 
                                          self->resolution);*/
            if (dfDeltaExt > 0.0)
            {
                oNewGeorefExt.minx = dfGeoPosX - (dfDeltaExt/2);
                oNewGeorefExt.miny = dfGeoPosY - (dfDeltaExt/2);
                oNewGeorefExt.maxx = dfGeoPosX + (dfDeltaExt/2);
                oNewGeorefExt.maxy = dfGeoPosY + (dfDeltaExt/2);
            }
            else
                return MS_FAILURE;
        }

        /* ------------------------------------------------------------ */
        /*  If the buffer is set, make sure that the extents do not go  */
        /*  beyond the buffer.                                          */
        /* ------------------------------------------------------------ */
        if (bMaxExtSet)
        {
            dfDeltaX = oNewGeorefExt.maxx - oNewGeorefExt.minx;
            dfDeltaY = oNewGeorefExt.maxy - oNewGeorefExt.miny;
        
            /* Make sure Current georef extents is not bigger than 
             * max extents */
            if (dfDeltaX > (poMaxGeorefExt->maxx-poMaxGeorefExt->minx))
                dfDeltaX = poMaxGeorefExt->maxx-poMaxGeorefExt->minx;
            if (dfDeltaY > (poMaxGeorefExt->maxy-poMaxGeorefExt->miny))
                dfDeltaY = poMaxGeorefExt->maxy-poMaxGeorefExt->miny;

            if (oNewGeorefExt.minx < poMaxGeorefExt->minx)
            {
                oNewGeorefExt.minx = poMaxGeorefExt->minx;
                oNewGeorefExt.maxx =  oNewGeorefExt.minx + dfDeltaX;
            }
            if (oNewGeorefExt.maxx > poMaxGeorefExt->maxx)
            {
                oNewGeorefExt.maxx = poMaxGeorefExt->maxx;
                oNewGeorefExt.minx = oNewGeorefExt.maxx - dfDeltaX;
            }
            if (oNewGeorefExt.miny < poMaxGeorefExt->miny)
            {
                oNewGeorefExt.miny = poMaxGeorefExt->miny;
                oNewGeorefExt.maxy =  oNewGeorefExt.miny + dfDeltaY;
            }
            if (oNewGeorefExt.maxy > poMaxGeorefExt->maxy)
            {
                oNewGeorefExt.maxy = poMaxGeorefExt->maxy;
                oNewGeorefExt.miny = oNewGeorefExt.maxy - dfDeltaY;
            }
        }
    
        /* ------------------------------------------------------------ */
        /*      set the map extents with new values.                    */
        /* ------------------------------------------------------------ */
        self->extent.minx = oNewGeorefExt.minx;
        self->extent.miny = oNewGeorefExt.miny;
        self->extent.maxx = oNewGeorefExt.maxx;
        self->extent.maxy = oNewGeorefExt.maxy;
    
        self->cellsize = msAdjustExtent(&(self->extent), self->width, 
                                        self->height);      
        dfDeltaX = self->extent.maxx - self->extent.minx;
        dfDeltaY = self->extent.maxy - self->extent.miny; 

        if (bMaxExtSet)
        {
            if (self->extent.minx < poMaxGeorefExt->minx)
            {
                self->extent.minx = poMaxGeorefExt->minx;
                self->extent.maxx = self->extent.minx + dfDeltaX;
            }
            if (self->extent.maxx > poMaxGeorefExt->maxx)
            {
                self->extent.maxx = poMaxGeorefExt->maxx;
                oNewGeorefExt.minx = oNewGeorefExt.maxx - dfDeltaX;
            }
            if (self->extent.miny < poMaxGeorefExt->miny)
            {
                self->extent.miny = poMaxGeorefExt->miny;
                self->extent.maxy =  self->extent.miny + dfDeltaY;
            }
            if (self->extent.maxy > poMaxGeorefExt->maxy)
            {
                self->extent.maxy = poMaxGeorefExt->maxy;
                oNewGeorefExt.miny = oNewGeorefExt.maxy - dfDeltaY;
            }
        }
    
        msCalculateScale(self->extent, self->units, self->width, 
                         self->height, self->resolution, &(self->scale));
        return MS_SUCCESS;

    }
int mapObj_zoomRectangle(mapObj *self,rectObj *poPixRect,int width,int height,rectObj *poGeorefExt,rectObj *poMaxGeorefExt){
        double      dfDeltaX, dfDeltaY;
        rectObj     oNewGeorefExt;    
        double      dfNewScale;
        double      dfDeltaExt;
        double dfMiddleX, dfMiddleY;
        double dX, dY;
        int bMaxExtSet;
        
        bMaxExtSet = 0;
        dfNewScale = 0.0;
        dfDeltaExt = -1.0;

        if (poMaxGeorefExt != NULL) { bMaxExtSet = 1; }

        /* ----------------------------------------------------------- */
        /*      check the validity of the parameters.                  */
        /* ----------------------------------------------------------- */
        if (poPixRect == 0 || 
            width <= 0 ||
            height <= 0 ||
            poGeorefExt == NULL )
        {
            msSetError(12, "Incorrect arguments", 
                       "mapscript::mapObj::zoomRectangle");
            return MS_FAILURE;
        }

        /* ----------------------------------------------------------- */
        /*      check if the values passed are consistent min > max.   */
        /* ----------------------------------------------------------- */
        if (poPixRect->minx >= poPixRect->maxx)
        {
            msSetError(12, "image rectangle minx >= maxx",
                       "mapscript::mapObj::zoomRectangle()");
            return MS_FAILURE;
        }
        if (poPixRect->maxy >= poPixRect->miny)
        {
            msSetError(12, "image rectangle miny >= maxy",
                       "mapscript::mapObj::zoomRectangle()");
            return MS_FAILURE;
        }

        if (poGeorefExt->minx >= poGeorefExt->maxx)
        {
            msSetError(12, "Georeferenced coordinates minx >= maxx",
                       "mapscript::mapObj::zoomRectangle()");
            return MS_FAILURE;
        }
        if (poGeorefExt->miny >= poGeorefExt->maxy)
        {
            msSetError(12, "Georeferenced coordinates miny >= maxy",
                       "mapscript::mapObj::zoomRectangle()");
            return MS_FAILURE;
        }
        if (bMaxExtSet == 1)
        {
            if (poMaxGeorefExt->minx >= poMaxGeorefExt->maxx)
            {
                msSetError(12, 
                           "Max Georeferenced coordinates minx >= maxx",
                           "mapscript::mapObj::zoomRectangle()");
                return MS_FAILURE;
            }
            if (poMaxGeorefExt->miny >= poMaxGeorefExt->maxy)
            {
                msSetError(12, 
                           "Max Georeferenced coordinates miny >= maxy",
                           "mapscript::mapObj::zoomRectangle()");
            }
        }

  
        /* ----------------------------------------------------------- */
        /*   Convert pixel rectangle to georeferenced rectangle        */
        /* ----------------------------------------------------------- */
        
        dfDeltaX = poGeorefExt->maxx - poGeorefExt->minx;
        dfDeltaY = poGeorefExt->maxy - poGeorefExt->miny;
        dX = dfDeltaX/(double)width;
        dY = dfDeltaY/(double)height;

        oNewGeorefExt.minx = poGeorefExt->minx
                           + dX * (double)poPixRect->minx;
        oNewGeorefExt.miny = poGeorefExt->maxy
                           - dY * (double)poPixRect->miny;
        oNewGeorefExt.maxx = poGeorefExt->minx
                           + dX * (double)poPixRect->maxx;
        oNewGeorefExt.maxy = poGeorefExt->maxy
                           - dY * (double)poPixRect->maxy;

        msAdjustExtent(&oNewGeorefExt, self->width, self->height);

        /* ------------------------------------------------------------ */
        /*   if the min and max scale are set in the map file, we will  */
        /*   use them to test before setting extents.                   */
        /* ------------------------------------------------------------ */
        msCalculateScale(oNewGeorefExt, self->units, 
                         self->width, self->height, 
                         self->resolution, &dfNewScale);

        if (self->web.maxscale > 0 &&  dfNewScale > self->web.maxscale)
        {
            return MS_FAILURE;
        }

        if (self->web.minscale > 0 && dfNewScale <  self->web.minscale)
        {
            dfMiddleX = oNewGeorefExt.minx + 
                ((oNewGeorefExt.maxx - oNewGeorefExt.minx)/2);
            dfMiddleY = oNewGeorefExt.miny + 
                ((oNewGeorefExt.maxy - oNewGeorefExt.miny)/2);
        
            dfDeltaExt = (self->web.minscale * self->width)
                       / (self->resolution * msInchesPerUnit(self->units,0));
            /*dfDeltaExt = 
                GetDeltaExtentsUsingScale(self->web.minscale, self->units, 
                                          dfMiddleY, self->width, 
                                      self->resolution);*/

            if (dfDeltaExt > 0.0)
            {
                oNewGeorefExt.minx = dfMiddleX - (dfDeltaExt/2);
                oNewGeorefExt.miny = dfMiddleY - (dfDeltaExt/2);
                oNewGeorefExt.maxx = dfMiddleX + (dfDeltaExt/2);
                oNewGeorefExt.maxy = dfMiddleY + (dfDeltaExt/2);
            }
            else
                return MS_FAILURE;
        }

        /* ------------------------------------------------------------ */
        /*  If the buffer is set, make sure that the extents do not go  */
        /*  beyond the buffer.                                          */
        /* ------------------------------------------------------------ */
        if (bMaxExtSet)
        {
            dfDeltaX = oNewGeorefExt.maxx - oNewGeorefExt.minx;
            dfDeltaY = oNewGeorefExt.maxy - oNewGeorefExt.miny;
        
            /* Make sure Current georef extents is not bigger 
             * than max extents */
            if (dfDeltaX > (poMaxGeorefExt->maxx-poMaxGeorefExt->minx))
                dfDeltaX = poMaxGeorefExt->maxx-poMaxGeorefExt->minx;
            if (dfDeltaY > (poMaxGeorefExt->maxy-poMaxGeorefExt->miny))
                dfDeltaY = poMaxGeorefExt->maxy-poMaxGeorefExt->miny;

            if (oNewGeorefExt.minx < poMaxGeorefExt->minx)
            {
                oNewGeorefExt.minx = poMaxGeorefExt->minx;
                oNewGeorefExt.maxx =  oNewGeorefExt.minx + dfDeltaX;
            }
            if (oNewGeorefExt.maxx > poMaxGeorefExt->maxx)
            {
                oNewGeorefExt.maxx = poMaxGeorefExt->maxx;
                oNewGeorefExt.minx = oNewGeorefExt.maxx - dfDeltaX;
            }
            if (oNewGeorefExt.miny < poMaxGeorefExt->miny)
            {
                oNewGeorefExt.miny = poMaxGeorefExt->miny;
                oNewGeorefExt.maxy =  oNewGeorefExt.miny + dfDeltaY;
            }
            if (oNewGeorefExt.maxy > poMaxGeorefExt->maxy)
            {
                oNewGeorefExt.maxy = poMaxGeorefExt->maxy;
                oNewGeorefExt.miny = oNewGeorefExt.maxy - dfDeltaY;
            }
        }

        self->extent.minx = oNewGeorefExt.minx;
        self->extent.miny = oNewGeorefExt.miny;
        self->extent.maxx = oNewGeorefExt.maxx;
        self->extent.maxy = oNewGeorefExt.maxy;
    
        self->cellsize = msAdjustExtent(&(self->extent), self->width, 
                                        self->height);    
        dfDeltaX = self->extent.maxx - self->extent.minx;
        dfDeltaY = self->extent.maxy - self->extent.miny; 

        if (bMaxExtSet)
        {
            if (self->extent.minx < poMaxGeorefExt->minx)
            {
                self->extent.minx = poMaxGeorefExt->minx;
                self->extent.maxx = self->extent.minx + dfDeltaX;
            }
            if (self->extent.maxx > poMaxGeorefExt->maxx)
            {
                self->extent.maxx = poMaxGeorefExt->maxx;
                oNewGeorefExt.minx = oNewGeorefExt.maxx - dfDeltaX;
            }
            if (self->extent.miny < poMaxGeorefExt->miny)
            {
                self->extent.miny = poMaxGeorefExt->miny;
                self->extent.maxy =  self->extent.miny + dfDeltaY;
            }
            if (self->extent.maxy > poMaxGeorefExt->maxy)
            {
                self->extent.maxy = poMaxGeorefExt->maxy;
                oNewGeorefExt.miny = oNewGeorefExt.maxy - dfDeltaY;
            }
        }

        msCalculateScale(self->extent, self->units, self->width, 
                         self->height, self->resolution, &(self->scale));
        return MS_SUCCESS;

    }
int mapObj_zoomScale(mapObj *self,double scale,pointObj *poPixPos,int width,int height,rectObj *poGeorefExt,rectObj *poMaxGeorefExt){
        double      dfGeoPosX, dfGeoPosY;
        double      dfDeltaX, dfDeltaY;
        rectObj     oNewGeorefExt;    
        double      dfNewScale, dfCurrentScale;
        int         bMaxExtSet;
        int nTmp;
        double      dfDeltaExt;
        double dX, dY;
        
        dfNewScale = 0.0;
        dfCurrentScale = 0.0;
        nTmp = 0;
        bMaxExtSet = 0;
        dfDeltaExt = -1.0;

        if (poMaxGeorefExt != NULL) { bMaxExtSet = 1; }

        /* ----------------------------------------------------------- */
        /*      check the validity of the parameters.                  */
        /* ----------------------------------------------------------- */
        if (scale <= 0.0 || 
            width <= 0 ||
            height <= 0 ||
            poGeorefExt == NULL ||
            poPixPos == NULL )
        {
            msSetError(12, "Incorrect arguments", 
                       "mapscript::mapObj::zoomScale");
            return MS_FAILURE;
        }

        /* ----------------------------------------------------------- */
        /*      check if the values passed are consistent min > max.   */
        /* ----------------------------------------------------------- */
        if (poGeorefExt->minx >= poGeorefExt->maxx)
        {
            msSetError(12, "Georeferenced coordinates minx >= maxx",
                       "mapscript::mapObj::zoomScale()");
            return MS_FAILURE;
        }
        if (poGeorefExt->miny >= poGeorefExt->maxy)
        {
            msSetError(12, "Georeferenced coordinates miny >= maxy",
                       "mapscript::mapObj::zoomScale()");
            return MS_FAILURE;
        }
        if (bMaxExtSet == 1)
        {
            if (poMaxGeorefExt->minx >= poMaxGeorefExt->maxx)
            {
                msSetError(12, 
                           "Max Georeferenced coordinates minx >= maxx",
                           "mapscript::mapObj::zoomScale()");
                return MS_FAILURE;
            }
            if (poMaxGeorefExt->miny >= poMaxGeorefExt->maxy)
            {
                msSetError(12, 
                           "Max Georeferenced coordinates miny >= maxy",
                           "mapscript::mapObj::zoomScale()");
            }
        }
   
        dfDeltaX = poGeorefExt->maxx - poGeorefExt->minx;
        dfDeltaY = poGeorefExt->maxy - poGeorefExt->miny;
        dX = dfDeltaX/(double)width;
        dY = dfDeltaY/(double)height;
        dfGeoPosX = poGeorefExt->minx + dX * (double)poPixPos->x;
        dfGeoPosY = poGeorefExt->maxy - dY * (double)poPixPos->y;
        
        /* ------------------------------------------------------------ */
        /*  Calculate new extents based on the scale.                   */
        /* ------------------------------------------------------------ */

        /* ============================================================ */
        /*  make sure to take the smallest size because this is the one */
        /*  that will be used to ajust the scale.                       */
        /* ============================================================ */

        if (self->width <  self->height)
            nTmp = self->width;
        else
            nTmp = self->height;

        dfDeltaExt=scale*nTmp/(self->resolution*msInchesPerUnit(self->units,0));

        if (dfDeltaExt > 0.0)
        {
            oNewGeorefExt.minx = dfGeoPosX - (dfDeltaExt/2);
            oNewGeorefExt.miny = dfGeoPosY - (dfDeltaExt/2);
            oNewGeorefExt.maxx = dfGeoPosX + (dfDeltaExt/2);
            oNewGeorefExt.maxy = dfGeoPosY + (dfDeltaExt/2);
        }
        else
            return MS_FAILURE;

        /* ------------------------------------------------------------ */
        /*   get current scale.                                         */
        /* ------------------------------------------------------------ */
        msCalculateScale(*poGeorefExt, self->units, 
                         self->width, self->height,
                         self->resolution, &dfCurrentScale);

        /* ------------------------------------------------------------ *
         *   if the min and max scale are set in the map file, we will  *
         *   use them to test before zooming.                           *
         *                                                              *
         *   This function has the same effect as zoomin or zoom out.
         *   If the current scale is > newscale we zoom in; else it is
         *   a zoom out.
         * ------------------------------------------------------------ */
        msAdjustExtent(&oNewGeorefExt, self->width, self->height);
        msCalculateScale(oNewGeorefExt, self->units, 
                         self->width, self->height,
                         self->resolution, &dfNewScale);

        if (self->web.maxscale > 0)
        {
            if (dfCurrentScale < dfNewScale && dfNewScale >  self->web.maxscale)
            {
                return MS_FAILURE;
            }
        }

        /* ============================================================ */
        /* we do a special case for zoom in : we try to zoom as much as */
        /* possible using the mincale set in the .map.                  */
        /* ============================================================ */
        if (self->web.minscale > 0 && dfNewScale <  self->web.minscale &&
            dfCurrentScale > dfNewScale)
        {
            dfDeltaExt=scale*nTmp/(self->resolution*msInchesPerUnit(self->units,0));
            if (dfDeltaExt > 0.0)
            {
                oNewGeorefExt.minx = dfGeoPosX - (dfDeltaExt/2);
                oNewGeorefExt.miny = dfGeoPosY - (dfDeltaExt/2);
                oNewGeorefExt.maxx = dfGeoPosX + (dfDeltaExt/2);
                oNewGeorefExt.maxy = dfGeoPosY + (dfDeltaExt/2);
            }
            else
                return MS_FAILURE;
        }

        /* ------------------------------------------------------------ */
        /*  If the buffer is set, make sure that the extents do not go  */
        /*  beyond the buffer.                                          */
        /* ------------------------------------------------------------ */
        if (bMaxExtSet)
        {
            dfDeltaX = oNewGeorefExt.maxx - oNewGeorefExt.minx;
            dfDeltaY = oNewGeorefExt.maxy - oNewGeorefExt.miny;
        
            /* Make sure Current georef extents is not bigger 
             * than max extents */
            if (dfDeltaX > (poMaxGeorefExt->maxx-poMaxGeorefExt->minx))
                dfDeltaX = poMaxGeorefExt->maxx-poMaxGeorefExt->minx;
            if (dfDeltaY > (poMaxGeorefExt->maxy-poMaxGeorefExt->miny))
                dfDeltaY = poMaxGeorefExt->maxy-poMaxGeorefExt->miny;

            if (oNewGeorefExt.minx < poMaxGeorefExt->minx)
            {
                oNewGeorefExt.minx = poMaxGeorefExt->minx;
                oNewGeorefExt.maxx =  oNewGeorefExt.minx + dfDeltaX;
            }
            if (oNewGeorefExt.maxx > poMaxGeorefExt->maxx)
            {
                oNewGeorefExt.maxx = poMaxGeorefExt->maxx;
                oNewGeorefExt.minx = oNewGeorefExt.maxx - dfDeltaX;
            }
            if (oNewGeorefExt.miny < poMaxGeorefExt->miny)
            {
                oNewGeorefExt.miny = poMaxGeorefExt->miny;
                oNewGeorefExt.maxy =  oNewGeorefExt.miny + dfDeltaY;
            }
            if (oNewGeorefExt.maxy > poMaxGeorefExt->maxy)
            {
                oNewGeorefExt.maxy = poMaxGeorefExt->maxy;
                oNewGeorefExt.miny = oNewGeorefExt.maxy - dfDeltaY;
            }
        }

        self->extent.minx = oNewGeorefExt.minx;
        self->extent.miny = oNewGeorefExt.miny;
        self->extent.maxx = oNewGeorefExt.maxx;
        self->extent.maxy = oNewGeorefExt.maxy;
    
        self->cellsize = msAdjustExtent(&(self->extent), self->width, 
                                        self->height);    
        dfDeltaX = self->extent.maxx - self->extent.minx;
        dfDeltaY = self->extent.maxy - self->extent.miny; 

        if (bMaxExtSet)
        {
            if (self->extent.minx < poMaxGeorefExt->minx)
            {
                self->extent.minx = poMaxGeorefExt->minx;
                self->extent.maxx = self->extent.minx + dfDeltaX;
            }
            if (self->extent.maxx > poMaxGeorefExt->maxx)
            {
                self->extent.maxx = poMaxGeorefExt->maxx;
                oNewGeorefExt.minx = oNewGeorefExt.maxx - dfDeltaX;
            }
            if (self->extent.miny < poMaxGeorefExt->miny)
            {
                self->extent.miny = poMaxGeorefExt->miny;
                self->extent.maxy =  self->extent.miny + dfDeltaY;
            }
            if (self->extent.maxy > poMaxGeorefExt->maxy)
            {
                self->extent.maxy = poMaxGeorefExt->maxy;
                oNewGeorefExt.miny = oNewGeorefExt.maxy - dfDeltaY;
            }
        }

        msCalculateScale(self->extent, self->units, self->width, 
                         self->height, self->resolution, &(self->scale));
        return MS_SUCCESS;
    }
imageObj *new_imageObj(int width,int height,outputFormatObj *input_format,char const *file){
        imageObj *image=NULL;
        outputFormatObj *format;

        if (file) {
            return (imageObj *) msImageLoadGD(file);
        }
        if (input_format) {
            format = input_format;
        }
        else {
            format = msCreateDefaultOutputFormat(NULL, "GD/GIF");
            if (format == NULL)
                format = msCreateDefaultOutputFormat(NULL, "GD/PNG");
            if (format == NULL)
                format = msCreateDefaultOutputFormat(NULL, "GD/JPEG");
            if (format == NULL)
                format = msCreateDefaultOutputFormat(NULL, "GD/WBMP");
        }
        if (format == NULL) {
            msSetError(15, "Could not create output format",
                       "imageObj()");
            return NULL;
        }
        image = msImageCreate(width, height, format, NULL, NULL, NULL);
        return image;
    }
void delete_imageObj(imageObj *self){
        msFreeImage(self);    
    }
void imageObj_save(imageObj *self,char *filename,mapObj *map){
        msSaveImage(map, self, filename );
    }
int imageObj_write(imageObj *self,FILE *file){
        gdIOCtx *ctx=NULL;
        int retval=MS_FAILURE;
        
        if ( MS_DRIVER_GD(self->format) )
        {
            if (file)
            {
                /* gdNewFileCtx is a semi-documented function from 
                   gd_io_file.c */
                ctx = msNewGDFileCtx(file);
            }
            else /* create a gdIOCtx interface to stdout */
            {
                ctx = msNewGDFileCtx(stdout);
            }
            
            /* we wrap msSaveImageGDCtx in the same way that 
               gdImageJpeg() wraps gdImageJpegCtx()  (bug 1047). */
            retval = msSaveImageGDCtx(self->img.gd, ctx, self->format);
            ctx->gd_free(ctx);
        }
        else
        {
            msSetError(15, "Writing of %s format not implemented",
                       "imageObj::write");
        }

        return retval;
    }
gdBuffer imageObj_getBytes(imageObj *self){
        gdBuffer buffer;
        
  	buffer.owns_data = 1;
        buffer.data = msSaveImageBufferGD(self->img.gd, &buffer.size,
                                          self->format);
        if( buffer.size == 0 )
        {
            buffer.data = NULL;
            msSetError(12, "Failed to get image buffer", "getBytes");
            return buffer;
        }

        return buffer;
    }
rectObj *new_rectObj(double minx,double miny,double maxx,double maxy,int imageunits){	
        rectObj *rect;
    
        if (imageunits == 0)
        { 
            if (minx > maxx || miny > maxy)
            {
                msSetError(34,
                    "{ 'minx': %f , 'miny': %f , 'maxx': %f , 'maxy': %f }",
                    "rectObj()", minx, miny, maxx, maxy);
                return NULL;
            }
        }
        else 
        {
            if (minx > maxx || maxy > miny) 
            {
                msSetError(34,
                    "image (pixel/line) units { 'minx': %f , 'miny': %f , 'maxx': %f , 'maxy': %f }",
                    "rectObj()", minx, miny, maxx, maxy);
                return NULL;
            }
        }
    
        rect = (rectObj *)calloc(1, sizeof(rectObj));
        if (!rect)
            return(NULL);
    
        rect->minx = minx;
        rect->miny = miny;
        rect->maxx = maxx;
        rect->maxy = maxy;

        return(rect);    	
    }
void delete_rectObj(rectObj *self){
        free(self);
    }
int rectObj_project(rectObj *self,projectionObj *projin,projectionObj *projout){
        return msProjectRect(projin, projout, self);
    }
double rectObj_fit(rectObj *self,int width,int height){
        return  msAdjustExtent(self, width, height);
    }
int rectObj_draw(rectObj *self,mapObj *map,layerObj *layer,imageObj *image,int classindex,char *text){
        shapeObj shape;

        msInitShape(&shape);
        msRectToPolygon(*self, &shape);
        shape.classindex = classindex;
        shape.text = strdup(text);

        msDrawShape(map, layer, &shape, image, -1);

        msFreeShape(&shape);
    
        return MS_SUCCESS;
    }
shapeObj *rectObj_toPolygon(rectObj *self){
        lineObj line = {0,NULL};
        shapeObj *shape;
        shape = (shapeObj *)malloc(sizeof(shapeObj));
        if (!shape)
            return NULL;
        msInitShape(shape);
        shape->type = MS_SHAPE_POLYGON;
  
        line.point = (pointObj *)malloc(sizeof(pointObj)*5);
        line.point[0].x = self->minx;
        line.point[0].y = self->miny;
        line.point[1].x = self->minx;
        line.point[1].y = self->maxy;
        line.point[2].x = self->maxx;
        line.point[2].y = self->maxy;
        line.point[3].x = self->maxx;
        line.point[3].y = self->miny;
        line.point[4].x = line.point[0].x;
        line.point[4].y = line.point[0].y;
  
        line.numpoints = 5;
  
        msAddLine(shape, &line);
        msComputeBounds(shape);
        
        free(line.point);

        return shape;
    }
char *rectObj_toString(rectObj *self){
        char buffer[256];
        char fmt[]="{ 'minx': %.16g , 'miny': %.16g , 'maxx': %.16g , 'maxy': %.16g }";
        msRectToFormattedString(self, (char *) &fmt, (char *) &buffer, 256);
        return strdup(buffer);
    }
void delete_pointObj(pointObj *self){
        free(self);
    }
int pointObj_project(pointObj *self,projectionObj *projin,projectionObj *projout){
        return msProjectPoint(projin, projout, self);
    }
int pointObj_draw(pointObj *self,mapObj *map,layerObj *layer,imageObj *image,int classindex,char *text){
        return msDrawPoint(map, layer, self, image, classindex, text);
    }
double pointObj_distanceToPoint(pointObj *self,pointObj *point){
        return msDistancePointToPoint(self, point);
    }
double pointObj_distanceToSegment(pointObj *self,pointObj *a,pointObj *b){
        return msDistancePointToSegment(self, a, b);
    }
double pointObj_distanceToShape(pointObj *self,shapeObj *shape){
        return msDistancePointToShape(self, shape);
    }
int pointObj_setXY(pointObj *self,double x,double y,double m){
        self->x = x;
        self->y = y;




	
        return MS_SUCCESS;
    }
int pointObj_setXYZ(pointObj *self,double x,double y,double z,double m){
        self->x = x;
        self->y = y;




        return MS_SUCCESS;
    }
int pointObj_setXYZM(pointObj *self,double x,double y,double z,double m){
        self->x = x;
        self->y = y;




        return MS_SUCCESS;
    }
char *pointObj_toString(pointObj *self){
        char buffer[256];
        const char *fmt;







        fmt = "{ 'x': %.16g, 'y': %.16g }";

	
        msPointToFormattedString(self, fmt, (char *) &buffer, 256);
        return strdup(buffer);
    }
shapeObj *pointObj_toShape(pointObj *self){
      shapeObj *shape;

      shape = (shapeObj *) malloc(sizeof(shapeObj));
      msInitShape(shape);
    
      shape->type = MS_SHAPE_POINT;
      shape->line = (lineObj *) malloc(sizeof(lineObj));
      shape->numlines = 1;
      shape->line[0].point = (pointObj *) malloc(sizeof(pointObj));
      shape->line[0].numpoints = 1;

      shape->line[0].point[0].x = self->x;
      shape->line[0].point[0].y = self->y;





      return shape;
    }
pointObj *new_pointObj__SWIG_0(double x,double y,double z,double m){
        pointObj *p;
        p = (pointObj *)calloc(1,sizeof(pointObj));
        if (!p) return NULL;
        p->x = x;
        p->y = y;




        return p;
    }
pointObj *new_pointObj__SWIG_1(double x,double y,double z){
        pointObj *p;
        p = (pointObj *)calloc(1,sizeof(pointObj));
        if (!p) return NULL;
        p->x = x;
        p->y = y;




        return p;
    }
lineObj *new_lineObj(){
        lineObj *line;

        line = (lineObj *)malloc(sizeof(lineObj));
        if (!line)
            return(NULL);

        line->numpoints=0;
        line->point=NULL;

        return line;
    }
void delete_lineObj(lineObj *self){
        free(self->point);
        free(self);		
    }
int lineObj_project(lineObj *self,projectionObj *projin,projectionObj *projout){
        return msProjectLine(projin, projout, self);
    }
pointObj *lineObj_get(lineObj *self,int i){
        if (i<0 || i>=self->numpoints)
            return NULL;
        else
            return &(self->point[i]);
    }
int lineObj_add(lineObj *self,pointObj *p){
        if (self->numpoints == 0) { /* new */	
        self->point = (pointObj *)malloc(sizeof(pointObj));      
        if (!self->point)
	        return MS_FAILURE;
        } else { /* extend array */
            self->point = (pointObj *)realloc(self->point, 
                                      sizeof(pointObj)*(self->numpoints+1));
        if (!self->point)
	        return MS_FAILURE;
        }

        self->point[self->numpoints].x = p->x;
        self->point[self->numpoints].y = p->y;
        self->numpoints++;

        return MS_SUCCESS;
    }
int lineObj_set(lineObj *self,int i,pointObj *p){
        if (i<0 || i>=self->numpoints)
            return MS_FAILURE;

        self->point[i].x = p->x;
        self->point[i].y = p->y;
        return MS_SUCCESS;    
    }
shapeObj *new_shapeObj(int type){
        shapeObj *shape;

	shape = (shapeObj *)malloc(sizeof(shapeObj));
        if (!shape)
            return NULL;

        msInitShape(shape);
        if(type >= 0) shape->type = type;
        
        return shape;
    }
void delete_shapeObj(shapeObj *self){
        msFreeShape(self);
        free(self);		
    }
shapeObj *shapeObj_fromWKT(char *wkt){
	shapeObj *shape;
        
        if(!wkt) return NULL;

        shape = msShapeFromWKT(wkt);
	if(!shape) return NULL;

	return shape;
    }
int shapeObj_project(shapeObj *self,projectionObj *projin,projectionObj *projout){
        return msProjectShape(projin, projout, self);
    }
lineObj *shapeObj_get(shapeObj *self,int i){
        if (i<0 || i>=self->numlines)
            return NULL;
        else
            return &(self->line[i]);
    }
int shapeObj_add(shapeObj *self,lineObj *line){
        return msAddLine(self, line);
    }
int shapeObj_draw(shapeObj *self,mapObj *map,layerObj *layer,imageObj *image){
        return msDrawShape(map, layer, self, image, -1);
    }
void shapeObj_setBounds(shapeObj *self){    
        msComputeBounds(self);
        return;
    }
shapeObj *shapeObj_cloneShape(shapeObj *self){
        shapeObj *shape;
        shape = (shapeObj *)malloc(sizeof(shapeObj));
        if (!shape)
            return NULL;
        msInitShape(shape);
        shape->type = self->type;
        msCopyShape(self, shape);
        return shape;
    }
int shapeObj_copy(shapeObj *self,shapeObj *dest){
        return(msCopyShape(self, dest));
    }
char *shapeObj_toWKT(shapeObj *self){
        return msShapeToWKT(self);
    }
shapeObj *shapeObj_buffer(shapeObj *self,double width){ return msGEOSBuffer(self, width); }
shapeObj *shapeObj_convexHull(shapeObj *self){ return msGEOSConvexHull(self); }
shapeObj *shapeObj_boundary(shapeObj *self){ return msGEOSBoundary(self); }
pointObj *shapeObj_getCentroid(shapeObj *self){ return msGEOSGetCentroid(self); }
shapeObj *shapeObj_Union(shapeObj *self,shapeObj *shape){ return msGEOSUnion(self, shape); }
shapeObj *shapeObj_intersection(shapeObj *self,shapeObj *shape){ return msGEOSIntersection(self, shape); }
shapeObj *shapeObj_difference(shapeObj *self,shapeObj *shape){ return msGEOSDifference(self, shape); }
shapeObj *shapeObj_symDifference(shapeObj *self,shapeObj *shape){ return msGEOSSymDifference(self, shape); }
int shapeObj_contains__SWIG_0(shapeObj *self,shapeObj *shape){ return msGEOSContains(self, shape); }
int shapeObj_overlaps(shapeObj *self,shapeObj *shape){ return msGEOSOverlaps(self, shape); }
int shapeObj_within(shapeObj *self,shapeObj *shape){ return msGEOSWithin(self, shape); }
int shapeObj_crosses(shapeObj *self,shapeObj *shape){ return msGEOSCrosses(self, shape); }
int shapeObj_intersects(shapeObj *self,shapeObj *shape){ return msGEOSIntersects(self, shape); }
int shapeObj_touches(shapeObj *self,shapeObj *shape){ return msGEOSTouches(self, shape); }
int shapeObj_equals(shapeObj *self,shapeObj *shape){ return msGEOSEquals(self, shape); }
int shapeObj_disjoint(shapeObj *self,shapeObj *shape){ return msGEOSDisjoint(self, shape); }
double shapeObj_getArea(shapeObj *self){ return msGEOSArea(self); }
double shapeObj_getLength(shapeObj *self){ return msGEOSLength(self); }
char *shapeObj_getValue(shapeObj *self,int i){
        if (i >= 0 && i < self->numvalues && self->values)
            return (self->values[i]);
        else
            return NULL;
    }
int shapeObj_contains__SWIG_1(shapeObj *self,pointObj *point){
        if (self->type == MS_SHAPE_POLYGON)
            return msIntersectPointPolygon(point, self);
        
        return -1;
    }
double shapeObj_distanceToPoint(shapeObj *self,pointObj *point){
        return msDistancePointToShape(point, self); /* should there be a GEOS version of this? */
    }
double shapeObj_distanceToShape(shapeObj *self,shapeObj *shape){
	return msGEOSDistance(self, shape); /* note this calls msDistanceShapeToShape() if GEOS support is not present */
    }
int shapeObj_setValue(shapeObj *self,int i,char *value){
        if (!self->values || !value)
        {
            msSetError(19, "Can't set value", "setValue()");
            return MS_FAILURE;
        }
        if (i >= 0 && i < self->numvalues)
        {
            msFree(self->values[i]);
            self->values[i] = strdup(value);
            if (!self->values[i])
            {
                return MS_FAILURE;
            }
            else return MS_SUCCESS;
        }
        else
        {
            msSetError(19, "Invalid value index", 
                                  "setValue()");
            return MS_FAILURE;
        }
    }
void shapeObj_initValues(shapeObj *self,int numvalues){
        int i;
        
        if(self->values) msFreeCharArray(self->values, self->numvalues);
        self->values = NULL;
        self->numvalues = 0;
        
        /* Allocate memory for the values */
        if (numvalues > 0) {
            if ((self->values = (char **)malloc(sizeof(char *)*numvalues)) == NULL) {
                msSetError(2, "Failed to allocate memory for values", "shapeObj()");
                return;
            } else {
                for (i=0; i<numvalues; i++) self->values[i] = strdup("");
            }
            self->numvalues = numvalues;
        }
    }
char *DBFInfo_getFieldName(DBFInfo *self,int iField){
        static char pszFieldName[1000];
	    int pnWidth;
	    int pnDecimals;
	    msDBFGetFieldInfo(self, iField, &pszFieldName[0], &pnWidth, 
                          &pnDecimals);
	    return pszFieldName;
    }
int DBFInfo_getFieldWidth(DBFInfo *self,int iField){
        char pszFieldName[1000];
	    int pnWidth;
	    int pnDecimals;
	    msDBFGetFieldInfo(self, iField, &pszFieldName[0], &pnWidth,
                          &pnDecimals);
	    return pnWidth;
    }
int DBFInfo_getFieldDecimals(DBFInfo *self,int iField){
        char pszFieldName[1000];
	    int pnWidth;
	    int pnDecimals;
	    msDBFGetFieldInfo(self, iField, &pszFieldName[0], &pnWidth,
                          &pnDecimals);
	    return pnDecimals;
    }
int DBFInfo_getFieldType(DBFInfo *self,int iField){
	    return msDBFGetFieldInfo(self, iField, NULL, NULL, NULL);
    }
shapefileObj *new_shapefileObj(char *filename,int type){    
        shapefileObj *shapefile;
        int status;

        shapefile = (shapefileObj *)malloc(sizeof(shapefileObj));
        if (!shapefile)
            return NULL;

        if (type == -1)
            status = msSHPOpenFile(shapefile, "rb", filename);
        else if (type == -2)
            status = msSHPOpenFile(shapefile, "rb+", filename);
        else
            status = msSHPCreateFile(shapefile, filename, type);

        if (status == -1) {
            msSHPCloseFile(shapefile);
            free(shapefile);
            return NULL;
        }
 
        return(shapefile);
    }
void delete_shapefileObj(shapefileObj *self){
        msSHPCloseFile(self);
        free(self);  
    }
int shapefileObj_get(shapefileObj *self,int i,shapeObj *shape){
        if (i<0 || i>=self->numshapes)
            return MS_FAILURE;

        msFreeShape(shape); /* frees all lines and points before re-filling */
        msSHPReadShape(self->hSHP, i, shape);

        return MS_SUCCESS;
    }
shapeObj *shapefileObj_getShape(shapefileObj *self,int i){
        shapeObj *shape;
        shape = (shapeObj *)malloc(sizeof(shapeObj));
        if (!shape)
            return NULL;
        msInitShape(shape);
        shape->type = self->type;
        msSHPReadShape(self->hSHP, i, shape);
        return shape;

    }
int shapefileObj_getPoint(shapefileObj *self,int i,pointObj *point){
        if (i<0 || i>=self->numshapes)
            return MS_FAILURE;

        msSHPReadPoint(self->hSHP, i, point);
        return MS_SUCCESS;
    }
int shapefileObj_getTransformed(shapefileObj *self,mapObj *map,int i,shapeObj *shape){
        if (i<0 || i>=self->numshapes)
            return MS_FAILURE;

        msFreeShape(shape); /* frees all lines and points before re-filling */
        msSHPReadShape(self->hSHP, i, shape);
        msTransformShapeToPixel(shape, map->extent, map->cellsize);

        return MS_SUCCESS;
    }
void shapefileObj_getExtent(shapefileObj *self,int i,rectObj *rect){
        msSHPReadBounds(self->hSHP, i, rect);
    }
int shapefileObj_add(shapefileObj *self,shapeObj *shape){
        /* Trap NULL or empty shapes -- bug 1201 */
        if (!shape) 
        {
            msSetError(19, "Can't add NULL shape", "shapefileObj::add");
            return MS_FAILURE;
        }
        else if (!shape->line)
        {
            msSetError(19, "Can't add empty shape", "shapefileObj::add");
            return MS_FAILURE;
        }

        return msSHPWriteShape(self->hSHP, shape);	
    }
int shapefileObj_addPoint(shapefileObj *self,pointObj *point){    
        return msSHPWritePoint(self->hSHP, point);	
    }
projectionObj *new_projectionObj(char *proj4){
        int status;
        projectionObj *proj=NULL;

        proj = (projectionObj *)malloc(sizeof(projectionObj));
        if (!proj) return NULL;
        msInitProjection(proj);

        status = msLoadProjectionString(proj, proj4);
        if (status == -1) {
            msFreeProjection(proj);
            free(proj);
            return NULL;
        }

        return proj;
    }
void delete_projectionObj(projectionObj *self){
        msFreeProjection(self);
        free(self);		
    }
colorObj *new_colorObj(int red,int green,int blue,int pen){
        colorObj *color;
        
        /* Check colors */
        if (red > 255 || green > 255 || blue > 255) {
            msSetError(12, "Invalid color index.", "colorObj()");
            return NULL;
        }
    
        color = (colorObj *)calloc(1, sizeof(colorObj));
        if (!color)
            return(NULL);
    
        MS_INIT_COLOR(*color, red, green, blue);

        return(color);    	
    }
void delete_colorObj(colorObj *self){
        free(self);
    }
int colorObj_setRGB(colorObj *self,int red,int green,int blue){
        /* Check colors */
        if (red > 255 || green > 255 || blue > 255) {
            msSetError(12, "Invalid color index.", "setRGB()");
            return MS_FAILURE;
        }
    
        MS_INIT_COLOR(*self, red, green, blue);
        return MS_SUCCESS;
    }
int colorObj_setHex(colorObj *self,char *psHexColor){
        int red, green, blue;
        if (psHexColor && strlen(psHexColor)== 7 && psHexColor[0] == '#') {
            red = hex2int(psHexColor+1);
            green = hex2int(psHexColor+3);
            blue= hex2int(psHexColor+5);
            if (red > 255 || green > 255 || blue > 255) {
                msSetError(12, "Invalid color index.", "setHex()");
                return MS_FAILURE;
            }

            MS_INIT_COLOR(*self, red, green, blue);
            return MS_SUCCESS;
        }
        else {
            msSetError(12, "Invalid hex color.", "setHex()");
            return MS_FAILURE;
        }
    }
char *colorObj_toHex(colorObj *self){
        char hexcolor[8] = "";

        if (!self) 
        {
            msSetError(12, "Can't express NULL color as hex",
                       "toHex()");
            return NULL;
        }
        if (self->red < 0 || self->green < 0 || self->blue < 0) 
        {
            msSetError(12, "Can't express invalid color as hex",
                       "toHex()");
            return NULL;
        }
        snprintf(hexcolor, 8, "#%02x%02x%02x",
                 self->red, self->green, self->blue);
        return strdup(hexcolor);
    }
symbolObj *new_symbolObj(char *symbolname,char const *imagefile){
        symbolObj *symbol;
        symbol = (symbolObj *) malloc(sizeof(symbolObj));
        initSymbol(symbol);
        symbol->name = strdup(symbolname);
        if (imagefile) {
            msLoadImageSymbol(symbol, imagefile);
        }
        return symbol;
    }
void delete_symbolObj(symbolObj *self){
        if (!self) return;
        if (self->name) free(self->name);
        if (self->img) gdImageDestroy(self->img);
        if (self->font) free(self->font);
        if (self->imagepath) free(self->imagepath);
        free(self);
    }
int symbolObj_setImagepath(symbolObj *self,char const *imagefile){
	return msLoadImageSymbol(self, imagefile);
    }
int symbolObj_setPoints(symbolObj *self,lineObj *line){
        int i;
        for (i=0; i<line->numpoints; i++) {
            MS_COPYPOINT(&(self->points[i]), &(line->point[i]));
        }
        self->numpoints = line->numpoints;
        return self->numpoints;
    }
lineObj *symbolObj_getPoints(symbolObj *self){
        int i;
        lineObj *line;
        line = (lineObj *) malloc(sizeof(lineObj));
        line->point = (pointObj *) malloc(sizeof(pointObj)*(self->numpoints));
        for (i=0; i<self->numpoints; i++) {
            line->point[i].x = self->points[i].x;
            line->point[i].y = self->points[i].y;
        }
        line->numpoints = self->numpoints;
        return line;
    }
int symbolObj_setStyle(symbolObj *self,int index,int value){
        if (index < 0 || index > 10) {
            msSetError(4, "Can't set style at index %d.", "setStyle()", index);
            return MS_FAILURE;
        }
        self->style[index] = value;
        return MS_SUCCESS;
    }
imageObj *symbolObj_getImage(symbolObj *self,outputFormatObj *format){
        return msSymbolGetImageGD(self, format);
    }
int symbolObj_setImage(symbolObj *self,imageObj *image){
        return msSymbolSetImageGD(self, image);
    }
errorObj *new_errorObj(){    
        return msGetErrorObj();
    }
void delete_errorObj(errorObj *self){}
errorObj *errorObj_next(errorObj *self){
        errorObj *ep;	

        if (self == NULL || self->next == NULL) return NULL;

        ep = msGetErrorObj();
        while (ep != self) {
            /* We reached end of list of active errorObj and 
               didn't find the errorObj... this is bad! */
            if (ep->next == NULL) return NULL;
            ep = ep->next;
        }
    
        return ep->next;
    }

#include "../../map.h"


#include "../../maphash.h"

hashTableObj *new_hashTableObj(){



        return msCreateHashTable();
    }
void delete_hashTableObj(hashTableObj *self){
        msFreeHashTable(self);
    }
int hashTableObj_set(hashTableObj *self,char *key,char *value){
        if (msInsertHashTable(self, key, value) == NULL) {
	        return MS_FAILURE;
        }
        return MS_SUCCESS;
    }
char *hashTableObj_get(hashTableObj *self,char *key,char *default_value){
        char *value = NULL;
        if (!key) {
            msSetError(16, "NULL key", "get");
        }
     
        value = (char *) msLookupHashTable(self, key);
        if (!value) {
            return default_value;
        }
        return value;
    }
int hashTableObj_remove(hashTableObj *self,char *key){
        return msRemoveHashTable(self, key);
    }
void hashTableObj_clear(hashTableObj *self){
        msFreeHashItems(self);
        initHashTable(self);
    }
char const *hashTableObj_nextKey(hashTableObj *self,char *prevkey){
        return msNextKeyFromHashTable(self, (const char *) prevkey);
    }
cgiRequestObj *new_cgiRequestObj(){
        cgiRequestObj *request;
        
        request = msAllocCgiObj();
        if (!request) {
            msSetError(13, "Failed to initialize object","OWSRequest()");
            return NULL;
        }
        
        request->ParamNames = (char **) malloc(100*sizeof(char*));
        request->ParamValues = (char **) malloc(100*sizeof(char*));
        if (request->ParamNames==NULL || request->ParamValues==NULL) {
	        msSetError(2, NULL, "OWSRequest()");
            return NULL;
        }
        return request;
    }
void delete_cgiRequestObj(cgiRequestObj *self){
        msFreeCharArray(self->ParamNames, self->NumParams);
        msFreeCharArray(self->ParamValues, self->NumParams);
        free(self);
    }
int cgiRequestObj_loadParams(cgiRequestObj *self){
	self->NumParams = loadParams( self );
	return self->NumParams;
    }
void cgiRequestObj_setParameter(cgiRequestObj *self,char *name,char *value){
        int i;
        
        if (self->NumParams == 100) {
            msSetError(31, "Maximum number of items, %d, has been reached", "setItem()", 100);
        }
        
        for (i=0; i<self->NumParams; i++) {
            if (strcasecmp(self->ParamNames[i], name) == 0) {
                free(self->ParamValues[i]);
                self->ParamValues[i] = strdup(value);
                break;
            }
        }
        if (i == self->NumParams) {
            self->ParamNames[self->NumParams] = strdup(name);
            self->ParamValues[self->NumParams] = strdup(value);
            self->NumParams++;
        }
    }
char *cgiRequestObj_getName(cgiRequestObj *self,int index){
        if (index < 0 || index >= self->NumParams) {
            msSetError(31, "Invalid index, valid range is [0, %d]", "getName()", self->NumParams-1);
            return NULL;
        }
        return self->ParamNames[index];
    }
char *cgiRequestObj_getValue(cgiRequestObj *self,int index){
        if (index < 0 || index >= self->NumParams) {
            msSetError(31, "Invalid index, valid range is [0, %d]", "getValue()", self->NumParams-1);
            return NULL;
        }
        return self->ParamValues[index];
    }
char *cgiRequestObj_getValueByName(cgiRequestObj *self,char const *name){
        int i;
        for (i=0; i<self->NumParams; i++) {
            if (strcasecmp(self->ParamNames[i], name) == 0) {
                return self->ParamValues[i];
            }
        }
        return NULL;
    }


const char *msIO_getStdoutBufferString() {
    msIOContext *ctx = msIO_getHandler( (FILE *) "stdout" );
    msIOBuffer  *buf;

    if( ctx == NULL || ctx->write_channel == MS_FALSE 
        || strcmp(ctx->label,"buffer") != 0 )
    {
	msSetError( MS_MISCERR, "Can't identify msIO buffer.",
                    "msIO_getStdoutBufferString" );
	return "";
    }

    buf = (msIOBuffer *) ctx->cbData;

    /* write one zero byte and backtrack if it isn't already there */
    if( buf->data_len == 0 || buf->data[buf->data_offset] != '\0' ) {
        msIO_bufferWrite( buf, "", 1 );
	buf->data_offset--;
    }

    return (const char *) (buf->data);
}

gdBuffer msIO_getStdoutBufferBytes() {
    msIOContext *ctx = msIO_getHandler( (FILE *) "stdout" );
    msIOBuffer  *buf;
    gdBuffer     gdBuf;

    if( ctx == NULL || ctx->write_channel == MS_FALSE 
        || strcmp(ctx->label,"buffer") != 0 )
    {
	msSetError( MS_MISCERR, "Can't identify msIO buffer.",
                    "msIO_getStdoutBufferString" );
	gdBuf.data = (unsigned char*)"";
	gdBuf.size = 0;
	gdBuf.owns_data = MS_FALSE;
	return gdBuf;
    }

    buf = (msIOBuffer *) ctx->cbData;

    gdBuf.data = buf->data;
    gdBuf.size = buf->data_offset;
    gdBuf.owns_data = MS_FALSE;

    /* we are seizing ownership of the buffer contents */
    buf->data_offset = 0;
    buf->data_len = 0;
    buf->data = NULL;

    return gdBuf;
}



#ifdef __cplusplus
extern "C" {
#endif

JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_new_1intarray(JNIEnv *jenv, jclass jcls, jint jarg1) {
    jlong jresult = 0 ;
    int arg1 ;
    intarray *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (int)jarg1; 
    result = (intarray *)new_intarray(arg1);
    
    *(intarray **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_delete_1intarray(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    intarray *arg1 = (intarray *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(intarray **)&jarg1; 
    delete_intarray(arg1);
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_intarray_1getitem(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    intarray *arg1 = (intarray *) 0 ;
    int arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(intarray **)&jarg1; 
    arg2 = (int)jarg2; 
    result = (int)intarray_getitem(arg1,arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_intarray_1setitem(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3) {
    intarray *arg1 = (intarray *) 0 ;
    int arg2 ;
    int arg3 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(intarray **)&jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    intarray_setitem(arg1,arg2,arg3);
    
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_intarray_1cast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    intarray *arg1 = (intarray *) 0 ;
    int *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(intarray **)&jarg1; 
    result = (int *)intarray_cast(arg1);
    
    *(int **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_intarray_1frompointer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    int *arg1 = (int *) 0 ;
    intarray *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(int **)&jarg1; 
    result = (intarray *)intarray_frompointer(arg1);
    
    *(intarray **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MAX_1ERROR_1LEN(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 8192;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1VERSION(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (char *) "4.10.0";
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1TRUE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int) 1;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1FALSE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int) 0;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1ON(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int) 1;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1OFF(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int) 0;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1DEFAULT(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int) 2;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1EMBED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int) 3;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1DELETE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int) 4;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1YES(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int) 1;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1NO(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int) 0;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1SINGLE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int) 0;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1MULTIPLE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int) 1;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1GD_1ALPHA(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int) 1000;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1MAXCLASSES(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int) 250;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1MAXSTYLES(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int) 5;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1MAXLAYERS(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int) 200;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1FILE_1MAP(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_FILE_MAP;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1FILE_1SYMBOL(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_FILE_SYMBOL;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1INCHES(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_INCHES;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1FEET(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_FEET;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1MILES(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_MILES;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1METERS(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_METERS;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1KILOMETERS(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_KILOMETERS;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1DD(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_DD;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1PIXELS(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_PIXELS;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1PERCENTAGES(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_PERCENTAGES;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1SHAPE_1POINT(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_SHAPE_POINT;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1SHAPE_1LINE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_SHAPE_LINE;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1SHAPE_1POLYGON(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_SHAPE_POLYGON;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1SHAPE_1NULL(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_SHAPE_NULL;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1LAYER_1POINT(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_LAYER_POINT;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1LAYER_1LINE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_LAYER_LINE;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1LAYER_1POLYGON(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_LAYER_POLYGON;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1LAYER_1RASTER(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_LAYER_RASTER;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1LAYER_1ANNOTATION(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_LAYER_ANNOTATION;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1LAYER_1QUERY(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_LAYER_QUERY;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1LAYER_1CIRCLE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_LAYER_CIRCLE;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1LAYER_1TILEINDEX(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_LAYER_TILEINDEX;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1TRUETYPE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_TRUETYPE;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1BITMAP(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_BITMAP;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1POSITIONS_1LENGTH(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int) 12;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1UL(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_UL;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1LR(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_LR;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1UR(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_UR;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1LL(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_LL;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1CR(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_CR;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1CL(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_CL;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1UC(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_UC;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1LC(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_LC;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1CC(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_CC;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1AUTO(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_AUTO;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1XY(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_XY;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1FOLLOW(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_FOLLOW;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1TINY(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_TINY;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1SMALL(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_SMALL;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1MEDIUM(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_MEDIUM;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1LARGE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_LARGE;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1GIANT(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_GIANT;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1NORMAL(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_NORMAL;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1HILITE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_HILITE;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1SELECTED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_SELECTED;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1INLINE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_INLINE;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1SHAPEFILE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_SHAPEFILE;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1TILED_1SHAPEFILE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_TILED_SHAPEFILE;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1SDE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_SDE;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1OGR(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_OGR;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1UNUSED_11(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_UNUSED_1;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1POSTGIS(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_POSTGIS;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1WMS(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_WMS;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1ORACLESPATIAL(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_ORACLESPATIAL;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1WFS(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_WFS;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1GRATICULE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_GRATICULE;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1MYGIS(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_MYGIS;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1RASTER(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_RASTER;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1PLUGIN(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_PLUGIN;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1DB_1XBASE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_DB_XBASE;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1DB_1CSV(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_DB_CSV;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1DB_1MYSQL(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_DB_MYSQL;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1DB_1ORACLE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_DB_ORACLE;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1DB_1POSTGRES(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_DB_POSTGRES;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1JOIN_1ONE_1TO_1ONE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_JOIN_ONE_TO_ONE;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1JOIN_1ONE_1TO_1MANY(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_JOIN_ONE_TO_MANY;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1CJC_1NONE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_CJC_NONE;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1CJC_1BEVEL(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_CJC_BEVEL;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1CJC_1BUTT(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_CJC_BUTT;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1CJC_1MITER(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_CJC_MITER;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1CJC_1ROUND(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_CJC_ROUND;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1CJC_1SQUARE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_CJC_SQUARE;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1CJC_1TRIANGLE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_CJC_TRIANGLE;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1SUCCESS(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_SUCCESS;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1FAILURE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_FAILURE;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1DONE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_DONE;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1IMAGEMODE_1PC256(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_IMAGEMODE_PC256;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1IMAGEMODE_1RGB(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_IMAGEMODE_RGB;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1IMAGEMODE_1RGBA(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_IMAGEMODE_RGBA;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1IMAGEMODE_1INT16(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_IMAGEMODE_INT16;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1IMAGEMODE_1FLOAT32(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_IMAGEMODE_FLOAT32;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1IMAGEMODE_1BYTE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_IMAGEMODE_BYTE;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1IMAGEMODE_1NULL(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)MS_IMAGEMODE_NULL;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1fontSetObj_1filename(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    fontSetObj *arg1 = (fontSetObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(fontSetObj **)&jarg1; 
    result = (char *) ((arg1)->filename);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1fontSetObj_1numfonts(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    fontSetObj *arg1 = (fontSetObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(fontSetObj **)&jarg1; 
    result = (int) ((arg1)->numfonts);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1fontSetObj_1fonts(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    fontSetObj *arg1 = (fontSetObj *) 0 ;
    hashTableObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(fontSetObj **)&jarg1; 
    result = (hashTableObj *)& ((arg1)->fonts);
    
    *(hashTableObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_new_1fontSetObj(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    fontSetObj *result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (fontSetObj *)(fontSetObj *) calloc(1, sizeof(fontSetObj));
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(fontSetObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_delete_1fontSetObj(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    fontSetObj *arg1 = (fontSetObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(fontSetObj **)&jarg1; 
    {
        errorObj *ms_error;
        free((char *) arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1outputFormatObj_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    outputFormatObj *arg1 = (outputFormatObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(outputFormatObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->name) free((char*)arg1->name);
        if (arg2) {
            arg1->name = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->name,arg2);
        } else {
            arg1->name = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1outputFormatObj_1name(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    outputFormatObj *arg1 = (outputFormatObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(outputFormatObj **)&jarg1; 
    result = (char *) ((arg1)->name);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1outputFormatObj_1mimetype(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    outputFormatObj *arg1 = (outputFormatObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(outputFormatObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->mimetype) free((char*)arg1->mimetype);
        if (arg2) {
            arg1->mimetype = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->mimetype,arg2);
        } else {
            arg1->mimetype = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1outputFormatObj_1mimetype(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    outputFormatObj *arg1 = (outputFormatObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(outputFormatObj **)&jarg1; 
    result = (char *) ((arg1)->mimetype);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1outputFormatObj_1driver(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    outputFormatObj *arg1 = (outputFormatObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(outputFormatObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->driver) free((char*)arg1->driver);
        if (arg2) {
            arg1->driver = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->driver,arg2);
        } else {
            arg1->driver = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1outputFormatObj_1driver(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    outputFormatObj *arg1 = (outputFormatObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(outputFormatObj **)&jarg1; 
    result = (char *) ((arg1)->driver);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1outputFormatObj_1extension(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    outputFormatObj *arg1 = (outputFormatObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(outputFormatObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->extension) free((char*)arg1->extension);
        if (arg2) {
            arg1->extension = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->extension,arg2);
        } else {
            arg1->extension = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1outputFormatObj_1extension(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    outputFormatObj *arg1 = (outputFormatObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(outputFormatObj **)&jarg1; 
    result = (char *) ((arg1)->extension);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1outputFormatObj_1renderer(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    outputFormatObj *arg1 = (outputFormatObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(outputFormatObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->renderer = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1outputFormatObj_1renderer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    outputFormatObj *arg1 = (outputFormatObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(outputFormatObj **)&jarg1; 
    result = (int) ((arg1)->renderer);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1outputFormatObj_1imagemode(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    outputFormatObj *arg1 = (outputFormatObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(outputFormatObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->imagemode = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1outputFormatObj_1imagemode(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    outputFormatObj *arg1 = (outputFormatObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(outputFormatObj **)&jarg1; 
    result = (int) ((arg1)->imagemode);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1outputFormatObj_1transparent(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    outputFormatObj *arg1 = (outputFormatObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(outputFormatObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->transparent = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1outputFormatObj_1transparent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    outputFormatObj *arg1 = (outputFormatObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(outputFormatObj **)&jarg1; 
    result = (int) ((arg1)->transparent);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1outputFormatObj_1bands(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    outputFormatObj *arg1 = (outputFormatObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(outputFormatObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->bands = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1outputFormatObj_1bands(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    outputFormatObj *arg1 = (outputFormatObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(outputFormatObj **)&jarg1; 
    result = (int) ((arg1)->bands);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1outputFormatObj_1numformatoptions(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    outputFormatObj *arg1 = (outputFormatObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(outputFormatObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->numformatoptions = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1outputFormatObj_1numformatoptions(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    outputFormatObj *arg1 = (outputFormatObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(outputFormatObj **)&jarg1; 
    result = (int) ((arg1)->numformatoptions);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1outputFormatObj_1formatoptions(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    outputFormatObj *arg1 = (outputFormatObj *) 0 ;
    char **arg2 = (char **) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(outputFormatObj **)&jarg1; 
    arg2 = *(char ***)&jarg2; 
    if (arg1) (arg1)->formatoptions = arg2;
    
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1outputFormatObj_1formatoptions(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    outputFormatObj *arg1 = (outputFormatObj *) 0 ;
    char **result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(outputFormatObj **)&jarg1; 
    result = (char **) ((arg1)->formatoptions);
    
    *(char ***)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1outputFormatObj_1refcount(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    outputFormatObj *arg1 = (outputFormatObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(outputFormatObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->refcount = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1outputFormatObj_1refcount(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    outputFormatObj *arg1 = (outputFormatObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(outputFormatObj **)&jarg1; 
    result = (int) ((arg1)->refcount);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1outputFormatObj_1inmapfile(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    outputFormatObj *arg1 = (outputFormatObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(outputFormatObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->inmapfile = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1outputFormatObj_1inmapfile(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    outputFormatObj *arg1 = (outputFormatObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(outputFormatObj **)&jarg1; 
    result = (int) ((arg1)->inmapfile);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_new_1outputFormatObj(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
    jlong jresult = 0 ;
    char *arg1 ;
    char *arg2 = (char *) NULL ;
    outputFormatObj *result;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = JNU_GetStringNativeChars(jenv, jarg1);
    }
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        result = (outputFormatObj *)new_outputFormatObj((char const *)arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(outputFormatObj **)&jresult = result; 
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_delete_1outputFormatObj(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    outputFormatObj *arg1 = (outputFormatObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(outputFormatObj **)&jarg1; 
    {
        errorObj *ms_error;
        delete_outputFormatObj(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_outputFormatObj_1setOption(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
    outputFormatObj *arg1 = (outputFormatObj *) 0 ;
    char *arg2 ;
    char *arg3 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(outputFormatObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        arg3 = JNU_GetStringNativeChars(jenv, jarg3);
    }
    {
        errorObj *ms_error;
        outputFormatObj_setOption(arg1,(char const *)arg2,(char const *)arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_outputFormatObj_1validate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    outputFormatObj *arg1 = (outputFormatObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(outputFormatObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (int)outputFormatObj_validate(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_outputFormatObj_1getOption(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
    jstring jresult = 0 ;
    outputFormatObj *arg1 = (outputFormatObj *) 0 ;
    char *arg2 ;
    char *arg3 = (char *) "" ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(outputFormatObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        arg3 = JNU_GetStringNativeChars(jenv, jarg3);
    }
    {
        errorObj *ms_error;
        result = (char *)outputFormatObj_getOption(arg1,(char const *)arg2,(char const *)arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
    free(result);
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1NOOVERRIDE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int) -1111;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1queryMapObj_1height(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    queryMapObj *arg1 = (queryMapObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(queryMapObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->height = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1queryMapObj_1height(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    queryMapObj *arg1 = (queryMapObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(queryMapObj **)&jarg1; 
    result = (int) ((arg1)->height);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1queryMapObj_1width(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    queryMapObj *arg1 = (queryMapObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(queryMapObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->width = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1queryMapObj_1width(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    queryMapObj *arg1 = (queryMapObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(queryMapObj **)&jarg1; 
    result = (int) ((arg1)->width);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1queryMapObj_1status(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    queryMapObj *arg1 = (queryMapObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(queryMapObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->status = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1queryMapObj_1status(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    queryMapObj *arg1 = (queryMapObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(queryMapObj **)&jarg1; 
    result = (int) ((arg1)->status);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1queryMapObj_1style(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    queryMapObj *arg1 = (queryMapObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(queryMapObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->style = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1queryMapObj_1style(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    queryMapObj *arg1 = (queryMapObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(queryMapObj **)&jarg1; 
    result = (int) ((arg1)->style);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1queryMapObj_1color(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    queryMapObj *arg1 = (queryMapObj *) 0 ;
    colorObj *arg2 = (colorObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(queryMapObj **)&jarg1; 
    arg2 = *(colorObj **)&jarg2; 
    if (arg1) (arg1)->color = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1queryMapObj_1color(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    queryMapObj *arg1 = (queryMapObj *) 0 ;
    colorObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(queryMapObj **)&jarg1; 
    result = (colorObj *)& ((arg1)->color);
    
    *(colorObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_new_1queryMapObj(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    queryMapObj *result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (queryMapObj *)(queryMapObj *) calloc(1, sizeof(queryMapObj));
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(queryMapObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_delete_1queryMapObj(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    queryMapObj *arg1 = (queryMapObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(queryMapObj **)&jarg1; 
    {
        errorObj *ms_error;
        free((char *) arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1labelObj_1font(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    labelObj *arg1 = (labelObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->font) free((char*)arg1->font);
        if (arg2) {
            arg1->font = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->font,arg2);
        } else {
            arg1->font = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelObj_1font(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    labelObj *arg1 = (labelObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    result = (char *) ((arg1)->font);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1labelObj_1type(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    labelObj *arg1 = (labelObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->type = (enum MS_FONT_TYPE)arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelObj_1type(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    labelObj *arg1 = (labelObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    result = (int) ((arg1)->type);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1labelObj_1color(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    labelObj *arg1 = (labelObj *) 0 ;
    colorObj *arg2 = (colorObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    arg2 = *(colorObj **)&jarg2; 
    if (arg1) (arg1)->color = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelObj_1color(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    labelObj *arg1 = (labelObj *) 0 ;
    colorObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    result = (colorObj *)& ((arg1)->color);
    
    *(colorObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1labelObj_1outlinecolor(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    labelObj *arg1 = (labelObj *) 0 ;
    colorObj *arg2 = (colorObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    arg2 = *(colorObj **)&jarg2; 
    if (arg1) (arg1)->outlinecolor = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelObj_1outlinecolor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    labelObj *arg1 = (labelObj *) 0 ;
    colorObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    result = (colorObj *)& ((arg1)->outlinecolor);
    
    *(colorObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1labelObj_1shadowcolor(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    labelObj *arg1 = (labelObj *) 0 ;
    colorObj *arg2 = (colorObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    arg2 = *(colorObj **)&jarg2; 
    if (arg1) (arg1)->shadowcolor = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelObj_1shadowcolor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    labelObj *arg1 = (labelObj *) 0 ;
    colorObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    result = (colorObj *)& ((arg1)->shadowcolor);
    
    *(colorObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1labelObj_1shadowsizex(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    labelObj *arg1 = (labelObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->shadowsizex = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelObj_1shadowsizex(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    labelObj *arg1 = (labelObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    result = (int) ((arg1)->shadowsizex);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1labelObj_1shadowsizey(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    labelObj *arg1 = (labelObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->shadowsizey = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelObj_1shadowsizey(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    labelObj *arg1 = (labelObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    result = (int) ((arg1)->shadowsizey);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1labelObj_1backgroundcolor(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    labelObj *arg1 = (labelObj *) 0 ;
    colorObj *arg2 = (colorObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    arg2 = *(colorObj **)&jarg2; 
    if (arg1) (arg1)->backgroundcolor = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelObj_1backgroundcolor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    labelObj *arg1 = (labelObj *) 0 ;
    colorObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    result = (colorObj *)& ((arg1)->backgroundcolor);
    
    *(colorObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1labelObj_1backgroundshadowcolor(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    labelObj *arg1 = (labelObj *) 0 ;
    colorObj *arg2 = (colorObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    arg2 = *(colorObj **)&jarg2; 
    if (arg1) (arg1)->backgroundshadowcolor = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelObj_1backgroundshadowcolor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    labelObj *arg1 = (labelObj *) 0 ;
    colorObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    result = (colorObj *)& ((arg1)->backgroundshadowcolor);
    
    *(colorObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1labelObj_1backgroundshadowsizex(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    labelObj *arg1 = (labelObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->backgroundshadowsizex = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelObj_1backgroundshadowsizex(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    labelObj *arg1 = (labelObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    result = (int) ((arg1)->backgroundshadowsizex);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1labelObj_1backgroundshadowsizey(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    labelObj *arg1 = (labelObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->backgroundshadowsizey = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelObj_1backgroundshadowsizey(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    labelObj *arg1 = (labelObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    result = (int) ((arg1)->backgroundshadowsizey);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1labelObj_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    labelObj *arg1 = (labelObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->size = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelObj_1size(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    labelObj *arg1 = (labelObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    result = (int) ((arg1)->size);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1labelObj_1minsize(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    labelObj *arg1 = (labelObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->minsize = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelObj_1minsize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    labelObj *arg1 = (labelObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    result = (int) ((arg1)->minsize);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1labelObj_1maxsize(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    labelObj *arg1 = (labelObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->maxsize = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelObj_1maxsize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    labelObj *arg1 = (labelObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    result = (int) ((arg1)->maxsize);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1labelObj_1position(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    labelObj *arg1 = (labelObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->position = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelObj_1position(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    labelObj *arg1 = (labelObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    result = (int) ((arg1)->position);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1labelObj_1offsetx(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    labelObj *arg1 = (labelObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->offsetx = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelObj_1offsetx(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    labelObj *arg1 = (labelObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    result = (int) ((arg1)->offsetx);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1labelObj_1offsety(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    labelObj *arg1 = (labelObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->offsety = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelObj_1offsety(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    labelObj *arg1 = (labelObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    result = (int) ((arg1)->offsety);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1labelObj_1angle(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    labelObj *arg1 = (labelObj *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->angle = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelObj_1angle(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    labelObj *arg1 = (labelObj *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    result = (double) ((arg1)->angle);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1labelObj_1autoangle(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    labelObj *arg1 = (labelObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->autoangle = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelObj_1autoangle(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    labelObj *arg1 = (labelObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    result = (int) ((arg1)->autoangle);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1labelObj_1autofollow(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    labelObj *arg1 = (labelObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->autofollow = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelObj_1autofollow(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    labelObj *arg1 = (labelObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    result = (int) ((arg1)->autofollow);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1labelObj_1buffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    labelObj *arg1 = (labelObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->buffer = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelObj_1buffer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    labelObj *arg1 = (labelObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    result = (int) ((arg1)->buffer);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1labelObj_1antialias(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    labelObj *arg1 = (labelObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->antialias = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelObj_1antialias(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    labelObj *arg1 = (labelObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    result = (int) ((arg1)->antialias);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1labelObj_1wrap(JNIEnv *jenv, jclass jcls, jlong jarg1, jchar jarg2) {
    labelObj *arg1 = (labelObj *) 0 ;
    char arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    arg2 = (char)jarg2; 
    if (arg1) (arg1)->wrap = arg2;
    
}


JNIEXPORT jchar JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelObj_1wrap(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jchar jresult = 0 ;
    labelObj *arg1 = (labelObj *) 0 ;
    char result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    result = (char) ((arg1)->wrap);
    
    jresult = (jchar)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1labelObj_1minfeaturesize(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    labelObj *arg1 = (labelObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->minfeaturesize = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelObj_1minfeaturesize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    labelObj *arg1 = (labelObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    result = (int) ((arg1)->minfeaturesize);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1labelObj_1autominfeaturesize(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    labelObj *arg1 = (labelObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->autominfeaturesize = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelObj_1autominfeaturesize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    labelObj *arg1 = (labelObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    result = (int) ((arg1)->autominfeaturesize);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1labelObj_1mindistance(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    labelObj *arg1 = (labelObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->mindistance = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelObj_1mindistance(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    labelObj *arg1 = (labelObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    result = (int) ((arg1)->mindistance);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1labelObj_1partials(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    labelObj *arg1 = (labelObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->partials = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelObj_1partials(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    labelObj *arg1 = (labelObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    result = (int) ((arg1)->partials);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1labelObj_1force(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    labelObj *arg1 = (labelObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->force = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelObj_1force(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    labelObj *arg1 = (labelObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    result = (int) ((arg1)->force);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1labelObj_1encoding(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    labelObj *arg1 = (labelObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->encoding) free((char*)arg1->encoding);
        if (arg2) {
            arg1->encoding = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->encoding,arg2);
        } else {
            arg1->encoding = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelObj_1encoding(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    labelObj *arg1 = (labelObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    result = (char *) ((arg1)->encoding);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_new_1labelObj(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    labelObj *result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (labelObj *)(labelObj *) calloc(1, sizeof(labelObj));
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(labelObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_delete_1labelObj(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    labelObj *arg1 = (labelObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelObj **)&jarg1; 
    {
        errorObj *ms_error;
        free((char *) arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1webObj_1log(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    webObj *arg1 = (webObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->log) free((char*)arg1->log);
        if (arg2) {
            arg1->log = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->log,arg2);
        } else {
            arg1->log = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1webObj_1log(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    webObj *arg1 = (webObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    result = (char *) ((arg1)->log);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1webObj_1imagepath(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    webObj *arg1 = (webObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->imagepath) free((char*)arg1->imagepath);
        if (arg2) {
            arg1->imagepath = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->imagepath,arg2);
        } else {
            arg1->imagepath = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1webObj_1imagepath(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    webObj *arg1 = (webObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    result = (char *) ((arg1)->imagepath);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1webObj_1imageurl(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    webObj *arg1 = (webObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->imageurl) free((char*)arg1->imageurl);
        if (arg2) {
            arg1->imageurl = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->imageurl,arg2);
        } else {
            arg1->imageurl = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1webObj_1imageurl(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    webObj *arg1 = (webObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    result = (char *) ((arg1)->imageurl);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1webObj_1map(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    webObj *arg1 = (webObj *) 0 ;
    struct map_obj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    result = (struct map_obj *) ((arg1)->map);
    
    *(struct map_obj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1webObj_1template(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    webObj *arg1 = (webObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->template) free((char*)arg1->template);
        if (arg2) {
            arg1->template = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->template,arg2);
        } else {
            arg1->template = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1webObj_1template(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    webObj *arg1 = (webObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    result = (char *) ((arg1)->template);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1webObj_1header(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    webObj *arg1 = (webObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->header) free((char*)arg1->header);
        if (arg2) {
            arg1->header = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->header,arg2);
        } else {
            arg1->header = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1webObj_1header(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    webObj *arg1 = (webObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    result = (char *) ((arg1)->header);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1webObj_1footer(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    webObj *arg1 = (webObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->footer) free((char*)arg1->footer);
        if (arg2) {
            arg1->footer = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->footer,arg2);
        } else {
            arg1->footer = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1webObj_1footer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    webObj *arg1 = (webObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    result = (char *) ((arg1)->footer);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1webObj_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    webObj *arg1 = (webObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->empty) free((char*)arg1->empty);
        if (arg2) {
            arg1->empty = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->empty,arg2);
        } else {
            arg1->empty = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1webObj_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    webObj *arg1 = (webObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    result = (char *) ((arg1)->empty);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1webObj_1error(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    webObj *arg1 = (webObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->error) free((char*)arg1->error);
        if (arg2) {
            arg1->error = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->error,arg2);
        } else {
            arg1->error = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1webObj_1error(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    webObj *arg1 = (webObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    result = (char *) ((arg1)->error);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1webObj_1extent(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    webObj *arg1 = (webObj *) 0 ;
    rectObj *arg2 = (rectObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    arg2 = *(rectObj **)&jarg2; 
    if (arg1) (arg1)->extent = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1webObj_1extent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    webObj *arg1 = (webObj *) 0 ;
    rectObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    result = (rectObj *)& ((arg1)->extent);
    
    *(rectObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1webObj_1minscale(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    webObj *arg1 = (webObj *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->minscale = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1webObj_1minscale(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    webObj *arg1 = (webObj *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    result = (double) ((arg1)->minscale);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1webObj_1maxscale(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    webObj *arg1 = (webObj *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->maxscale = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1webObj_1maxscale(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    webObj *arg1 = (webObj *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    result = (double) ((arg1)->maxscale);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1webObj_1mintemplate(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    webObj *arg1 = (webObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->mintemplate) free((char*)arg1->mintemplate);
        if (arg2) {
            arg1->mintemplate = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->mintemplate,arg2);
        } else {
            arg1->mintemplate = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1webObj_1mintemplate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    webObj *arg1 = (webObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    result = (char *) ((arg1)->mintemplate);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1webObj_1maxtemplate(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    webObj *arg1 = (webObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->maxtemplate) free((char*)arg1->maxtemplate);
        if (arg2) {
            arg1->maxtemplate = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->maxtemplate,arg2);
        } else {
            arg1->maxtemplate = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1webObj_1maxtemplate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    webObj *arg1 = (webObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    result = (char *) ((arg1)->maxtemplate);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1webObj_1queryformat(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    webObj *arg1 = (webObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->queryformat) free((char*)arg1->queryformat);
        if (arg2) {
            arg1->queryformat = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->queryformat,arg2);
        } else {
            arg1->queryformat = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1webObj_1queryformat(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    webObj *arg1 = (webObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    result = (char *) ((arg1)->queryformat);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1webObj_1legendformat(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    webObj *arg1 = (webObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->legendformat) free((char*)arg1->legendformat);
        if (arg2) {
            arg1->legendformat = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->legendformat,arg2);
        } else {
            arg1->legendformat = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1webObj_1legendformat(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    webObj *arg1 = (webObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    result = (char *) ((arg1)->legendformat);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1webObj_1browseformat(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    webObj *arg1 = (webObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->browseformat) free((char*)arg1->browseformat);
        if (arg2) {
            arg1->browseformat = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->browseformat,arg2);
        } else {
            arg1->browseformat = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1webObj_1browseformat(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    webObj *arg1 = (webObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    result = (char *) ((arg1)->browseformat);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1webObj_1metadata(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    webObj *arg1 = (webObj *) 0 ;
    hashTableObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    result = (hashTableObj *)& ((arg1)->metadata);
    
    *(hashTableObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_new_1webObj(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    webObj *result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (webObj *)new_webObj();
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(webObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_delete_1webObj(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    webObj *arg1 = (webObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(webObj **)&jarg1; 
    {
        errorObj *ms_error;
        delete_webObj(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1styleObj_1color(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    styleObj *arg1 = (styleObj *) 0 ;
    colorObj *arg2 = (colorObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    arg2 = *(colorObj **)&jarg2; 
    if (arg1) (arg1)->color = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1styleObj_1color(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    styleObj *arg1 = (styleObj *) 0 ;
    colorObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    result = (colorObj *)& ((arg1)->color);
    
    *(colorObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1styleObj_1backgroundcolor(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    styleObj *arg1 = (styleObj *) 0 ;
    colorObj *arg2 = (colorObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    arg2 = *(colorObj **)&jarg2; 
    if (arg1) (arg1)->backgroundcolor = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1styleObj_1backgroundcolor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    styleObj *arg1 = (styleObj *) 0 ;
    colorObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    result = (colorObj *)& ((arg1)->backgroundcolor);
    
    *(colorObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1styleObj_1outlinecolor(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    styleObj *arg1 = (styleObj *) 0 ;
    colorObj *arg2 = (colorObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    arg2 = *(colorObj **)&jarg2; 
    if (arg1) (arg1)->outlinecolor = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1styleObj_1outlinecolor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    styleObj *arg1 = (styleObj *) 0 ;
    colorObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    result = (colorObj *)& ((arg1)->outlinecolor);
    
    *(colorObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1styleObj_1mincolor(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    styleObj *arg1 = (styleObj *) 0 ;
    colorObj *arg2 = (colorObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    arg2 = *(colorObj **)&jarg2; 
    if (arg1) (arg1)->mincolor = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1styleObj_1mincolor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    styleObj *arg1 = (styleObj *) 0 ;
    colorObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    result = (colorObj *)& ((arg1)->mincolor);
    
    *(colorObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1styleObj_1maxcolor(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    styleObj *arg1 = (styleObj *) 0 ;
    colorObj *arg2 = (colorObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    arg2 = *(colorObj **)&jarg2; 
    if (arg1) (arg1)->maxcolor = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1styleObj_1maxcolor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    styleObj *arg1 = (styleObj *) 0 ;
    colorObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    result = (colorObj *)& ((arg1)->maxcolor);
    
    *(colorObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1styleObj_1minvalue(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    styleObj *arg1 = (styleObj *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->minvalue = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1styleObj_1minvalue(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    styleObj *arg1 = (styleObj *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    result = (double) ((arg1)->minvalue);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1styleObj_1maxvalue(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    styleObj *arg1 = (styleObj *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->maxvalue = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1styleObj_1maxvalue(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    styleObj *arg1 = (styleObj *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    result = (double) ((arg1)->maxvalue);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1styleObj_1rangeitem(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    styleObj *arg1 = (styleObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->rangeitem) free((char*)arg1->rangeitem);
        if (arg2) {
            arg1->rangeitem = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->rangeitem,arg2);
        } else {
            arg1->rangeitem = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1styleObj_1rangeitem(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    styleObj *arg1 = (styleObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    result = (char *) ((arg1)->rangeitem);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1styleObj_1rangeitemindex(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    styleObj *arg1 = (styleObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->rangeitemindex = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1styleObj_1rangeitemindex(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    styleObj *arg1 = (styleObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    result = (int) ((arg1)->rangeitemindex);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1styleObj_1symbol(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    styleObj *arg1 = (styleObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->symbol = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1styleObj_1symbol(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    styleObj *arg1 = (styleObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    result = (int) ((arg1)->symbol);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1styleObj_1symbolname(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    styleObj *arg1 = (styleObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->symbolname) free((char*)arg1->symbolname);
        if (arg2) {
            arg1->symbolname = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->symbolname,arg2);
        } else {
            arg1->symbolname = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1styleObj_1symbolname(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    styleObj *arg1 = (styleObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    result = (char *) ((arg1)->symbolname);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1styleObj_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    styleObj *arg1 = (styleObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->size = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1styleObj_1size(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    styleObj *arg1 = (styleObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    result = (int) ((arg1)->size);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1styleObj_1minsize(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    styleObj *arg1 = (styleObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->minsize = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1styleObj_1minsize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    styleObj *arg1 = (styleObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    result = (int) ((arg1)->minsize);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1styleObj_1maxsize(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    styleObj *arg1 = (styleObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->maxsize = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1styleObj_1maxsize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    styleObj *arg1 = (styleObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    result = (int) ((arg1)->maxsize);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1styleObj_1width(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    styleObj *arg1 = (styleObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->width = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1styleObj_1width(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    styleObj *arg1 = (styleObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    result = (int) ((arg1)->width);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1styleObj_1minwidth(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    styleObj *arg1 = (styleObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->minwidth = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1styleObj_1minwidth(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    styleObj *arg1 = (styleObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    result = (int) ((arg1)->minwidth);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1styleObj_1maxwidth(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    styleObj *arg1 = (styleObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->maxwidth = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1styleObj_1maxwidth(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    styleObj *arg1 = (styleObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    result = (int) ((arg1)->maxwidth);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1styleObj_1offsetx(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    styleObj *arg1 = (styleObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->offsetx = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1styleObj_1offsetx(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    styleObj *arg1 = (styleObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    result = (int) ((arg1)->offsetx);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1styleObj_1offsety(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    styleObj *arg1 = (styleObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->offsety = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1styleObj_1offsety(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    styleObj *arg1 = (styleObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    result = (int) ((arg1)->offsety);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1styleObj_1angle(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    styleObj *arg1 = (styleObj *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->angle = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1styleObj_1angle(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    styleObj *arg1 = (styleObj *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    result = (double) ((arg1)->angle);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1styleObj_1antialias(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    styleObj *arg1 = (styleObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->antialias = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1styleObj_1antialias(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    styleObj *arg1 = (styleObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    result = (int) ((arg1)->antialias);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1styleObj_1angleitem(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    styleObj *arg1 = (styleObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->angleitem) free((char*)arg1->angleitem);
        if (arg2) {
            arg1->angleitem = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->angleitem,arg2);
        } else {
            arg1->angleitem = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1styleObj_1angleitem(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    styleObj *arg1 = (styleObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    result = (char *) ((arg1)->angleitem);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1styleObj_1sizeitem(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    styleObj *arg1 = (styleObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->sizeitem) free((char*)arg1->sizeitem);
        if (arg2) {
            arg1->sizeitem = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->sizeitem,arg2);
        } else {
            arg1->sizeitem = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1styleObj_1sizeitem(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    styleObj *arg1 = (styleObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    result = (char *) ((arg1)->sizeitem);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_new_1styleObj(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    classObj *arg1 = (classObj *) NULL ;
    styleObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (styleObj *)new_styleObj(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(styleObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_delete_1styleObj(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    styleObj *arg1 = (styleObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    {
        errorObj *ms_error;
        delete_styleObj(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_styleObj_1cloneStyle(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    styleObj *arg1 = (styleObj *) 0 ;
    styleObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (styleObj *)styleObj_cloneStyle(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(styleObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_styleObj_1setSymbolByName(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3) {
    jint jresult = 0 ;
    styleObj *arg1 = (styleObj *) 0 ;
    mapObj *arg2 = (mapObj *) 0 ;
    char *arg3 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(styleObj **)&jarg1; 
    arg2 = *(mapObj **)&jarg2; 
    {
        arg3 = JNU_GetStringNativeChars(jenv, jarg3);
    }
    {
        errorObj *ms_error;
        result = (int)styleObj_setSymbolByName(arg1,arg2,arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1classObj_1status(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    classObj *arg1 = (classObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->status = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1classObj_1status(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    classObj *arg1 = (classObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    result = (int) ((arg1)->status);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1classObj_1numstyles(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    classObj *arg1 = (classObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->numstyles = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1classObj_1numstyles(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    classObj *arg1 = (classObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    result = (int) ((arg1)->numstyles);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1classObj_1label(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    classObj *arg1 = (classObj *) 0 ;
    labelObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    result = (labelObj *)& ((arg1)->label);
    
    *(labelObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1classObj_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    classObj *arg1 = (classObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->name) free((char*)arg1->name);
        if (arg2) {
            arg1->name = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->name,arg2);
        } else {
            arg1->name = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1classObj_1name(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    classObj *arg1 = (classObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    result = (char *) ((arg1)->name);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1classObj_1title(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    classObj *arg1 = (classObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->title) free((char*)arg1->title);
        if (arg2) {
            arg1->title = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->title,arg2);
        } else {
            arg1->title = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1classObj_1title(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    classObj *arg1 = (classObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    result = (char *) ((arg1)->title);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1classObj_1template(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    classObj *arg1 = (classObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->template) free((char*)arg1->template);
        if (arg2) {
            arg1->template = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->template,arg2);
        } else {
            arg1->template = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1classObj_1template(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    classObj *arg1 = (classObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    result = (char *) ((arg1)->template);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1classObj_1type(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    classObj *arg1 = (classObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->type = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1classObj_1type(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    classObj *arg1 = (classObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    result = (int) ((arg1)->type);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1classObj_1metadata(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    classObj *arg1 = (classObj *) 0 ;
    hashTableObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    result = (hashTableObj *)& ((arg1)->metadata);
    
    *(hashTableObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1classObj_1minscale(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    classObj *arg1 = (classObj *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->minscale = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1classObj_1minscale(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    classObj *arg1 = (classObj *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    result = (double) ((arg1)->minscale);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1classObj_1maxscale(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    classObj *arg1 = (classObj *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->maxscale = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1classObj_1maxscale(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    classObj *arg1 = (classObj *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    result = (double) ((arg1)->maxscale);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1classObj_1layer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    classObj *arg1 = (classObj *) 0 ;
    struct layer_obj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    result = (struct layer_obj *) ((arg1)->layer);
    
    *(struct layer_obj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1classObj_1debug(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    classObj *arg1 = (classObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->debug = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1classObj_1debug(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    classObj *arg1 = (classObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    result = (int) ((arg1)->debug);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1classObj_1keyimage(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    classObj *arg1 = (classObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->keyimage) free((char*)arg1->keyimage);
        if (arg2) {
            arg1->keyimage = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->keyimage,arg2);
        } else {
            arg1->keyimage = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1classObj_1keyimage(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    classObj *arg1 = (classObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    result = (char *) ((arg1)->keyimage);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_new_1classObj(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    layerObj *arg1 = (layerObj *) NULL ;
    classObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (classObj *)new_classObj(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(classObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_delete_1classObj(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    classObj *arg1 = (classObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    {
        errorObj *ms_error;
        delete_classObj(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_classObj_1cloneClass(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    classObj *arg1 = (classObj *) 0 ;
    classObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (classObj *)classObj_cloneClass(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(classObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_classObj_1setExpression(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    classObj *arg1 = (classObj *) 0 ;
    char *arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        result = (int)classObj_setExpression(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_classObj_1getExpressionString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    classObj *arg1 = (classObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (char *)classObj_getExpressionString(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    free(result);
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_classObj_1setText(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    classObj *arg1 = (classObj *) 0 ;
    char *arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        result = (int)classObj_setText(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_classObj_1getTextString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    classObj *arg1 = (classObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (char *)classObj_getTextString(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    free(result);
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_classObj_1getMetaData(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jstring jresult = 0 ;
    classObj *arg1 = (classObj *) 0 ;
    char *arg2 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        result = (char *)classObj_getMetaData(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_classObj_1setMetaData(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
    jint jresult = 0 ;
    classObj *arg1 = (classObj *) 0 ;
    char *arg2 ;
    char *arg3 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        arg3 = JNU_GetStringNativeChars(jenv, jarg3);
    }
    {
        errorObj *ms_error;
        result = (int)classObj_setMetaData(arg1,arg2,arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_classObj_1getFirstMetaDataKey(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    classObj *arg1 = (classObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (char *)classObj_getFirstMetaDataKey(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_classObj_1getNextMetaDataKey(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jstring jresult = 0 ;
    classObj *arg1 = (classObj *) 0 ;
    char *arg2 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        result = (char *)classObj_getNextMetaDataKey(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_classObj_1drawLegendIcon(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4, jint jarg5, jlong jarg6, jint jarg7, jint jarg8) {
    jint jresult = 0 ;
    classObj *arg1 = (classObj *) 0 ;
    mapObj *arg2 = (mapObj *) 0 ;
    layerObj *arg3 = (layerObj *) 0 ;
    int arg4 ;
    int arg5 ;
    imageObj *arg6 = (imageObj *) 0 ;
    int arg7 ;
    int arg8 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    arg2 = *(mapObj **)&jarg2; 
    arg3 = *(layerObj **)&jarg3; 
    arg4 = (int)jarg4; 
    arg5 = (int)jarg5; 
    arg6 = *(imageObj **)&jarg6; 
    arg7 = (int)jarg7; 
    arg8 = (int)jarg8; 
    {
        errorObj *ms_error;
        result = (int)classObj_drawLegendIcon(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_classObj_1createLegendIcon(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4, jint jarg5) {
    jlong jresult = 0 ;
    classObj *arg1 = (classObj *) 0 ;
    mapObj *arg2 = (mapObj *) 0 ;
    layerObj *arg3 = (layerObj *) 0 ;
    int arg4 ;
    int arg5 ;
    imageObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    arg2 = *(mapObj **)&jarg2; 
    arg3 = *(layerObj **)&jarg3; 
    arg4 = (int)jarg4; 
    arg5 = (int)jarg5; 
    {
        errorObj *ms_error;
        result = (imageObj *)classObj_createLegendIcon(arg1,arg2,arg3,arg4,arg5);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(imageObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_classObj_1getStyle(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    classObj *arg1 = (classObj *) 0 ;
    int arg2 ;
    styleObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        errorObj *ms_error;
        result = (styleObj *)classObj_getStyle(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(styleObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_classObj_1insertStyle(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
    jint jresult = 0 ;
    classObj *arg1 = (classObj *) 0 ;
    styleObj *arg2 = (styleObj *) 0 ;
    int arg3 = (int) -1 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    arg2 = *(styleObj **)&jarg2; 
    arg3 = (int)jarg3; 
    {
        errorObj *ms_error;
        result = (int)classObj_insertStyle(arg1,arg2,arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_classObj_1removeStyle(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    classObj *arg1 = (classObj *) 0 ;
    int arg2 ;
    styleObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        errorObj *ms_error;
        result = (styleObj *)classObj_removeStyle(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(styleObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_classObj_1moveStyleUp(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    classObj *arg1 = (classObj *) 0 ;
    int arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        errorObj *ms_error;
        result = (int)classObj_moveStyleUp(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_classObj_1moveStyleDown(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    classObj *arg1 = (classObj *) 0 ;
    int arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(classObj **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        errorObj *ms_error;
        result = (int)classObj_moveStyleDown(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelCacheMemberObj_1text(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    labelCacheMemberObj *arg1 = (labelCacheMemberObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelCacheMemberObj **)&jarg1; 
    result = (char *) ((arg1)->text);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelCacheMemberObj_1featuresize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    labelCacheMemberObj *arg1 = (labelCacheMemberObj *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelCacheMemberObj **)&jarg1; 
    result = (double) ((arg1)->featuresize);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelCacheMemberObj_1styles(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    labelCacheMemberObj *arg1 = (labelCacheMemberObj *) 0 ;
    styleObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelCacheMemberObj **)&jarg1; 
    result = (styleObj *) ((arg1)->styles);
    
    *(styleObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelCacheMemberObj_1numstyles(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    labelCacheMemberObj *arg1 = (labelCacheMemberObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelCacheMemberObj **)&jarg1; 
    result = (int) ((arg1)->numstyles);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelCacheMemberObj_1label(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    labelCacheMemberObj *arg1 = (labelCacheMemberObj *) 0 ;
    labelObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelCacheMemberObj **)&jarg1; 
    result = (labelObj *)& ((arg1)->label);
    
    *(labelObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelCacheMemberObj_1layerindex(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    labelCacheMemberObj *arg1 = (labelCacheMemberObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelCacheMemberObj **)&jarg1; 
    result = (int) ((arg1)->layerindex);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelCacheMemberObj_1classindex(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    labelCacheMemberObj *arg1 = (labelCacheMemberObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelCacheMemberObj **)&jarg1; 
    result = (int) ((arg1)->classindex);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelCacheMemberObj_1tileindex(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    labelCacheMemberObj *arg1 = (labelCacheMemberObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelCacheMemberObj **)&jarg1; 
    result = (int) ((arg1)->tileindex);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelCacheMemberObj_1shapeindex(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    labelCacheMemberObj *arg1 = (labelCacheMemberObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelCacheMemberObj **)&jarg1; 
    result = (int) ((arg1)->shapeindex);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelCacheMemberObj_1point(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    labelCacheMemberObj *arg1 = (labelCacheMemberObj *) 0 ;
    pointObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelCacheMemberObj **)&jarg1; 
    result = (pointObj *)& ((arg1)->point);
    
    *(pointObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelCacheMemberObj_1poly(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    labelCacheMemberObj *arg1 = (labelCacheMemberObj *) 0 ;
    shapeObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelCacheMemberObj **)&jarg1; 
    result = (shapeObj *) ((arg1)->poly);
    
    *(shapeObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelCacheMemberObj_1status(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    labelCacheMemberObj *arg1 = (labelCacheMemberObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelCacheMemberObj **)&jarg1; 
    result = (int) ((arg1)->status);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelCacheMemberObj_1labelpath(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    labelCacheMemberObj *arg1 = (labelCacheMemberObj *) 0 ;
    labelPathObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelCacheMemberObj **)&jarg1; 
    result = (labelPathObj *) ((arg1)->labelpath);
    
    *(labelPathObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_new_1labelCacheMemberObj(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    labelCacheMemberObj *result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (labelCacheMemberObj *)(labelCacheMemberObj *) calloc(1, sizeof(labelCacheMemberObj));
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(labelCacheMemberObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_delete_1labelCacheMemberObj(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    labelCacheMemberObj *arg1 = (labelCacheMemberObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelCacheMemberObj **)&jarg1; 
    {
        errorObj *ms_error;
        free((char *) arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1markerCacheMemberObj_1id(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    markerCacheMemberObj *arg1 = (markerCacheMemberObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(markerCacheMemberObj **)&jarg1; 
    result = (int) ((arg1)->id);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1markerCacheMemberObj_1poly(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    markerCacheMemberObj *arg1 = (markerCacheMemberObj *) 0 ;
    shapeObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(markerCacheMemberObj **)&jarg1; 
    result = (shapeObj *) ((arg1)->poly);
    
    *(shapeObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_new_1markerCacheMemberObj(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    markerCacheMemberObj *result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (markerCacheMemberObj *)(markerCacheMemberObj *) calloc(1, sizeof(markerCacheMemberObj));
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(markerCacheMemberObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_delete_1markerCacheMemberObj(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    markerCacheMemberObj *arg1 = (markerCacheMemberObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(markerCacheMemberObj **)&jarg1; 
    {
        errorObj *ms_error;
        free((char *) arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelCacheObj_1labels(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    labelCacheObj *arg1 = (labelCacheObj *) 0 ;
    labelCacheMemberObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelCacheObj **)&jarg1; 
    result = (labelCacheMemberObj *) ((arg1)->labels);
    
    *(labelCacheMemberObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelCacheObj_1numlabels(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    labelCacheObj *arg1 = (labelCacheObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelCacheObj **)&jarg1; 
    result = (int) ((arg1)->numlabels);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelCacheObj_1cachesize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    labelCacheObj *arg1 = (labelCacheObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelCacheObj **)&jarg1; 
    result = (int) ((arg1)->cachesize);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelCacheObj_1markers(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    labelCacheObj *arg1 = (labelCacheObj *) 0 ;
    markerCacheMemberObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelCacheObj **)&jarg1; 
    result = (markerCacheMemberObj *) ((arg1)->markers);
    
    *(markerCacheMemberObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelCacheObj_1nummarkers(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    labelCacheObj *arg1 = (labelCacheObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelCacheObj **)&jarg1; 
    result = (int) ((arg1)->nummarkers);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1labelCacheObj_1markercachesize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    labelCacheObj *arg1 = (labelCacheObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelCacheObj **)&jarg1; 
    result = (int) ((arg1)->markercachesize);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_labelCacheObj_1freeCache(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    labelCacheObj *arg1 = (labelCacheObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelCacheObj **)&jarg1; 
    {
        errorObj *ms_error;
        labelCacheObj_freeCache(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_new_1labelCacheObj(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    labelCacheObj *result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (labelCacheObj *)(labelCacheObj *) calloc(1, sizeof(labelCacheObj));
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(labelCacheObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_delete_1labelCacheObj(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    labelCacheObj *arg1 = (labelCacheObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(labelCacheObj **)&jarg1; 
    {
        errorObj *ms_error;
        free((char *) arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1resultCacheMemberObj_1shapeindex(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    resultCacheMemberObj *arg1 = (resultCacheMemberObj *) 0 ;
    long result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(resultCacheMemberObj **)&jarg1; 
    result = (long) ((arg1)->shapeindex);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1resultCacheMemberObj_1tileindex(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    resultCacheMemberObj *arg1 = (resultCacheMemberObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(resultCacheMemberObj **)&jarg1; 
    result = (int) ((arg1)->tileindex);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1resultCacheMemberObj_1classindex(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    resultCacheMemberObj *arg1 = (resultCacheMemberObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(resultCacheMemberObj **)&jarg1; 
    result = (int) ((arg1)->classindex);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_new_1resultCacheMemberObj(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    resultCacheMemberObj *result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (resultCacheMemberObj *)(resultCacheMemberObj *) calloc(1, sizeof(resultCacheMemberObj));
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(resultCacheMemberObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_delete_1resultCacheMemberObj(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    resultCacheMemberObj *arg1 = (resultCacheMemberObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(resultCacheMemberObj **)&jarg1; 
    {
        errorObj *ms_error;
        free((char *) arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1resultCacheObj_1numresults(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    resultCacheObj *arg1 = (resultCacheObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(resultCacheObj **)&jarg1; 
    result = (int) ((arg1)->numresults);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1resultCacheObj_1bounds(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    resultCacheObj *arg1 = (resultCacheObj *) 0 ;
    rectObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(resultCacheObj **)&jarg1; 
    result = (rectObj *)& ((arg1)->bounds);
    
    *(rectObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_resultCacheObj_1getResult(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    resultCacheObj *arg1 = (resultCacheObj *) 0 ;
    int arg2 ;
    resultCacheMemberObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(resultCacheObj **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        errorObj *ms_error;
        result = (resultCacheMemberObj *)resultCacheObj_getResult(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(resultCacheMemberObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_new_1resultCacheObj(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    resultCacheObj *result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (resultCacheObj *)(resultCacheObj *) calloc(1, sizeof(resultCacheObj));
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(resultCacheObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_delete_1resultCacheObj(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    resultCacheObj *arg1 = (resultCacheObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(resultCacheObj **)&jarg1; 
    {
        errorObj *ms_error;
        free((char *) arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1symbolSetObj_1filename(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    symbolSetObj *arg1 = (symbolSetObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(symbolSetObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->filename) free((char*)arg1->filename);
        if (arg2) {
            arg1->filename = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->filename,arg2);
        } else {
            arg1->filename = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1symbolSetObj_1filename(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    symbolSetObj *arg1 = (symbolSetObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(symbolSetObj **)&jarg1; 
    result = (char *) ((arg1)->filename);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1symbolSetObj_1imagecachesize(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    symbolSetObj *arg1 = (symbolSetObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(symbolSetObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->imagecachesize = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1symbolSetObj_1imagecachesize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    symbolSetObj *arg1 = (symbolSetObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(symbolSetObj **)&jarg1; 
    result = (int) ((arg1)->imagecachesize);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1symbolSetObj_1numsymbols(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    symbolSetObj *arg1 = (symbolSetObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(symbolSetObj **)&jarg1; 
    result = (int) ((arg1)->numsymbols);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1symbolSetObj_1symbol(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    symbolSetObj *arg1 = (symbolSetObj *) 0 ;
    symbolObj *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(symbolSetObj **)&jarg1; 
    arg2 = *(symbolObj **)&jarg2; 
    {
        int ii;
        symbolObj *b = (symbolObj *) arg1->symbol;
        for (ii = 0; ii < MS_MAXSYMBOLS; ii++) b[ii] = *((symbolObj *) arg2 + ii);
    }
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1symbolSetObj_1symbol(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    symbolSetObj *arg1 = (symbolSetObj *) 0 ;
    symbolObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(symbolSetObj **)&jarg1; 
    result = (symbolObj *)(symbolObj *) ((arg1)->symbol);
    
    *(symbolObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_new_1symbolSetObj(JNIEnv *jenv, jclass jcls, jstring jarg1) {
    jlong jresult = 0 ;
    char *arg1 = (char *) NULL ;
    symbolSetObj *result;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = JNU_GetStringNativeChars(jenv, jarg1);
    }
    {
        errorObj *ms_error;
        result = (symbolSetObj *)new_symbolSetObj((char const *)arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(symbolSetObj **)&jresult = result; 
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_delete_1symbolSetObj(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    symbolSetObj *arg1 = (symbolSetObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(symbolSetObj **)&jarg1; 
    {
        errorObj *ms_error;
        delete_symbolSetObj(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_symbolSetObj_1getSymbol(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    symbolSetObj *arg1 = (symbolSetObj *) 0 ;
    int arg2 ;
    symbolObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(symbolSetObj **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        errorObj *ms_error;
        result = (symbolObj *)symbolSetObj_getSymbol(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(symbolObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_symbolSetObj_1getSymbolByName(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jlong jresult = 0 ;
    symbolSetObj *arg1 = (symbolSetObj *) 0 ;
    char *arg2 ;
    symbolObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(symbolSetObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        result = (symbolObj *)symbolSetObj_getSymbolByName(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(symbolObj **)&jresult = result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_symbolSetObj_1index(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    symbolSetObj *arg1 = (symbolSetObj *) 0 ;
    char *arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(symbolSetObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        result = (int)symbolSetObj_index(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_symbolSetObj_1appendSymbol(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    symbolSetObj *arg1 = (symbolSetObj *) 0 ;
    symbolObj *arg2 = (symbolObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(symbolSetObj **)&jarg1; 
    arg2 = *(symbolObj **)&jarg2; 
    {
        errorObj *ms_error;
        result = (int)symbolSetObj_appendSymbol(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_symbolSetObj_1removeSymbol(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    symbolSetObj *arg1 = (symbolSetObj *) 0 ;
    int arg2 ;
    symbolObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(symbolSetObj **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        errorObj *ms_error;
        result = (symbolObj *)symbolSetObj_removeSymbol(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(symbolObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_symbolSetObj_1save(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    symbolSetObj *arg1 = (symbolSetObj *) 0 ;
    char *arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(symbolSetObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        result = (int)symbolSetObj_save(arg1,(char const *)arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1referenceMapObj_1extent(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    referenceMapObj *arg1 = (referenceMapObj *) 0 ;
    rectObj *arg2 = (rectObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(referenceMapObj **)&jarg1; 
    arg2 = *(rectObj **)&jarg2; 
    if (arg1) (arg1)->extent = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1referenceMapObj_1extent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    referenceMapObj *arg1 = (referenceMapObj *) 0 ;
    rectObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(referenceMapObj **)&jarg1; 
    result = (rectObj *)& ((arg1)->extent);
    
    *(rectObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1referenceMapObj_1height(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    referenceMapObj *arg1 = (referenceMapObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(referenceMapObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->height = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1referenceMapObj_1height(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    referenceMapObj *arg1 = (referenceMapObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(referenceMapObj **)&jarg1; 
    result = (int) ((arg1)->height);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1referenceMapObj_1width(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    referenceMapObj *arg1 = (referenceMapObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(referenceMapObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->width = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1referenceMapObj_1width(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    referenceMapObj *arg1 = (referenceMapObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(referenceMapObj **)&jarg1; 
    result = (int) ((arg1)->width);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1referenceMapObj_1color(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    referenceMapObj *arg1 = (referenceMapObj *) 0 ;
    colorObj *arg2 = (colorObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(referenceMapObj **)&jarg1; 
    arg2 = *(colorObj **)&jarg2; 
    if (arg1) (arg1)->color = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1referenceMapObj_1color(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    referenceMapObj *arg1 = (referenceMapObj *) 0 ;
    colorObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(referenceMapObj **)&jarg1; 
    result = (colorObj *)& ((arg1)->color);
    
    *(colorObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1referenceMapObj_1outlinecolor(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    referenceMapObj *arg1 = (referenceMapObj *) 0 ;
    colorObj *arg2 = (colorObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(referenceMapObj **)&jarg1; 
    arg2 = *(colorObj **)&jarg2; 
    if (arg1) (arg1)->outlinecolor = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1referenceMapObj_1outlinecolor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    referenceMapObj *arg1 = (referenceMapObj *) 0 ;
    colorObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(referenceMapObj **)&jarg1; 
    result = (colorObj *)& ((arg1)->outlinecolor);
    
    *(colorObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1referenceMapObj_1image(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    referenceMapObj *arg1 = (referenceMapObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(referenceMapObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->image) free((char*)arg1->image);
        if (arg2) {
            arg1->image = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->image,arg2);
        } else {
            arg1->image = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1referenceMapObj_1image(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    referenceMapObj *arg1 = (referenceMapObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(referenceMapObj **)&jarg1; 
    result = (char *) ((arg1)->image);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1referenceMapObj_1status(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    referenceMapObj *arg1 = (referenceMapObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(referenceMapObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->status = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1referenceMapObj_1status(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    referenceMapObj *arg1 = (referenceMapObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(referenceMapObj **)&jarg1; 
    result = (int) ((arg1)->status);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1referenceMapObj_1marker(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    referenceMapObj *arg1 = (referenceMapObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(referenceMapObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->marker = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1referenceMapObj_1marker(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    referenceMapObj *arg1 = (referenceMapObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(referenceMapObj **)&jarg1; 
    result = (int) ((arg1)->marker);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1referenceMapObj_1markername(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    referenceMapObj *arg1 = (referenceMapObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(referenceMapObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->markername) free((char*)arg1->markername);
        if (arg2) {
            arg1->markername = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->markername,arg2);
        } else {
            arg1->markername = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1referenceMapObj_1markername(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    referenceMapObj *arg1 = (referenceMapObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(referenceMapObj **)&jarg1; 
    result = (char *) ((arg1)->markername);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1referenceMapObj_1markersize(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    referenceMapObj *arg1 = (referenceMapObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(referenceMapObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->markersize = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1referenceMapObj_1markersize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    referenceMapObj *arg1 = (referenceMapObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(referenceMapObj **)&jarg1; 
    result = (int) ((arg1)->markersize);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1referenceMapObj_1minboxsize(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    referenceMapObj *arg1 = (referenceMapObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(referenceMapObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->minboxsize = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1referenceMapObj_1minboxsize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    referenceMapObj *arg1 = (referenceMapObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(referenceMapObj **)&jarg1; 
    result = (int) ((arg1)->minboxsize);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1referenceMapObj_1maxboxsize(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    referenceMapObj *arg1 = (referenceMapObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(referenceMapObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->maxboxsize = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1referenceMapObj_1maxboxsize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    referenceMapObj *arg1 = (referenceMapObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(referenceMapObj **)&jarg1; 
    result = (int) ((arg1)->maxboxsize);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1referenceMapObj_1map(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    referenceMapObj *arg1 = (referenceMapObj *) 0 ;
    struct map_obj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(referenceMapObj **)&jarg1; 
    result = (struct map_obj *) ((arg1)->map);
    
    *(struct map_obj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_new_1referenceMapObj(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    referenceMapObj *result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (referenceMapObj *)(referenceMapObj *) calloc(1, sizeof(referenceMapObj));
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(referenceMapObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_delete_1referenceMapObj(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    referenceMapObj *arg1 = (referenceMapObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(referenceMapObj **)&jarg1; 
    {
        errorObj *ms_error;
        free((char *) arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1scalebarObj_1imagecolor(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    scalebarObj *arg1 = (scalebarObj *) 0 ;
    colorObj *arg2 = (colorObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(scalebarObj **)&jarg1; 
    arg2 = *(colorObj **)&jarg2; 
    if (arg1) (arg1)->imagecolor = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1scalebarObj_1imagecolor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    scalebarObj *arg1 = (scalebarObj *) 0 ;
    colorObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(scalebarObj **)&jarg1; 
    result = (colorObj *)& ((arg1)->imagecolor);
    
    *(colorObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1scalebarObj_1height(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    scalebarObj *arg1 = (scalebarObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(scalebarObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->height = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1scalebarObj_1height(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    scalebarObj *arg1 = (scalebarObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(scalebarObj **)&jarg1; 
    result = (int) ((arg1)->height);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1scalebarObj_1width(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    scalebarObj *arg1 = (scalebarObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(scalebarObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->width = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1scalebarObj_1width(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    scalebarObj *arg1 = (scalebarObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(scalebarObj **)&jarg1; 
    result = (int) ((arg1)->width);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1scalebarObj_1style(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    scalebarObj *arg1 = (scalebarObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(scalebarObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->style = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1scalebarObj_1style(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    scalebarObj *arg1 = (scalebarObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(scalebarObj **)&jarg1; 
    result = (int) ((arg1)->style);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1scalebarObj_1intervals(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    scalebarObj *arg1 = (scalebarObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(scalebarObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->intervals = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1scalebarObj_1intervals(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    scalebarObj *arg1 = (scalebarObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(scalebarObj **)&jarg1; 
    result = (int) ((arg1)->intervals);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1scalebarObj_1label(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    scalebarObj *arg1 = (scalebarObj *) 0 ;
    labelObj *arg2 = (labelObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(scalebarObj **)&jarg1; 
    arg2 = *(labelObj **)&jarg2; 
    if (arg1) (arg1)->label = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1scalebarObj_1label(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    scalebarObj *arg1 = (scalebarObj *) 0 ;
    labelObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(scalebarObj **)&jarg1; 
    result = (labelObj *)& ((arg1)->label);
    
    *(labelObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1scalebarObj_1color(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    scalebarObj *arg1 = (scalebarObj *) 0 ;
    colorObj *arg2 = (colorObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(scalebarObj **)&jarg1; 
    arg2 = *(colorObj **)&jarg2; 
    if (arg1) (arg1)->color = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1scalebarObj_1color(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    scalebarObj *arg1 = (scalebarObj *) 0 ;
    colorObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(scalebarObj **)&jarg1; 
    result = (colorObj *)& ((arg1)->color);
    
    *(colorObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1scalebarObj_1backgroundcolor(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    scalebarObj *arg1 = (scalebarObj *) 0 ;
    colorObj *arg2 = (colorObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(scalebarObj **)&jarg1; 
    arg2 = *(colorObj **)&jarg2; 
    if (arg1) (arg1)->backgroundcolor = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1scalebarObj_1backgroundcolor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    scalebarObj *arg1 = (scalebarObj *) 0 ;
    colorObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(scalebarObj **)&jarg1; 
    result = (colorObj *)& ((arg1)->backgroundcolor);
    
    *(colorObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1scalebarObj_1outlinecolor(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    scalebarObj *arg1 = (scalebarObj *) 0 ;
    colorObj *arg2 = (colorObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(scalebarObj **)&jarg1; 
    arg2 = *(colorObj **)&jarg2; 
    if (arg1) (arg1)->outlinecolor = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1scalebarObj_1outlinecolor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    scalebarObj *arg1 = (scalebarObj *) 0 ;
    colorObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(scalebarObj **)&jarg1; 
    result = (colorObj *)& ((arg1)->outlinecolor);
    
    *(colorObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1scalebarObj_1units(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    scalebarObj *arg1 = (scalebarObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(scalebarObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->units = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1scalebarObj_1units(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    scalebarObj *arg1 = (scalebarObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(scalebarObj **)&jarg1; 
    result = (int) ((arg1)->units);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1scalebarObj_1status(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    scalebarObj *arg1 = (scalebarObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(scalebarObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->status = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1scalebarObj_1status(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    scalebarObj *arg1 = (scalebarObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(scalebarObj **)&jarg1; 
    result = (int) ((arg1)->status);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1scalebarObj_1position(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    scalebarObj *arg1 = (scalebarObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(scalebarObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->position = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1scalebarObj_1position(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    scalebarObj *arg1 = (scalebarObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(scalebarObj **)&jarg1; 
    result = (int) ((arg1)->position);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1scalebarObj_1postlabelcache(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    scalebarObj *arg1 = (scalebarObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(scalebarObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->postlabelcache = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1scalebarObj_1postlabelcache(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    scalebarObj *arg1 = (scalebarObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(scalebarObj **)&jarg1; 
    result = (int) ((arg1)->postlabelcache);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_new_1scalebarObj(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    scalebarObj *result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (scalebarObj *)(scalebarObj *) calloc(1, sizeof(scalebarObj));
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(scalebarObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_delete_1scalebarObj(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    scalebarObj *arg1 = (scalebarObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(scalebarObj **)&jarg1; 
    {
        errorObj *ms_error;
        free((char *) arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1legendObj_1imagecolor(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    legendObj *arg1 = (legendObj *) 0 ;
    colorObj *arg2 = (colorObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(legendObj **)&jarg1; 
    arg2 = *(colorObj **)&jarg2; 
    if (arg1) (arg1)->imagecolor = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1legendObj_1imagecolor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    legendObj *arg1 = (legendObj *) 0 ;
    colorObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(legendObj **)&jarg1; 
    result = (colorObj *)& ((arg1)->imagecolor);
    
    *(colorObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1legendObj_1label(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    legendObj *arg1 = (legendObj *) 0 ;
    labelObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(legendObj **)&jarg1; 
    result = (labelObj *)& ((arg1)->label);
    
    *(labelObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1legendObj_1keysizex(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    legendObj *arg1 = (legendObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(legendObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->keysizex = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1legendObj_1keysizex(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    legendObj *arg1 = (legendObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(legendObj **)&jarg1; 
    result = (int) ((arg1)->keysizex);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1legendObj_1keysizey(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    legendObj *arg1 = (legendObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(legendObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->keysizey = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1legendObj_1keysizey(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    legendObj *arg1 = (legendObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(legendObj **)&jarg1; 
    result = (int) ((arg1)->keysizey);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1legendObj_1keyspacingx(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    legendObj *arg1 = (legendObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(legendObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->keyspacingx = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1legendObj_1keyspacingx(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    legendObj *arg1 = (legendObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(legendObj **)&jarg1; 
    result = (int) ((arg1)->keyspacingx);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1legendObj_1keyspacingy(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    legendObj *arg1 = (legendObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(legendObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->keyspacingy = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1legendObj_1keyspacingy(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    legendObj *arg1 = (legendObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(legendObj **)&jarg1; 
    result = (int) ((arg1)->keyspacingy);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1legendObj_1outlinecolor(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    legendObj *arg1 = (legendObj *) 0 ;
    colorObj *arg2 = (colorObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(legendObj **)&jarg1; 
    arg2 = *(colorObj **)&jarg2; 
    if (arg1) (arg1)->outlinecolor = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1legendObj_1outlinecolor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    legendObj *arg1 = (legendObj *) 0 ;
    colorObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(legendObj **)&jarg1; 
    result = (colorObj *)& ((arg1)->outlinecolor);
    
    *(colorObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1legendObj_1status(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    legendObj *arg1 = (legendObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(legendObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->status = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1legendObj_1status(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    legendObj *arg1 = (legendObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(legendObj **)&jarg1; 
    result = (int) ((arg1)->status);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1legendObj_1height(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    legendObj *arg1 = (legendObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(legendObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->height = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1legendObj_1height(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    legendObj *arg1 = (legendObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(legendObj **)&jarg1; 
    result = (int) ((arg1)->height);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1legendObj_1width(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    legendObj *arg1 = (legendObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(legendObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->width = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1legendObj_1width(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    legendObj *arg1 = (legendObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(legendObj **)&jarg1; 
    result = (int) ((arg1)->width);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1legendObj_1position(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    legendObj *arg1 = (legendObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(legendObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->position = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1legendObj_1position(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    legendObj *arg1 = (legendObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(legendObj **)&jarg1; 
    result = (int) ((arg1)->position);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1legendObj_1postlabelcache(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    legendObj *arg1 = (legendObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(legendObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->postlabelcache = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1legendObj_1postlabelcache(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    legendObj *arg1 = (legendObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(legendObj **)&jarg1; 
    result = (int) ((arg1)->postlabelcache);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1legendObj_1template(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    legendObj *arg1 = (legendObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(legendObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->template) free((char*)arg1->template);
        if (arg2) {
            arg1->template = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->template,arg2);
        } else {
            arg1->template = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1legendObj_1template(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    legendObj *arg1 = (legendObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(legendObj **)&jarg1; 
    result = (char *) ((arg1)->template);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1legendObj_1map(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    legendObj *arg1 = (legendObj *) 0 ;
    struct map_obj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(legendObj **)&jarg1; 
    result = (struct map_obj *) ((arg1)->map);
    
    *(struct map_obj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_new_1legendObj(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    legendObj *result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (legendObj *)(legendObj *) calloc(1, sizeof(legendObj));
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(legendObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_delete_1legendObj(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    legendObj *arg1 = (legendObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(legendObj **)&jarg1; 
    {
        errorObj *ms_error;
        free((char *) arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1classitem(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->classitem) free((char*)arg1->classitem);
        if (arg2) {
            arg1->classitem = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->classitem,arg2);
        } else {
            arg1->classitem = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1classitem(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (char *) ((arg1)->classitem);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1numclasses(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (int) ((arg1)->numclasses);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1index(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (int) ((arg1)->index);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1map(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    struct map_obj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (struct map_obj *) ((arg1)->map);
    
    *(struct map_obj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1header(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->header) free((char*)arg1->header);
        if (arg2) {
            arg1->header = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->header,arg2);
        } else {
            arg1->header = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1header(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (char *) ((arg1)->header);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1footer(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->footer) free((char*)arg1->footer);
        if (arg2) {
            arg1->footer = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->footer,arg2);
        } else {
            arg1->footer = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1footer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (char *) ((arg1)->footer);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1template(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->template) free((char*)arg1->template);
        if (arg2) {
            arg1->template = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->template,arg2);
        } else {
            arg1->template = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1template(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (char *) ((arg1)->template);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->name) free((char*)arg1->name);
        if (arg2) {
            arg1->name = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->name,arg2);
        } else {
            arg1->name = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1name(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (char *) ((arg1)->name);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1group(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->group) free((char*)arg1->group);
        if (arg2) {
            arg1->group = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->group,arg2);
        } else {
            arg1->group = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1group(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (char *) ((arg1)->group);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1status(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->status = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1status(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (int) ((arg1)->status);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1data(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->data) free((char*)arg1->data);
        if (arg2) {
            arg1->data = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->data,arg2);
        } else {
            arg1->data = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1data(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (char *) ((arg1)->data);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1type(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->type = (enum MS_LAYER_TYPE)arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1type(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (int) ((arg1)->type);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1tolerance(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->tolerance = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1tolerance(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (double) ((arg1)->tolerance);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1toleranceunits(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->toleranceunits = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1toleranceunits(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (int) ((arg1)->toleranceunits);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1symbolscale(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->symbolscale = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1symbolscale(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (double) ((arg1)->symbolscale);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1minscale(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->minscale = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1minscale(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (double) ((arg1)->minscale);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1maxscale(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->maxscale = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1maxscale(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (double) ((arg1)->maxscale);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1labelminscale(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->labelminscale = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1labelminscale(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (double) ((arg1)->labelminscale);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1labelmaxscale(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->labelmaxscale = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1labelmaxscale(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (double) ((arg1)->labelmaxscale);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1sizeunits(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->sizeunits = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1sizeunits(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (int) ((arg1)->sizeunits);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1maxfeatures(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->maxfeatures = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1maxfeatures(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (int) ((arg1)->maxfeatures);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1offsite(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    colorObj *arg2 = (colorObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = *(colorObj **)&jarg2; 
    if (arg1) (arg1)->offsite = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1offsite(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    colorObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (colorObj *)& ((arg1)->offsite);
    
    *(colorObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1transform(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->transform = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1transform(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (int) ((arg1)->transform);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1labelcache(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->labelcache = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1labelcache(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (int) ((arg1)->labelcache);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1postlabelcache(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->postlabelcache = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1postlabelcache(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (int) ((arg1)->postlabelcache);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1labelitem(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->labelitem) free((char*)arg1->labelitem);
        if (arg2) {
            arg1->labelitem = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->labelitem,arg2);
        } else {
            arg1->labelitem = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1labelitem(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (char *) ((arg1)->labelitem);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1labelsizeitem(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->labelsizeitem) free((char*)arg1->labelsizeitem);
        if (arg2) {
            arg1->labelsizeitem = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->labelsizeitem,arg2);
        } else {
            arg1->labelsizeitem = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1labelsizeitem(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (char *) ((arg1)->labelsizeitem);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1labelangleitem(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->labelangleitem) free((char*)arg1->labelangleitem);
        if (arg2) {
            arg1->labelangleitem = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->labelangleitem,arg2);
        } else {
            arg1->labelangleitem = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1labelangleitem(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (char *) ((arg1)->labelangleitem);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1tileitem(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->tileitem) free((char*)arg1->tileitem);
        if (arg2) {
            arg1->tileitem = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->tileitem,arg2);
        } else {
            arg1->tileitem = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1tileitem(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (char *) ((arg1)->tileitem);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1tileindex(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->tileindex) free((char*)arg1->tileindex);
        if (arg2) {
            arg1->tileindex = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->tileindex,arg2);
        } else {
            arg1->tileindex = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1tileindex(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (char *) ((arg1)->tileindex);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1units(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->units = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1units(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (int) ((arg1)->units);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1connection(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->connection) free((char*)arg1->connection);
        if (arg2) {
            arg1->connection = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->connection,arg2);
        } else {
            arg1->connection = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1connection(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (char *) ((arg1)->connection);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1plugin_1library(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->plugin_library) free((char*)arg1->plugin_library);
        if (arg2) {
            arg1->plugin_library = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->plugin_library,arg2);
        } else {
            arg1->plugin_library = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1plugin_1library(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (char *) ((arg1)->plugin_library);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1plugin_1library_1original(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->plugin_library_original) free((char*)arg1->plugin_library_original);
        if (arg2) {
            arg1->plugin_library_original = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->plugin_library_original,arg2);
        } else {
            arg1->plugin_library_original = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1plugin_1library_1original(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (char *) ((arg1)->plugin_library_original);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1connectiontype(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->connectiontype = (enum MS_CONNECTION_TYPE)arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1connectiontype(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (int) ((arg1)->connectiontype);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1numitems(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (int) ((arg1)->numitems);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1bandsitem(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->bandsitem) free((char*)arg1->bandsitem);
        if (arg2) {
            arg1->bandsitem = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->bandsitem,arg2);
        } else {
            arg1->bandsitem = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1bandsitem(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (char *) ((arg1)->bandsitem);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1filteritem(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->filteritem) free((char*)arg1->filteritem);
        if (arg2) {
            arg1->filteritem = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->filteritem,arg2);
        } else {
            arg1->filteritem = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1filteritem(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (char *) ((arg1)->filteritem);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1styleitem(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->styleitem) free((char*)arg1->styleitem);
        if (arg2) {
            arg1->styleitem = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->styleitem,arg2);
        } else {
            arg1->styleitem = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1styleitem(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (char *) ((arg1)->styleitem);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1requires(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->requires) free((char*)arg1->requires);
        if (arg2) {
            arg1->requires = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->requires,arg2);
        } else {
            arg1->requires = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1requires(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (char *) ((arg1)->requires);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1labelrequires(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->labelrequires) free((char*)arg1->labelrequires);
        if (arg2) {
            arg1->labelrequires = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->labelrequires,arg2);
        } else {
            arg1->labelrequires = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1labelrequires(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (char *) ((arg1)->labelrequires);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1metadata(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    hashTableObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (hashTableObj *)& ((arg1)->metadata);
    
    *(hashTableObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1transparency(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->transparency = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1transparency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (int) ((arg1)->transparency);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->dump = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (int) ((arg1)->dump);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1layerObj_1debug(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->debug = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1debug(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (int) ((arg1)->debug);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1numprocessing(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (int) ((arg1)->numprocessing);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1layerObj_1numjoins(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    result = (int) ((arg1)->numjoins);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_new_1layerObj(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    mapObj *arg1 = (mapObj *) NULL ;
    layerObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (layerObj *)new_layerObj(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(layerObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_delete_1layerObj(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    layerObj *arg1 = (layerObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        errorObj *ms_error;
        delete_layerObj(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1cloneLayer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    layerObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (layerObj *)layerObj_cloneLayer(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(layerObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1insertClass(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    classObj *arg2 = (classObj *) 0 ;
    int arg3 = (int) -1 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = *(classObj **)&jarg2; 
    arg3 = (int)jarg3; 
    {
        errorObj *ms_error;
        result = (int)layerObj_insertClass(arg1,arg2,arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1removeClass(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    int arg2 ;
    classObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        errorObj *ms_error;
        result = (classObj *)layerObj_removeClass(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(classObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1open(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (int)layerObj_open(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1whichShapes(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    rectObj arg2 ;
    int result;
    rectObj *argp2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    argp2 = *(rectObj **)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null rectObj");
        return 0;
    }
    arg2 = *argp2; 
    {
        errorObj *ms_error;
        result = (int)layerObj_whichShapes(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1nextShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    shapeObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (shapeObj *)layerObj_nextShape(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(shapeObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1close(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    layerObj *arg1 = (layerObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        errorObj *ms_error;
        layerObj_close(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1getFeature(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3) {
    jlong jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    int arg2 ;
    int arg3 = (int) -1 ;
    shapeObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    {
        errorObj *ms_error;
        result = (shapeObj *)layerObj_getFeature(arg1,arg2,arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(shapeObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1getShape(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jint jarg4) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    shapeObj *arg2 = (shapeObj *) 0 ;
    int arg3 ;
    int arg4 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = *(shapeObj **)&jarg2; 
    arg3 = (int)jarg3; 
    arg4 = (int)jarg4; 
    {
        errorObj *ms_error;
        result = (int)layerObj_getShape(arg1,arg2,arg3,arg4);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1getNumResults(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (int)layerObj_getNumResults(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1getResult(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    int arg2 ;
    resultCacheMemberObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        errorObj *ms_error;
        result = (resultCacheMemberObj *)layerObj_getResult(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(resultCacheMemberObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1getClass(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    int arg2 ;
    classObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        errorObj *ms_error;
        result = (classObj *)layerObj_getClass(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(classObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1getItem(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jstring jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    int arg2 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        errorObj *ms_error;
        result = (char *)layerObj_getItem(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1draw(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    mapObj *arg2 = (mapObj *) 0 ;
    imageObj *arg3 = (imageObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = *(mapObj **)&jarg2; 
    arg3 = *(imageObj **)&jarg3; 
    {
        errorObj *ms_error;
        result = (int)layerObj_draw(arg1,arg2,arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1drawQuery(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    mapObj *arg2 = (mapObj *) 0 ;
    imageObj *arg3 = (imageObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = *(mapObj **)&jarg2; 
    arg3 = *(imageObj **)&jarg3; 
    {
        errorObj *ms_error;
        result = (int)layerObj_drawQuery(arg1,arg2,arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1queryByAttributes(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jstring jarg4, jint jarg5) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    mapObj *arg2 = (mapObj *) 0 ;
    char *arg3 ;
    char *arg4 ;
    int arg5 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = *(mapObj **)&jarg2; 
    {
        arg3 = JNU_GetStringNativeChars(jenv, jarg3);
    }
    {
        arg4 = JNU_GetStringNativeChars(jenv, jarg4);
    }
    arg5 = (int)jarg5; 
    {
        errorObj *ms_error;
        result = (int)layerObj_queryByAttributes(arg1,arg2,arg3,arg4,arg5);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
    {
        if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1queryByPoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4, jdouble jarg5) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    mapObj *arg2 = (mapObj *) 0 ;
    pointObj *arg3 = (pointObj *) 0 ;
    int arg4 ;
    double arg5 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = *(mapObj **)&jarg2; 
    arg3 = *(pointObj **)&jarg3; 
    arg4 = (int)jarg4; 
    arg5 = (double)jarg5; 
    {
        errorObj *ms_error;
        result = (int)layerObj_queryByPoint(arg1,arg2,arg3,arg4,arg5);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1queryByRect(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    mapObj *arg2 = (mapObj *) 0 ;
    rectObj arg3 ;
    int result;
    rectObj *argp3 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = *(mapObj **)&jarg2; 
    argp3 = *(rectObj **)&jarg3; 
    if (!argp3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null rectObj");
        return 0;
    }
    arg3 = *argp3; 
    {
        errorObj *ms_error;
        result = (int)layerObj_queryByRect(arg1,arg2,arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1queryByFeatures(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    mapObj *arg2 = (mapObj *) 0 ;
    int arg3 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = *(mapObj **)&jarg2; 
    arg3 = (int)jarg3; 
    {
        errorObj *ms_error;
        result = (int)layerObj_queryByFeatures(arg1,arg2,arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1queryByShape(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    mapObj *arg2 = (mapObj *) 0 ;
    shapeObj *arg3 = (shapeObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = *(mapObj **)&jarg2; 
    arg3 = *(shapeObj **)&jarg3; 
    {
        errorObj *ms_error;
        result = (int)layerObj_queryByShape(arg1,arg2,arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1queryByIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jint jarg4, jint jarg5) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    mapObj *arg2 = (mapObj *) 0 ;
    int arg3 ;
    int arg4 ;
    int arg5 = (int) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = *(mapObj **)&jarg2; 
    arg3 = (int)jarg3; 
    arg4 = (int)jarg4; 
    arg5 = (int)jarg5; 
    {
        errorObj *ms_error;
        result = (int)layerObj_queryByIndex(arg1,arg2,arg3,arg4,arg5);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1getResults(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    resultCacheObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (resultCacheObj *)layerObj_getResults(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(resultCacheObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1setFilter(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    char *arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        result = (int)layerObj_setFilter(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1getFilterString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (char *)layerObj_getFilterString(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    free(result);
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1setWKTProjection(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    char *arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        result = (int)layerObj_setWKTProjection(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1getProjection(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (char *)layerObj_getProjection(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    free(result);
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1setProjection(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    char *arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        result = (int)layerObj_setProjection(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1addFeature(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    shapeObj *arg2 = (shapeObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = *(shapeObj **)&jarg2; 
    {
        errorObj *ms_error;
        result = (int)layerObj_addFeature(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1getNumFeatures(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (int)layerObj_getNumFeatures(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1getExtent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    rectObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (rectObj *)layerObj_getExtent(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(rectObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1setExtent(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    double arg2 = (double) -1.0 ;
    double arg3 = (double) -1.0 ;
    double arg4 = (double) -1.0 ;
    double arg5 = (double) -1.0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = (double)jarg2; 
    arg3 = (double)jarg3; 
    arg4 = (double)jarg4; 
    arg5 = (double)jarg5; 
    {
        errorObj *ms_error;
        result = (int)layerObj_setExtent(arg1,arg2,arg3,arg4,arg5);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1getMetaData(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jstring jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    char *arg2 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        result = (char *)layerObj_getMetaData(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1setMetaData(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    char *arg2 ;
    char *arg3 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        arg3 = JNU_GetStringNativeChars(jenv, jarg3);
    }
    {
        errorObj *ms_error;
        result = (int)layerObj_setMetaData(arg1,arg2,arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1removeMetaData(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    char *arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        result = (int)layerObj_removeMetaData(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1getFirstMetaDataKey(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (char *)layerObj_getFirstMetaDataKey(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1getNextMetaDataKey(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jstring jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    char *arg2 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        result = (char *)layerObj_getNextMetaDataKey(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1getWMSFeatureInfoURL(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jint jarg4, jint jarg5, jstring jarg6) {
    jstring jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    mapObj *arg2 = (mapObj *) 0 ;
    int arg3 ;
    int arg4 ;
    int arg5 ;
    char *arg6 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = *(mapObj **)&jarg2; 
    arg3 = (int)jarg3; 
    arg4 = (int)jarg4; 
    arg5 = (int)jarg5; 
    {
        arg6 = JNU_GetStringNativeChars(jenv, jarg6);
    }
    {
        errorObj *ms_error;
        result = (char *)layerObj_getWMSFeatureInfoURL(arg1,arg2,arg3,arg4,arg5,arg6);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    {
        if (arg6) (*jenv)->ReleaseStringUTFChars(jenv, jarg6, arg6); 
    }
    free(result);
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1executeWFSGetFeature(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jstring jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    layerObj *arg2 = (layerObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = *(layerObj **)&jarg2; 
    {
        errorObj *ms_error;
        result = (char *)layerObj_executeWFSGetFeature(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    free(result);
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1applySLD(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    char *arg2 ;
    char *arg3 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        arg3 = JNU_GetStringNativeChars(jenv, jarg3);
    }
    {
        errorObj *ms_error;
        result = (int)layerObj_applySLD(arg1,arg2,arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1applySLDURL(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    char *arg2 ;
    char *arg3 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        arg3 = JNU_GetStringNativeChars(jenv, jarg3);
    }
    {
        errorObj *ms_error;
        result = (int)layerObj_applySLDURL(arg1,arg2,arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1generateSLD(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (char *)layerObj_generateSLD(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    free(result);
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1isVisible(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (int)layerObj_isVisible(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1moveClassUp(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    int arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        errorObj *ms_error;
        result = (int)layerObj_moveClassUp(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1moveClassDown(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    int arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        errorObj *ms_error;
        result = (int)layerObj_moveClassDown(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1setProcessingKey(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
    layerObj *arg1 = (layerObj *) 0 ;
    char *arg2 ;
    char *arg3 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        arg3 = JNU_GetStringNativeChars(jenv, jarg3);
    }
    {
        errorObj *ms_error;
        layerObj_setProcessingKey(arg1,(char const *)arg2,(char const *)arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1setProcessing(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        layerObj_setProcessing(arg1,(char const *)arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1addProcessing(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    layerObj *arg1 = (layerObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        layerObj_addProcessing(arg1,(char const *)arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1getProcessing(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jstring jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    int arg2 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        errorObj *ms_error;
        result = (char *)layerObj_getProcessing(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_layerObj_1clearProcessing(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    layerObj *arg1 = (layerObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(layerObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (int)layerObj_clearProcessing(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1mapObj_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    mapObj *arg1 = (mapObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->name) free((char*)arg1->name);
        if (arg2) {
            arg1->name = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->name,arg2);
        } else {
            arg1->name = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1name(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (char *) ((arg1)->name);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1mapObj_1status(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    mapObj *arg1 = (mapObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->status = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1status(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (int) ((arg1)->status);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1mapObj_1height(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    mapObj *arg1 = (mapObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->height = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1height(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (int) ((arg1)->height);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1mapObj_1width(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    mapObj *arg1 = (mapObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->width = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1width(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (int) ((arg1)->width);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1mapObj_1maxsize(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    mapObj *arg1 = (mapObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->maxsize = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1maxsize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (int) ((arg1)->maxsize);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1numlayers(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (int) ((arg1)->numlayers);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1symbolset(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    symbolSetObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (symbolSetObj *)& ((arg1)->symbolset);
    
    *(symbolSetObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1fontset(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    fontSetObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (fontSetObj *)& ((arg1)->fontset);
    
    *(fontSetObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1labelcache(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    labelCacheObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (labelCacheObj *)& ((arg1)->labelcache);
    
    *(labelCacheObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1mapObj_1transparent(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    mapObj *arg1 = (mapObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->transparent = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1transparent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (int) ((arg1)->transparent);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1mapObj_1interlace(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    mapObj *arg1 = (mapObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->interlace = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1interlace(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (int) ((arg1)->interlace);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1mapObj_1imagequality(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    mapObj *arg1 = (mapObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->imagequality = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1imagequality(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (int) ((arg1)->imagequality);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1mapObj_1extent(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    mapObj *arg1 = (mapObj *) 0 ;
    rectObj *arg2 = (rectObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = *(rectObj **)&jarg2; 
    if (arg1) (arg1)->extent = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1extent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    rectObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (rectObj *)& ((arg1)->extent);
    
    *(rectObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1mapObj_1cellsize(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    mapObj *arg1 = (mapObj *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->cellsize = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1cellsize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (double) ((arg1)->cellsize);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1mapObj_1saved_1extent(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    mapObj *arg1 = (mapObj *) 0 ;
    rectObj *arg2 = (rectObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = *(rectObj **)&jarg2; 
    if (arg1) (arg1)->saved_extent = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1saved_1extent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    rectObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (rectObj *)& ((arg1)->saved_extent);
    
    *(rectObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1mapObj_1units(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    mapObj *arg1 = (mapObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->units = (enum MS_UNITS)arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1units(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (int) ((arg1)->units);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1mapObj_1scale(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    mapObj *arg1 = (mapObj *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->scale = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1scale(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (double) ((arg1)->scale);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1mapObj_1resolution(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    mapObj *arg1 = (mapObj *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->resolution = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1resolution(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (double) ((arg1)->resolution);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1mapObj_1shapepath(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    mapObj *arg1 = (mapObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->shapepath) free((char*)arg1->shapepath);
        if (arg2) {
            arg1->shapepath = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->shapepath,arg2);
        } else {
            arg1->shapepath = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1shapepath(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (char *) ((arg1)->shapepath);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1mapObj_1mappath(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    mapObj *arg1 = (mapObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->mappath) free((char*)arg1->mappath);
        if (arg2) {
            arg1->mappath = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->mappath,arg2);
        } else {
            arg1->mappath = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1mappath(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (char *) ((arg1)->mappath);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1mapObj_1imagecolor(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    mapObj *arg1 = (mapObj *) 0 ;
    colorObj *arg2 = (colorObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = *(colorObj **)&jarg2; 
    if (arg1) (arg1)->imagecolor = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1imagecolor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    colorObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (colorObj *)& ((arg1)->imagecolor);
    
    *(colorObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1numoutputformats(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (int) ((arg1)->numoutputformats);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1outputformatlist(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    outputFormatObj **result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (outputFormatObj **) ((arg1)->outputformatlist);
    
    *(outputFormatObj ***)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1outputformat(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    outputFormatObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (outputFormatObj *) ((arg1)->outputformat);
    
    *(outputFormatObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1imagetype(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (char *) ((arg1)->imagetype);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1reference(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    referenceMapObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (referenceMapObj *)& ((arg1)->reference);
    
    *(referenceMapObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1scalebar(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    scalebarObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (scalebarObj *)& ((arg1)->scalebar);
    
    *(scalebarObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1legend(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    legendObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (legendObj *)& ((arg1)->legend);
    
    *(legendObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1querymap(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    queryMapObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (queryMapObj *)& ((arg1)->querymap);
    
    *(queryMapObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1web(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    webObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (webObj *)& ((arg1)->web);
    
    *(webObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1mapObj_1layerorder(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    mapObj *arg1 = (mapObj *) 0 ;
    int *arg2 = (int *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = *(int **)&jarg2; 
    if (arg1) (arg1)->layerorder = arg2;
    
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1layerorder(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    int *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (int *) ((arg1)->layerorder);
    
    *(int **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1mapObj_1debug(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    mapObj *arg1 = (mapObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->debug = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1debug(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (int) ((arg1)->debug);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1mapObj_1datapattern(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    mapObj *arg1 = (mapObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->datapattern) free((char*)arg1->datapattern);
        if (arg2) {
            arg1->datapattern = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->datapattern,arg2);
        } else {
            arg1->datapattern = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1datapattern(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (char *) ((arg1)->datapattern);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1mapObj_1templatepattern(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    mapObj *arg1 = (mapObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->templatepattern) free((char*)arg1->templatepattern);
        if (arg2) {
            arg1->templatepattern = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->templatepattern,arg2);
        } else {
            arg1->templatepattern = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1templatepattern(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (char *) ((arg1)->templatepattern);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1mapObj_1configoptions(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    hashTableObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    result = (hashTableObj *)& ((arg1)->configoptions);
    
    *(hashTableObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_new_1mapObj(JNIEnv *jenv, jclass jcls, jstring jarg1) {
    jlong jresult = 0 ;
    char *arg1 = (char *) "" ;
    mapObj *result;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = JNU_GetStringNativeChars(jenv, jarg1);
    }
    {
        errorObj *ms_error;
        result = (mapObj *)new_mapObj(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(mapObj **)&jresult = result; 
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_delete_1mapObj(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    mapObj *arg1 = (mapObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        errorObj *ms_error;
        delete_mapObj(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1cloneMap(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    mapObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (mapObj *)mapObj_cloneMap(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(mapObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1insertLayer(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    layerObj *arg2 = (layerObj *) 0 ;
    int arg3 = (int) -1 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = *(layerObj **)&jarg2; 
    arg3 = (int)jarg3; 
    {
        errorObj *ms_error;
        result = (int)mapObj_insertLayer(arg1,arg2,arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1removeLayer(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    int arg2 ;
    layerObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        errorObj *ms_error;
        result = (layerObj *)mapObj_removeLayer(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(layerObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1setExtent(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    double arg2 ;
    double arg3 ;
    double arg4 ;
    double arg5 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = (double)jarg2; 
    arg3 = (double)jarg3; 
    arg4 = (double)jarg4; 
    arg5 = (double)jarg5; 
    {
        errorObj *ms_error;
        result = (int)mapObj_setExtent(arg1,arg2,arg3,arg4,arg5);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1setSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    int arg2 ;
    int arg3 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    {
        errorObj *ms_error;
        result = (int)mapObj_setSize(arg1,arg2,arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1setRotation(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    double arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = (double)jarg2; 
    {
        errorObj *ms_error;
        result = (int)mapObj_setRotation(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1getLayer(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    int arg2 ;
    layerObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        errorObj *ms_error;
        result = (layerObj *)mapObj_getLayer(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(layerObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1getLayerByName(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jlong jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    char *arg2 ;
    layerObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        result = (layerObj *)mapObj_getLayerByName(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(layerObj **)&jresult = result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1getSymbolByName(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    char *arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        result = (int)mapObj_getSymbolByName(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1prepareQuery(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    mapObj *arg1 = (mapObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        errorObj *ms_error;
        mapObj_prepareQuery(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1prepareImage(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    imageObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (imageObj *)mapObj_prepareImage(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(imageObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1setImageType(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    mapObj *arg1 = (mapObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        mapObj_setImageType(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1selectOutputFormat(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    mapObj *arg1 = (mapObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        mapObj_selectOutputFormat(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1setOutputFormat(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    mapObj *arg1 = (mapObj *) 0 ;
    outputFormatObj *arg2 = (outputFormatObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = *(outputFormatObj **)&jarg2; 
    {
        errorObj *ms_error;
        mapObj_setOutputFormat(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1draw(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    imageObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (imageObj *)mapObj_draw(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(imageObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1drawQuery(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    imageObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (imageObj *)mapObj_drawQuery(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(imageObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1drawLegend(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    imageObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (imageObj *)mapObj_drawLegend(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(imageObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1drawScalebar(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    imageObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (imageObj *)mapObj_drawScalebar(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(imageObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1drawReferenceMap(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    imageObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (imageObj *)mapObj_drawReferenceMap(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(imageObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1embedScalebar(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    imageObj *arg2 = (imageObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = *(imageObj **)&jarg2; 
    {
        errorObj *ms_error;
        result = (int)mapObj_embedScalebar(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1embedLegend(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    imageObj *arg2 = (imageObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = *(imageObj **)&jarg2; 
    {
        errorObj *ms_error;
        result = (int)mapObj_embedLegend(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1drawLabelCache(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    imageObj *arg2 = (imageObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = *(imageObj **)&jarg2; 
    {
        errorObj *ms_error;
        result = (int)mapObj_drawLabelCache(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1getLabel(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    int arg2 ;
    labelCacheMemberObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        errorObj *ms_error;
        result = (labelCacheMemberObj *)mapObj_getLabel(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(labelCacheMemberObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1nextLabel(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    labelCacheMemberObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (labelCacheMemberObj *)mapObj_nextLabel(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(labelCacheMemberObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1queryByPoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jdouble jarg4) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    pointObj *arg2 = (pointObj *) 0 ;
    int arg3 ;
    double arg4 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = *(pointObj **)&jarg2; 
    arg3 = (int)jarg3; 
    arg4 = (double)jarg4; 
    {
        errorObj *ms_error;
        result = (int)mapObj_queryByPoint(arg1,arg2,arg3,arg4);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1queryByRect(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    rectObj arg2 ;
    int result;
    rectObj *argp2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    argp2 = *(rectObj **)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null rectObj");
        return 0;
    }
    arg2 = *argp2; 
    {
        errorObj *ms_error;
        result = (int)mapObj_queryByRect(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1queryByFeatures(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    int arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        errorObj *ms_error;
        result = (int)mapObj_queryByFeatures(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1queryByShape(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    shapeObj *arg2 = (shapeObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = *(shapeObj **)&jarg2; 
    {
        errorObj *ms_error;
        result = (int)mapObj_queryByShape(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1setWKTProjection(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    char *arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        result = (int)mapObj_setWKTProjection(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1getProjection(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (char *)mapObj_getProjection(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    free(result);
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1setProjection(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    char *arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        result = (int)mapObj_setProjection(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1save(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    char *arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        result = (int)mapObj_save(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1saveQuery(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    char *arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        result = (int)mapObj_saveQuery(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1loadQuery(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    char *arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        result = (int)mapObj_loadQuery(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1freeQuery(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    mapObj *arg1 = (mapObj *) 0 ;
    int arg2 = (int) -1 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        errorObj *ms_error;
        mapObj_freeQuery(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1saveQueryAsGML(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    char *arg2 ;
    char *arg3 = (char *) "GOMF" ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        arg3 = JNU_GetStringNativeChars(jenv, jarg3);
    }
    {
        errorObj *ms_error;
        result = (int)mapObj_saveQueryAsGML(arg1,arg2,(char const *)arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1getMetaData(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jstring jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    char *arg2 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        result = (char *)mapObj_getMetaData(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1setMetaData(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    char *arg2 ;
    char *arg3 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        arg3 = JNU_GetStringNativeChars(jenv, jarg3);
    }
    {
        errorObj *ms_error;
        result = (int)mapObj_setMetaData(arg1,arg2,arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1removeMetaData(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    char *arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        result = (int)mapObj_removeMetaData(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1getFirstMetaDataKey(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (char *)mapObj_getFirstMetaDataKey(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1getNextMetaDataKey(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jstring jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    char *arg2 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        result = (char *)mapObj_getNextMetaDataKey(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1setSymbolSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    char *arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        result = (int)mapObj_setSymbolSet(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1getNumSymbols(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (int)mapObj_getNumSymbols(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1setFontSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    char *arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        result = (int)mapObj_setFontSet(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1saveMapContext(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    char *arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        result = (int)mapObj_saveMapContext(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1loadMapContext(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    char *arg2 ;
    int arg3 = (int) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    arg3 = (int)jarg3; 
    {
        errorObj *ms_error;
        result = (int)mapObj_loadMapContext(arg1,arg2,arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1moveLayerUp(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    int arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        errorObj *ms_error;
        result = (int)mapObj_moveLayerUp(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1moveLayerDown(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    int arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        errorObj *ms_error;
        result = (int)mapObj_moveLayerDown(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1getLayersDrawingOrder(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    intarray *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (intarray *)mapObj_getLayersDrawingOrder(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(intarray **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1setLayersDrawingOrder(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    int *arg2 = (int *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = *(int **)&jarg2; 
    {
        errorObj *ms_error;
        result = (int)mapObj_setLayersDrawingOrder(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1setConfigOption(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
    mapObj *arg1 = (mapObj *) 0 ;
    char *arg2 ;
    char *arg3 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        arg3 = JNU_GetStringNativeChars(jenv, jarg3);
    }
    {
        errorObj *ms_error;
        mapObj_setConfigOption(arg1,arg2,arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1getConfigOption(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jstring jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    char *arg2 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        result = (char *)mapObj_getConfigOption(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1applyConfigOptions(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    mapObj *arg1 = (mapObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        errorObj *ms_error;
        mapObj_applyConfigOptions(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1applySLD(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    char *arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        result = (int)mapObj_applySLD(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1applySLDURL(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    char *arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        result = (int)mapObj_applySLDURL(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1generateSLD(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (char *)mapObj_generateSLD(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    free(result);
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1processTemplate(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jlong jarg4, jint jarg5) {
    jstring jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    int arg2 ;
    char **arg3 = (char **) 0 ;
    char **arg4 = (char **) 0 ;
    int arg5 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = (int)jarg2; 
    arg3 = *(char ***)&jarg3; 
    arg4 = *(char ***)&jarg4; 
    arg5 = (int)jarg5; 
    {
        errorObj *ms_error;
        result = (char *)mapObj_processTemplate(arg1,arg2,arg3,arg4,arg5);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    free(result);
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1processLegendTemplate(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4) {
    jstring jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    char **arg2 = (char **) 0 ;
    char **arg3 = (char **) 0 ;
    int arg4 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = *(char ***)&jarg2; 
    arg3 = *(char ***)&jarg3; 
    arg4 = (int)jarg4; 
    {
        errorObj *ms_error;
        result = (char *)mapObj_processLegendTemplate(arg1,arg2,arg3,arg4);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    free(result);
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1processQueryTemplate(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4) {
    jstring jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    char **arg2 = (char **) 0 ;
    char **arg3 = (char **) 0 ;
    int arg4 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = *(char ***)&jarg2; 
    arg3 = *(char ***)&jarg3; 
    arg4 = (int)jarg4; 
    {
        errorObj *ms_error;
        result = (char *)mapObj_processQueryTemplate(arg1,arg2,arg3,arg4);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    free(result);
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1getOutputFormatByName(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jlong jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    char *arg2 ;
    outputFormatObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        result = (outputFormatObj *)mapObj_getOutputFormatByName(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(outputFormatObj **)&jresult = result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1appendOutputFormat(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    outputFormatObj *arg2 = (outputFormatObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = *(outputFormatObj **)&jarg2; 
    {
        errorObj *ms_error;
        result = (int)mapObj_appendOutputFormat(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1removeOutputFormat(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    char *arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        errorObj *ms_error;
        result = (int)mapObj_removeOutputFormat(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1loadOWSParameters(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    cgiRequestObj *arg2 = (cgiRequestObj *) 0 ;
    char *arg3 = (char *) "1.1.1" ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = *(cgiRequestObj **)&jarg2; 
    {
        arg3 = JNU_GetStringNativeChars(jenv, jarg3);
    }
    {
        errorObj *ms_error;
        result = (int)mapObj_loadOWSParameters(arg1,arg2,arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1OWSDispatch(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    cgiRequestObj *arg2 = (cgiRequestObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = *(cgiRequestObj **)&jarg2; 
    {
        errorObj *ms_error;
        result = (int)mapObj_OWSDispatch(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1zoomPoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jint jarg4, jint jarg5, jlong jarg6, jlong jarg7) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    int arg2 ;
    pointObj *arg3 = (pointObj *) 0 ;
    int arg4 ;
    int arg5 ;
    rectObj *arg6 = (rectObj *) 0 ;
    rectObj *arg7 = (rectObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = (int)jarg2; 
    arg3 = *(pointObj **)&jarg3; 
    arg4 = (int)jarg4; 
    arg5 = (int)jarg5; 
    arg6 = *(rectObj **)&jarg6; 
    arg7 = *(rectObj **)&jarg7; 
    {
        errorObj *ms_error;
        result = (int)mapObj_zoomPoint(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1zoomRectangle(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jint jarg4, jlong jarg5, jlong jarg6) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    rectObj *arg2 = (rectObj *) 0 ;
    int arg3 ;
    int arg4 ;
    rectObj *arg5 = (rectObj *) 0 ;
    rectObj *arg6 = (rectObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = *(rectObj **)&jarg2; 
    arg3 = (int)jarg3; 
    arg4 = (int)jarg4; 
    arg5 = *(rectObj **)&jarg5; 
    arg6 = *(rectObj **)&jarg6; 
    {
        errorObj *ms_error;
        result = (int)mapObj_zoomRectangle(arg1,arg2,arg3,arg4,arg5,arg6);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_mapObj_1zoomScale(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jlong jarg3, jint jarg4, jint jarg5, jlong jarg6, jlong jarg7) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    double arg2 ;
    pointObj *arg3 = (pointObj *) 0 ;
    int arg4 ;
    int arg5 ;
    rectObj *arg6 = (rectObj *) 0 ;
    rectObj *arg7 = (rectObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = (double)jarg2; 
    arg3 = *(pointObj **)&jarg3; 
    arg4 = (int)jarg4; 
    arg5 = (int)jarg5; 
    arg6 = *(rectObj **)&jarg6; 
    arg7 = *(rectObj **)&jarg7; 
    {
        errorObj *ms_error;
        result = (int)mapObj_zoomScale(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1imageObj_1width(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    imageObj *arg1 = (imageObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(imageObj **)&jarg1; 
    result = (int) ((arg1)->width);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1imageObj_1height(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    imageObj *arg1 = (imageObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(imageObj **)&jarg1; 
    result = (int) ((arg1)->height);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1imageObj_1imagepath(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    imageObj *arg1 = (imageObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(imageObj **)&jarg1; 
    result = (char *) ((arg1)->imagepath);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1imageObj_1imageurl(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    imageObj *arg1 = (imageObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(imageObj **)&jarg1; 
    result = (char *) ((arg1)->imageurl);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1imageObj_1format(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    imageObj *arg1 = (imageObj *) 0 ;
    outputFormatObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(imageObj **)&jarg1; 
    result = (outputFormatObj *) ((arg1)->format);
    
    *(outputFormatObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1imageObj_1renderer(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    imageObj *arg1 = (imageObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(imageObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->renderer = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1imageObj_1renderer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    imageObj *arg1 = (imageObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(imageObj **)&jarg1; 
    result = (int) ((arg1)->renderer);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1imageObj_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    imageObj *arg1 = (imageObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(imageObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->size = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1imageObj_1size(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    imageObj *arg1 = (imageObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(imageObj **)&jarg1; 
    result = (int) ((arg1)->size);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_new_1imageObj(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jlong jarg3, jstring jarg4) {
    jlong jresult = 0 ;
    int arg1 ;
    int arg2 ;
    outputFormatObj *arg3 = (outputFormatObj *) NULL ;
    char *arg4 = (char *) NULL ;
    imageObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (int)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = *(outputFormatObj **)&jarg3; 
    {
        arg4 = JNU_GetStringNativeChars(jenv, jarg4);
    }
    {
        errorObj *ms_error;
        result = (imageObj *)new_imageObj(arg1,arg2,arg3,(char const *)arg4);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(imageObj **)&jresult = result; 
    {
        if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_delete_1imageObj(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    imageObj *arg1 = (imageObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(imageObj **)&jarg1; 
    {
        errorObj *ms_error;
        delete_imageObj(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_imageObj_1save(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
    imageObj *arg1 = (imageObj *) 0 ;
    char *arg2 ;
    mapObj *arg3 = (mapObj *) NULL ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(imageObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    arg3 = *(mapObj **)&jarg3; 
    {
        errorObj *ms_error;
        imageObj_save(arg1,arg2,arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_imageObj_1write(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    imageObj *arg1 = (imageObj *) 0 ;
    FILE *arg2 = (FILE *) NULL ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(imageObj **)&jarg1; 
    arg2 = *(FILE **)&jarg2; 
    {
        errorObj *ms_error;
        result = (int)imageObj_write(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jbyteArray JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_imageObj_1getBytes(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jbyteArray jresult = 0 ;
    imageObj *arg1 = (imageObj *) 0 ;
    gdBuffer result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(imageObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = imageObj_getBytes(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = SWIG_JavaArrayOutSchar(jenv, (&result)->data, (&result)->size); 
    if( (&result)->owns_data ) gdFree((&result)->data); 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_msSaveImage(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3) {
    jint jresult = 0 ;
    mapObj *arg1 = (mapObj *) 0 ;
    imageObj *arg2 = (imageObj *) 0 ;
    char *arg3 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(mapObj **)&jarg1; 
    arg2 = *(imageObj **)&jarg2; 
    {
        arg3 = JNU_GetStringNativeChars(jenv, jarg3);
    }
    {
        errorObj *ms_error;
        result = (int)msSaveImage(arg1,arg2,arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_msFreeImage(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    imageObj *arg1 = (imageObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(imageObj **)&jarg1; 
    {
        errorObj *ms_error;
        msFreeImage(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_msSetup(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)msSetup();
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_msCleanup(JNIEnv *jenv, jclass jcls) {
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        msCleanup();
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1rectObj_1minx(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    rectObj *arg1 = (rectObj *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(rectObj **)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->minx = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1rectObj_1minx(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    rectObj *arg1 = (rectObj *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(rectObj **)&jarg1; 
    result = (double) ((arg1)->minx);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1rectObj_1miny(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    rectObj *arg1 = (rectObj *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(rectObj **)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->miny = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1rectObj_1miny(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    rectObj *arg1 = (rectObj *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(rectObj **)&jarg1; 
    result = (double) ((arg1)->miny);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1rectObj_1maxx(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    rectObj *arg1 = (rectObj *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(rectObj **)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->maxx = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1rectObj_1maxx(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    rectObj *arg1 = (rectObj *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(rectObj **)&jarg1; 
    result = (double) ((arg1)->maxx);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1rectObj_1maxy(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    rectObj *arg1 = (rectObj *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(rectObj **)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->maxy = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1rectObj_1maxy(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    rectObj *arg1 = (rectObj *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(rectObj **)&jarg1; 
    result = (double) ((arg1)->maxy);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_new_1rectObj(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4, jint jarg5) {
    jlong jresult = 0 ;
    double arg1 = (double) -1.0 ;
    double arg2 = (double) -1.0 ;
    double arg3 = (double) -1.0 ;
    double arg4 = (double) -1.0 ;
    int arg5 = (int) 0 ;
    rectObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (double)jarg1; 
    arg2 = (double)jarg2; 
    arg3 = (double)jarg3; 
    arg4 = (double)jarg4; 
    arg5 = (int)jarg5; 
    {
        errorObj *ms_error;
        result = (rectObj *)new_rectObj(arg1,arg2,arg3,arg4,arg5);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(rectObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_delete_1rectObj(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    rectObj *arg1 = (rectObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(rectObj **)&jarg1; 
    {
        errorObj *ms_error;
        delete_rectObj(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_rectObj_1project(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jint jresult = 0 ;
    rectObj *arg1 = (rectObj *) 0 ;
    projectionObj *arg2 = (projectionObj *) 0 ;
    projectionObj *arg3 = (projectionObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(rectObj **)&jarg1; 
    arg2 = *(projectionObj **)&jarg2; 
    arg3 = *(projectionObj **)&jarg3; 
    {
        errorObj *ms_error;
        result = (int)rectObj_project(arg1,arg2,arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_rectObj_1fit(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3) {
    jdouble jresult = 0 ;
    rectObj *arg1 = (rectObj *) 0 ;
    int arg2 ;
    int arg3 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(rectObj **)&jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    {
        errorObj *ms_error;
        result = (double)rectObj_fit(arg1,arg2,arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_rectObj_1draw(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jint jarg5, jstring jarg6) {
    jint jresult = 0 ;
    rectObj *arg1 = (rectObj *) 0 ;
    mapObj *arg2 = (mapObj *) 0 ;
    layerObj *arg3 = (layerObj *) 0 ;
    imageObj *arg4 = (imageObj *) 0 ;
    int arg5 ;
    char *arg6 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(rectObj **)&jarg1; 
    arg2 = *(mapObj **)&jarg2; 
    arg3 = *(layerObj **)&jarg3; 
    arg4 = *(imageObj **)&jarg4; 
    arg5 = (int)jarg5; 
    {
        arg6 = JNU_GetStringNativeChars(jenv, jarg6);
    }
    {
        errorObj *ms_error;
        result = (int)rectObj_draw(arg1,arg2,arg3,arg4,arg5,arg6);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg6) (*jenv)->ReleaseStringUTFChars(jenv, jarg6, arg6); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_rectObj_1toPolygon(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    rectObj *arg1 = (rectObj *) 0 ;
    shapeObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(rectObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (shapeObj *)rectObj_toPolygon(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(shapeObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_rectObj_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    rectObj *arg1 = (rectObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(rectObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (char *)rectObj_toString(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1pointObj_1x(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    pointObj *arg1 = (pointObj *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(pointObj **)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->x = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1pointObj_1x(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    pointObj *arg1 = (pointObj *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(pointObj **)&jarg1; 
    result = (double) ((arg1)->x);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1pointObj_1y(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    pointObj *arg1 = (pointObj *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(pointObj **)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->y = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1pointObj_1y(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    pointObj *arg1 = (pointObj *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(pointObj **)&jarg1; 
    result = (double) ((arg1)->y);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_delete_1pointObj(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    pointObj *arg1 = (pointObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(pointObj **)&jarg1; 
    {
        errorObj *ms_error;
        delete_pointObj(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_pointObj_1project(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jint jresult = 0 ;
    pointObj *arg1 = (pointObj *) 0 ;
    projectionObj *arg2 = (projectionObj *) 0 ;
    projectionObj *arg3 = (projectionObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(pointObj **)&jarg1; 
    arg2 = *(projectionObj **)&jarg2; 
    arg3 = *(projectionObj **)&jarg3; 
    {
        errorObj *ms_error;
        result = (int)pointObj_project(arg1,arg2,arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_pointObj_1draw(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jint jarg5, jstring jarg6) {
    jint jresult = 0 ;
    pointObj *arg1 = (pointObj *) 0 ;
    mapObj *arg2 = (mapObj *) 0 ;
    layerObj *arg3 = (layerObj *) 0 ;
    imageObj *arg4 = (imageObj *) 0 ;
    int arg5 ;
    char *arg6 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(pointObj **)&jarg1; 
    arg2 = *(mapObj **)&jarg2; 
    arg3 = *(layerObj **)&jarg3; 
    arg4 = *(imageObj **)&jarg4; 
    arg5 = (int)jarg5; 
    {
        arg6 = JNU_GetStringNativeChars(jenv, jarg6);
    }
    {
        errorObj *ms_error;
        result = (int)pointObj_draw(arg1,arg2,arg3,arg4,arg5,arg6);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg6) (*jenv)->ReleaseStringUTFChars(jenv, jarg6, arg6); 
    }
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_pointObj_1distanceToPoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jdouble jresult = 0 ;
    pointObj *arg1 = (pointObj *) 0 ;
    pointObj *arg2 = (pointObj *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(pointObj **)&jarg1; 
    arg2 = *(pointObj **)&jarg2; 
    {
        errorObj *ms_error;
        result = (double)pointObj_distanceToPoint(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_pointObj_1distanceToSegment(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jdouble jresult = 0 ;
    pointObj *arg1 = (pointObj *) 0 ;
    pointObj *arg2 = (pointObj *) 0 ;
    pointObj *arg3 = (pointObj *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(pointObj **)&jarg1; 
    arg2 = *(pointObj **)&jarg2; 
    arg3 = *(pointObj **)&jarg3; 
    {
        errorObj *ms_error;
        result = (double)pointObj_distanceToSegment(arg1,arg2,arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_pointObj_1distanceToShape(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jdouble jresult = 0 ;
    pointObj *arg1 = (pointObj *) 0 ;
    shapeObj *arg2 = (shapeObj *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(pointObj **)&jarg1; 
    arg2 = *(shapeObj **)&jarg2; 
    {
        errorObj *ms_error;
        result = (double)pointObj_distanceToShape(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_pointObj_1setXY(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4) {
    jint jresult = 0 ;
    pointObj *arg1 = (pointObj *) 0 ;
    double arg2 ;
    double arg3 ;
    double arg4 = (double) -2e38 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(pointObj **)&jarg1; 
    arg2 = (double)jarg2; 
    arg3 = (double)jarg3; 
    arg4 = (double)jarg4; 
    {
        errorObj *ms_error;
        result = (int)pointObj_setXY(arg1,arg2,arg3,arg4);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_pointObj_1setXYZ(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5) {
    jint jresult = 0 ;
    pointObj *arg1 = (pointObj *) 0 ;
    double arg2 ;
    double arg3 ;
    double arg4 ;
    double arg5 = (double) -2e38 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(pointObj **)&jarg1; 
    arg2 = (double)jarg2; 
    arg3 = (double)jarg3; 
    arg4 = (double)jarg4; 
    arg5 = (double)jarg5; 
    {
        errorObj *ms_error;
        result = (int)pointObj_setXYZ(arg1,arg2,arg3,arg4,arg5);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_pointObj_1setXYZM(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5) {
    jint jresult = 0 ;
    pointObj *arg1 = (pointObj *) 0 ;
    double arg2 ;
    double arg3 ;
    double arg4 ;
    double arg5 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(pointObj **)&jarg1; 
    arg2 = (double)jarg2; 
    arg3 = (double)jarg3; 
    arg4 = (double)jarg4; 
    arg5 = (double)jarg5; 
    {
        errorObj *ms_error;
        result = (int)pointObj_setXYZM(arg1,arg2,arg3,arg4,arg5);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_pointObj_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    pointObj *arg1 = (pointObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(pointObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (char *)pointObj_toString(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    free(result);
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_pointObj_1toShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    pointObj *arg1 = (pointObj *) 0 ;
    shapeObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(pointObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (shapeObj *)pointObj_toShape(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(shapeObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_new_1pointObj_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4) {
    jlong jresult = 0 ;
    double arg1 ;
    double arg2 ;
    double arg3 ;
    double arg4 ;
    pointObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (double)jarg1; 
    arg2 = (double)jarg2; 
    arg3 = (double)jarg3; 
    arg4 = (double)jarg4; 
    {
        errorObj *ms_error;
        result = (pointObj *)new_pointObj__SWIG_0(arg1,arg2,arg3,arg4);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(pointObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_new_1pointObj_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2, jdouble jarg3) {
    jlong jresult = 0 ;
    double arg1 ;
    double arg2 ;
    double arg3 ;
    pointObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (double)jarg1; 
    arg2 = (double)jarg2; 
    arg3 = (double)jarg3; 
    {
        errorObj *ms_error;
        result = (pointObj *)new_pointObj__SWIG_1(arg1,arg2,arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(pointObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1lineObj_1numpoints(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    lineObj *arg1 = (lineObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(lineObj **)&jarg1; 
    result = (int) ((arg1)->numpoints);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1lineObj_1point(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    lineObj *arg1 = (lineObj *) 0 ;
    pointObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(lineObj **)&jarg1; 
    result = (pointObj *) ((arg1)->point);
    
    *(pointObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_new_1lineObj(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    lineObj *result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (lineObj *)new_lineObj();
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(lineObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_delete_1lineObj(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    lineObj *arg1 = (lineObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(lineObj **)&jarg1; 
    {
        errorObj *ms_error;
        delete_lineObj(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_lineObj_1project(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jint jresult = 0 ;
    lineObj *arg1 = (lineObj *) 0 ;
    projectionObj *arg2 = (projectionObj *) 0 ;
    projectionObj *arg3 = (projectionObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(lineObj **)&jarg1; 
    arg2 = *(projectionObj **)&jarg2; 
    arg3 = *(projectionObj **)&jarg3; 
    {
        errorObj *ms_error;
        result = (int)lineObj_project(arg1,arg2,arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_lineObj_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    lineObj *arg1 = (lineObj *) 0 ;
    int arg2 ;
    pointObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(lineObj **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        errorObj *ms_error;
        result = (pointObj *)lineObj_get(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(pointObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_lineObj_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    lineObj *arg1 = (lineObj *) 0 ;
    pointObj *arg2 = (pointObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(lineObj **)&jarg1; 
    arg2 = *(pointObj **)&jarg2; 
    {
        errorObj *ms_error;
        result = (int)lineObj_add(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_lineObj_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3) {
    jint jresult = 0 ;
    lineObj *arg1 = (lineObj *) 0 ;
    int arg2 ;
    pointObj *arg3 = (pointObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(lineObj **)&jarg1; 
    arg2 = (int)jarg2; 
    arg3 = *(pointObj **)&jarg3; 
    {
        errorObj *ms_error;
        result = (int)lineObj_set(arg1,arg2,arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1shapeObj_1numlines(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    result = (int) ((arg1)->numlines);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1shapeObj_1numvalues(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    result = (int) ((arg1)->numvalues);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1shapeObj_1line(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    lineObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    result = (lineObj *) ((arg1)->line);
    
    *(lineObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1shapeObj_1values(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    char **result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    result = (char **) ((arg1)->values);
    
    *(char ***)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1shapeObj_1bounds(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    shapeObj *arg1 = (shapeObj *) 0 ;
    rectObj *arg2 = (rectObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    arg2 = *(rectObj **)&jarg2; 
    if (arg1) (arg1)->bounds = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1shapeObj_1bounds(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    rectObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    result = (rectObj *)& ((arg1)->bounds);
    
    *(rectObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1shapeObj_1type(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    shapeObj *arg1 = (shapeObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->type = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1shapeObj_1type(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    result = (int) ((arg1)->type);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1shapeObj_1index(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    shapeObj *arg1 = (shapeObj *) 0 ;
    long arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    arg2 = (long)jarg2; 
    if (arg1) (arg1)->index = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1shapeObj_1index(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    long result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    result = (long) ((arg1)->index);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1shapeObj_1tileindex(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    shapeObj *arg1 = (shapeObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->tileindex = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1shapeObj_1tileindex(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    result = (int) ((arg1)->tileindex);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1shapeObj_1classindex(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    shapeObj *arg1 = (shapeObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->classindex = arg2;
    
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1shapeObj_1classindex(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    result = (int) ((arg1)->classindex);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_set_1shapeObj_1text(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    shapeObj *arg1 = (shapeObj *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    {
        arg2 = JNU_GetStringNativeChars(jenv, jarg2);
    }
    {
        if (arg1->text) free((char*)arg1->text);
        if (arg2) {
            arg1->text = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->text,arg2);
        } else {
            arg1->text = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1shapeObj_1text(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    result = (char *) ((arg1)->text);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_new_1shapeObj(JNIEnv *jenv, jclass jcls, jint jarg1) {
    jlong jresult = 0 ;
    int arg1 = (int) MS_SHAPE_NULL ;
    shapeObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (int)jarg1; 
    {
        errorObj *ms_error;
        result = (shapeObj *)new_shapeObj(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(shapeObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_delete_1shapeObj(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    shapeObj *arg1 = (shapeObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    {
        errorObj *ms_error;
        delete_shapeObj(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapeObj_1fromWKT(JNIEnv *jenv, jclass jcls, jstring jarg1) {
    jlong jresult = 0 ;
    char *arg1 ;
    shapeObj *result;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = JNU_GetStringNativeChars(jenv, jarg1);
    }
    {
        errorObj *ms_error;
        result = (shapeObj *)shapeObj_fromWKT(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(shapeObj **)&jresult = result; 
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapeObj_1project(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jint jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    projectionObj *arg2 = (projectionObj *) 0 ;
    projectionObj *arg3 = (projectionObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    arg2 = *(projectionObj **)&jarg2; 
    arg3 = *(projectionObj **)&jarg3; 
    {
        errorObj *ms_error;
        result = (int)shapeObj_project(arg1,arg2,arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapeObj_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    int arg2 ;
    lineObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        errorObj *ms_error;
        result = (lineObj *)shapeObj_get(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(lineObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapeObj_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    lineObj *arg2 = (lineObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    arg2 = *(lineObj **)&jarg2; 
    {
        errorObj *ms_error;
        result = (int)shapeObj_add(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapeObj_1draw(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
    jint jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    mapObj *arg2 = (mapObj *) 0 ;
    layerObj *arg3 = (layerObj *) 0 ;
    imageObj *arg4 = (imageObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    arg2 = *(mapObj **)&jarg2; 
    arg3 = *(layerObj **)&jarg3; 
    arg4 = *(imageObj **)&jarg4; 
    {
        errorObj *ms_error;
        result = (int)shapeObj_draw(arg1,arg2,arg3,arg4);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapeObj_1setBounds(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    shapeObj *arg1 = (shapeObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    {
        errorObj *ms_error;
        shapeObj_setBounds(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapeObj_1cloneShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    shapeObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (shapeObj *)shapeObj_cloneShape(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(shapeObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapeObj_1copy(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    shapeObj *arg2 = (shapeObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    arg2 = *(shapeObj **)&jarg2; 
    {
        errorObj *ms_error;
        result = (int)shapeObj_copy(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapeObj_1toWKT(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (char *)shapeObj_toWKT(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    free(result);
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapeObj_1buffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    jlong jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    double arg2 ;
    shapeObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    arg2 = (double)jarg2; 
    {
        errorObj *ms_error;
        result = (shapeObj *)shapeObj_buffer(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(shapeObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapeObj_1convexHull(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    shapeObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (shapeObj *)shapeObj_convexHull(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(shapeObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapeObj_1boundary(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    shapeObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (shapeObj *)shapeObj_boundary(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(shapeObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapeObj_1getCentroid(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    pointObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (pointObj *)shapeObj_getCentroid(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(pointObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapeObj_1Union(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    shapeObj *arg2 = (shapeObj *) 0 ;
    shapeObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    arg2 = *(shapeObj **)&jarg2; 
    {
        errorObj *ms_error;
        result = (shapeObj *)shapeObj_Union(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(shapeObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapeObj_1intersection(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    shapeObj *arg2 = (shapeObj *) 0 ;
    shapeObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    arg2 = *(shapeObj **)&jarg2; 
    {
        errorObj *ms_error;
        result = (shapeObj *)shapeObj_intersection(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(shapeObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapeObj_1difference(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    shapeObj *arg2 = (shapeObj *) 0 ;
    shapeObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    arg2 = *(shapeObj **)&jarg2; 
    {
        errorObj *ms_error;
        result = (shapeObj *)shapeObj_difference(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(shapeObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapeObj_1symDifference(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    shapeObj *arg2 = (shapeObj *) 0 ;
    shapeObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    arg2 = *(shapeObj **)&jarg2; 
    {
        errorObj *ms_error;
        result = (shapeObj *)shapeObj_symDifference(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(shapeObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapeObj_1contains_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    shapeObj *arg2 = (shapeObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    arg2 = *(shapeObj **)&jarg2; 
    {
        errorObj *ms_error;
        result = (int)shapeObj_contains__SWIG_0(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapeObj_1overlaps(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    shapeObj *arg2 = (shapeObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    arg2 = *(shapeObj **)&jarg2; 
    {
        errorObj *ms_error;
        result = (int)shapeObj_overlaps(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapeObj_1within(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    shapeObj *arg2 = (shapeObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    arg2 = *(shapeObj **)&jarg2; 
    {
        errorObj *ms_error;
        result = (int)shapeObj_within(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapeObj_1crosses(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    shapeObj *arg2 = (shapeObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    arg2 = *(shapeObj **)&jarg2; 
    {
        errorObj *ms_error;
        result = (int)shapeObj_crosses(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapeObj_1intersects(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    shapeObj *arg2 = (shapeObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    arg2 = *(shapeObj **)&jarg2; 
    {
        errorObj *ms_error;
        result = (int)shapeObj_intersects(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapeObj_1touches(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    shapeObj *arg2 = (shapeObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    arg2 = *(shapeObj **)&jarg2; 
    {
        errorObj *ms_error;
        result = (int)shapeObj_touches(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapeObj_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    shapeObj *arg2 = (shapeObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    arg2 = *(shapeObj **)&jarg2; 
    {
        errorObj *ms_error;
        result = (int)shapeObj_equals(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapeObj_1disjoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    shapeObj *arg2 = (shapeObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    arg2 = *(shapeObj **)&jarg2; 
    {
        errorObj *ms_error;
        result = (int)shapeObj_disjoint(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapeObj_1getArea(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (double)shapeObj_getArea(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapeObj_1getLength(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    {
        errorObj *ms_error;
        result = (double)shapeObj_getLength(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapeObj_1getValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jstring jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    int arg2 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        errorObj *ms_error;
        result = (char *)shapeObj_getValue(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapeObj_1contains_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    pointObj *arg2 = (pointObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    arg2 = *(pointObj **)&jarg2; 
    {
        errorObj *ms_error;
        result = (int)shapeObj_contains__SWIG_1(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapeObj_1distanceToPoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jdouble jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    pointObj *arg2 = (pointObj *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    arg2 = *(pointObj **)&jarg2; 
    {
        errorObj *ms_error;
        result = (double)shapeObj_distanceToPoint(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapeObj_1distanceToShape(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jdouble jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    shapeObj *arg2 = (shapeObj *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    arg2 = *(shapeObj **)&jarg2; 
    {
        errorObj *ms_error;
        result = (double)shapeObj_distanceToShape(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapeObj_1setValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3) {
    jint jresult = 0 ;
    shapeObj *arg1 = (shapeObj *) 0 ;
    int arg2 ;
    char *arg3 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        arg3 = JNU_GetStringNativeChars(jenv, jarg3);
    }
    {
        errorObj *ms_error;
        result = (int)shapeObj_setValue(arg1,arg2,arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapeObj_1initValues(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    shapeObj *arg1 = (shapeObj *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapeObj **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        errorObj *ms_error;
        shapeObj_initValues(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1SHAPEFILE_1POINT(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int) 1;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1SHAPEFILE_1ARC(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int) 3;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1SHAPEFILE_1POLYGON(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int) 5;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1SHAPEFILE_1MULTIPOINT(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int) 8;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1SHP_1POINTZ(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int) 11;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1SHP_1ARCZ(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int) 13;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1SHP_1POLYGONZ(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int) 15;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1SHP_1MULTIPOINTZ(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int) 18;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1SHP_1POINTM(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int) 21;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1SHP_1ARCM(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int) 23;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1SHP_1POLYGONM(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int) 25;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1MS_1SHP_1MULTIPOINTM(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int) 28;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1DBFInfo_1fp(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    DBFInfo *arg1 = (DBFInfo *) 0 ;
    FILE *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DBFInfo **)&jarg1; 
    result = (FILE *) ((arg1)->fp);
    
    *(FILE **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1DBFInfo_1nRecords(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    DBFInfo *arg1 = (DBFInfo *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DBFInfo **)&jarg1; 
    result = (int) ((arg1)->nRecords);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1DBFInfo_1nRecordLength(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    DBFInfo *arg1 = (DBFInfo *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DBFInfo **)&jarg1; 
    result = (int) ((arg1)->nRecordLength);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1DBFInfo_1nHeaderLength(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    DBFInfo *arg1 = (DBFInfo *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DBFInfo **)&jarg1; 
    result = (int) ((arg1)->nHeaderLength);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1DBFInfo_1nFields(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    DBFInfo *arg1 = (DBFInfo *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DBFInfo **)&jarg1; 
    result = (int) ((arg1)->nFields);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1DBFInfo_1panFieldOffset(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    DBFInfo *arg1 = (DBFInfo *) 0 ;
    int *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DBFInfo **)&jarg1; 
    result = (int *) ((arg1)->panFieldOffset);
    
    *(int **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1DBFInfo_1panFieldSize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    DBFInfo *arg1 = (DBFInfo *) 0 ;
    int *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DBFInfo **)&jarg1; 
    result = (int *) ((arg1)->panFieldSize);
    
    *(int **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1DBFInfo_1panFieldDecimals(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    DBFInfo *arg1 = (DBFInfo *) 0 ;
    int *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DBFInfo **)&jarg1; 
    result = (int *) ((arg1)->panFieldDecimals);
    
    *(int **)&jresult = result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1DBFInfo_1pachFieldType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    DBFInfo *arg1 = (DBFInfo *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DBFInfo **)&jarg1; 
    result = (char *) ((arg1)->pachFieldType);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1DBFInfo_1pszHeader(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    DBFInfo *arg1 = (DBFInfo *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DBFInfo **)&jarg1; 
    result = (char *) ((arg1)->pszHeader);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1DBFInfo_1nCurrentRecord(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    DBFInfo *arg1 = (DBFInfo *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DBFInfo **)&jarg1; 
    result = (int) ((arg1)->nCurrentRecord);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1DBFInfo_1bCurrentRecordModified(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    DBFInfo *arg1 = (DBFInfo *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DBFInfo **)&jarg1; 
    result = (int) ((arg1)->bCurrentRecordModified);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1DBFInfo_1pszCurrentRecord(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    DBFInfo *arg1 = (DBFInfo *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DBFInfo **)&jarg1; 
    result = (char *) ((arg1)->pszCurrentRecord);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1DBFInfo_1bNoHeader(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    DBFInfo *arg1 = (DBFInfo *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DBFInfo **)&jarg1; 
    result = (int) ((arg1)->bNoHeader);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1DBFInfo_1bUpdated(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    DBFInfo *arg1 = (DBFInfo *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DBFInfo **)&jarg1; 
    result = (int) ((arg1)->bUpdated);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1DBFInfo_1pszStringField(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    DBFInfo *arg1 = (DBFInfo *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DBFInfo **)&jarg1; 
    result = (char *) ((arg1)->pszStringField);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1DBFInfo_1nStringFieldLen(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    DBFInfo *arg1 = (DBFInfo *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DBFInfo **)&jarg1; 
    result = (int) ((arg1)->nStringFieldLen);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_DBFInfo_1getFieldName(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jstring jresult = 0 ;
    DBFInfo *arg1 = (DBFInfo *) 0 ;
    int arg2 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DBFInfo **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        errorObj *ms_error;
        result = (char *)DBFInfo_getFieldName(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_DBFInfo_1getFieldWidth(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    DBFInfo *arg1 = (DBFInfo *) 0 ;
    int arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DBFInfo **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        errorObj *ms_error;
        result = (int)DBFInfo_getFieldWidth(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_DBFInfo_1getFieldDecimals(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    DBFInfo *arg1 = (DBFInfo *) 0 ;
    int arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DBFInfo **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        errorObj *ms_error;
        result = (int)DBFInfo_getFieldDecimals(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_DBFInfo_1getFieldType(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    DBFInfo *arg1 = (DBFInfo *) 0 ;
    int arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DBFInfo **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        errorObj *ms_error;
        result = (int)DBFInfo_getFieldType(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_new_1DBFInfo(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    DBFInfo *result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (DBFInfo *)(DBFInfo *) calloc(1, sizeof(DBFInfo));
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(DBFInfo **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_delete_1DBFInfo(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    DBFInfo *arg1 = (DBFInfo *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DBFInfo **)&jarg1; 
    {
        errorObj *ms_error;
        free((char *) arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1FTString(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)FTString;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1FTInteger(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)FTInteger;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1FTDouble(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)FTDouble;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1FTInvalid(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        errorObj *ms_error;
        result = (int)FTInvalid;
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1shapefileObj_1source(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    shapefileObj *arg1 = (shapefileObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapefileObj **)&jarg1; 
    result = (char *)(char *) ((arg1)->source);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1shapefileObj_1type(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    shapefileObj *arg1 = (shapefileObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapefileObj **)&jarg1; 
    result = (int) ((arg1)->type);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1shapefileObj_1numshapes(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    shapefileObj *arg1 = (shapefileObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapefileObj **)&jarg1; 
    result = (int) ((arg1)->numshapes);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1shapefileObj_1bounds(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    shapefileObj *arg1 = (shapefileObj *) 0 ;
    rectObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapefileObj **)&jarg1; 
    result = (rectObj *)& ((arg1)->bounds);
    
    *(rectObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1shapefileObj_1lastshape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    shapefileObj *arg1 = (shapefileObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapefileObj **)&jarg1; 
    result = (int) ((arg1)->lastshape);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1shapefileObj_1status(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    shapefileObj *arg1 = (shapefileObj *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapefileObj **)&jarg1; 
    result = (char *) ((arg1)->status);
    
    {
        jresult = JNU_NewStringNative(jenv, result);
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1shapefileObj_1statusbounds(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    shapefileObj *arg1 = (shapefileObj *) 0 ;
    rectObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapefileObj **)&jarg1; 
    result = (rectObj *)& ((arg1)->statusbounds);
    
    *(rectObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_get_1shapefileObj_1isopen(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    shapefileObj *arg1 = (shapefileObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapefileObj **)&jarg1; 
    result = (int) ((arg1)->isopen);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_new_1shapefileObj(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2) {
    jlong jresult = 0 ;
    char *arg1 ;
    int arg2 = (int) -1 ;
    shapefileObj *result;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = JNU_GetStringNativeChars(jenv, jarg1);
    }
    arg2 = (int)jarg2; 
    {
        errorObj *ms_error;
        result = (shapefileObj *)new_shapefileObj(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(shapefileObj **)&jresult = result; 
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_delete_1shapefileObj(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    shapefileObj *arg1 = (shapefileObj *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapefileObj **)&jarg1; 
    {
        errorObj *ms_error;
        delete_shapefileObj(arg1);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapefileObj_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3) {
    jint jresult = 0 ;
    shapefileObj *arg1 = (shapefileObj *) 0 ;
    int arg2 ;
    shapeObj *arg3 = (shapeObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapefileObj **)&jarg1; 
    arg2 = (int)jarg2; 
    arg3 = *(shapeObj **)&jarg3; 
    {
        errorObj *ms_error;
        result = (int)shapefileObj_get(arg1,arg2,arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapefileObj_1getShape(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    shapefileObj *arg1 = (shapefileObj *) 0 ;
    int arg2 ;
    shapeObj *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapefileObj **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        errorObj *ms_error;
        result = (shapeObj *)shapefileObj_getShape(arg1,arg2);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg) {
                snprintf(ms_message, 8192, msg);
                free(msg);
            }
            else sprintf(ms_message, "Unknown message");
            
            msResetErrorList();
            
            switch(ms_errorcode) {
                case MS_NOTFOUND:
                break;
                case -1:
                break;
                case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_message);
                break;
                case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_message);
                break;
                case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_message);
                break;
                case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_message);
                break;
                case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_message);
                break;
                default:
                SWIG_exception(SWIG_UnknownError,ms_message);
                break;
            }       
        }
    }
    *(shapeObj **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_edu_umn_gis_mapscript_mapscriptJNI_shapefileObj_1getPoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3) {
    jint jresult = 0 ;
    shapefileObj *arg1 = (shapefileObj *) 0 ;
    int arg2 ;
    pointObj *arg3 = (pointObj *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(shapefileObj **)&jarg1; 
    arg2 = (int)jarg2; 
    arg3 = *(pointObj **)&jarg3; 
    {
        errorObj *ms_error;
        result = (int)shapefileObj_getPoint(arg1,arg2,arg3);
        
        ms_error = msGetErrorObj();
        if (ms_error!=NULL && ms_error->code != MS_NOERR) {
            char ms_message[8192];
            char* msg = msGetErrorString(";");
            int ms_errorcode = ms_error->code;
            if (msg