/***************************************************************************
 *   Copyright (C) 2005 by Jakub Stachowski                                *
 *   qbast@go2.pl                                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef STARTDIALOG_H
#define STARTDIALOG_H

#include <kdialogbase.h>
#include <qlistbox.h>
#include <dnssd/servicebrowser.h>
#include "startdialogbase.h"

/**
@author Jakub Stachowski
*/
class StartDialog : public KDialogBase
{
Q_OBJECT
public:
    StartDialog(QWidget *parent = 0, const char *name = 0);

    ~StartDialog();
    StartDialogBase* m_main;

private:
    DNSSD::ServiceBrowser browser;

private slots:
	void serviceAdded(DNSSD::RemoteService::Ptr);
	void serviceRemoved(DNSSD::RemoteService::Ptr);
	void enableWidgets();
};

class ServiceItem : public QListBoxText
{
public:
	ServiceItem(QListBox* parent,DNSSD::RemoteService::Ptr srv);
	const DNSSD::RemoteService::Ptr service;
};
#endif
