/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import java.util.ArrayList;

public class DBProcParameterInfo {
    public static final int ABAPTABLE = 1;
    public static final int STRUCTURE = 2;
    private int type;
    private String typeName;
    private String sqlTypeName;
    private String baseTypeName;
    private int length;
    private int precision;
    private ArrayList typeElements;

    public DBProcParameterInfo(String string, int n, int n2) {
        this.typeName = string;
        this.length = n;
        this.precision = n2;
        if (string.equals("ABAPTABLE")) {
            this.type = 1;
            this.typeElements = new ArrayList();
        } else if (string.equals("STRUCTURE")) {
            this.type = 2;
            this.typeElements = new ArrayList();
        }
    }

    public void addStructureElement(String string, String string2, int n, int n2, int n3, int n4, int n5) {
        if (this.typeElements == null) {
            return;
        }
        this.typeElements.add(new StructureElement(string, string2, n, n2, n3, n4, n5));
    }

    public int getMemberCount() {
        return this.typeElements.size();
    }

    public int getType() {
        return this.type;
    }

    public StructureElement getMember(int n) {
        return (StructureElement)this.typeElements.get(n);
    }

    public String getSQLTypeName() {
        if (this.sqlTypeName == null) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            String string = ")";
            if (this.type == 1) {
                if (this.typeElements.size() == 1) {
                    StructureElement structureElement = (StructureElement)this.typeElements.get(0);
                    if (structureElement.typeName.equals("CHAR")) {
                        if (structureElement.codeType.equals("ASCII")) {
                            this.sqlTypeName = "CHARACTER STREAM";
                        } else if (structureElement.codeType.equals("BYTE")) {
                            this.sqlTypeName = "BYTE STREAM";
                        }
                    } else if (structureElement.typeName.equals("WYDE")) {
                        this.sqlTypeName = "CHARACTER STREAM";
                    }
                    stringBuffer.append("STREAM(");
                } else {
                    stringBuffer.append("STREAM(STRUCTURE(");
                    string = "))";
                }
            } else {
                stringBuffer.append("STRUCTURE(");
            }
            for (int i = 0; i < this.typeElements.size(); ++i) {
                if (i != 0) {
                    stringBuffer2.append(", ");
                    stringBuffer.append(", ");
                }
                StructureElement structureElement = (StructureElement)this.typeElements.get(i);
                stringBuffer.append(structureElement.getSQLTypeName());
                stringBuffer2.append(structureElement.getSQLTypeName());
            }
            stringBuffer.append(string);
            this.sqlTypeName = stringBuffer.toString();
            this.baseTypeName = stringBuffer2.toString();
        }
        return this.sqlTypeName;
    }

    public String getBaseTypeName() {
        return this.baseTypeName;
    }

    public static class StructureElement {
        public String typeName;
        public String codeType;
        public int length;
        public int precision;
        public int offset;
        public int asciiOffset;
        public int unicodeOffset;

        StructureElement(String string, String string2, int n, int n2, int n3, int n4, int n5) {
            this.typeName = string;
            this.codeType = string2;
            this.length = n;
            this.precision = n2;
            this.offset = n3;
            this.asciiOffset = n4;
            this.unicodeOffset = n5;
        }

        public String getSQLTypeName() {
            if (this.typeName.equals("CHAR")) {
                return this.typeName + "(" + this.length + ") " + this.codeType;
            }
            if (this.typeName.equals("FIXED")) {
                return this.typeName + "(" + this.length + ", " + this.precision + ")";
            }
            if (this.typeName.equals("BOOLEAN")) {
                return this.typeName;
            }
            return this.typeName + "(" + this.length + ")";
        }
    }
}

