/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/
package com.sap.dbtech.jdbcext;

import java.io.*;
import java.math.BigDecimal;
import java.sql.*;
import java.util.Calendar;
import java.util.Map;
import java.util.Iterator;
import java.net.URL;
import javax.naming.*;
import javax.sql.DataSource;
import javax.sql.RowSet;
import com.sap.dbtech.jdbc.exceptions.*;
import com.sap.dbtech.jdbcext.translators.RowSetTranslator;
import com.sap.dbtech.util.MessageKey;
import com.sap.dbtech.util.MessageTranslator;

public class JDBCRowSetSapDB  extends AbstractRowSetSapDB
    implements RowSet
{
    private Connection conn = null;
    private PreparedStatement ps = null;
    private ResultSet rs = null;

    public JDBCRowSetSapDB()
        throws SQLException
    {
        conn = null;
        ps = null;
        rs = null;
        initParams();
    }

    public boolean absolute(int i)
        throws SQLException
    {
        checkState();
        boolean flag = rs.absolute(i);
        notifyCursorMoved();
        return flag;
    }

    public void afterLast()
        throws SQLException
    {
        checkState();
        rs.afterLast();
        notifyCursorMoved();
    }

    public void beforeFirst()
        throws SQLException
    {
        checkState();
        rs.beforeFirst();
        notifyCursorMoved();
    }

    public void cancelRowUpdates()
        throws SQLException
    {
        checkState();
        rs.cancelRowUpdates();
        notifyRowChanged();
    }

    void checkState()
        throws SQLException
    {
        if(conn == null || ps == null || rs == null)
          throw new ObjectIsClosedException (this);
    }

    public void clearWarnings()
        throws SQLException
    {
        checkState();
        rs.clearWarnings();
    }

    public void close()
        throws SQLException
    {
        if(rs != null)
            rs.close();
        if(ps != null)
            ps.close();
        if(conn != null)
            conn.close();
    }

    private Connection connect()
        throws SQLException
    {
        if(getDataSourceName() != null)
            try
            {
                InitialContext initialcontext = new InitialContext();
                DataSource datasource = (DataSource)initialcontext.lookup(getDataSourceName());
                return datasource.getConnection(getUsername(), getPassword());
            }
            catch(NamingException _ex)
            {
               throw new SQLExceptionSapDB (MessageTranslator.translate(MessageKey.ERROR_JNDILOOKUP_FAILED));
            }
        if(getUrl() != null)
            return DriverManager.getConnection(getUrl(), getUsername(), getPassword());
        else
            return null;
    }

    public void deleteRow()
        throws SQLException
    {
        checkState();
        rs.deleteRow();
        notifyRowChanged();
    }

    public void execute()
        throws SQLException
    {
        try
        {
          this.conn = connect();
          this.conn.setTransactionIsolation(getTransactionIsolation());
          this.conn.setTypeMap(getTypeMap());
          this.ps = this.conn.prepareStatement(getCommand());
          this.ps.setEscapeProcessing(getEscapeProcessing());
          this.ps.setMaxFieldSize(getMaxFieldSize());
          this.ps.setMaxRows(getMaxRows());
          this.ps.setQueryTimeout(getQueryTimeout());
          for(Iterator iterator = this.params.iterator(); iterator.hasNext(); ((RowSetTranslator)iterator.next()).setValue(this.ps));
          this.rs = this.ps.executeQuery();
          notifyRowSetChanged();
        }
        catch(SQLException sqlexc)
        {
            if(  this.ps != null)
                  this.ps.close();
            if(  this.conn != null)
                  this.conn.close();
            throw sqlexc;
        }
    }

    public int findColumn(String s)
        throws SQLException
    {
        checkState();
        return rs.findColumn(s);
    }

    public boolean first()
        throws SQLException
    {
        checkState();
        boolean flag = rs.first();
        notifyCursorMoved();
        return flag;
    }

    public Array getArray(int i)
        throws SQLException
    {
        checkState();
        return rs.getArray(i);
    }

    public Array getArray(String s)
        throws SQLException
    {
        checkState();
        return rs.getArray(s);
    }

    public InputStream getAsciiStream(int i)
        throws SQLException
    {
        checkState();
        return rs.getAsciiStream(i);
    }

    public InputStream getAsciiStream(String s)
        throws SQLException
    {
        checkState();
        return rs.getAsciiStream(s);
    }

    public BigDecimal getBigDecimal(int i)
        throws SQLException
    {
        checkState();
        return rs.getBigDecimal(i);
    }

    public BigDecimal getBigDecimal(int i, int j)
        throws SQLException
    {
        checkState();
        return rs.getBigDecimal(i, j);
    }

    public BigDecimal getBigDecimal(String s)
        throws SQLException
    {
        return getBigDecimal(s);
    }

    public BigDecimal getBigDecimal(String s, int i)
        throws SQLException
    {
        checkState();
        return rs.getBigDecimal(s, i);
    }

    public InputStream getBinaryStream(int i)
        throws SQLException
    {
        checkState();
        return rs.getBinaryStream(i);
    }

    public InputStream getBinaryStream(String s)
        throws SQLException
    {
        checkState();
        return rs.getBinaryStream(s);
    }

    public Blob getBlob(int i)
        throws SQLException
    {
        checkState();
        return rs.getBlob(i);
    }

    public Blob getBlob(String s)
        throws SQLException
    {
        checkState();
        return rs.getBlob(s);
    }

    public boolean getBoolean(int i)
        throws SQLException
    {
        checkState();
        return rs.getBoolean(i);
    }

    public boolean getBoolean(String s)
        throws SQLException
    {
        checkState();
        return rs.getBoolean(s);
    }

    public byte getByte(int i)
        throws SQLException
    {
        checkState();
        return rs.getByte(i);
    }

    public byte getByte(String s)
        throws SQLException
    {
        checkState();
        return rs.getByte(s);
    }

    public byte[] getBytes(int i)
        throws SQLException
    {
        checkState();
        return rs.getBytes(i);
    }

    public byte[] getBytes(String s)
        throws SQLException
    {
        checkState();
        return rs.getBytes(s);
    }

    public Reader getCharacterStream(int i)
        throws SQLException
    {
        checkState();
        return rs.getCharacterStream(i);
    }

    public Reader getCharacterStream(String s)
        throws SQLException
    {
        checkState();
        return rs.getCharacterStream(s);
    }

    public Clob getClob(int i)
        throws SQLException
    {
        checkState();
        return rs.getClob(i);
    }

    public Clob getClob(String s)
        throws SQLException
    {
        checkState();
        return rs.getClob(s);
    }

    public int getConcurrency()
        throws SQLException
    {
        checkState();
        return rs.getConcurrency();
    }

    public String getCursorName()
        throws SQLException
    {
        checkState();
        return rs.getCursorName();
    }

    public Date getDate(int i)
        throws SQLException
    {
        checkState();
        return rs.getDate(i);
    }

    public Date getDate(int i, Calendar calendar)
        throws SQLException
    {
        checkState();
        return rs.getDate(i, calendar);
    }

    public Date getDate(String s)
        throws SQLException
    {
        checkState();
        return rs.getDate(s);
    }

    public Date getDate(String s, Calendar calendar)
        throws SQLException
    {
        checkState();
        return rs.getDate(s, calendar);
    }

    public double getDouble(int i)
        throws SQLException
    {
        checkState();
        return rs.getDouble(i);
    }

    public double getDouble(String s)
        throws SQLException
    {
        checkState();
        return rs.getDouble(s);
    }

    public int getFetchDirection()
        throws SQLException
    {
        checkState();
        return rs.getFetchDirection();
    }

    public float getFloat(int i)
        throws SQLException
    {
        checkState();
        return rs.getFloat(i);
    }

    public float getFloat(String s)
        throws SQLException
    {
        checkState();
        return rs.getFloat(s);
    }

    public int getInt(int i)
        throws SQLException
    {
        checkState();
        return rs.getInt(i);
    }

    public int getInt(String s)
        throws SQLException
    {
        checkState();
        return rs.getInt(s);
    }

    public long getLong(int i)
        throws SQLException
    {
        checkState();
        return rs.getLong(i);
    }

    public long getLong(String s)
        throws SQLException
    {
        checkState();
        return rs.getLong(s);
    }

    public ResultSetMetaData getMetaData()
        throws SQLException
    {
        checkState();
        return rs.getMetaData();
    }

    public Object getObject(int i)
        throws SQLException
    {
        checkState();
        return rs.getObject(i);
    }

    public Object getObject(int i, Map map)
        throws SQLException
    {
        checkState();
        return rs.getObject(i, map);
    }

    public Object getObject(String s)
        throws SQLException
    {
        checkState();
        return rs.getObject(s);
    }

    public Object getObject(String s, Map map)
        throws SQLException
    {
        checkState();
        return rs.getObject(s, map);
    }

    public Ref getRef(int i)
        throws SQLException
    {
        checkState();
        return rs.getRef(i);
    }

    public Ref getRef(String s)
        throws SQLException
    {
        checkState();
        return rs.getRef(s);
    }

    public int getRow()
        throws SQLException
    {
        checkState();
        return rs.getRow();
    }

    public short getShort(int i)
        throws SQLException
    {
        checkState();
        return rs.getShort(i);
    }

    public short getShort(String s)
        throws SQLException
    {
        checkState();
        return rs.getShort(s);
    }

    public Statement getStatement()
        throws SQLException
    {
        checkState();
        return rs.getStatement();
    }

    public String getString(int i)
        throws SQLException
    {
        checkState();
        return rs.getString(i);
    }

    public String getString(String s)
        throws SQLException
    {
        checkState();
        return rs.getString(s);
    }

    public Time getTime(int i)
        throws SQLException
    {
        checkState();
        return rs.getTime(i);
    }

    public Time getTime(int i, Calendar calendar)
        throws SQLException
    {
        checkState();
        return rs.getTime(i, calendar);
    }

    public Time getTime(String s)
        throws SQLException
    {
        checkState();
        return rs.getTime(s);
    }

    public Time getTime(String s, Calendar calendar)
        throws SQLException
    {
        checkState();
        return rs.getTime(s, calendar);
    }

    public Timestamp getTimestamp(int i)
        throws SQLException
    {
        checkState();
        return rs.getTimestamp(i);
    }

    public Timestamp getTimestamp(int i, Calendar calendar)
        throws SQLException
    {
        checkState();
        return rs.getTimestamp(i, calendar);
    }

    public Timestamp getTimestamp(String s)
        throws SQLException
    {
        checkState();
        return rs.getTimestamp(s);
    }

    public Timestamp getTimestamp(String s, Calendar calendar)
        throws SQLException
    {
        checkState();
        return rs.getTimestamp(s, calendar);
    }

    public int getType()
        throws SQLException
    {
        checkState();
        return rs.getType();
    }

    public InputStream getUnicodeStream(int i)
        throws SQLException
    {
        checkState();
        return rs.getUnicodeStream(i);
    }

    public InputStream getUnicodeStream(String s)
        throws SQLException
    {
        checkState();
        return rs.getUnicodeStream(s);
    }

    public SQLWarning getWarnings()
        throws SQLException
    {
        checkState();
        return rs.getWarnings();
    }

    public void insertRow()
        throws SQLException
    {
        checkState();
        rs.insertRow();
        notifyRowChanged();
    }

    public boolean isAfterLast()
        throws SQLException
    {
        checkState();
        return rs.isAfterLast();
    }

    public boolean isBeforeFirst()
        throws SQLException
    {
        checkState();
        return rs.isBeforeFirst();
    }

    public boolean isFirst()
        throws SQLException
    {
        checkState();
        return rs.isFirst();
    }

    public boolean isLast()
        throws SQLException
    {
        checkState();
        return rs.isLast();
    }

    public boolean last()
        throws SQLException
    {
        checkState();
        boolean flag = rs.last();
        notifyCursorMoved();
        return flag;
    }

    public void moveToCurrentRow()
        throws SQLException
    {
        checkState();
        rs.moveToCurrentRow();
    }

    public void moveToInsertRow()
        throws SQLException
    {
        checkState();
        rs.moveToInsertRow();
    }

    public boolean next()
        throws SQLException
    {
        checkState();
        boolean flag = rs.next();
        notifyCursorMoved();
        return flag;
    }

    public boolean previous()
        throws SQLException
    {
        checkState();
        boolean flag = rs.previous();
        notifyCursorMoved();
        return flag;
    }

    public void refreshRow()
        throws SQLException
    {
        checkState();
        rs.refreshRow();
    }

    public boolean relative(int i)
        throws SQLException
    {
        checkState();
        boolean flag = rs.relative(i);
        notifyCursorMoved();
        return flag;
    }

    public boolean rowDeleted()
        throws SQLException
    {
        checkState();
        return rs.rowDeleted();
    }

    public boolean rowInserted()
        throws SQLException
    {
        checkState();
        return rs.rowInserted();
    }

    public boolean rowUpdated()
        throws SQLException
    {
        checkState();
        return rs.rowUpdated();
    }

    public void setFetchDirection(int i)
        throws SQLException
    {
        checkState();
        rs.setFetchDirection(i);
    }

    public void setFetchSize(int i)
        throws SQLException
    {
        checkState();
        rs.setFetchSize(i);
    }

    public void updateAsciiStream(int i, InputStream inputstream, int j)
        throws SQLException
    {
        checkState();
        rs.updateAsciiStream(i, inputstream, j);
    }

    public void updateAsciiStream(String s, InputStream inputstream, int i)
        throws SQLException
    {
        checkState();
        rs.updateAsciiStream(s, inputstream, i);
    }

    public void updateBigDecimal(int i, BigDecimal bigdecimal)
        throws SQLException
    {
        checkState();
        rs.updateBigDecimal(i, bigdecimal);
    }

    public void updateBigDecimal(String s, BigDecimal bigdecimal)
        throws SQLException
    {
        checkState();
        rs.updateBigDecimal(s, bigdecimal);
    }

    public void updateBinaryStream(int i, InputStream inputstream, int j)
        throws SQLException
    {
        checkState();
        rs.updateBinaryStream(i, inputstream, j);
    }

    public void updateBinaryStream(String s, InputStream inputstream, int i)
        throws SQLException
    {
        checkState();
        rs.updateBinaryStream(s, inputstream, i);
    }

    public void updateBoolean(int i, boolean flag)
        throws SQLException
    {
        checkState();
        rs.updateBoolean(i, flag);
    }

    public void updateBoolean(String s, boolean flag)
        throws SQLException
    {
        checkState();
        rs.updateBoolean(s, flag);
    }

    public void updateByte(int i, byte byte0)
        throws SQLException
    {
        checkState();
        rs.updateByte(i, byte0);
    }

    public void updateByte(String s, byte byte0)
        throws SQLException
    {
        checkState();
        rs.updateByte(s, byte0);
    }

    public void updateBytes(int i, byte abyte0[])
        throws SQLException
    {
        checkState();
        rs.updateBytes(i, abyte0);
    }

    public void updateBytes(String s, byte abyte0[])
        throws SQLException
    {
        checkState();
        rs.updateBytes(s, abyte0);
    }

    public void updateCharacterStream(int i, Reader reader, int j)
        throws SQLException
    {
        checkState();
        rs.updateCharacterStream(i, reader, j);
    }

    public void updateCharacterStream(String s, Reader reader, int i)
        throws SQLException
    {
        checkState();
        rs.updateCharacterStream(s, reader, i);
    }

    public void updateDate(int i, Date date)
        throws SQLException
    {
        checkState();
        rs.updateDate(i, date);
    }

    public void updateDate(String s, Date date)
        throws SQLException
    {
        checkState();
        rs.updateDate(s, date);
    }

    public void updateDouble(int i, double d)
        throws SQLException
    {
        checkState();
        rs.updateDouble(i, d);
    }

    public void updateDouble(String s, double d)
        throws SQLException
    {
        checkState();
        rs.updateDouble(s, d);
    }

    public void updateFloat(int i, float f)
        throws SQLException
    {
        checkState();
        rs.updateFloat(i, f);
    }

    public void updateFloat(String s, float f)
        throws SQLException
    {
        checkState();
        rs.updateFloat(s, f);
    }

    public void updateInt(int i, int j)
        throws SQLException
    {
        checkState();
        rs.updateInt(i, j);
    }

    public void updateInt(String s, int i)
        throws SQLException
    {
        checkState();
        rs.updateInt(s, i);
    }

    public void updateLong(int i, long l)
        throws SQLException
    {
        checkState();
        rs.updateLong(i, l);
    }

    public void updateLong(String s, long l)
        throws SQLException
    {
        checkState();
        rs.updateLong(s, l);
    }

    public void updateNull(int i)
        throws SQLException
    {
        checkState();
        rs.updateNull(i);
    }

    public void updateNull(String s)
        throws SQLException
    {
        checkState();
        rs.updateNull(s);
    }

    public void updateObject(int i, Object obj)
        throws SQLException
    {
        checkState();
        rs.updateObject(i, obj);
    }

    public void updateObject(int i, Object obj, int j)
        throws SQLException
    {
        checkState();
        rs.updateObject(i, obj, j);
    }

    public void updateObject(String s, Object obj)
        throws SQLException
    {
        checkState();
        rs.updateObject(s, obj);
    }

    public void updateObject(String s, Object obj, int i)
        throws SQLException
    {
        checkState();
        rs.updateObject(s, obj, i);
    }

    public void updateRow()
        throws SQLException
    {
        checkState();
        rs.updateRow();
        notifyRowChanged();
    }

    public void updateShort(int i, short word0)
        throws SQLException
    {
        checkState();
        rs.updateShort(i, word0);
    }

    public void updateShort(String s, short word0)
        throws SQLException
    {
        checkState();
        rs.updateShort(s, word0);
    }

    public void updateString(int i, String s)
        throws SQLException
    {
        checkState();
        rs.updateString(i, s);
    }

    public void updateString(String s, String s1)
        throws SQLException
    {
        checkState();
        rs.updateString(s, s1);
    }

    public void updateTime(int i, Time time)
        throws SQLException
    {
        checkState();
        rs.updateTime(i, time);
    }

    public void updateTime(String s, Time time)
        throws SQLException
    {
        checkState();
        rs.updateTime(s, time);
    }

    public void updateTimestamp(int i, Timestamp timestamp)
        throws SQLException
    {
        checkState();
        rs.updateTimestamp(i, timestamp);
    }

    public void updateTimestamp(String s, Timestamp timestamp)
        throws SQLException
    {
        checkState();
        rs.updateTimestamp(s, timestamp);
    }

    public boolean wasNull()
        throws SQLException
    {
        checkState();
        return rs.wasNull();
    }

    public URL getURL(int columnIndex)
           throws SQLException{
        checkState();
        return rs.getURL(columnIndex);
    }

    public URL getURL(String columnName)
           throws SQLException{
        checkState();
        return rs.getURL(columnName);
    }

    public void updateRef(int columnIndex,
                      Ref x)
               throws SQLException{
        checkState();
        rs.updateRef(columnIndex, x);
   }

    public void updateRef(String columnName,
                      Ref x)
               throws SQLException{
        checkState();
        rs.updateRef(columnName, x);
    }

    public void updateBlob(int columnIndex,
                       Blob x)
                throws SQLException{
        checkState();
        rs.updateBlob(columnIndex, x);
    }

    public void updateBlob(String columnName,
                       Blob x)
                throws SQLException{
        checkState();
        rs.updateBlob(columnName, x);
    }

    public void updateClob(int columnIndex,
                       Clob x)
                throws SQLException{
        checkState();
        rs.updateClob(columnIndex, x);
    }

    public void updateClob(String columnName,
                       Clob x)
                throws SQLException{
        checkState();
        rs.updateClob(columnName, x);
    }

    public void updateArray(int columnIndex,
                        Array x)
                 throws SQLException{
        checkState();
        rs.updateArray(columnIndex, x);
    }

    public void updateArray(String columnName,
                        Array x)
                 throws SQLException{
        checkState();
        rs.updateArray(columnName, x);
    }
}
