/*

    ========== licence begin  GPL
    Copyright (c) 2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

*/
#include "gen00.h"
#define USE_KGS
#include "gen50.h"
#include "heo00.h"

#include "RunTime/Tasking/RTETask_IScheduling.hpp"

#include "gen500.h"  
#include "gen71.h"  // e71_Enqu_Rex()...
#include "hen50.h"  // vabort()  
// this would be in RTETask_SchedulingUNIX.cpp:

extern "C" void    e55_remactive ();    // this is quite dirty... e55_remactive() actually has parameters, but it is given as a parameter to en71EnqueueUkt2Ukt(), which expects a pointer to a function without parameters....

class RTETask_SchedulingUNIX : public RTETask_IScheduling
{
public:
    void ActivateTaskInOtherUKT(RTE_TCB TCB,RTE_UKT UKTCB,RTE_TCB nextTCB)
    {
        en71EnqueueUkt2Ukt ( UKTCB, nextTCB, TCB, e55_remactive, (void *)TCB.inRegionID() );
    }

    void PutTaskToRavQueue(RTE_TCB TCB,RTE_UKT UKTCB,SAPDB_ULong reqType)
    {
        TCB.requestType() = reqType ;
        e71_EnquRav ( TCB, true );   // set the priority of the owner to a high value to force him being the next one to be scheduled 
    }

    void PutTaskToRexQueue(RTE_TCB TCB,RTE_UKT UKTCB,SAPDB_ULong reqType,SAPDB_Bool condition)
    {
        TCB.requestType() = reqType ;
        e71_EnquRex ( TCB, condition ) ; // enter myself in the run queue, with a lower priority than the process waiting for access to the task list
    }

    void Reschedule(RTE_UKT &UKTCB)
    {
        ten50_UKT_Control *uktCtrlRec = UKTCB;
        GOTO_DISP(&uktCtrlRec);
        UKTCB = uktCtrlRec;
    }
private:
    static RTETask_SchedulingUNIX m_Instance;

friend class RTETask_IScheduling;
};

RTETask_SchedulingUNIX RTETask_SchedulingUNIX::m_Instance;

RTETask_IScheduling& RTETask_IScheduling::Instance()
{
    return RTETask_SchedulingUNIX::m_Instance;
}

