/****************************************************************************

  module      : WDVDelete_Interface.c

  -------------------------------------------------------------------------

  responsible : Daniel Kirmse

  special area: 
  description : 


  last changed: 2001-02-28  10:41
  see also    : 

  -------------------------------------------------------------------------


    ========== licence begin  GPL
    Copyright (c) 2001-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*****************************************************************************/



/* =====================================================================
   |  Includes                                                         |
   =====================================================================*/
	#include "SAPDB/WebDAV/DeleteService/WDVDelete_Interface.h"

/* =====================================================================
   |  Globals                                                          |
   =====================================================================*/
	static SAPDB_Char			user[WDV_MAX_URI_LEN+1];
	static SAPDB_Char			password[WDV_MAX_URI_LEN+1];
	static SAPDB_Char			isRequired[11];
	
/* =====================================================================
   |  Functions                                                        |
   =====================================================================*/
	void delete_DeletedItems(sapdbwa_Handle wa);


/* ---------------------------------------------------------------------
   WebAgent UserInit Function
   ---------------------------------------------------------------------*/
	sapdbwa_Int2  WDVDeleteInit( sapdbwa_Handle wa )
	{
		WDVD_Char			message[WDVD_MAX_URI_LEN+50];
		WDVD_Char			tempPrefix[WDVD_MAX_URI_LEN+1];

		if (wa==NULL)
			return -1;

		sapdbwa_WriteLogMsg(wa,"WDVDeleteInit\n");
		strcpy(isRequired,"0");

		/* get authentication parameters */
		/* - authentication required */
		if (sapdbwa_GetParam(wa,"BasicAuthentication",isRequired,10)) {
            isRequired[10] = '\0';
		} else {
			strcpy(isRequired,"0");
		}
		if (sapdbwa_GetParam(wa,"WebDAVUser",user,WDV_MAX_URI_LEN)) {
			user[WDV_MAX_URI_LEN] = '\0';
		} else {
			strcpy(user,"");
		}
		if (sapdbwa_GetParam(wa,"WebDAVPassword",password,WDV_MAX_URI_LEN)) {
			password[WDV_MAX_URI_LEN] = '\0';
		} else {
			strcpy(password,"");
		}

		return 1;
	}


/* ---------------------------------------------------------------------
   WebAgent UserExit Function
   ---------------------------------------------------------------------*/
	sapdbwa_Int2  WDVDeleteExit( sapdbwa_Handle wa )
	{
		if (wa==NULL)
			return -1;

		sapdbwa_WriteLogMsg(wa,"WDVDeleteExit\n");

		return 1;
	}


/* ---------------------------------------------------------------------
   WebAgent UserService Function
   ---------------------------------------------------------------------*/
	sapdbwa_Int2  WDVDeleteService( sapdbwa_Handle    wa,
								     sapdbwa_HttpRequestP request,
									 sapdbwa_HttpReplyP   reply )
	{

		sapdbwa_DbConnectionP	connection = NULL;
		
		if (wa==NULL)
			return sapdbwa_RTC_Error;
		
		/* check authentication */
        if (request!=NULL || reply!=NULL) {
		    if (checkAuthentication(wa,request,reply,isRequired,user,password)==WDVD_False) {
	            return sapdbwa_RTC_Accepted;
		    }
        }

		delete_DeletedItems(wa);

        if (request!=NULL || reply!=NULL) {
		    sapdbwa_InitHeader(reply,
						    200,
						    NULL,
						    NULL,
						    NULL,								/* const char    *LastModified,*/
						    NULL,								/* const char    *Expires,*/
						    NULL);								/* const char    *Location );*/
		    sapdbwa_SetHeader( reply,
						    "Content-Length",
						    "0");
		    sapdbwa_SendHeader(reply);
        }

		return sapdbwa_RTC_Accepted;
	}

/* ---------------------------------------------------------------------
   Deletion Worker Function
   ---------------------------------------------------------------------*/
	void delete_DeletedItems( sapdbwa_Handle    wa)
	{
		WDVD_UInt4				statuscode;
		sapdbwa_DbConnectionP	connection;
		sapdbwa_Int2			rc;
		WDV_Bool				success;
		WDVCAPI_ErrorItem		errorItem;
		WDVCAPI_ErrorType		errorType;
		WDVCAPI_ErrorCode		errorCode;
		WDVCAPI_ErrorText		errorMsg;
		WDVD_Char				errorText[1000];
		WDVCAPI_WDV				pCapiHandle;
        WDVCAPI_URIString       uriOfDeletedItems;
        WDVCAPI_LockId          lockId;

		connection = getConnection(wa);
		if (connection != NULL) {
			/* delete Deleted Items Folder completely */
			if (wa==NULL) {
				sapdbwa_WriteLogMsg(wa, "delete:Missing WebAgent Handle\n");
				return;
			}
			pCapiHandle = getWdvHandle(wa,connection);
			if (pCapiHandle==NULL) {
				sapdbwa_WriteLogMsg(wa, "delete:Uninitialized Pointers\n");
				return;
			}

            strcpy(uriOfDeletedItems, "/Deleted Items");
            WDVCAPI_IdInitValue(lockId);
			success = WDVCAPI_Delete( pCapiHandle, uriOfDeletedItems, lockId, WDVD_False);

			/* error handling */
			if (!success) {
				WDVCAPI_GetLastError(pCapiHandle,&errorItem);
				WDVCAPI_GetErrorType(errorItem,&errorType);
				switch (errorType) {
					case WDVCAPI_ERR_TYPE_UNDEFINED:
					case WDVCAPI_ERR_TYPE_SQL: 
						{
							/* internal server error */
							WDVCAPI_GetErrorText(errorItem,&errorMsg);
							sp77sprintf(errorText,1000,"DELETE: Error while deleting Deleted Items Folder\n");
							sapdbwa_WriteLogMsg(wa, errorText);
							sp77sprintf(errorText,1000,"DELETE: Internal server error: %s\n",errorMsg);
							sapdbwa_WriteLogMsg(wa, errorText);
							break;
						}
					case WDVCAPI_ERR_TYPE_CAPI: 
						{
							WDVCAPI_GetErrorCode(errorItem,&errorCode);
							switch(errorCode) {
								case WDVCAPI_ERR_CODE_RESOURCE_OR_COLLECTION_DOESNT_EXIST:
									{
										break;
									}
								case WDVCAPI_ERR_CODE_LOCK_EXISTS:
									{
										break;
									}
							}
							break;
						}
					default:
						{
							WDVCAPI_GetErrorText(errorItem,&errorMsg);
							sp77sprintf(errorText,1000,"DELETE: Error while deleting Deleted Items Folder\n");
							sapdbwa_WriteLogMsg(wa, errorText);
							sp77sprintf(errorText,1000,"DELETE: Internal server error: %s\n",errorMsg);
							sapdbwa_WriteLogMsg(wa, errorText);
							break;
						}
				}
			}
			closeConnection(wa,connection);
		} else {
			sp77sprintf(errorText,1000,"DELETE: Error while deleting Deleted Items Folder\n");
			sapdbwa_WriteLogMsg(wa, errorText);
			sapdbwa_WriteLogMsg(wa, "Connect to Database failed\n");
		}
	}


/* --- EOF -------------------------------------------------------------*/
