/*!******************************************************************************

  @file         hbd190.h

  ------------------------------------------------------------------------------

  @author       TorstenS

  @brief        systemkeycache

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
\endif

********************************************************************************/

#ifndef HBD190_H
#define HBD190_H


/*===========================================================================*
 *     RefType: Both                                                         *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\xc2\xb9\xde\x09\x09\xa5\xa0\xa7\x10\xf4\xf8\xdf\x7d\x27\xe2\x94'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "ggg00.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal void bd190CreateSysKeyCache ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd190InitSysKeyCache ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool bd190GetNewSysKeyForFile (
    const tsp00_PageNo                   fileRoot,
    tgg00_Surrogate       VAR_ARRAY_REF  sysKey);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool bd190AddAndGetNewSysKeyForFile (
    const tsp00_PageNo                   fileRoot,
    tgg00_Surrogate       VAR_ARRAY_REF  sysKey);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd190DeleteSysKeyFile (
    const tsp00_PageNo                   fileRoot);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

