/*************************************************************************
* COPYRIGHT (C) 1999 - 2003  EDF R&D
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med_outils.h>
#include <med.h>
#include <stdlib.h>
#include <string.h>

#ifdef MAJUSCULES
#define nedfnent NOMF(EDFNENT)
#define nedfnoel NOMF(EDFNOEL)
#define nedfnoee NOMF(EDFNOEE)
#define nedfelee NOMF(EDFELEE)
#define nedfelel NOMF(EDFELEL)
#define nedfg2fc NOMF(EDFG2FC)
#else
#define nedfnent NOMF(edfnent)
#define nedfnoel NOMF(edfnoel)
#define nedfnoee NOMF(edfnoee)
#define nedfelee NOMF(edfelee)
#define nedfelel NOMF(edfelel)
#define nedfg2fc NOMF(edfg2fc)
#endif

#ifdef PPRO_NT
med_int 
__stdcall EDFNENT(med_int *fid,char *maa, unsigned int bidon1,
                  med_int *lon1, med_int *typ_ent, 
                  med_int *typ_con)
#else
med_int 
nedfnent(med_int *fid,char *maa, med_int *lon1, med_int *typ_ent, 
         med_int *typ_con)
#endif
{
  char *fn1;
  med_int ret;

  fn1 = _MED2cstring((char *)maa,(int) *lon1);

  if (! fn1)
    return -1;

  ret = (med_int) MEDnEntites((med_idt)*fid, (char*)fn1,
                              (med_entite_maillage) *typ_ent, 
                              (med_connectivite) *typ_con);

  _MEDcstringFree(fn1);

  return (ret);
    
}

#ifdef PPRO_NT
med_int 
__stdcall EDFNOEL(med_int *fid,char *maa,unsigned int bidon1,
                  med_int *lon1, med_int *mdim, med_float *coo,
	          med_int *modcoo,
	          med_int *rep, char *nomcoo, unsigned int bidon2, 
                  char *unicoo, unsigned int bidon3, 
                  char *nom, unsigned int bidon4,
                  med_int *inom,
	          med_int *num, med_int *inum, med_int *fam, med_int *nnoe)
#else
med_int 
nedfnoel(med_int *fid,char *maa,med_int *lon1,med_int *mdim,med_float *coo,
	 med_int *modcoo,
	 med_int *rep,char *nomcoo,char *unicoo,char *nom,med_int *inom,
	 med_int *num,med_int *inum,med_int *fam,med_int *nnoe)
#endif
{
  med_int ret;
  char *fn1;
  char *fs1,*fs2,*fs3;

  fn1 = _MED2cstring((char *)maa,(int) *lon1);
  fs1 = (char *) malloc(sizeof(char)*MED_TAILLE_PNOM*(*mdim)+1);
  fs2 = (char *) malloc(sizeof(char)*MED_TAILLE_PNOM*(*mdim)+1);
  fs3 = (char *) malloc(sizeof(char)*MED_TAILLE_PNOM*(*nnoe)+1);

  if (!(fn1&&fs1&&fs2&&fs3))
     return -1;

  ret = (med_int) MEDnoeudsLire((med_idt)*fid,(char*)fn1,(med_int)*mdim,
				(med_float *)coo,(med_mode_switch)*modcoo,
				(med_repere*)rep,(char*)fs1,
				(char*)fs2,(char*)fs3,
				(med_booleen*)inom,(med_int*)num,(med_booleen*)inum,
				(med_int*)fam,(med_int)*nnoe);

  strncpy(nomcoo,fs1,MED_TAILLE_PNOM*(*mdim));
  strncpy(unicoo,fs2,MED_TAILLE_PNOM*(*mdim));
  strncpy(nom   ,fs3,MED_TAILLE_PNOM*(*nnoe));
  _MEDfstring(nomcoo,MED_TAILLE_PNOM*(*mdim));
  _MEDfstring(unicoo,MED_TAILLE_PNOM*(*mdim));
  _MEDfstring(nom   ,MED_TAILLE_PNOM*(*nnoe));

  _MEDcstringFree(fn1);
  free(fs1);
  free(fs2);
  free(fs3);

  return ret;
}
 
#ifdef PPRO_NT
med_int 
__stdcall EDFNOEE(med_int *fid, char *maa, unsigned int bidon1, 
                  med_int *lon1, med_int *mdim, med_float *coo,
	          med_int *modcoo,
	          med_int *rep, char *nomcoo, unsigned int bidon2, 
                  med_int *lon2, char *unicoo, unsigned int bidon3, 
                  med_int *lon3,
	          char *nom, unsigned int bidon4, med_int *lon4,
                  med_int *inom,med_int *num,med_int *inum,
	          med_int *fam,med_int *nnoe)
#else 
med_int 
nedfnoee(med_int *fid,char *maa,med_int *lon1,med_int *mdim,med_float *coo,
	 med_int *modcoo,
	 med_int *rep,char *nomcoo,med_int *lon2,char *unicoo,med_int *lon3,
	 char *nom,med_int *lon4,med_int *inom,med_int *num,med_int *inum,
	 med_int *fam,med_int *nnoe)
#endif
{
  med_int ret;
  char *fn1,*fn2,*fn3,*fn4;

  fn1 = _MED2cstring((char*)maa,(int)*lon1);
  fn2 = _MED1cstring((char*)nomcoo,(int)*lon2,(int)*mdim*MED_TAILLE_PNOM);
  fn3 = _MED1cstring((char*)unicoo,(int)*lon3,(int)*mdim*MED_TAILLE_PNOM);
  fn4 = _MED1cstring((char*)nom,(int)*lon4,(int)*nnoe*MED_TAILLE_PNOM);

  if (!(fn1&&fn2&&fn3&&fn4))
     return -1;
 
  ret = (med_int) MEDnoeudsEcr((med_idt)*fid,(char*)fn1,(med_int)*mdim,
			       (med_float *)coo,(med_mode_switch)*modcoo,
			       (med_repere)*rep,(char*)fn2,
			       (char*)fn3,(char*)fn4,(med_booleen)*inom,
			       (med_int*)num,(med_booleen)*inum,
			       (med_int*)fam,(med_int)*nnoe);

  _MEDcstringFree(fn1);
  _MEDcstringFree(fn2);
  _MEDcstringFree(fn3); 
  _MEDcstringFree(fn4);

  return ret;
}


#ifdef PPRO_NT
med_int 
__stdcall EDFELEE(med_int *fid, char *maa, unsigned int bidon1,
                  med_int*lon1, med_int*mdim, med_int*conn,med_int *mode_switch,
	          char*nom, unsigned int bidon2, med_int*lon2, med_int*inom,
	          med_int *num, med_int*inum, med_int*fam, med_int*nele,
                  med_int*typent,
	          med_int*typgeo,med_int*typcon)
#else
med_int
nedfelee(med_int *fid,char *maa,med_int*lon1,med_int*mdim,med_int*conn,med_int *mode_switch,
	 char*nom,med_int*lon2,med_int*inom,
	 med_int *num,med_int*inum,med_int*fam,med_int*nele,med_int*typent,
	 med_int*typgeo,med_int*typcon)
#endif
{
  med_int ret;
  char *fn1,*fn2;

  fn1 = _MED2cstring((char*)maa,(int)*lon1);
  fn2 = _MED1cstring((char*)nom,(int)*lon2,*nele*MED_TAILLE_PNOM);

  if (!(fn1&&fn2))
     return -1;

  ret = (med_int) MEDelementsEcr((med_idt)*fid,(char*)fn1,(med_int)*mdim,
				 (med_int*)conn,(med_mode_switch) *mode_switch,
				 (char*)fn2,(med_booleen)*inom,
				 (med_int*)num,(med_booleen)*inum,
				 (med_int*)fam,(med_int)*nele,
				 (med_entite_maillage)*typent,
				 (med_geometrie_element)*typgeo,
				 (med_connectivite)*typcon);

  _MEDcstringFree(fn1);
  _MEDcstringFree(fn2);

  return ret;
}

#ifdef PPRO_NT
med_int 
__stdcall EDFELEL(med_int *fid,char *maa, unsigned int bidon1,
                  med_int*lon1, med_int*mdim, med_int*conn,med_int *mode_switch,
	          char*nom, unsigned int bidon2, med_int*inom,
	          med_int *num, med_int*inum, med_int*fam, med_int*nele,
                  med_int*typent, med_int*typgeo,med_int*typcon)
#else  
med_int
nedfelel(med_int *fid,char *maa,med_int*lon1,med_int*mdim,med_int*conn,
	 med_int *mode_switch,
	 char*nom,med_int*inom,
	 med_int *num,med_int*inum,med_int*fam,med_int*nele,med_int*typent,
	 med_int*typgeo,med_int*typcon)
#endif
{
  med_int ret;
  char *fn1,*fs1;

  fn1 = _MED2cstring((char*)maa,(int)*lon1);
  fs1 = (char *) malloc(sizeof(char)*MED_TAILLE_PNOM*(*nele)+1);

  if (!(fn1&&fs1))
     return -1;

  ret = (med_int) MEDelementsLire((med_idt)*fid,(char*)fn1,(med_int)*mdim,
				 (med_int*)conn,(med_mode_switch) *mode_switch,
				 (char*)fs1,(med_booleen*)inom,
				 (med_int*)num,(med_booleen*)inum,
				 (med_int*)fam,(med_int)*nele,
				 (med_entite_maillage)*typent,
				 (med_geometrie_element)*typgeo,
				 (med_connectivite)*typcon);

  strncpy(nom,fs1,MED_TAILLE_PNOM*(*nele));
  _MEDfstring(nom,MED_TAILLE_PNOM*(*nele));

  _MEDcstringFree(fn1);
  free(fs1);

  return ret;
} 


#ifdef PPRO_NT
med_int 
__stdcall EDFG2FC(med_int *fid, char *maa, unsigned int bidon1,med_int *lon1, 
		  char *groupes, unsigned int bidon2,med_int *lon2, 
		  med_int *index, med_int *ngroup,med_int *entites,
		  med_int *nent, med_int *type_ent,med_int *type_geo,
		  med_int *indexgeo, med_int *ngeo)
#else 
med_int 
nedfg2fc(med_int *fid, char *maa,med_int *lon1, 
	 char *groupes,med_int *lon2, 
	 med_int *index, med_int *ngroup,med_int *entites,
	 med_int *nent, med_int *type_ent,med_int *type_geo,
	 med_int *indexgeo, med_int *ngeo)
#endif
{
  med_int ret,i;
  char *fn1,*fn2;
  med_geometrie_element *types = (med_geometrie_element *) malloc (*ngeo*sizeof(med_geometrie_element));

  fn1 = _MED2cstring((char*)maa,(int)*lon1);
  fn2 = _MED1cstring((char*)groupes,(int)*lon2,(int)*ngroup*MED_TAILLE_LNOM);

  if (!(fn1&&fn2))
     return -1;

  for (i=0;i<*ngeo;i++)
    *(types+i) = (med_geometrie_element) *(type_geo+i);

  ret = (med_int) MEDgro2famCr((med_idt)*fid,(char*)fn1,
			       (char*)fn2,(med_int*)index,
			       (med_int)*ngroup,(med_int *)entites,
			       (med_int) *nent,
			       (med_entite_maillage)*type_ent,
			       (med_geometrie_element *)types,
			       (med_int *)indexgeo,(med_int) *ngeo);

  _MEDcstringFree(fn1);
  _MEDcstringFree(fn2);
  free(types);

  return ret;
}
