<?php
/*
 * Copyright 2003-2004 Jamin W. Collins <jcollins@asgardsrealm.net>
 * Copyright 2001-2003 Tony Collins
 *
 * This file is part of Media Mate
 * 
 * Media Mate is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * Media Mate is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Media Mate; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 */

// This script is the front page that shows the module summaries and admin area
require_once('header.php');

if ($_GET['module']) {
   $module = $_GET['module'];
   $do = $_GET['do'];
} elseif ($_POST['module']) {
   $module = $_POST['module'];
   $do = $_POST['do'];
}

?>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html>
   <head>
      <link rel="stylesheet" type="text/css"
         href="themes/<?php echo $global_prefs['theme'];?>.css">
      <script language="javascript" type="text/javascript" src="validate.js">
      </script>
      <meta http-equiv="Content-Type" content="text/html; charset=utf-8">

<?php
// These lines are so that the module can use its own page titles
// And if they want to include any javascript etc
if ($module && file_exists("modules/$module/head.php"))
{
   include("modules/$module/head.php");
} else {
   echo "<title>{$global_text['welcome']}</title>";
}

?>
   </head>
   <body>
      <div align="center">
         <div id="pageborder">

            <a href="index.php">
               <div id="title">
               </div>
            </a>
         
            <br/>

<?php

// If no module is loaded, we show the front page
if (!$module) {

   // Module Summary Section
   if ($dir = @opendir("modules/")) {
      $modules_list = array();
      // Get all modules into an array so that we can sort it
      while (($file = readdir($dir)) !== false) {
         if ($file != "." && $file != ".." && 
            file_exists("modules/$file/summary.php")) {
               array_push($modules_list, $file);
         };
      };
      // Sort the modules list alphabetically
      sort($modules_list);
      // Now show all the module summaries
      while (list($key, $val) = each($modules_list)) {
         echo "<table id=\"summarybox\"><tr><td>\n";
         include("modules/$val/summary.php");
         echo "</tr></td></table><br/>\n";
      };
   };

   if ($_SESSION['level']) {
   // If the user IS logged in, show the admin box.
?>
            <table class="admin" cellpadding="2">
               <tr>
                  <td>
                     <table>
                        <tr>
                           <td>
                              <p class="admintext">

<?php 
      echo $global_text['userdetailsfor'];
?>

                              </p>
                           </td>
                           <form action="details.php" method="get">
                              <td>
                                 <select class="adminlist" name="id">

<?php
      $sql = "SELECT * FROM global_users WHERE user_name != 'super' 
         ORDER BY real_name";
      $result = $mm->dbExec($sql);
      while ($row = $mm->dbFetchArray($result)) {
         echo "\n<option class=\"adminlist\" ";
         echo "value=\"{$row['user_id']}\">{$row['real_name']}</option>";
      };
?>
                                 </select>
                                 <input class="adminbutton" type="submit" 
                                    value="<?php echo $global_text['go'];?>">
                              </td>
                           </form>
                        </tr>
                     </table>
                  </td>
                  <td>

<?php
      // If the logged in user is a super user, show more options
      if ($_SESSION['level'] == "3") {
?>
                     <a class="admintext" 
                        href="options.php?action=globaloptions">

<?php 
         echo $global_text['globaloptionsshort'];
?>

                     </a>&nbsp;&nbsp;
                     <a class="admintext" 
                        href="add.php?action=user">

<?php 
         echo $global_text['addnewuser'];
?>

                     </a>
                     <br/>

<?php
      };
?>

                     <a class="admintext" 
                        href="options.php?action=chpwd">

<?php 
      echo $global_text['changemypass'];
?>

                     </a>&nbsp;&nbsp;
                     <a class="admintext" 
                        href="authenticate.php?action=logout">

<?php 
      echo "{$global_text['logout']} {$_SESSION['username']}";
?>

                     </a>
                  </td>
               </tr>
            </table>
            <br/>
               
<?php
   // If the viewer isn't logged in, show the login box
   } elseif (!$_SESSION['level']) {
?>

            <table class="admin">
               <tr>
                  <form action="authenticate.php" method="post">
                     <td align="right" class="adminlabel">

<?php 
      echo $global_text['username'];
?>

                     </td>
                     <td align="left">
                        <input class="admintext" name="username" 
                           type="text" size="15" maxlength="25">
                        <input type="hidden" name="r_username" 
                           value="<?php echo $global_text['usernamemissing'];?>">
                     </td>
                     &nbsp;&nbsp;
                     <td align="right" class="adminlabel">

<?php 
      echo $global_text['password'];
?>

                     </td>
                     <td>
                        <input class="admintext" name="password" 
                           type="password" size="15" maxlength="50">
                        <input type="hidden" name="r_password" 
                           value="<?php echo $global_text['passwordmissing'];?>">
                     </td>
                     <td align ="center" colspan="2">
                        <input class="adminbutton" type="button" 
                           value="<?php echo $global_text['login'];?>" onclick="check(form,form.elements.length)">
                     </td>
                  </form>
               </tr>
            </table>
            <br/>
<?php
   };

   // Create a couple of columns for the next two optional boxes
   // if either of theme are to be displayed
   if ($global_prefs['theme_credits'] == 'on' 
      OR $global_prefs['notify_new'] == 'on') {
         
         echo "<table><tr><td valign=\"top\">";

         // Show the theme About box if available and enabled
         $theme_dir = strtolower($global_prefs['theme']);
         if (file_exists("themes/$theme_dir/about") 
            && $global_prefs['theme_credits'] == 'on') {
?>

            <table class="theme">
               <tr>
                  <td align="center" colspan="3">
                     <p class="themetitle">

<?php 
               echo "{$global_text['aboutthistheme']} - ";
               echo "{$global_prefs['theme']}";
?>

                     </p>
                  </td>
               </tr>
               <tr>
                  <td align="left">
                     <p class="themetext">

<?php
               include("themes/$theme_dir/about");
?>

                     </p>
                  </td>
               </tr>
            </table>
            <br/>

<?php
         };
         echo "</td><td valign=\"top\">";
         // Show the new release notification if enabled in the 
         // global prefs.  It's turned off by default.  Some people 
         // don't like software phoning home.
         if ($global_prefs['notify_new'] == 'on') {
            $get_current=fopen("http://mediamate.rocks.cc/current_release","r");
            while ($line=fgets($get_current,4096)) {
               $current_release.=$line;
            };
            fclose ($get_current);

            $get_this=fopen("release","r");
            while ($line=fgets($get_this,4096)) {
               $this_release.=$line;
            };
            fclose ($get_this);

            if ($current_release > $this_release) {
?>

            <table class="theme">
               <tr>
                  <td align="center" colspan="3">
                     <p class="themetitle">

<?php 
                  echo $global_text['newrelease'];
?>

                     </p>
                  </td>
               </tr>
               <tr>
                  <td>
                     <p class="themetext">

<?php 
                  echo "$current_release {$global_text['hasbeenreleased']}";
                  echo "<br/>{$global_text['considerupgrading']}";
?>

                     </p>
                  </td>
               </tr>
            </table>

<?php
            };
         };
         echo "</td></tr></table><br>";

   };
   echo "<a class=\"returnlink\" href=\"http://mediamate.rocks.cc/\">";
   echo "{$global_text['mediamatehomepage']}</a>";


// The rest of this script is run if there's a module requested
} elseif (file_exists("modules/$module")) {
   // Include the correct translation, or English if it's not available
   if (file_exists("modules/$module/lang/$lang.php")) {
      require("modules/$module/lang/$lang.php");
   } else {
      require("modules/$module/lang/en.php");
   }

   include("modules/$module/$do.php");

   echo "<br/><a class=\"returnlink\" href=\"index.php\">";
   echo "{$global_text['returntofront']}</a>";
// End of modules and end of script
} else {
   echo "<div align=\"center\">{$global_text['nomodule']}</div>";
   echo "<br/><a class=\"returnlink\" href=\"index.php\">";
   echo "{$global_text['returntofront']}</a>";
};
?>

         </div>
      </div>
   </body>
</html>
