<?php
/*
 * Copyright 2003-2004 Jamin W. Collins <jcollins@asgardsrealm.net>
 * Copyright 2001-2003 Tony Collins
 *
 * This file is part of Media Mate
 * 
 * Media Mate is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * Media Mate is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Media Mate; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 */

// This script lets you change the global options/preferences
require_once('header.php');

?>


<!-- Some necessary crap to set the page up. -->
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html>
   <head>
      <link rel="stylesheet" type="text/css"
         href="themes/<?php echo $global_prefs['theme'];?>.css">
      <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
      <title>

<?php 
echo $global_text['globaloptions'];
?>

      </title>
   </head>
   <body>
      <!-- Center the background canvas on the page -->
      <div align="center">
         <div id="pageborder">

            <a href="index.php">
               <div id="title">
               </div>
            </a>

<?php
// If the user is level three, and they want to set global options
if ($_GET['action'] == "globaloptions" AND $_SESSION['level'] == "3") {
?>

            <br/>
            <p class="subheading">

<?php 
   echo $global_text['globaloptions'];
?>

            </p>
            
<form action="modify.php" method="post">

            <table class="admin" cellpadding="5">
               <tr>
                  <td align="right">
                     <p class="adminlabel">

<?php 
   echo $global_text['language'], "&nbsp;&nbsp;\n";
?>

                     </p>
                  </td>
                  <td align="left">
                     <input type="hidden" name="action" value="options">
                     <select class="adminlist" name="lang_name">

<?php
   // Let's get a list of the available languages by reading the ./lang/ 
   // directory.  If individual modules don't have a chosen language, it 
   // will fall back to en.
   if ($dir = @opendir("lang/")) {
      // Create an array, used for sorting the list
      $lang_array = array();
      while (($file = readdir($dir)) !== false) {
         // If the file is a .php
         if (ereg(".php", $file)) {
            // Strip the .php off the theme name
            list($lang_name, $ext) = split('[.]', $file);
            // Then push it onto the array
            array_push($lang_array, $lang_name);
         } else {
            continue;
         };
      };
   };

   // Sort the array alphabetically
   sort($lang_array);

   // Now, display the suckers as options in the list
   while (list($key, $val) = each($lang_array)) {
      // If the language is currently being used,
      //  pre-select it in the list
      if ($val == $global_prefs['lang']) {
         echo "<option class=\"adminlist\" SELECTED>$val</option>";

      // If it's not, don't pre-select it
      } else {
         echo "<option class=\"adminlist\">$val</option>";
      };
   };
?>
   
                     </select>
                  </td>
               </tr>
               <tr>
                  <td align="right">
                     <p class="adminlabel">

<?php 
   echo $global_text['themestyle'], "&nbsp;&nbsp;\n";
?>

                     </p>
                  </td>
                  <td align="left">

                     <input type="hidden" name="action" value="options">
                     <select class="adminlist" name="theme_name">

<?php
   // Let's get a list of the theme names by reading the ./themes/ directory
   if ($dir = @opendir("themes/")) {
      $theme_array = array();
      while (($file = readdir($dir)) !== false) {
         // If the file is a .css
         if (ereg(".css", $file)) {
            // Strip the .css off the theme name
            list($theme_name, $ext) = split('[.]', $file);
            // Then push it onto the array
            array_push($theme_array, $theme_name);
            // If the file isn't a .css file, skip it
         } else {
            continue;
         };
      };
   };

   // Sort the array alphabetically
   sort($theme_array);
   // Then display them
   while (list($key, $val) = each($theme_array)) {
      // If the theme is currently being used, pre-select it in the list
      if ($val == $global_prefs['theme']) {
         echo "<option class=\"adminlist\" SELECTED>$val</option>";
      // If it's not, don't pre-select it
      } else {
         echo "<option class=\"adminlist\">$val</option>";
      };
   };
?>

                     </select>
                     &nbsp;&nbsp;
                     <a class="maintext" 
                        href="http://mediamate.rocks.cc/?p=themes" 
                        target="_blank">

<?php 
   echo $global_text['morethemes'];
?>

                     </a>
                  </td>
               </tr>
               <tr>
                  <td align="right">
                     <p class="adminlabel">

<?php 
   echo $global_text['showthemecredits'], "&nbsp;&nbsp;\n";
?>

                     </p>
                  </td>
                  <td align="left">
                     <input class="admintext" name="theme_credits" 
                        type="checkbox"

<?php 
   if ($global_prefs['theme_credits'] == 'on') { 
      echo "checked=\"yes\"";
   };
?>

                     >
                  </td>
               </tr>
               <tr>
                  <td align="right">
                     <p class="adminlabel">

<?php 
   echo $global_text['notifynewversion'], "&nbsp;&nbsp;\n";
?>

                     </p>
                  </td>
                  <td align="left">
                     <input class="admintext" name="notify_new" 
                        type="checkbox"

<?php 
   if ($global_prefs['notify_new'] == 'on') { 
      echo "checked=\"yes\"";
   };
?>

                     >
                  </td>
               </tr>
               <tr>
                  <td align="right">
                     <p class="adminlabel">

<?php 
   echo $global_text['internetconnected'], "&nbsp;&nbsp;\n";
?>

                     </p>
                  </td>
                  <td align="left">
                     <input class="admintext" name="server_online" 
                        type="checkbox" 

<?php 
   if ($global_prefs['online'] == 'on'){ 
      echo "checked=\"yes\"";
   };
?>

                     >
                  </td>
               </tr>
               <tr>
                  <td align="right">
                     <p class="adminlabel">

<?php 
   echo $global_text['mtainstalled'], "&nbsp;&nbsp;\n";
?>

                     </p>
                  </td>
                  <td align="left">
                     <input class="admintext" name="mail_server" 
                        type="checkbox" 

<?php 
   if ($global_prefs['mta'] == 'on'){ 
      echo "checked=\"yes\"";
   };
?>

                     >
                  </td>
               </tr>
               <tr>
                  <td colspan="2" align="center">
                     <hr/>
                     <p class="maintitle">

<?php 
   echo $global_text['jabber'];
?>

                     </p>
                     <p class="maintext">

<?php 
   echo $global_text['allreminders'];
?>

                     </p>
                  </td>
               </tr>
               <tr>
                  <td align="right">
                     <p class="adminlabel">

<?php 
   echo $global_text['server'], "&nbsp;&nbsp;\n";
?>

                     </p>
                  </td>
                  <td align="left">
                     <input class="admintext" type="text" 
                        name="j_server" size="25" maxlength="50" 
                        value="<?php echo $global_prefs['j_server'];?>">
                  </td>
               </tr>
               <tr>
                  <td align="right">
                     <p class="adminlabel">

<?php 
   echo $global_text['port'], "&nbsp;&nbsp;\n";
?>

                     </p>
                  </td>
                  <td align="left">
                     <input class="admintext" type="text" 
                        name="j_port" size="5" maxlength="5" 
                        value="<?php echo $global_prefs['j_port'];?>">
                  </td>
               </tr>
               <tr>
                  <td align="right">
                     <p class="adminlabel">

<?php 
   echo $global_text['username'], "&nbsp;&nbsp;\n";
?>

                     </p>
                  </td>
                  <td align="left">
                     <input class="admintext" type="text" 
                        name="j_username" size="20" maxlength="50" 
                        value="<?php echo $global_prefs['j_username'];?>">
                  </td>
               </tr>
               <tr>
                  <td align="right">
                     <p class="adminlabel">

<?php 
   echo $global_text['password'], "&nbsp;&nbsp;\n";
?>

                     </p>
                  </td>
                  <td align="left">
                     <input class="admintext" type="password" 
                        name="j_password" size="20" maxlength="50" 
                        value="<?php echo $global_prefs['j_password'];?>">
                  </td>
               </tr>
               <tr>
                  <td colspan="2">
                  <!--<hr>-->
                  </td>
               </tr>

            </table>
            <br/><br/>
            <table class="admin" cellpadding="5">
               <tr>
                  <td align="right">
                     <input class="adminbutton" type="submit" 
                        value="<?php echo $global_text['saveoptions'];?>">

</form>

                  </td>
                  <td align="left">
                     <form action="index.php">
                        <input class="adminbutton" type="submit" 
                           value="<?php echo $global_text['cancel'];?>">
                     </form>
                  </td>
                  <td>
                     <form action="" method="get" onSubmit="window.open('help.php?page=options','Help', 'width=450,height=350,toobar=0,scrollbars=1,location=0,statusbar=0,menubar=0,resizable=1'); return false">
                        <input class="adminbutton" type="submit" 
                           value="<?php echo $global_text['showhelp'];?>">
                     </form>
                  </td>
               </tr>
            </table>
            <br/><br/>

<?php
// If the user wants to change their password, check that they're logged in
} elseif ($_GET['action'] == "chpwd" AND $_SESSION['level'] > "1") {
?>

            <br/>
            <p class="subheading">

<?php 
   echo $global_text['changepassword'];
?>

            </p>

<form action="modify.php" method="post">

            <table class="admin">
               <tr>
                  <td align="right">
                     <input type="hidden" name="action" value="chpwd">
                     <p class="adminlabel">

<?php 
   echo $global_text['enternewpass'];
?>

                     </p>
                  </td>
                  <td align="left">
                     <input class="admintext" type="password" 
                        name="password_1" size="15" maxlength="15">
                  </td>
               </tr>
               <tr>
                  <td align="right">
                     <p class="adminlabel">

<?php 
   echo $global_text['confirmnewpass'];
?>

                     </p>
                  </td>
                  <td align="left">
                     <input class="admintext" type="password" 
                        name="password_2" size="15" maxlength="15">
                  </td>
               </tr>
               <tr>
                  <td align="right">
                     <br/>
                     <input class="adminbutton" type="submit" 
                        value="<?php echo $global_text['savepassword'];?>">
                  </td>

</form>

                  <td align="left">
                     <form action="index.php" method="post">
                        <br/>
                        <input class="adminbutton" type="submit" 
                           value="<?php echo $global_text['cancel'];?>">
                     </form>
                  </td>
               </tr>
            </table>
            <br/><br/>
            
<?php
// If the user doesn't have the right credentials, tell them so
} else {
?>

            <table class="admin">
               <tr>
                  <td>

<?php 
   echo $global_text['nopermission'];
?>

                  </td>
               </tr>
            </table>

<?php
// End of credentials check
};
?>


      <!-- End of the background canvas -->
         </div>
      </div>
   </body>
</html>
