/* position.c -- position setting 
 *
 * Copyright(C) 2001-2002 Elisa Manara <e@entropika.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */ 

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "melon.h"

GtkWidget *hentry, *ventry;
static void update_position (GtkWidget *widget, gpointer user_data);
void set_melon_position (void);

gint set_position (GtkWidget *widget, gpointer data)
{
	GtkWidget *pos_window;
	GtkWidget *vbox, *hbox, *hbox1, *hbox2;
	GtkWidget *button, *label;
	char text[16];

	/* window */
	pos_window = gtk_window_new( GTK_WINDOW_DIALOG);
	gtk_window_set_position(GTK_WINDOW (pos_window), GTK_WIN_POS_MOUSE);
	gtk_widget_set_usize( GTK_WIDGET (pos_window), 200, 70);
	gtk_window_set_title(GTK_WINDOW (pos_window), "Set Icon Position");
	gtk_widget_show(pos_window);

	/* vbox */
	vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( pos_window ), vbox );
	gtk_widget_show( vbox );

	/* hbox1 */
	hbox1 = gtk_hbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( vbox ), hbox1);
	gtk_widget_show( hbox1 );

	/* label */
	label = gtk_label_new ("X: ");
	gtk_box_pack_start (GTK_BOX (hbox1), label, FALSE, FALSE, 5);
	gtk_widget_show(label);

	/* Hposition entry */
	hentry = gtk_entry_new();
	gtk_entry_set_max_length (GTK_ENTRY( hentry ), 16);

	snprintf(text, 16, "%s", cfg_data.xposition);
	gtk_entry_set_text (GTK_ENTRY( hentry ), text);
	gtk_box_pack_start (GTK_BOX (hbox1), hentry, FALSE, FALSE, 5);
	gtk_widget_show(hentry);

	/* hbox2 */
	hbox2 = gtk_hbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( vbox ), hbox2);
	gtk_widget_show( hbox2 );

	/* label */
	label = gtk_label_new ("Y: ");
	gtk_box_pack_start (GTK_BOX (hbox2), label, FALSE, FALSE, 5);
	gtk_widget_show(label);

	/* Vposition entry */
	ventry = gtk_entry_new();
	gtk_entry_set_max_length (GTK_ENTRY( ventry ), 16);

	snprintf(text, 16, "%s", cfg_data.yposition);
	gtk_entry_set_text (GTK_ENTRY( ventry ), text);
	gtk_box_pack_start (GTK_BOX (hbox2), ventry, FALSE, FALSE, 5);
	gtk_widget_show(ventry);

	/* hbox */
	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( vbox ), hbox);
	gtk_widget_show( hbox );

	/* APPLY button */
	button = gtk_button_new_with_label ("Apply");
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
		GTK_SIGNAL_FUNC(update_position), NULL);
	gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
	gtk_widget_show (button);

	/* CLOSE button */
	button = gtk_button_new_with_label ("Close");
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
		GTK_SIGNAL_FUNC(gtk_widget_destroy),
		GTK_OBJECT (pos_window));
	gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
	gtk_widget_show (button);

	return 1;

}

void update_position (GtkWidget *widget, gpointer user_data)
{
	char *text;

	text = gtk_editable_get_chars(GTK_EDITABLE( hentry ), 0, -1);
	if (text[0] != '\0')
		strncpy(cfg_data.xposition, text, 16);

	g_free(text);

	text = gtk_editable_get_chars(GTK_EDITABLE( ventry ), 0, -1);
	if (text[0] != '\0')
		strncpy(cfg_data.yposition, text, 16);

	g_free(text);

	set_melon_position();
	config_update();

	return;
}
	
gint update_melon_position(gpointer data)
{
	int x, y;
		
	gdk_window_get_position(GTK_WIDGET(w_data.window)->window, &x, &y);

	if(x == w_data.xwindow && y == w_data.ywindow)
		return TRUE;

	w_data.xwindow = x;
	w_data.ywindow = y;

	snprintf(cfg_data.xposition, 16, "%d", x);
	snprintf(cfg_data.yposition, 16, "%d", y);
	config_update();

	return TRUE;
}
