#ifndef __MEMAID_ANN__
#define __MEMAID_ANN__

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifdef __GNUC__
#define INLINE __inline__
#else /* !__GNUC__ */
#if defined(C99_INLINE)
#define INLINE inline
#else /* !__GNUC && !C99_INLINE */
#define INLINE
#endif /* C99_INLINE */
#endif /* __GNUC__ */

/*
 * Don't change 2 lines below unless you *really* know what are you doing!
 * They have influence on many things.. even on how data is stored in files.
 */
#define MA_MAX_N_OF_RPTS 128 /* 128 repetititions */
#define MA_MAX_INTERVAL 2048 /* 2048 days */

#define MAX_PATH_LEN 128
#define MAX_FILENAME_LEN 64

#ifndef __USE_BSD
typedef unsigned short u_short;
typedef unsigned long u_long;
typedef unsigned char u_char;
#endif

#ifdef MEMAID_DEBUG
extern FILE *F_debug;
#endif

extern u_long NData;          /* how many cases for ANN to learn from */
extern u_short NData_general; /* how many cases for ANN not learn from user */
extern char ma_Path[MAX_PATH_LEN];

extern void ma_error (const char*, ...);
	/*
	 * Horrible errors, probably go to stderr,
	 * unless currently configured in another way
	 */

extern void ma_debug (const char*, ...);

extern char *pathed (const char *a_filename);
	/*
	 * returns pointer to a string with full path
	 *   (if you want to put your a_filename
	 *      in the same directory where MemAid data is)
	 * e.g.:
	 *  /path/to/dir/where/data/is/a_filename
	 */

extern void ma_train_ann (int number_of_epochs);
	/*
	 * Trains ANN for number_of_epochs (for small number_of_epochs
	 * ma_train_ann() returns very fast so you may want
	 * to use it in threaded learning.)
	 *
	 * IMPORTANT NOTE:
	 * Please keep in mind that while learning ANN you are 
	 * NOT allowed (e.g. using another thread) to call
	 * ma_new_interval(), ma_put_new_el() and ma_move_el()
	 *
	 * Please also read NOTE about ma_move_el()
	 */

extern void ma_train_ann_for_x_secs (int secs);
	/*
	 * Trains internal ANN for 'secs' seconds.
	 *
	 * IMPORTANT NOTE: 
	 * Please keep in mind that while training ANN you are 
	 * NOT allowed (e.g. using another thread) to call
	 * ma_new_interval(), ma_put_new_el() and ma_move_el()
	 */

void nn_save_weights_to_file (void);

extern int nn_init (void);
	/*
	 * Initialises the neural network.
	 * This function is only needed when bypassing ma_init().
	 */

extern int nn_deinit (void);
	/*
	 * Deinitialises the neural network.
	 * This function is only needed when bypassing ma_deinit().
	 */

extern u_short ma_new_interval (u_short a, u_short b, u_short c, u_short d);
	/*
	 * a = last interval computed by ANN. (0-2048)
	 * 	(0 if this is the first time in the learning process)
	 * b = real last interval (0-2048)
	 *	(0 if this is the first time in the learning process)
	 * c = how many repetetitions they were (0-128)
	 * d = current grade (0-5, 5 is the best)
	 *
	 * returns new interval (0-2048) computed by ANN
	 * Generally you don't have to use ma_new_interval() directly.
	 */

extern int feedback_to_ann (u_short l_ivl, u_short real_l_ivl, u_short rp, u_short l_gr, u_short ivl_by_ann,
		u_short real_act_ivl, u_short act_grade);

extern float test_net (void); /* returns TestError */

extern float f_interval (u_short); /* "f" stands for "float" */
extern u_short us_interval (float);
extern float f_grade (u_short);
extern u_short us_grade (float);
extern float f_n_of_rpt (u_short);
extern u_short us_n_of_rpt (float);

extern unsigned int ma_rand (u_long up_to);
	

#ifdef __cplusplus
}
#endif

#endif /* ifndef __MEMAID_ANN__ */

